/*
 * Decompiled with CFR 0.152.
 */
package com.google.archivepatcher.generator;

import com.google.archivepatcher.generator.ByteArrayHolder;
import com.google.archivepatcher.generator.MatchingOutputStream;
import com.google.archivepatcher.generator.MinimalZipEntry;
import com.google.archivepatcher.generator.MismatchException;
import com.google.archivepatcher.generator.PreDiffPlan;
import com.google.archivepatcher.generator.QualifiedRecommendation;
import com.google.archivepatcher.generator.Recommendation;
import com.google.archivepatcher.generator.RecommendationModifier;
import com.google.archivepatcher.generator.RecommendationReason;
import com.google.archivepatcher.generator.similarity.Crc32SimilarityFinder;
import com.google.archivepatcher.generator.similarity.SimilarityFinder;
import com.google.archivepatcher.shared.JreDeflateParameters;
import com.google.archivepatcher.shared.RandomAccessFileInputStream;
import com.google.archivepatcher.shared.TypedRange;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import java.util.Map;

class PreDiffPlanner {
    private final File oldFile;
    private final File newFile;
    private final Map<ByteArrayHolder, MinimalZipEntry> oldArchiveZipEntriesByPath;
    private final Map<ByteArrayHolder, MinimalZipEntry> newArchiveZipEntriesByPath;
    private final Map<ByteArrayHolder, JreDeflateParameters> newArchiveJreDeflateParametersByPath;
    private final List<RecommendationModifier> recommendationModifiers;

    PreDiffPlanner(File oldFile, Map<ByteArrayHolder, MinimalZipEntry> oldArchiveZipEntriesByPath, File newFile, Map<ByteArrayHolder, MinimalZipEntry> newArchiveZipEntriesByPath, Map<ByteArrayHolder, JreDeflateParameters> newArchiveJreDeflateParametersByPath, RecommendationModifier ... recommendationModifiers) {
        this.oldFile = oldFile;
        this.oldArchiveZipEntriesByPath = oldArchiveZipEntriesByPath;
        this.newFile = newFile;
        this.newArchiveZipEntriesByPath = newArchiveZipEntriesByPath;
        this.newArchiveJreDeflateParametersByPath = newArchiveJreDeflateParametersByPath;
        this.recommendationModifiers = Collections.unmodifiableList(Arrays.asList(recommendationModifiers));
    }

    PreDiffPlan generatePreDiffPlan() throws IOException {
        List<QualifiedRecommendation> recommendations = this.getDefaultRecommendations();
        for (RecommendationModifier modifier : this.recommendationModifiers) {
            recommendations = modifier.getModifiedRecommendations(this.oldFile, this.newFile, recommendations);
        }
        HashSet<TypedRange> oldFilePlan = new HashSet<TypedRange>();
        HashSet<TypedRange> newFilePlan = new HashSet<TypedRange>();
        for (QualifiedRecommendation recommendation : recommendations) {
            long length;
            long offset;
            if (recommendation.getRecommendation().uncompressOldEntry) {
                offset = recommendation.getOldEntry().getFileOffsetOfCompressedData();
                length = recommendation.getOldEntry().getCompressedSize();
                TypedRange range = new TypedRange(offset, length, null);
                oldFilePlan.add(range);
            }
            if (!recommendation.getRecommendation().uncompressNewEntry) continue;
            offset = recommendation.getNewEntry().getFileOffsetOfCompressedData();
            length = recommendation.getNewEntry().getCompressedSize();
            JreDeflateParameters newJreDeflateParameters = this.newArchiveJreDeflateParametersByPath.get(new ByteArrayHolder(recommendation.getNewEntry().getFileNameBytes()));
            TypedRange range = new TypedRange(offset, length, (Object)newJreDeflateParameters);
            newFilePlan.add(range);
        }
        ArrayList oldFilePlanList = new ArrayList(oldFilePlan);
        Collections.sort(oldFilePlanList);
        ArrayList newFilePlanList = new ArrayList(newFilePlan);
        Collections.sort(newFilePlanList);
        return new PreDiffPlan(Collections.unmodifiableList(recommendations), Collections.unmodifiableList(oldFilePlanList), Collections.unmodifiableList(newFilePlanList));
    }

    private List<QualifiedRecommendation> getDefaultRecommendations() throws IOException {
        ArrayList<QualifiedRecommendation> recommendations = new ArrayList<QualifiedRecommendation>();
        Crc32SimilarityFinder trivialRenameFinder = new Crc32SimilarityFinder(this.oldFile, this.oldArchiveZipEntriesByPath.values());
        for (Map.Entry<ByteArrayHolder, MinimalZipEntry> newEntry : this.newArchiveZipEntriesByPath.entrySet()) {
            List<MinimalZipEntry> identicalEntriesInOldArchive;
            ByteArrayHolder newEntryPath = newEntry.getKey();
            MinimalZipEntry oldZipEntry = this.oldArchiveZipEntriesByPath.get(newEntryPath);
            if (oldZipEntry == null && !(identicalEntriesInOldArchive = ((SimilarityFinder)trivialRenameFinder).findSimilarFiles(this.newFile, newEntry.getValue())).isEmpty()) {
                oldZipEntry = identicalEntriesInOldArchive.get(0);
            }
            if (oldZipEntry == null) continue;
            recommendations.add(this.getRecommendation(oldZipEntry, newEntry.getValue()));
        }
        return recommendations;
    }

    private QualifiedRecommendation getRecommendation(MinimalZipEntry oldEntry, MinimalZipEntry newEntry) throws IOException {
        if (this.unsuitable(oldEntry, newEntry)) {
            return new QualifiedRecommendation(oldEntry, newEntry, Recommendation.UNCOMPRESS_NEITHER, RecommendationReason.UNSUITABLE);
        }
        if (this.bothEntriesUncompressed(oldEntry, newEntry)) {
            return new QualifiedRecommendation(oldEntry, newEntry, Recommendation.UNCOMPRESS_NEITHER, RecommendationReason.BOTH_ENTRIES_UNCOMPRESSED);
        }
        if (this.uncompressedChangedToCompressed(oldEntry, newEntry)) {
            return new QualifiedRecommendation(oldEntry, newEntry, Recommendation.UNCOMPRESS_NEW, RecommendationReason.UNCOMPRESSED_CHANGED_TO_COMPRESSED);
        }
        if (this.compressedChangedToUncompressed(oldEntry, newEntry)) {
            return new QualifiedRecommendation(oldEntry, newEntry, Recommendation.UNCOMPRESS_OLD, RecommendationReason.COMPRESSED_CHANGED_TO_UNCOMPRESSED);
        }
        if (this.compressedBytesChanged(oldEntry, newEntry)) {
            return new QualifiedRecommendation(oldEntry, newEntry, Recommendation.UNCOMPRESS_BOTH, RecommendationReason.COMPRESSED_BYTES_CHANGED);
        }
        return new QualifiedRecommendation(oldEntry, newEntry, Recommendation.UNCOMPRESS_NEITHER, RecommendationReason.COMPRESSED_BYTES_IDENTICAL);
    }

    private boolean unsuitable(MinimalZipEntry oldEntry, MinimalZipEntry newEntry) {
        if (oldEntry.getCompressionMethod() != 0 && !oldEntry.isDeflateCompressed()) {
            return true;
        }
        if (newEntry.getCompressionMethod() != 0 && !newEntry.isDeflateCompressed()) {
            return true;
        }
        JreDeflateParameters newJreDeflateParameters = this.newArchiveJreDeflateParametersByPath.get(new ByteArrayHolder(newEntry.getFileNameBytes()));
        return newEntry.isDeflateCompressed() && newJreDeflateParameters == null;
    }

    private boolean bothEntriesUncompressed(MinimalZipEntry oldEntry, MinimalZipEntry newEntry) {
        return oldEntry.getCompressionMethod() == 0 && newEntry.getCompressionMethod() == 0;
    }

    private boolean uncompressedChangedToCompressed(MinimalZipEntry oldEntry, MinimalZipEntry newEntry) {
        return oldEntry.getCompressionMethod() == 0 && newEntry.getCompressionMethod() != 0;
    }

    private boolean compressedChangedToUncompressed(MinimalZipEntry oldEntry, MinimalZipEntry newEntry) {
        return newEntry.getCompressionMethod() == 0 && oldEntry.getCompressionMethod() != 0;
    }

    /*
     * WARNING - bad return control flow
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private boolean compressedBytesChanged(MinimalZipEntry oldEntry, MinimalZipEntry newEntry) throws IOException {
        if (oldEntry.getCompressedSize() != newEntry.getCompressedSize()) {
            return true;
        }
        byte[] buffer = new byte[4096];
        int numRead = 0;
        try (RandomAccessFileInputStream oldRafis = new RandomAccessFileInputStream(this.oldFile, oldEntry.getFileOffsetOfCompressedData(), oldEntry.getCompressedSize());
             RandomAccessFileInputStream newRafis = new RandomAccessFileInputStream(this.newFile, newEntry.getFileOffsetOfCompressedData(), newEntry.getCompressedSize());
             MatchingOutputStream matcher = new MatchingOutputStream((InputStream)oldRafis, 4096);){
            while ((numRead = newRafis.read(buffer)) >= 0) {
                try {
                    matcher.write(buffer, 0, numRead);
                }
                catch (MismatchException mismatched) {
                    boolean bl = true;
                    if (matcher != null) {
                        if (var10_14 != null) {
                            try {
                                matcher.close();
                            }
                            catch (Throwable throwable) {
                                var10_14.addSuppressed(throwable);
                            }
                        } else {
                            matcher.close();
                        }
                    }
                    if (newRafis != null) {
                        if (var8_10 != null) {
                            try {
                                newRafis.close();
                            }
                            catch (Throwable throwable) {
                                var8_10.addSuppressed(throwable);
                            }
                        } else {
                            newRafis.close();
                        }
                    }
                    if (oldRafis == null) return bl;
                    if (var6_6 != null) {
                        try {
                            oldRafis.close();
                            return bl;
                        }
                        catch (Throwable throwable) {
                            var6_6.addSuppressed(throwable);
                        }
                        return bl;
                    } else {
                        oldRafis.close();
                    }
                    return bl;
                    return false;
                }
            }
        }
    }
}

