/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.analysis.api.fir.components;

import com.intellij.lang.java.JavaLanguage;
import com.intellij.psi.PsiClass;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiMember;
import com.intellij.psi.PsiModifierListOwner;
import com.intellij.psi.PsiType;
import com.intellij.psi.impl.cache.TypeInfo;
import com.intellij.psi.impl.compiled.ClsTypeElementImpl;
import com.intellij.psi.impl.compiled.SignatureParsing;
import com.intellij.psi.impl.compiled.StubBuildingVisitor;
import com.intellij.util.Function;
import java.text.CharacterIterator;
import java.text.StringCharacterIterator;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.internal.Intrinsics;
import kotlin.sequences.Sequence;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.kotlin.KtSourceElement;
import org.jetbrains.kotlin.KtSourceElementKt;
import org.jetbrains.kotlin.analysis.api.fir.components.AnonymousTypesSubstitutor;
import org.jetbrains.kotlin.analysis.api.fir.types.PublicTypeApproximator;
import org.jetbrains.kotlin.asJava.classes.KtLightClassForFacade;
import org.jetbrains.kotlin.asJava.elements.KtLightElement;
import org.jetbrains.kotlin.codegen.signature.BothSignatureWriter;
import org.jetbrains.kotlin.descriptors.Visibilities;
import org.jetbrains.kotlin.descriptors.Visibility;
import org.jetbrains.kotlin.descriptors.java.JavaVisibilities;
import org.jetbrains.kotlin.fir.FirSession;
import org.jetbrains.kotlin.fir.analysis.checkers.FirHelpersKt;
import org.jetbrains.kotlin.fir.backend.jvm.FirJvmTypeMapperKt;
import org.jetbrains.kotlin.fir.resolve.TypeExpansionUtilsKt;
import org.jetbrains.kotlin.fir.symbols.impl.FirRegularClassSymbol;
import org.jetbrains.kotlin.fir.types.ConeErrorType;
import org.jetbrains.kotlin.fir.types.ConeInferenceContext;
import org.jetbrains.kotlin.fir.types.ConeKotlinType;
import org.jetbrains.kotlin.fir.types.ConeKotlinTypeProjection;
import org.jetbrains.kotlin.fir.types.ConeTypeProjection;
import org.jetbrains.kotlin.fir.types.ConeTypeUtilsKt;
import org.jetbrains.kotlin.fir.types.TypeComponentsKt;
import org.jetbrains.kotlin.fir.types.TypeUtilsKt;
import org.jetbrains.kotlin.load.kotlin.TypeMappingMode;
import org.jetbrains.kotlin.psi.psiUtil.PsiUtilsKt;
import org.jetbrains.kotlin.types.model.SimpleTypeMarker;

@Metadata(mv={1, 7, 1}, k=2, xi=48, d1={"\u00006\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000b\n\u0002\b\u0005\u001a&\u0010\t\u001a\u0004\u0018\u00010\n*\u00020\u000b2\u0006\u0010\f\u001a\u00020\r2\u0006\u0010\u000e\u001a\u00020\u000f2\u0006\u0010\u0010\u001a\u00020\u0006H\u0000\u001a\u0014\u0010\u0011\u001a\u00020\u0012*\u00020\u000b2\u0006\u0010\f\u001a\u00020\rH\u0002\u001a\u001c\u0010\u0013\u001a\u00020\u0012*\u00020\u000b2\u0006\u0010\f\u001a\u00020\r2\u0006\u0010\u0010\u001a\u00020\u0006H\u0002\u001a,\u0010\u0014\u001a\u00020\u0012*\u00020\u000b2\u0006\u0010\u0005\u001a\u00020\u00012\u0006\u0010\u0015\u001a\u00020\u00122\u0006\u0010\f\u001a\u00020\r2\u0006\u0010\u0010\u001a\u00020\u0006H\u0002\u001a\u001c\u0010\u0016\u001a\u00020\u000b*\u00020\u000b2\u0006\u0010\f\u001a\u00020\r2\u0006\u0010\u0010\u001a\u00020\u0006H\u0002\"\u0018\u0010\u0000\u001a\u00020\u0001*\u00020\u00028BX\u0082\u0004\u00a2\u0006\u0006\u001a\u0004\b\u0003\u0010\u0004\"\u0018\u0010\u0005\u001a\u00020\u0001*\u00020\u00068BX\u0082\u0004\u00a2\u0006\u0006\u001a\u0004\b\u0007\u0010\b\u00a8\u0006\u0017"}, d2={"visibility", "Lorg/jetbrains/kotlin/descriptors/Visibility;", "Lcom/intellij/psi/PsiModifierListOwner;", "getVisibility", "(Lcom/intellij/psi/PsiModifierListOwner;)Lorg/jetbrains/kotlin/descriptors/Visibility;", "visibilityForApproximation", "Lcom/intellij/psi/PsiElement;", "getVisibilityForApproximation", "(Lcom/intellij/psi/PsiElement;)Lorg/jetbrains/kotlin/descriptors/Visibility;", "asPsiType", "Lcom/intellij/psi/PsiType;", "Lorg/jetbrains/kotlin/fir/types/ConeKotlinType;", "session", "Lorg/jetbrains/kotlin/fir/FirSession;", "mode", "Lorg/jetbrains/kotlin/load/kotlin/TypeMappingMode;", "useSitePosition", "isLocal", "", "isLocalButAvailableAtPosition", "needLocalTypeApproximation", "isInlineFunction", "simplifyType", "analysis-api-fir"})
public final class KtFirPsiTypeProviderKt {
    private static final ConeKotlinType simplifyType(ConeKotlinType $this$simplifyType, FirSession session2, PsiElement useSitePosition) {
        ConeKotlinType coneKotlinType;
        ConeKotlinType oldType;
        AnonymousTypesSubstitutor substitutor2 = new AnonymousTypesSubstitutor(session2);
        Visibility visibilityForApproximation = KtFirPsiTypeProviderKt.getVisibilityForApproximation(useSitePosition);
        boolean isInlineFunction = false;
        ConeKotlinType currentType = $this$simplifyType;
        do {
            boolean needLocalTypeApproximation;
            oldType = currentType;
            currentType = TypeExpansionUtilsKt.fullyExpandedType(currentType, session2);
            currentType = ConeTypeUtilsKt.upperBoundIfFlexible(currentType);
            coneKotlinType = PublicTypeApproximator.INSTANCE.approximateTypeToPublicDenotable(currentType = substitutor2.substituteOrSelf(currentType), session2, needLocalTypeApproximation = KtFirPsiTypeProviderKt.needLocalTypeApproximation($this$simplifyType, visibilityForApproximation, isInlineFunction, session2, useSitePosition));
            if (coneKotlinType != null) continue;
            coneKotlinType = currentType;
        } while (oldType != (currentType = coneKotlinType));
        return currentType;
    }

    /*
     * WARNING - void declaration
     */
    private static final boolean needLocalTypeApproximation(ConeKotlinType $this$needLocalTypeApproximation, Visibility visibilityForApproximation, boolean isInlineFunction, FirSession session2, PsiElement useSitePosition) {
        void $this$filterNotTo$iv$iv;
        Iterable destination$iv$iv;
        List list2;
        if (!TypeUtilsKt.shouldHideLocalType(visibilityForApproximation, isInlineFunction)) {
            return false;
        }
        if (KtFirPsiTypeProviderKt.isLocal($this$needLocalTypeApproximation, session2)) {
            list2 = CollectionsKt.listOf((Object)$this$needLocalTypeApproximation);
        } else {
            void $this$mapNotNullTo$iv$iv;
            ConeTypeProjection[] $this$mapNotNull$iv = $this$needLocalTypeApproximation.getTypeArguments();
            boolean $i$f$mapNotNull = false;
            ConeTypeProjection[] coneTypeProjectionArray = $this$mapNotNull$iv;
            destination$iv$iv = new ArrayList();
            boolean $i$f$mapNotNullTo = false;
            void $this$forEach$iv$iv$iv = $this$mapNotNullTo$iv$iv;
            boolean $i$f$forEach = false;
            int n = ((void)$this$forEach$iv$iv$iv).length;
            for (int i = 0; i < n; ++i) {
                ConeKotlinType it$iv$iv;
                void element$iv$iv$iv;
                void element$iv$iv = element$iv$iv$iv = $this$forEach$iv$iv$iv[i];
                boolean bl = false;
                void it = element$iv$iv;
                boolean bl2 = false;
                if ((it instanceof ConeKotlinTypeProjection && KtFirPsiTypeProviderKt.isLocal(((ConeKotlinTypeProjection)it).getType(), session2) ? ((ConeKotlinTypeProjection)it).getType() : null) == null) continue;
                it$iv$iv = it$iv$iv;
                boolean bl3 = false;
                destination$iv$iv.add(it$iv$iv);
            }
            list2 = (List)destination$iv$iv;
        }
        List localTypes = list2;
        Iterable $this$filterNot$iv = localTypes;
        boolean $i$f$filterNot = false;
        destination$iv$iv = $this$filterNot$iv;
        Collection destination$iv$iv2 = new ArrayList();
        boolean $i$f$filterNotTo = false;
        for (Object element$iv$iv : $this$filterNotTo$iv$iv) {
            ConeKotlinType it = (ConeKotlinType)element$iv$iv;
            boolean bl = false;
            if (KtFirPsiTypeProviderKt.isLocalButAvailableAtPosition(it, session2, useSitePosition)) continue;
            destination$iv$iv2.add(element$iv$iv);
        }
        List unavailableLocalTypes = (List)destination$iv$iv2;
        return !((Collection)localTypes).isEmpty() && !((Collection)unavailableLocalTypes).isEmpty();
    }

    private static final Visibility getVisibilityForApproximation(PsiElement $this$visibilityForApproximation) {
        Visibility containerVisibility;
        Visibility visibility2;
        if (!($this$visibilityForApproximation instanceof PsiMember)) {
            return Visibilities.Local.INSTANCE;
        }
        if (((PsiMember)$this$visibilityForApproximation).getParent() instanceof KtLightClassForFacade) {
            visibility2 = Visibilities.Public.INSTANCE;
        } else {
            PsiElement psiElement = ((PsiMember)$this$visibilityForApproximation).getParent();
            visibility2 = psiElement instanceof PsiClass ? (PsiClass)psiElement : null;
            if (visibility2 == null || (visibility2 = KtFirPsiTypeProviderKt.getVisibility((PsiModifierListOwner)visibility2)) == null) {
                visibility2 = containerVisibility = (Visibility)Visibilities.Local.INSTANCE;
            }
        }
        if (Intrinsics.areEqual((Object)containerVisibility, (Object)Visibilities.Local.INSTANCE) || Intrinsics.areEqual((Object)KtFirPsiTypeProviderKt.getVisibility((PsiModifierListOwner)$this$visibilityForApproximation), (Object)Visibilities.Local.INSTANCE)) {
            return Visibilities.Local.INSTANCE;
        }
        if (Intrinsics.areEqual((Object)containerVisibility, (Object)Visibilities.Private.INSTANCE)) {
            return Visibilities.Private.INSTANCE;
        }
        return KtFirPsiTypeProviderKt.getVisibility((PsiModifierListOwner)$this$visibilityForApproximation);
    }

    private static final Visibility getVisibility(PsiModifierListOwner $this$visibility) {
        if ($this$visibility.hasModifierProperty("public")) {
            return Visibilities.Public.INSTANCE;
        }
        if ($this$visibility.hasModifierProperty("private") || $this$visibility.hasModifierProperty("packageLocal")) {
            return Visibilities.Private.INSTANCE;
        }
        return Intrinsics.areEqual((Object)$this$visibility.getLanguage(), (Object)JavaLanguage.INSTANCE) ? ($this$visibility.hasModifierProperty("protected") && $this$visibility.hasModifierProperty("static") ? (Visibility)JavaVisibilities.ProtectedStaticVisibility.INSTANCE : ($this$visibility.hasModifierProperty("protected") ? (Visibility)JavaVisibilities.ProtectedAndPackage.INSTANCE : (Visibility)JavaVisibilities.PackageVisibility.INSTANCE)) : (Visibility)Visibilities.INSTANCE.getDEFAULT_VISIBILITY();
    }

    private static final boolean isLocal(ConeKotlinType $this$isLocal, FirSession session2) {
        ConeInferenceContext $this$isLocal_u24lambda_u2d2 = TypeComponentsKt.getTypeContext(session2);
        boolean bl = false;
        return $this$isLocal_u24lambda_u2d2.isLocalType($this$isLocal_u24lambda_u2d2.typeConstructor($this$isLocal));
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private static final boolean isLocalButAvailableAtPosition(ConeKotlinType $this$isLocalButAvailableAtPosition, FirSession session2, PsiElement useSitePosition) {
        PsiElement it;
        FirRegularClassSymbol firRegularClassSymbol = FirHelpersKt.toRegularClassSymbol($this$isLocalButAvailableAtPosition, session2);
        if (firRegularClassSymbol == null) {
            return false;
        }
        FirRegularClassSymbol localClassSymbol = firRegularClassSymbol;
        KtSourceElement ktSourceElement = localClassSymbol.getSource();
        KtSourceElement ktSourceElement2 = ktSourceElement;
        if (ktSourceElement == null) return false;
        if ((ktSourceElement2 = KtSourceElementKt.getPsi(ktSourceElement2)) == null) {
            return false;
        }
        KtSourceElement localPsi = ktSourceElement2;
        KtLightElement ktLightElement = useSitePosition instanceof KtLightElement ? (KtLightElement)useSitePosition : null;
        PsiElement context = ktLightElement != null && (ktLightElement = ktLightElement.getKotlinOrigin()) != null ? (PsiElement)ktLightElement : useSitePosition;
        if (Intrinsics.areEqual((Object)localPsi, (Object)context)) return true;
        Sequence<PsiElement> $this$any$iv = PsiUtilsKt.getParents((PsiElement)localPsi);
        boolean $i$f$any = false;
        for (Object element$iv : $this$any$iv) {
            it = (PsiElement)element$iv;
            boolean bl = false;
            if (!Intrinsics.areEqual((Object)it, (Object)context)) continue;
            return true;
        }
        boolean bl = false;
        if (bl) return true;
        $this$any$iv = PsiUtilsKt.getParents(context);
        $i$f$any = false;
        Iterator iterator2 = $this$any$iv.iterator();
        do {
            Object element$iv;
            if (!iterator2.hasNext()) return false;
            element$iv = iterator2.next();
            it = (PsiElement)element$iv;
            boolean bl2 = false;
        } while (!Intrinsics.areEqual((Object)it, (Object)localPsi));
        return true;
    }

    @Nullable
    public static final PsiType asPsiType(@NotNull ConeKotlinType $this$asPsiType, @NotNull FirSession session2, @NotNull TypeMappingMode mode, @NotNull PsiElement useSitePosition) {
        boolean bl;
        ConeKotlinType correctedType;
        block6: {
            Intrinsics.checkNotNullParameter((Object)$this$asPsiType, (String)"<this>");
            Intrinsics.checkNotNullParameter((Object)session2, (String)"session");
            Intrinsics.checkNotNullParameter((Object)mode, (String)"mode");
            Intrinsics.checkNotNullParameter((Object)useSitePosition, (String)"useSitePosition");
            correctedType = KtFirPsiTypeProviderKt.simplifyType($this$asPsiType, session2, useSitePosition);
            if (correctedType instanceof ConeErrorType || !(correctedType instanceof SimpleTypeMarker)) {
                return null;
            }
            ConeTypeProjection[] $this$any$iv = correctedType.getTypeArguments();
            boolean $i$f$any = false;
            int n = $this$any$iv.length;
            for (int i = 0; i < n; ++i) {
                ConeTypeProjection element$iv;
                ConeTypeProjection it = element$iv = $this$any$iv[i];
                boolean bl2 = false;
                if (!(it instanceof ConeErrorType)) continue;
                bl = true;
                break block6;
            }
            bl = false;
        }
        if (bl) {
            return null;
        }
        BothSignatureWriter signatureWriter = new BothSignatureWriter(BothSignatureWriter.Mode.SKIP_CHECKS);
        FirJvmTypeMapperKt.getJvmTypeMapper(session2).mapType(correctedType, mode, signatureWriter);
        String string2 = signatureWriter.toString();
        Intrinsics.checkNotNullExpressionValue((Object)string2, (String)"signatureWriter.toString()");
        String canonicalSignature = string2;
        if (StringsKt.contains$default((CharSequence)canonicalSignature, (CharSequence)"L<error>", (boolean)false, (int)2, null)) {
            return null;
        }
        if (!(!StringsKt.contains$default((CharSequence)canonicalSignature, (CharSequence)"<anonymous>", (boolean)false, (int)2, null))) {
            String string3 = "Failed requirement.";
            throw new IllegalArgumentException(string3.toString());
        }
        StringCharacterIterator signature2 = new StringCharacterIterator(canonicalSignature);
        String string4 = SignatureParsing.parseTypeString((CharacterIterator)signature2, (Function)StubBuildingVisitor.GUESSING_MAPPER);
        Intrinsics.checkNotNullExpressionValue((Object)string4, (String)"parseTypeString(signatur\u2026gVisitor.GUESSING_MAPPER)");
        String javaType = string4;
        TypeInfo typeInfo = TypeInfo.fromString((String)javaType, (boolean)false);
        Intrinsics.checkNotNullExpressionValue((Object)typeInfo, (String)"fromString(javaType, false)");
        TypeInfo typeInfo2 = typeInfo;
        String string5 = TypeInfo.createTypeText((TypeInfo)typeInfo2);
        if (string5 == null) {
            return null;
        }
        String typeText = string5;
        ClsTypeElementImpl typeElement = new ClsTypeElementImpl(useSitePosition, typeText, '\u0000');
        return typeElement.getType();
    }
}

