/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.analysis.api.symbols;

import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import kotlin.Metadata;
import kotlin.Pair;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.kotlin.analysis.api.ValidityTokenOwner;
import org.jetbrains.kotlin.analysis.api.annotations.KtAnnotatedKt;
import org.jetbrains.kotlin.analysis.api.annotations.KtAnnotationApplication;
import org.jetbrains.kotlin.analysis.api.annotations.KtConstantAnnotationValue;
import org.jetbrains.kotlin.analysis.api.annotations.KtNamedAnnotationValue;
import org.jetbrains.kotlin.analysis.api.symbols.KtSignature;
import org.jetbrains.kotlin.analysis.api.symbols.KtVariableLikeSymbol;
import org.jetbrains.kotlin.analysis.api.tokens.InaccessibleEntityAccessException;
import org.jetbrains.kotlin.analysis.api.tokens.InvalidEntityAccessException;
import org.jetbrains.kotlin.analysis.api.tokens.ValidityToken;
import org.jetbrains.kotlin.analysis.api.types.KtType;
import org.jetbrains.kotlin.builtins.StandardNames;
import org.jetbrains.kotlin.name.Name;
import org.jetbrains.kotlin.name.StandardClassIds;

@Metadata(mv={1, 7, 1}, k=1, xi=48, d1={"\u0000J\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\b\u000b\n\u0002\u0018\u0002\n\u0002\b\b\n\u0002\u0010\u000b\n\u0000\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\b\n\u0000\n\u0002\u0010\u000e\n\u0000\b\u0086\b\u0018\u0000*\n\b\u0000\u0010\u0001 \u0001*\u00020\u00022\b\u0012\u0004\u0012\u0002H\u00010\u0003B\u001f\u0012\u0006\u0010\u0004\u001a\u00028\u0000\u0012\u0006\u0010\u0005\u001a\u00020\u0006\u0012\b\u0010\u0007\u001a\u0004\u0018\u00010\u0006\u00a2\u0006\u0002\u0010\bJ\u000e\u0010\u001a\u001a\u00028\u0000H\u00c2\u0003\u00a2\u0006\u0002\u0010\u0015J\t\u0010\u001b\u001a\u00020\u0006H\u00c2\u0003J\u000b\u0010\u001c\u001a\u0004\u0018\u00010\u0006H\u00c2\u0003J4\u0010\u001d\u001a\b\u0012\u0004\u0012\u00028\u00000\u00002\b\b\u0002\u0010\u0004\u001a\u00028\u00002\b\b\u0002\u0010\u0005\u001a\u00020\u00062\n\b\u0002\u0010\u0007\u001a\u0004\u0018\u00010\u0006H\u00c6\u0001\u00a2\u0006\u0002\u0010\u001eJ\u0013\u0010\u001f\u001a\u00020 2\b\u0010!\u001a\u0004\u0018\u00010\"H\u00d6\u0003J\n\u0010#\u001a\u0004\u0018\u00010$H\u0002J\n\u0010%\u001a\u0004\u0018\u00010\u000bH\u0002J\t\u0010&\u001a\u00020'H\u00d6\u0001J\t\u0010(\u001a\u00020)H\u00d6\u0001R\u0010\u0010\u0007\u001a\u0004\u0018\u00010\u0006X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0005\u001a\u00020\u0006X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0010\u0010\u0004\u001a\u00028\u0000X\u0082\u0004\u00a2\u0006\u0004\n\u0002\u0010\tR\u0011\u0010\n\u001a\u00020\u000b8F\u00a2\u0006\u0006\u001a\u0004\b\f\u0010\rR\u0016\u0010\u000e\u001a\u0004\u0018\u00010\u00068VX\u0096\u0004\u00a2\u0006\u0006\u001a\u0004\b\u000f\u0010\u0010R\u0014\u0010\u0011\u001a\u00020\u00068VX\u0096\u0004\u00a2\u0006\u0006\u001a\u0004\b\u0012\u0010\u0010R\u0014\u0010\u0013\u001a\u00028\u00008VX\u0096\u0004\u00a2\u0006\u0006\u001a\u0004\b\u0014\u0010\u0015R\u0014\u0010\u0016\u001a\u00020\u00178VX\u0096\u0004\u00a2\u0006\u0006\u001a\u0004\b\u0018\u0010\u0019\u00a8\u0006*"}, d2={"Lorg/jetbrains/kotlin/analysis/api/symbols/KtVariableLikeSignature;", "S", "Lorg/jetbrains/kotlin/analysis/api/symbols/KtVariableLikeSymbol;", "Lorg/jetbrains/kotlin/analysis/api/symbols/KtSignature;", "_symbol", "_returnType", "Lorg/jetbrains/kotlin/analysis/api/types/KtType;", "_receiverType", "(Lorg/jetbrains/kotlin/analysis/api/symbols/KtVariableLikeSymbol;Lorg/jetbrains/kotlin/analysis/api/types/KtType;Lorg/jetbrains/kotlin/analysis/api/types/KtType;)V", "Lorg/jetbrains/kotlin/analysis/api/symbols/KtVariableLikeSymbol;", "name", "Lorg/jetbrains/kotlin/name/Name;", "getName", "()Lorg/jetbrains/kotlin/name/Name;", "receiverType", "getReceiverType", "()Lorg/jetbrains/kotlin/analysis/api/types/KtType;", "returnType", "getReturnType", "symbol", "getSymbol", "()Lorg/jetbrains/kotlin/analysis/api/symbols/KtVariableLikeSymbol;", "token", "Lorg/jetbrains/kotlin/analysis/api/tokens/ValidityToken;", "getToken", "()Lorg/jetbrains/kotlin/analysis/api/tokens/ValidityToken;", "component1", "component2", "component3", "copy", "(Lorg/jetbrains/kotlin/analysis/api/symbols/KtVariableLikeSymbol;Lorg/jetbrains/kotlin/analysis/api/types/KtType;Lorg/jetbrains/kotlin/analysis/api/types/KtType;)Lorg/jetbrains/kotlin/analysis/api/symbols/KtVariableLikeSignature;", "equals", "", "other", "", "findParameterNameAnnotation", "Lorg/jetbrains/kotlin/analysis/api/annotations/KtAnnotationApplication;", "getValueFromParameterNameAnnotation", "hashCode", "", "toString", "", "analysis-api"})
public final class KtVariableLikeSignature<S extends KtVariableLikeSymbol>
extends KtSignature<S> {
    @NotNull
    private final S _symbol;
    @NotNull
    private final KtType _returnType;
    @Nullable
    private final KtType _receiverType;

    public KtVariableLikeSignature(@NotNull S _symbol, @NotNull KtType _returnType, @Nullable KtType _receiverType) {
        Intrinsics.checkNotNullParameter(_symbol, (String)"_symbol");
        Intrinsics.checkNotNullParameter((Object)_returnType, (String)"_returnType");
        super(null);
        this._symbol = _symbol;
        this._returnType = _returnType;
        this._receiverType = _receiverType;
    }

    @Override
    @NotNull
    public ValidityToken getToken() {
        return this._symbol.getToken();
    }

    @Override
    @NotNull
    public S getSymbol() {
        ValidityTokenOwner $this$withValidityAssertion$iv = this;
        boolean $i$f$withValidityAssertion = false;
        ValidityTokenOwner $this$assertIsValidAndAccessible$iv$iv = $this$withValidityAssertion$iv;
        boolean $i$f$assertIsValidAndAccessible = false;
        ValidityToken $this$assertIsValidAndAccessible$iv$iv$iv = $this$assertIsValidAndAccessible$iv$iv.getToken();
        boolean $i$f$assertIsValidAndAccessible2 = false;
        if (!$this$assertIsValidAndAccessible$iv$iv$iv.isValid()) {
            throw new InvalidEntityAccessException("Access to invalid " + $this$assertIsValidAndAccessible$iv$iv$iv + ": " + $this$assertIsValidAndAccessible$iv$iv$iv.getInvalidationReason());
        }
        if (!$this$assertIsValidAndAccessible$iv$iv$iv.isAccessible()) {
            throw new InaccessibleEntityAccessException($this$assertIsValidAndAccessible$iv$iv$iv + " is inaccessible: " + $this$assertIsValidAndAccessible$iv$iv$iv.getInaccessibilityReason());
        }
        boolean bl = false;
        return this._symbol;
    }

    @Override
    @NotNull
    public KtType getReturnType() {
        ValidityTokenOwner $this$withValidityAssertion$iv = this;
        boolean $i$f$withValidityAssertion = false;
        ValidityTokenOwner $this$assertIsValidAndAccessible$iv$iv = $this$withValidityAssertion$iv;
        boolean $i$f$assertIsValidAndAccessible = false;
        ValidityToken $this$assertIsValidAndAccessible$iv$iv$iv = $this$assertIsValidAndAccessible$iv$iv.getToken();
        boolean $i$f$assertIsValidAndAccessible2 = false;
        if (!$this$assertIsValidAndAccessible$iv$iv$iv.isValid()) {
            throw new InvalidEntityAccessException("Access to invalid " + $this$assertIsValidAndAccessible$iv$iv$iv + ": " + $this$assertIsValidAndAccessible$iv$iv$iv.getInvalidationReason());
        }
        if (!$this$assertIsValidAndAccessible$iv$iv$iv.isAccessible()) {
            throw new InaccessibleEntityAccessException($this$assertIsValidAndAccessible$iv$iv$iv + " is inaccessible: " + $this$assertIsValidAndAccessible$iv$iv$iv.getInaccessibilityReason());
        }
        boolean bl = false;
        return this._returnType;
    }

    @Override
    @Nullable
    public KtType getReceiverType() {
        ValidityTokenOwner $this$withValidityAssertion$iv = this;
        boolean $i$f$withValidityAssertion = false;
        ValidityTokenOwner $this$assertIsValidAndAccessible$iv$iv = $this$withValidityAssertion$iv;
        boolean $i$f$assertIsValidAndAccessible = false;
        ValidityToken $this$assertIsValidAndAccessible$iv$iv$iv = $this$assertIsValidAndAccessible$iv$iv.getToken();
        boolean $i$f$assertIsValidAndAccessible2 = false;
        if (!$this$assertIsValidAndAccessible$iv$iv$iv.isValid()) {
            throw new InvalidEntityAccessException("Access to invalid " + $this$assertIsValidAndAccessible$iv$iv$iv + ": " + $this$assertIsValidAndAccessible$iv$iv$iv.getInvalidationReason());
        }
        if (!$this$assertIsValidAndAccessible$iv$iv$iv.isAccessible()) {
            throw new InaccessibleEntityAccessException($this$assertIsValidAndAccessible$iv$iv$iv + " is inaccessible: " + $this$assertIsValidAndAccessible$iv$iv$iv.getInaccessibilityReason());
        }
        boolean bl = false;
        return this._receiverType;
    }

    @NotNull
    public final Name getName() {
        Name name2;
        Name name3;
        ValidityTokenOwner $this$withValidityAssertion$iv = this;
        boolean $i$f$withValidityAssertion = false;
        ValidityTokenOwner $this$assertIsValidAndAccessible$iv$iv = $this$withValidityAssertion$iv;
        boolean $i$f$assertIsValidAndAccessible = false;
        ValidityToken $this$assertIsValidAndAccessible$iv$iv$iv = $this$assertIsValidAndAccessible$iv$iv.getToken();
        boolean $i$f$assertIsValidAndAccessible2 = false;
        if (!$this$assertIsValidAndAccessible$iv$iv$iv.isValid()) {
            throw new InvalidEntityAccessException("Access to invalid " + $this$assertIsValidAndAccessible$iv$iv$iv + ": " + $this$assertIsValidAndAccessible$iv$iv$iv.getInvalidationReason());
        }
        if (!$this$assertIsValidAndAccessible$iv$iv$iv.isAccessible()) {
            throw new InaccessibleEntityAccessException($this$assertIsValidAndAccessible$iv$iv$iv + " is inaccessible: " + $this$assertIsValidAndAccessible$iv$iv$iv.getInaccessibilityReason());
        }
        boolean bl = false;
        boolean nameCanBeDeclaredInAnnotation = this._symbol.getPsi() == null;
        boolean $i$f$runIf = false;
        if (nameCanBeDeclaredInAnnotation) {
            boolean bl2 = false;
            name3 = this.getValueFromParameterNameAnnotation();
        } else {
            name3 = name2 = null;
        }
        if (name3 == null) {
            name2 = this._symbol.getName();
        }
        return name2;
    }

    private final Name getValueFromParameterNameAnnotation() {
        Name name2;
        KtNamedAnnotationValue parameterNameArgument;
        Object v1;
        block6: {
            KtAnnotationApplication ktAnnotationApplication = this.findParameterNameAnnotation();
            if (ktAnnotationApplication == null) {
                return null;
            }
            KtAnnotationApplication resultingAnnotation = ktAnnotationApplication;
            Iterable $this$singleOrNull$iv = resultingAnnotation.getArguments();
            boolean $i$f$singleOrNull = false;
            Object single$iv = null;
            boolean found$iv = false;
            for (Object element$iv : $this$singleOrNull$iv) {
                KtNamedAnnotationValue it = (KtNamedAnnotationValue)element$iv;
                boolean bl = false;
                if (!Intrinsics.areEqual((Object)it.getName(), (Object)StandardClassIds.Annotations.ParameterNames.INSTANCE.getParameterNameName())) continue;
                if (found$iv) {
                    v1 = null;
                    break block6;
                }
                single$iv = element$iv;
                found$iv = true;
            }
            v1 = !found$iv ? null : single$iv;
        }
        KtNamedAnnotationValue ktNamedAnnotationValue = parameterNameArgument = (KtNamedAnnotationValue)v1;
        Object object = ktNamedAnnotationValue != null ? ktNamedAnnotationValue.getExpression() : null;
        KtConstantAnnotationValue ktConstantAnnotationValue = object instanceof KtConstantAnnotationValue ? (KtConstantAnnotationValue)object : null;
        if (ktConstantAnnotationValue == null) {
            return null;
        }
        KtConstantAnnotationValue constantArgumentValue = ktConstantAnnotationValue;
        object = constantArgumentValue.getConstantValue().getValue();
        String string2 = object instanceof String ? (String)object : null;
        if (string2 != null) {
            String p0 = string2;
            boolean bl = false;
            name2 = Name.identifier(p0);
        } else {
            name2 = null;
        }
        return name2;
    }

    private final KtAnnotationApplication findParameterNameAnnotation() {
        List<KtAnnotationApplication> allParameterNameAnnotations = KtAnnotatedKt.annotationsByClassId(this.getReturnType(), StandardNames.FqNames.parameterNameClassId);
        Iterable $this$partition$iv = allParameterNameAnnotations;
        boolean $i$f$partition = false;
        ArrayList first$iv = new ArrayList();
        ArrayList second$iv = new ArrayList();
        for (Object element$iv : $this$partition$iv) {
            KtAnnotationApplication it = (KtAnnotationApplication)element$iv;
            boolean bl = false;
            if (it.getPsi() != null) {
                first$iv.add(element$iv);
                continue;
            }
            second$iv.add(element$iv);
        }
        Pair pair = new Pair(first$iv, second$iv);
        List explicitAnnotations = (List)pair.component1();
        List implicitAnnotations = (List)pair.component2();
        return !((Collection)explicitAnnotations).isEmpty() ? (KtAnnotationApplication)CollectionsKt.first((List)explicitAnnotations) : (KtAnnotationApplication)CollectionsKt.singleOrNull((List)implicitAnnotations);
    }

    private final S component1() {
        return this._symbol;
    }

    private final KtType component2() {
        return this._returnType;
    }

    private final KtType component3() {
        return this._receiverType;
    }

    @NotNull
    public final KtVariableLikeSignature<S> copy(@NotNull S _symbol, @NotNull KtType _returnType, @Nullable KtType _receiverType) {
        Intrinsics.checkNotNullParameter(_symbol, (String)"_symbol");
        Intrinsics.checkNotNullParameter((Object)_returnType, (String)"_returnType");
        return new KtVariableLikeSignature<S>(_symbol, _returnType, _receiverType);
    }

    public static /* synthetic */ KtVariableLikeSignature copy$default(KtVariableLikeSignature ktVariableLikeSignature, KtVariableLikeSymbol ktVariableLikeSymbol, KtType ktType, KtType ktType2, int n, Object object) {
        if ((n & 1) != 0) {
            ktVariableLikeSymbol = ktVariableLikeSignature._symbol;
        }
        if ((n & 2) != 0) {
            ktType = ktVariableLikeSignature._returnType;
        }
        if ((n & 4) != 0) {
            ktType2 = ktVariableLikeSignature._receiverType;
        }
        return ktVariableLikeSignature.copy(ktVariableLikeSymbol, ktType, ktType2);
    }

    @NotNull
    public String toString() {
        return "KtVariableLikeSignature(_symbol=" + this._symbol + ", _returnType=" + this._returnType + ", _receiverType=" + this._receiverType + ')';
    }

    @Override
    public int hashCode() {
        int result2 = this._symbol.hashCode();
        result2 = result2 * 31 + this._returnType.hashCode();
        result2 = result2 * 31 + (this._receiverType == null ? 0 : this._receiverType.hashCode());
        return result2;
    }

    @Override
    public boolean equals(@Nullable Object other) {
        if (this == other) {
            return true;
        }
        if (!(other instanceof KtVariableLikeSignature)) {
            return false;
        }
        KtVariableLikeSignature ktVariableLikeSignature = (KtVariableLikeSignature)other;
        if (!Intrinsics.areEqual(this._symbol, ktVariableLikeSignature._symbol)) {
            return false;
        }
        if (!Intrinsics.areEqual((Object)this._returnType, (Object)ktVariableLikeSignature._returnType)) {
            return false;
        }
        return Intrinsics.areEqual((Object)this._receiverType, (Object)ktVariableLikeSignature._receiverType);
    }
}

