/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.codeInsight;

import com.intellij.codeInsight.AnnotationCacheOwnerNormalizer;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.psi.PsiClass;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiMethod;
import com.intellij.psi.PsiModifierListOwner;
import com.intellij.psi.util.CachedValueProvider;
import com.intellij.psi.util.CachedValuesManager;
import com.intellij.psi.util.PsiModificationTracker;
import com.intellij.testIntegration.TestFramework;
import com.intellij.util.containers.ContainerUtil;
import java.util.LinkedHashSet;
import java.util.Set;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public abstract class TestFrameworks {
    public static TestFrameworks getInstance() {
        return ApplicationManager.getApplication().getService(TestFrameworks.class);
    }

    public abstract boolean isTestClass(@NotNull PsiClass var1);

    public abstract boolean isPotentialTestClass(@NotNull PsiClass var1);

    @Nullable
    public abstract PsiMethod findOrCreateSetUpMethod(PsiClass var1);

    @Nullable
    public abstract PsiMethod findSetUpMethod(PsiClass var1);

    @Nullable
    public abstract PsiMethod findTearDownMethod(PsiClass var1);

    protected abstract boolean hasConfigMethods(PsiClass var1);

    public abstract boolean isTestMethod(PsiMethod var1);

    public boolean isTestMethod(PsiMethod method, boolean checkAbstract) {
        return this.isTestMethod(method);
    }

    public boolean isTestOrConfig(PsiClass psiClass) {
        return this.isTestClass(psiClass) || this.hasConfigMethods(psiClass);
    }

    @Nullable
    public static TestFramework detectFramework(@NotNull PsiClass psiClass) {
        if (psiClass == null) {
            TestFrameworks.$$$reportNull$$$0(0);
        }
        return ContainerUtil.getFirstItem(TestFrameworks.detectApplicableFrameworks(psiClass));
    }

    @NotNull
    public static Set<TestFramework> detectApplicableFrameworks(@NotNull PsiClass psiClass) {
        if (psiClass == null) {
            TestFrameworks.$$$reportNull$$$0(1);
        }
        PsiModifierListOwner normalized = AnnotationCacheOwnerNormalizer.normalize(psiClass);
        Set set = (Set)CachedValuesManager.getCachedValue(normalized, () -> CachedValueProvider.Result.create(TestFrameworks.computeFrameworks(normalized), PsiModificationTracker.MODIFICATION_COUNT));
        if (set == null) {
            TestFrameworks.$$$reportNull$$$0(2);
        }
        return set;
    }

    private static Set<TestFramework> computeFrameworks(PsiElement psiClass) {
        LinkedHashSet<TestFramework> frameworks = new LinkedHashSet<TestFramework>();
        for (TestFramework framework : TestFramework.EXTENSION_NAME.getExtensionList()) {
            if (!framework.isTestClass(psiClass)) continue;
            frameworks.add(framework);
        }
        for (TestFramework framework : TestFramework.EXTENSION_NAME.getExtensionList()) {
            if (frameworks.contains(framework) || framework.findSetUpMethod(psiClass) == null && framework.findTearDownMethod(psiClass) == null) continue;
            frameworks.add(framework);
        }
        return frameworks;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string2;
        switch (n) {
            default: {
                string2 = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 2: {
                string2 = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 2: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "psiClass";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/codeInsight/TestFrameworks";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/codeInsight/TestFrameworks";
                break;
            }
            case 2: {
                objectArray = objectArray2;
                objectArray2[1] = "detectApplicableFrameworks";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "detectFramework";
                break;
            }
            case 1: {
                objectArray = objectArray;
                objectArray[2] = "detectApplicableFrameworks";
                break;
            }
            case 2: {
                break;
            }
        }
        String string3 = String.format(string2, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string3);
                break;
            }
            case 2: {
                runtimeException = new IllegalStateException(string3);
                break;
            }
        }
        throw runtimeException;
    }
}

