/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.ide.plugins;

import com.intellij.diagnostic.Activity;
import com.intellij.diagnostic.ActivityCategory;
import com.intellij.diagnostic.StartUpMeasurer;
import com.intellij.ide.plugins.ClassPathXmlPathResolver;
import com.intellij.ide.plugins.DataLoader;
import com.intellij.ide.plugins.DescriptorListLoadingContext;
import com.intellij.ide.plugins.DisabledPluginsState;
import com.intellij.ide.plugins.IdeaPluginDescriptor;
import com.intellij.ide.plugins.IdeaPluginDescriptorImpl;
import com.intellij.ide.plugins.ImmutableZipFileDataLoader;
import com.intellij.ide.plugins.JavaZipFileDataLoader;
import com.intellij.ide.plugins.LoadDescriptorsFromClassPathAction;
import com.intellij.ide.plugins.LoadDescriptorsFromDirAction;
import com.intellij.ide.plugins.LocalFsDataLoader;
import com.intellij.ide.plugins.PathResolver;
import com.intellij.ide.plugins.PluginLoadingResult;
import com.intellij.ide.plugins.PluginManagerCore;
import com.intellij.ide.plugins.PluginXmlPathResolver;
import com.intellij.ide.plugins.RawPluginDescriptor;
import com.intellij.ide.plugins.ReadModuleContext;
import com.intellij.ide.plugins.XmlReader;
import com.intellij.openapi.application.PathManager;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.extensions.PluginId;
import com.intellij.openapi.util.BuildNumber;
import com.intellij.openapi.util.io.NioFiles;
import com.intellij.util.PlatformUtils;
import com.intellij.util.io.Decompressor;
import com.intellij.util.lang.UrlClassLoader;
import com.intellij.util.lang.ZipFilePool;
import com.intellij.util.xml.dom.StaxFactory;
import java.io.Closeable;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.net.URL;
import java.nio.charset.StandardCharsets;
import java.nio.file.DirectoryStream;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.NoSuchFileException;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.nio.file.attribute.FileAttribute;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.Enumeration;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.StringTokenizer;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.ForkJoinPool;
import java.util.function.Supplier;
import java.util.zip.ZipFile;
import javax.xml.stream.XMLStreamException;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin.collections.CollectionsKt;
import kotlin.collections.MapsKt;
import kotlin.collections.SetsKt;
import kotlin.io.CloseableKt;
import kotlin.io.path.PathsKt;
import kotlin.jdk7.AutoCloseableKt;
import kotlin.jvm.JvmName;
import kotlin.jvm.internal.Intrinsics;
import kotlin.sequences.Sequence;
import kotlin.sequences.SequencesKt;
import kotlin.text.StringsKt;
import org.codehaus.stax2.XMLStreamReader2;
import org.jetbrains.annotations.ApiStatus;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.annotations.TestOnly;

@Metadata(mv={1, 5, 1}, k=2, d1={"\u0000\u0086\u0001\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010$\n\u0002\u0018\u0002\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\u0010\"\n\u0000\n\u0002\u0010!\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\b\u0007\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\b\u0010\n\u0002\u0010 \n\u0002\b\u0006\u001a\u001c\u0010\u0004\u001a\u000e\u0012\u0004\u0012\u00020\u0006\u0012\u0004\u0012\u00020\u00070\u00052\u0006\u0010\b\u001a\u00020\tH\u0002\u001a\u0012\u0010\n\u001a\u00020\u000b2\b\u0010\f\u001a\u0004\u0018\u00010\rH\u0000\u001a\u0010\u0010\u000e\u001a\u00020\u000f2\u0006\u0010\u0010\u001a\u00020\u0007H\u0002\u001a^\u0010\u0011\u001a\u00020\u00122\u0006\u0010\u0013\u001a\u00020\u00142\b\u0010\u0015\u001a\u0004\u0018\u00010\r2\b\u0010\u0016\u001a\u0004\u0018\u00010\u00142\u001a\u0010\u0017\u001a\u0016\u0012\u0004\u0012\u00020\u0018\u0012\n\u0012\b\u0012\u0004\u0012\u00020\u00070\u0019\u0018\u00010\u00052\u000e\u0010\u001a\u001a\n\u0012\u0006\u0012\u0004\u0018\u00010\u001c0\u001b2\u000e\u0010\u001d\u001a\n\u0012\u0006\u0012\u0004\u0018\u00010\u001c0\u001b\u001a\u001a\u0010\u001e\u001a\u0004\u0018\u00010\u001f2\u0006\u0010 \u001a\u00020\u00072\u0006\u0010!\u001a\u00020\tH\u0002\u001a2\u0010\"\u001a\u00020\u00122\u0006\u0010#\u001a\u00020$2\u0006\u0010%\u001a\u00020\u00142\b\u0010&\u001a\u0004\u0018\u00010\u00142\u0006\u0010'\u001a\u00020\u000f2\u0006\u0010(\u001a\u00020\u000fH\u0002\u001a(\u0010)\u001a\u00020\u00122\u0006\u0010*\u001a\u00020\u001f2\u0006\u0010#\u001a\u00020$2\u0006\u0010+\u001a\u00020,2\u0006\u0010-\u001a\u00020\u000fH\u0002\u001a\u001a\u0010.\u001a\u0004\u0018\u00010/2\u0006\u00100\u001a\u00020\u00142\u0006\u00101\u001a\u00020$H\u0007\u001a.\u0010.\u001a\u0004\u0018\u00010/2\u0006\u00100\u001a\u00020\u00142\f\u00102\u001a\b\u0012\u0004\u0012\u00020\u00180\u00192\u0006\u00103\u001a\u00020\u000f2\u0006\u0010+\u001a\u000204\u001a\u001a\u00105\u001a\u0004\u0018\u00010/2\u0006\u00100\u001a\u00020\u00142\b\u0010\f\u001a\u0004\u0018\u00010\r\u001aL\u00106\u001a\u0004\u0018\u00010/2\u0006\u00100\u001a\u00020\u00142\u0006\u00107\u001a\u00020\u00072\b\u00108\u001a\u0004\u0018\u00010\u00142\u0006\u0010#\u001a\u00020$2\u0006\u00103\u001a\u00020\u000f2\u0006\u00109\u001a\u00020\u000f2\u0006\u0010-\u001a\u00020\u000f2\u0006\u0010+\u001a\u000204H\u0002\u001aJ\u0010:\u001a\u0004\u0018\u00010/2\u0006\u00100\u001a\u00020\u00142\u0006\u0010#\u001a\u00020$2\u0006\u0010+\u001a\u0002042\u0006\u00103\u001a\u00020\u000f2\u0006\u00109\u001a\u00020\u000f2\u0006\u0010;\u001a\u00020\u000f2\u0006\u0010-\u001a\u00020\u000f2\b\b\u0002\u0010'\u001a\u00020\u000f\u001aL\u0010<\u001a\u0004\u0018\u00010/2\u0006\u00100\u001a\u00020\u00142\u0006\u0010=\u001a\u00020\u00072\u0006\u0010+\u001a\u0002042\u0006\u00101\u001a\u00020$2\u0006\u00103\u001a\u00020\u000f2\u0006\u00109\u001a\u00020\u000f2\u0006\u0010-\u001a\u00020\u000f2\b\u00108\u001a\u0004\u0018\u00010\u0014H\u0002\u001a\u0018\u0010>\u001a\u00020$2\u0006\u0010'\u001a\u00020\u000f2\u0006\u0010(\u001a\u00020\u000fH\u0000\u001a\u0018\u0010?\u001a\u00020\u00122\u0006\u0010@\u001a\u00020\u000b2\u0006\u0010#\u001a\u00020$H\u0002\u001a\u001a\u0010A\u001a\u0004\u0018\u00010/2\u0006\u0010B\u001a\u00020\u00142\u0006\u0010=\u001a\u00020\u0007H\u0000\u001aD\u0010C\u001a\u0004\u0018\u00010/2\u0006\u00100\u001a\u00020\u00142\u0006\u00101\u001a\u00020$2\u0006\u00103\u001a\u00020\u000f2\u0006\u00109\u001a\u00020\u000f2\u0006\u0010-\u001a\u00020\u000f2\u0006\u0010+\u001a\u0002042\b\b\u0002\u0010'\u001a\u00020\u000fH\u0002\u001a\u001c\u0010D\u001a\b\u0012\u0004\u0012\u00020/0E2\u0006\u0010'\u001a\u00020\u000f2\u0006\u0010(\u001a\u00020\u000f\u001a\u001e\u0010F\u001a\u00020\u00122\u0006\u0010G\u001a\u00020\u00142\f\u0010H\u001a\b\u0012\u0004\u0012\u00020\u00140\u001bH\u0002\u001a\u0016\u0010I\u001a\b\u0012\u0004\u0012\u00020\u00140E2\u0006\u0010 \u001a\u00020\u0014H\u0002\u001a\u0016\u0010J\u001a\b\u0012\u0004\u0012\u00020\u001c0E2\u0006\u0010\b\u001a\u00020\tH\u0007\"\u0014\u0010\u0000\u001a\u00020\u00018BX\u0082\u0004\u00a2\u0006\u0006\u001a\u0004\b\u0002\u0010\u0003\u00a8\u0006K"}, d2={"LOG", "Lcom/intellij/openapi/diagnostic/Logger;", "getLOG", "()Lcom/intellij/openapi/diagnostic/Logger;", "collectPluginFilesInClassPath", "", "Ljava/net/URL;", "", "loader", "Ljava/lang/ClassLoader;", "createPluginLoadingResult", "Lcom/intellij/ide/plugins/PluginLoadingResult;", "buildNumber", "Lcom/intellij/openapi/util/BuildNumber;", "fileNameIsLikeVersionedLibraryName", "", "name", "getDescriptorsToMigrate", "", "dir", "Ljava/nio/file/Path;", "compatibleBuildNumber", "bundledPluginsPath", "brokenPluginVersions", "Lcom/intellij/openapi/extensions/PluginId;", "", "pluginsToMigrate", "", "Lcom/intellij/ide/plugins/IdeaPluginDescriptor;", "incompatiblePlugins", "getResourceReader", "Lorg/codehaus/stax2/XMLStreamReader2;", "path", "classLoader", "loadBundledDescriptorsAndDescriptorsFromDir", "context", "Lcom/intellij/ide/plugins/DescriptorListLoadingContext;", "customPluginDir", "bundledPluginDir", "isUnitTestMode", "isRunningFromSources", "loadCoreProductPlugin", "reader", "pathResolver", "Lcom/intellij/ide/plugins/ClassPathXmlPathResolver;", "useCoreClassLoader", "loadDescriptor", "Lcom/intellij/ide/plugins/IdeaPluginDescriptorImpl;", "file", "parentContext", "disabledPlugins", "isBundled", "Lcom/intellij/ide/plugins/PathResolver;", "loadDescriptorFromArtifact", "loadDescriptorFromDir", "descriptorRelativePath", "pluginPath", "isEssential", "loadDescriptorFromFileOrDir", "isDirectory", "loadDescriptorFromJar", "fileName", "loadDescriptors", "loadDescriptorsFromProperty", "result", "loadForCoreEnv", "pluginRoot", "loadFromPluginDir", "loadUncachedDescriptors", "", "putMoreLikelyPluginJarsFirst", "pluginDir", "filesInLibUnderPluginDir", "resolveArchives", "testLoadDescriptorsFromClassPath", "intellij.platform.core.impl"})
@JvmName(name="PluginDescriptorLoader")
@ApiStatus.Internal
public final class PluginDescriptorLoader {
    private static final Logger getLOG() {
        Logger logger = PluginManagerCore.getLogger();
        Intrinsics.checkNotNullExpressionValue((Object)logger, (String)"PluginManagerCore.getLogger()");
        return logger;
    }

    @NotNull
    public static final PluginLoadingResult createPluginLoadingResult(@Nullable BuildNumber buildNumber) {
        Map<PluginId, Set<String>> map2 = PluginManagerCore.getBrokenPluginVersions();
        Intrinsics.checkNotNullExpressionValue(map2, (String)"PluginManagerCore.getBrokenPluginVersions()");
        return new PluginLoadingResult(map2, new Supplier(buildNumber){
            final /* synthetic */ BuildNumber $buildNumber;

            @NotNull
            public final BuildNumber get() {
                BuildNumber buildNumber = this.$buildNumber;
                if (buildNumber == null) {
                    BuildNumber buildNumber2 = PluginManagerCore.getBuildNumber();
                    buildNumber = buildNumber2;
                    Intrinsics.checkNotNullExpressionValue((Object)buildNumber2, (String)"PluginManagerCore.getBuildNumber()");
                }
                return buildNumber;
            }
            {
                this.$buildNumber = buildNumber;
            }
        }, false, 4, null);
    }

    @TestOnly
    @Nullable
    public static final IdeaPluginDescriptorImpl loadDescriptor(@NotNull Path file2, @NotNull DescriptorListLoadingContext parentContext) {
        Intrinsics.checkNotNullParameter((Object)file2, (String)"file");
        Intrinsics.checkNotNullParameter((Object)parentContext, (String)"parentContext");
        return PluginDescriptorLoader.loadDescriptorFromFileOrDir$default(file2, parentContext, PluginXmlPathResolver.DEFAULT_PATH_RESOLVER, false, false, Files.isDirectory(file2, new LinkOption[0]), false, false, 128, null);
    }

    @Nullable
    public static final IdeaPluginDescriptorImpl loadForCoreEnv(@NotNull Path pluginRoot, @NotNull String fileName) {
        Intrinsics.checkNotNullParameter((Object)pluginRoot, (String)"pluginRoot");
        Intrinsics.checkNotNullParameter((Object)fileName, (String)"fileName");
        PathResolver pathResolver = PluginXmlPathResolver.DEFAULT_PATH_RESOLVER;
        Set<PluginId> set = DisabledPluginsState.disabledPlugins();
        Intrinsics.checkNotNullExpressionValue(set, (String)"DisabledPluginsState.disabledPlugins()");
        DescriptorListLoadingContext parentContext = new DescriptorListLoadingContext(set, null, false, false, false, false, 62, null);
        if (Files.isDirectory(pluginRoot, new LinkOption[0])) {
            boolean bl = false;
            PathResolver pathResolver2 = pathResolver;
            return PluginDescriptorLoader.loadDescriptorFromDir(pluginRoot, "META-INF/" + fileName, null, parentContext, true, true, bl, pathResolver2);
        }
        boolean bl = false;
        Path path = null;
        return PluginDescriptorLoader.loadDescriptorFromJar(pluginRoot, fileName, pathResolver, parentContext, true, true, bl, path);
    }

    private static final IdeaPluginDescriptorImpl loadDescriptorFromDir(Path file2, String descriptorRelativePath, Path pluginPath, DescriptorListLoadingContext context2, boolean isBundled, boolean isEssential, boolean useCoreClassLoader, PathResolver pathResolver) {
        try {
            byte[] input = Files.readAllBytes(file2.resolve(descriptorRelativePath));
            LocalFsDataLoader dataLoader2 = new LocalFsDataLoader(file2);
            Intrinsics.checkNotNullExpressionValue((Object)input, (String)"input");
            RawPluginDescriptor raw = XmlReader.readModuleDescriptor(input, (ReadModuleContext)context2, pathResolver, (DataLoader)dataLoader2, null, null, ((Object)file2).toString());
            Path path = pluginPath;
            if (path == null) {
                path = file2;
            }
            IdeaPluginDescriptorImpl descriptor = new IdeaPluginDescriptorImpl(raw, path, isBundled, null, null, useCoreClassLoader);
            descriptor.readExternal(raw, pathResolver, context2, false, dataLoader2);
            descriptor.jarFiles = Collections.singletonList(file2);
            return descriptor;
        }
        catch (NoSuchFileException e) {
            return null;
        }
        catch (Throwable e) {
            if (isEssential) {
                throw e;
            }
            PluginDescriptorLoader.getLOG().warn("Cannot load " + file2.resolve(descriptorRelativePath), e);
            return null;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static final IdeaPluginDescriptorImpl loadDescriptorFromJar(Path file2, String fileName, PathResolver pathResolver, DescriptorListLoadingContext parentContext, boolean isBundled, boolean isEssential, boolean useCoreClassLoader, Path pluginPath) {
        Closeable closeable = null;
        try {
            InputStream inputStream;
            DataLoader dataLoader2 = null;
            ZipFilePool pool = ZipFilePool.POOL;
            if (pool == null || parentContext.transient) {
                ZipFile zipFile = new ZipFile(file2.toFile(), StandardCharsets.UTF_8);
                closeable = zipFile;
                dataLoader2 = new JavaZipFileDataLoader(zipFile);
            } else {
                ZipFilePool.EntryResolver entryResolver = pool.load(file2);
                Intrinsics.checkNotNullExpressionValue((Object)entryResolver, (String)"pool.load(file)");
                dataLoader2 = new ImmutableZipFileDataLoader(entryResolver, file2, pool);
            }
            if (dataLoader2.load("META-INF/" + fileName) == null) {
                IdeaPluginDescriptorImpl ideaPluginDescriptorImpl = null;
                return ideaPluginDescriptorImpl;
            }
            RawPluginDescriptor raw = XmlReader.readModuleDescriptor(inputStream, (ReadModuleContext)parentContext, pathResolver, dataLoader2, null, null, ((Object)file2).toString());
            Path path = pluginPath;
            if (path == null) {
                path = file2;
            }
            IdeaPluginDescriptorImpl descriptor = new IdeaPluginDescriptorImpl(raw, path, isBundled, null, null, useCoreClassLoader);
            descriptor.readExternal(raw, pathResolver, parentContext, false, dataLoader2);
            descriptor.jarFiles = Collections.singletonList(descriptor.getPluginPath());
            IdeaPluginDescriptorImpl ideaPluginDescriptorImpl = descriptor;
            return ideaPluginDescriptorImpl;
        }
        catch (Throwable e) {
            if (isEssential) {
                throw e instanceof XMLStreamException ? (Throwable)new RuntimeException("Cannot read " + file2, e) : e;
            }
            parentContext.result.reportCannotLoad(file2, e);
        }
        finally {
            Closeable closeable2 = closeable;
            if (closeable2 != null) {
                closeable2.close();
            }
        }
        return null;
    }

    @Nullable
    public static final IdeaPluginDescriptorImpl loadDescriptorFromFileOrDir(@NotNull Path file2, @NotNull DescriptorListLoadingContext context2, @NotNull PathResolver pathResolver, boolean isBundled, boolean isEssential, boolean isDirectory, boolean useCoreClassLoader, boolean isUnitTestMode) {
        IdeaPluginDescriptorImpl ideaPluginDescriptorImpl;
        Intrinsics.checkNotNullParameter((Object)file2, (String)"file");
        Intrinsics.checkNotNullParameter((Object)context2, (String)"context");
        Intrinsics.checkNotNullParameter((Object)pathResolver, (String)"pathResolver");
        if (isDirectory) {
            ideaPluginDescriptorImpl = PluginDescriptorLoader.loadFromPluginDir(file2, context2, isBundled, isEssential, useCoreClassLoader, pathResolver, isUnitTestMode);
        } else if (StringsKt.endsWith((String)((Object)file2.getFileName()).toString(), (String)".jar", (boolean)true)) {
            boolean bl = useCoreClassLoader;
            Path path = null;
            ideaPluginDescriptorImpl = PluginDescriptorLoader.loadDescriptorFromJar(file2, "plugin.xml", pathResolver, context2, isBundled, isEssential, bl, path);
        } else {
            ideaPluginDescriptorImpl = null;
        }
        return ideaPluginDescriptorImpl;
    }

    public static /* synthetic */ IdeaPluginDescriptorImpl loadDescriptorFromFileOrDir$default(Path path, DescriptorListLoadingContext descriptorListLoadingContext, PathResolver pathResolver, boolean bl, boolean bl2, boolean bl3, boolean bl4, boolean bl5, int n, Object object) {
        if ((n & 0x80) != 0) {
            bl5 = false;
        }
        return PluginDescriptorLoader.loadDescriptorFromFileOrDir(path, descriptorListLoadingContext, pathResolver, bl, bl2, bl3, bl4, bl5);
    }

    private static final IdeaPluginDescriptorImpl loadFromPluginDir(Path file2, DescriptorListLoadingContext parentContext, boolean isBundled, boolean isEssential, boolean useCoreClassLoader, PathResolver pathResolver, boolean isUnitTestMode) {
        Object it;
        ArrayList pluginJarFiles = new ArrayList(PluginDescriptorLoader.resolveArchives(file2));
        if (!pluginJarFiles.isEmpty()) {
            PluginDescriptorLoader.putMoreLikelyPluginJarsFirst(file2, pluginJarFiles);
            PluginXmlPathResolver pluginPathResolver = new PluginXmlPathResolver(pluginJarFiles);
            Iterator iterator = pluginJarFiles.iterator();
            while (iterator.hasNext()) {
                Path jarFile;
                Path path = jarFile = (Path)iterator.next();
                Intrinsics.checkNotNullExpressionValue((Object)path, (String)"jarFile");
                boolean bl = useCoreClassLoader;
                Path path2 = file2;
                IdeaPluginDescriptorImpl ideaPluginDescriptorImpl = PluginDescriptorLoader.loadDescriptorFromJar(path, "plugin.xml", pluginPathResolver, parentContext, isBundled, isEssential, bl, path2);
                if (ideaPluginDescriptorImpl == null) continue;
                IdeaPluginDescriptorImpl ideaPluginDescriptorImpl2 = ideaPluginDescriptorImpl;
                it = ideaPluginDescriptorImpl2;
                boolean bl2 = false;
                ((IdeaPluginDescriptorImpl)it).jarFiles = pluginJarFiles;
                return it;
            }
        }
        if (!isBundled || isUnitTestMode) {
            Object object;
            Sequence sequence;
            Path classesDir;
            block5: {
                classesDir = file2.resolve("classes");
                sequence = SequencesKt.sequenceOf((Object[])new Path[]{classesDir, file2});
                for (Object e : sequence) {
                    it = (Path)e;
                    boolean bl = false;
                    Path path = it;
                    Intrinsics.checkNotNullExpressionValue((Object)path, (String)"it");
                    boolean bl3 = useCoreClassLoader;
                    PathResolver pathResolver2 = pathResolver;
                    it = PluginDescriptorLoader.loadDescriptorFromDir(path, "META-INF/plugin.xml", file2, parentContext, isBundled, isEssential, bl3, pathResolver2);
                    if (it == null) continue;
                    object = it;
                    break block5;
                }
                object = null;
            }
            if (object != null) {
                Sequence it2 = sequence = object;
                boolean bl = false;
                ArrayList<Path> classPath = new ArrayList<Path>(pluginJarFiles.size() + 1);
                classPath.add(classesDir);
                classPath.addAll(pluginJarFiles);
                it2.jarFiles = classPath;
                return it2;
            }
        }
        return null;
    }

    static /* synthetic */ IdeaPluginDescriptorImpl loadFromPluginDir$default(Path path, DescriptorListLoadingContext descriptorListLoadingContext, boolean bl, boolean bl2, boolean bl3, PathResolver pathResolver, boolean bl4, int n, Object object) {
        if ((n & 0x40) != 0) {
            bl4 = false;
        }
        return PluginDescriptorLoader.loadFromPluginDir(path, descriptorListLoadingContext, bl, bl2, bl3, pathResolver, bl4);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * WARNING - void declaration
     */
    private static final List<Path> resolveArchives(Path path) {
        Object object;
        try {
            List list;
            object = Files.newDirectoryStream(path.resolve("lib"));
            Throwable throwable = null;
            try {
                void $this$filterTo$iv$iv;
                DirectoryStream stream = (DirectoryStream)object;
                boolean bl = false;
                DirectoryStream directoryStream = stream;
                Intrinsics.checkNotNullExpressionValue((Object)directoryStream, (String)"stream");
                Iterable $this$filter$iv = directoryStream;
                boolean $i$f$filter = false;
                Iterable iterable = $this$filter$iv;
                Collection destination$iv$iv = new ArrayList();
                boolean $i$f$filterTo = false;
                for (Object element$iv$iv : $this$filterTo$iv$iv) {
                    Path it = (Path)element$iv$iv;
                    boolean bl2 = false;
                    String childPath = ((Object)it).toString();
                    if (!(StringsKt.endsWith((String)childPath, (String)".jar", (boolean)true) || StringsKt.endsWith((String)childPath, (String)".zip", (boolean)true))) continue;
                    destination$iv$iv.add(element$iv$iv);
                }
                list = (List)destination$iv$iv;
            }
            catch (Throwable throwable2) {
                throwable = throwable2;
                throw throwable2;
            }
            finally {
                CloseableKt.closeFinally((Closeable)object, (Throwable)throwable);
            }
            object = list;
        }
        catch (NoSuchFileException e) {
            object = CollectionsKt.emptyList();
        }
        return object;
    }

    private static final void putMoreLikelyPluginJarsFirst(Path pluginDir, List<Path> filesInLibUnderPluginDir) {
        String pluginDirName = ((Object)pluginDir.getFileName()).toString();
        Collections.sort(filesInLibUnderPluginDir, new Comparator(pluginDirName){
            final /* synthetic */ String $pluginDirName;

            public final int compare(@NotNull Path o1, @NotNull Path o2) {
                boolean o1EndsWithIdea;
                boolean o1StartsWithNeededName;
                boolean o1IsVersioned;
                Intrinsics.checkNotNullParameter((Object)o1, (String)"o1");
                Intrinsics.checkNotNullParameter((Object)o2, (String)"o2");
                String o2Name = ((Object)o2.getFileName()).toString();
                String o1Name = ((Object)o1.getFileName()).toString();
                boolean o2StartsWithResources = StringsKt.startsWith$default((String)o2Name, (String)"resources", (boolean)false, (int)2, null);
                boolean o1StartsWithResources = StringsKt.startsWith$default((String)o1Name, (String)"resources", (boolean)false, (int)2, null);
                if (o2StartsWithResources != o1StartsWithResources) {
                    return o2StartsWithResources ? -1 : 1;
                }
                boolean o2IsVersioned = PluginDescriptorLoader.access$fileNameIsLikeVersionedLibraryName(o2Name);
                if (o2IsVersioned != (o1IsVersioned = PluginDescriptorLoader.access$fileNameIsLikeVersionedLibraryName(o1Name))) {
                    return o2IsVersioned ? -1 : 1;
                }
                boolean o2StartsWithNeededName = StringsKt.startsWith((String)o2Name, (String)this.$pluginDirName, (boolean)true);
                if (o2StartsWithNeededName != (o1StartsWithNeededName = StringsKt.startsWith((String)o1Name, (String)this.$pluginDirName, (boolean)true))) {
                    return o2StartsWithNeededName ? 1 : -1;
                }
                boolean o2EndsWithIdea = StringsKt.endsWith$default((String)o2Name, (String)"-idea.jar", (boolean)false, (int)2, null);
                if (o2EndsWithIdea != (o1EndsWithIdea = StringsKt.endsWith$default((String)o1Name, (String)"-idea.jar", (boolean)false, (int)2, null))) {
                    return o2EndsWithIdea ? 1 : -1;
                }
                return o1Name.length() - o2Name.length();
            }
            {
                this.$pluginDirName = string2;
            }
        });
    }

    private static final boolean fileNameIsLikeVersionedLibraryName(String name) {
        int i = StringsKt.lastIndexOf$default((CharSequence)name, (char)'-', (int)0, (boolean)false, (int)6, null);
        if (i == -1) {
            return false;
        }
        if (i + 1 < name.length()) {
            char c = name.charAt(i + 1);
            return Character.isDigit(c) || (c == 'm' || c == 'M') && i + 2 < name.length() && Character.isDigit(name.charAt(i + 2));
        }
        return false;
    }

    private static final void loadDescriptorsFromProperty(PluginLoadingResult result2, DescriptorListLoadingContext context2) {
        String string2 = System.getProperty("plugin.path");
        if (string2 == null) {
            return;
        }
        String pathProperty = string2;
        boolean useCoreClassLoaderForPluginsFromProperty = Boolean.parseBoolean(System.getProperty("idea.use.core.classloader.for.plugin.path"));
        char c = File.pathSeparatorChar;
        String string3 = ",";
        StringTokenizer t = new StringTokenizer(pathProperty, c + string3);
        while (t.hasMoreTokens()) {
            IdeaPluginDescriptorImpl ideaPluginDescriptorImpl;
            Path file2;
            String s = t.nextToken();
            Path path = file2 = Paths.get(s, new String[0]);
            Intrinsics.checkNotNullExpressionValue((Object)path, (String)"file");
            if (PluginDescriptorLoader.loadDescriptorFromFileOrDir$default(path, context2, PluginXmlPathResolver.DEFAULT_PATH_RESOLVER, false, false, Files.isDirectory(file2, new LinkOption[0]), useCoreClassLoaderForPluginsFromProperty, false, 128, null) == null) continue;
            IdeaPluginDescriptorImpl it = ideaPluginDescriptorImpl;
            boolean bl = false;
            result2.add(it, true);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @NotNull
    public static final DescriptorListLoadingContext loadDescriptors(boolean isUnitTestMode, boolean isRunningFromSources) {
        PluginLoadingResult result2 = PluginDescriptorLoader.createPluginLoadingResult(null);
        Path bundledPluginPath = isUnitTestMode ? null : (Boolean.getBoolean("idea.use.dev.build.server") ? Paths.get(PathManager.getHomePath(), "out/dev-run", PlatformUtils.getPlatformPrefix(), "plugins") : Paths.get(PathManager.getPreInstalledPluginsPath(), new String[0]));
        boolean bl = isUnitTestMode || isRunningFromSources;
        Unit unit = DisabledPluginsState.disabledPlugins();
        Intrinsics.checkNotNullExpressionValue(unit, (String)"DisabledPluginsState.disabledPlugins()");
        boolean bl2 = false;
        Object object = result2;
        Unit unit2 = unit;
        boolean bl3 = bl;
        boolean bl4 = isUnitTestMode;
        boolean bl5 = true;
        DescriptorListLoadingContext context2 = new DescriptorListLoadingContext((Set)unit2, (PluginLoadingResult)object, bl4, bl5, bl3, bl2, 32, null);
        AutoCloseable autoCloseable = context2;
        object = null;
        try {
            DescriptorListLoadingContext it = (DescriptorListLoadingContext)autoCloseable;
            boolean bl6 = false;
            Path path = Paths.get(PathManager.getPluginsPath(), new String[0]);
            Intrinsics.checkNotNullExpressionValue((Object)path, (String)"Paths.get(PathManager.getPluginsPath())");
            PluginDescriptorLoader.loadBundledDescriptorsAndDescriptorsFromDir(context2, path, bundledPluginPath, isUnitTestMode, isRunningFromSources);
            PluginDescriptorLoader.loadDescriptorsFromProperty(result2, context2);
            if (isUnitTestMode && result2.enabledPluginCount() <= 1) {
                ForkJoinPool forkJoinPool = ForkJoinPool.commonPool();
                Path path2 = Paths.get(PathManager.getPreInstalledPluginsPath(), new String[0]);
                Intrinsics.checkNotNullExpressionValue((Object)path2, (String)"Paths.get(PathManager.ge\u2026reInstalledPluginsPath())");
                forkJoinPool.invoke(new LoadDescriptorsFromDirAction(path2, context2, true));
            }
            unit2 = Unit.INSTANCE;
        }
        catch (Throwable throwable) {
            object = throwable;
            throw throwable;
        }
        finally {
            AutoCloseableKt.closeFinally((AutoCloseable)autoCloseable, (Throwable)object);
        }
        context2.result.finishLoading();
        return context2;
    }

    private static final void loadBundledDescriptorsAndDescriptorsFromDir(DescriptorListLoadingContext context2, Path customPluginDir, Path bundledPluginDir, boolean isUnitTestMode, boolean isRunningFromSources) {
        boolean useCoreClassLoader;
        ClassLoader classLoader = DescriptorListLoadingContext.class.getClassLoader();
        ForkJoinPool pool = ForkJoinPool.commonPool();
        Activity activity = StartUpMeasurer.startActivity("platform plugin collecting", ActivityCategory.DEFAULT);
        Intrinsics.checkNotNullExpressionValue((Object)activity, (String)"StartUpMeasurer.startAct\u2026ActivityCategory.DEFAULT)");
        Activity activity2 = activity;
        String string2 = PlatformUtils.getPlatformPrefix();
        Intrinsics.checkNotNullExpressionValue((Object)string2, (String)"PlatformUtils.getPlatformPrefix()");
        String platformPrefix = string2;
        boolean isInDevServerMode = Boolean.getBoolean("idea.use.dev.build.server");
        ClassLoader classLoader2 = classLoader;
        Intrinsics.checkNotNullExpressionValue((Object)classLoader2, (String)"classLoader");
        ClassPathXmlPathResolver pathResolver = new ClassPathXmlPathResolver(classLoader2, isRunningFromSources && !isInDevServerMode);
        boolean bl = useCoreClassLoader = pathResolver.isRunningFromSources() || StringsKt.startsWith$default((String)platformPrefix, (String)"CodeServer", (boolean)false, (int)2, null) || Boolean.getBoolean("idea.force.use.core.classloader");
        if ((Intrinsics.areEqual((Object)platformPrefix, (Object)"idea") || Intrinsics.areEqual((Object)platformPrefix, (Object)"WebStorm")) && (isInDevServerMode || !isUnitTestMode && !isRunningFromSources)) {
            XMLStreamReader2 xMLStreamReader2 = PluginDescriptorLoader.getResourceReader("META-INF/plugin.xml", classLoader);
            Intrinsics.checkNotNull((Object)xMLStreamReader2);
            PluginDescriptorLoader.loadCoreProductPlugin(xMLStreamReader2, context2, pathResolver, useCoreClassLoader);
        } else {
            String fileName = platformPrefix + "Plugin.xml";
            XMLStreamReader2 xMLStreamReader2 = PluginDescriptorLoader.getResourceReader("META-INF/" + fileName, classLoader);
            if (xMLStreamReader2 != null) {
                XMLStreamReader2 xMLStreamReader22;
                XMLStreamReader2 it = xMLStreamReader22 = xMLStreamReader2;
                boolean bl2 = false;
                PluginDescriptorLoader.loadCoreProductPlugin(it, context2, pathResolver, useCoreClassLoader);
            }
            Map<URL, String> urlToFilename = PluginDescriptorLoader.collectPluginFilesInClassPath(classLoader);
            if (!urlToFilename.isEmpty()) {
                Activity activity3 = activity2.endAndStart("plugin from classpath loading");
                Intrinsics.checkNotNullExpressionValue((Object)activity3, (String)"activity.endAndStart(\"pl\u2026 from classpath loading\")");
                activity2 = activity3;
                pool.invoke(new LoadDescriptorsFromClassPathAction(urlToFilename, context2, pathResolver, useCoreClassLoader));
            }
        }
        Activity activity4 = activity2.endAndStart("plugin from user dir loading");
        Intrinsics.checkNotNullExpressionValue((Object)activity4, (String)"activity.endAndStart(\"pl\u2026n from user dir loading\")");
        activity2 = activity4;
        pool.invoke(new LoadDescriptorsFromDirAction(customPluginDir, context2, false));
        if (bundledPluginDir != null) {
            Activity activity5 = activity2.endAndStart("plugin from bundled dir loading");
            Intrinsics.checkNotNullExpressionValue((Object)activity5, (String)"activity.endAndStart(\"pl\u2026rom bundled dir loading\")");
            activity2 = activity5;
            pool.invoke(new LoadDescriptorsFromDirAction(bundledPluginDir, context2, true));
        }
        activity2.end();
    }

    private static final XMLStreamReader2 getResourceReader(String path, ClassLoader classLoader) {
        if (classLoader instanceof UrlClassLoader) {
            byte[] byArray = ((UrlClassLoader)classLoader).getResourceAsBytes(path, false);
            if (byArray == null) {
                return null;
            }
            return StaxFactory.createNonCoalescingXmlStreamReader(byArray, path);
        }
        InputStream inputStream = classLoader.getResourceAsStream(path);
        if (inputStream == null) {
            return null;
        }
        return StaxFactory.createNonCoalescingXmlStreamReader(inputStream, path);
    }

    private static final void loadCoreProductPlugin(XMLStreamReader2 reader, DescriptorListLoadingContext context2, ClassPathXmlPathResolver pathResolver, boolean useCoreClassLoader) {
        DataLoader dataLoader2 = new DataLoader(){

            @NotNull
            public ZipFilePool getPool() {
                throw (Throwable)new IllegalStateException("must be not called");
            }

            public boolean getEmptyDescriptorIfCannotResolve() {
                return true;
            }

            @NotNull
            public Void load(@NotNull String path) {
                Intrinsics.checkNotNullParameter((Object)path, (String)"path");
                throw (Throwable)new IllegalStateException("must be not called");
            }

            @NotNull
            public String toString() {
                return "product classpath";
            }

            public boolean isExcludedFromSubSearch(@NotNull Path jarFile) {
                Intrinsics.checkNotNullParameter((Object)jarFile, (String)"jarFile");
                return DataLoader.DefaultImpls.isExcludedFromSubSearch(this, jarFile);
            }
        };
        RawPluginDescriptor raw = XmlReader.readModuleDescriptor(reader, context2, pathResolver, dataLoader2, null, null);
        Path path = Paths.get(PathManager.getLibPath(), new String[0]);
        Intrinsics.checkNotNullExpressionValue((Object)path, (String)"Paths.get(PathManager.getLibPath())");
        IdeaPluginDescriptorImpl descriptor = new IdeaPluginDescriptorImpl(raw, path, true, null, null, useCoreClassLoader);
        descriptor.readExternal(raw, pathResolver, context2, false, dataLoader2);
        context2.result.add(descriptor, false);
    }

    private static final Map<URL, String> collectPluginFilesInClassPath(ClassLoader loader) {
        LinkedHashMap<URL, String> urlToFilename = new LinkedHashMap<URL, String>();
        try {
            Enumeration<URL> enumeration = loader.getResources("META-INF/plugin.xml");
            while (enumeration.hasMoreElements()) {
                urlToFilename.put(enumeration.nextElement(), "plugin.xml");
            }
        }
        catch (IOException e) {
            PluginDescriptorLoader.getLOG().warn(e);
        }
        return urlToFilename;
    }

    @NotNull
    public static final List<IdeaPluginDescriptorImpl> loadUncachedDescriptors(boolean isUnitTestMode, boolean isRunningFromSources) {
        return PluginDescriptorLoader.loadDescriptors((boolean)isUnitTestMode, (boolean)isRunningFromSources).result.getEnabledPlugins();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Nullable
    public static final IdeaPluginDescriptorImpl loadDescriptorFromArtifact(@NotNull Path file2, @Nullable BuildNumber buildNumber) throws IOException {
        Intrinsics.checkNotNullParameter((Object)file2, (String)"file");
        Set<PluginId> set = DisabledPluginsState.disabledPlugins();
        Intrinsics.checkNotNullExpressionValue(set, (String)"DisabledPluginsState.disabledPlugins()");
        boolean bl = true;
        boolean bl2 = false;
        PluginLoadingResult pluginLoadingResult = PluginDescriptorLoader.createPluginLoadingResult(buildNumber);
        boolean bl3 = false;
        Set<PluginId> set2 = set;
        boolean bl4 = true;
        DescriptorListLoadingContext context2 = new DescriptorListLoadingContext(set2, pluginLoadingResult, bl3, bl4, bl2, bl, 20, null);
        IdeaPluginDescriptorImpl descriptor = PluginDescriptorLoader.loadDescriptorFromFileOrDir$default(file2, context2, PluginXmlPathResolver.DEFAULT_PATH_RESOLVER, false, false, false, false, false, 128, null);
        if (descriptor != null || !StringsKt.endsWith$default((String)((Object)file2).toString(), (String)".zip", (boolean)false, (int)2, null)) {
            return descriptor;
        }
        Path path = Files.createTempDirectory("plugin", new FileAttribute[0]);
        Intrinsics.checkNotNull((Object)path);
        Path outputDir = path;
        try {
            new Decompressor.Zip(file2).extract(outputDir);
            try {
                Object v4;
                block9: {
                    List<Path> list = NioFiles.list(outputDir);
                    Intrinsics.checkNotNullExpressionValue(list, (String)"NioFiles.list(outputDir)");
                    Iterable $this$firstOrNull$iv = list;
                    boolean $i$f$firstOrNull = false;
                    for (Object element$iv : $this$firstOrNull$iv) {
                        Path it = (Path)element$iv;
                        boolean bl5 = false;
                        Path path2 = it;
                        Intrinsics.checkNotNullExpressionValue((Object)path2, (String)"it");
                        if (!(Intrinsics.areEqual((Object)PathsKt.getName((Path)path2), (Object)"__index__") ^ true)) continue;
                        v4 = element$iv;
                        break block9;
                    }
                    v4 = null;
                }
                Path rootDir = v4;
                if (rootDir != null) {
                    IdeaPluginDescriptorImpl ideaPluginDescriptorImpl = PluginDescriptorLoader.loadDescriptorFromFileOrDir$default(rootDir, context2, PluginXmlPathResolver.DEFAULT_PATH_RESOLVER, false, false, true, false, false, 128, null);
                    return ideaPluginDescriptorImpl;
                }
            }
            catch (NoSuchFileException noSuchFileException) {
            }
        }
        finally {
            NioFiles.deleteRecursively(outputDir);
        }
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Nullable
    public static final IdeaPluginDescriptorImpl loadDescriptor(@NotNull Path file2, @NotNull Set<PluginId> disabledPlugins, boolean isBundled, @NotNull PathResolver pathResolver) {
        Intrinsics.checkNotNullParameter((Object)file2, (String)"file");
        Intrinsics.checkNotNullParameter(disabledPlugins, (String)"disabledPlugins");
        Intrinsics.checkNotNullParameter((Object)pathResolver, (String)"pathResolver");
        AutoCloseable autoCloseable = new DescriptorListLoadingContext(disabledPlugins, null, false, false, false, false, 62, null);
        Throwable throwable = null;
        try {
            DescriptorListLoadingContext context2 = (DescriptorListLoadingContext)autoCloseable;
            boolean bl = false;
            IdeaPluginDescriptorImpl ideaPluginDescriptorImpl = PluginDescriptorLoader.loadDescriptorFromFileOrDir$default(file2, context2, pathResolver, isBundled, false, Files.isDirectory(file2, new LinkOption[0]), false, false, 128, null);
            return ideaPluginDescriptorImpl;
        }
        catch (Throwable throwable2) {
            throwable = throwable2;
            throw throwable2;
        }
        finally {
            AutoCloseableKt.closeFinally((AutoCloseable)autoCloseable, (Throwable)throwable);
        }
    }

    public static final void getDescriptorsToMigrate(@NotNull Path dir, @Nullable BuildNumber compatibleBuildNumber, @Nullable Path bundledPluginsPath, @Nullable Map<PluginId, ? extends Set<String>> brokenPluginVersions, @NotNull List<IdeaPluginDescriptor> pluginsToMigrate, @NotNull List<IdeaPluginDescriptor> incompatiblePlugins) throws ExecutionException, InterruptedException {
        IdeaPluginDescriptorImpl descriptor;
        Intrinsics.checkNotNullParameter((Object)dir, (String)"dir");
        Intrinsics.checkNotNullParameter(pluginsToMigrate, (String)"pluginsToMigrate");
        Intrinsics.checkNotNullParameter(incompatiblePlugins, (String)"incompatiblePlugins");
        Map<PluginId, Set<String>> map2 = brokenPluginVersions;
        if (map2 == null) {
            Map<PluginId, Set<String>> map3 = PluginManagerCore.getBrokenPluginVersions();
            map2 = map3;
            Intrinsics.checkNotNullExpressionValue(map3, (String)"PluginManagerCore.getBrokenPluginVersions()");
        }
        PluginLoadingResult loadingResult2 = new PluginLoadingResult(map2, new Supplier(compatibleBuildNumber){
            final /* synthetic */ BuildNumber $compatibleBuildNumber;

            @NotNull
            public final BuildNumber get() {
                BuildNumber buildNumber = this.$compatibleBuildNumber;
                if (buildNumber == null) {
                    BuildNumber buildNumber2 = PluginManagerCore.getBuildNumber();
                    buildNumber = buildNumber2;
                    Intrinsics.checkNotNullExpressionValue((Object)buildNumber2, (String)"PluginManagerCore.getBuildNumber()");
                }
                return buildNumber;
            }
            {
                this.$compatibleBuildNumber = buildNumber;
            }
        }, false, 4, null);
        DescriptorListLoadingContext context2 = new DescriptorListLoadingContext(SetsKt.emptySet(), loadingResult2, true, true, false, false, 48, null);
        Path effectiveBundledPluginPath = bundledPluginsPath != null || PluginManagerCore.isUnitTestMode ? bundledPluginsPath : Paths.get(PathManager.getPreInstalledPluginsPath(), new String[0]);
        PluginDescriptorLoader.loadBundledDescriptorsAndDescriptorsFromDir(context2, dir, effectiveBundledPluginPath, PluginManagerCore.isUnitTestMode, PluginManagerCore.isRunningFromSources());
        Iterator<IdeaPluginDescriptorImpl> iterator = loadingResult2.idMap.values().iterator();
        while (iterator.hasNext()) {
            IdeaPluginDescriptorImpl ideaPluginDescriptorImpl = descriptor = iterator.next();
            Intrinsics.checkNotNullExpressionValue((Object)ideaPluginDescriptorImpl, (String)"descriptor");
            if (ideaPluginDescriptorImpl.isBundled()) continue;
            if (loadingResult2.isBroken(descriptor.getPluginId())) {
                incompatiblePlugins.add(descriptor);
                continue;
            }
            pluginsToMigrate.add(descriptor);
        }
        iterator = loadingResult2.incompletePlugins.values().iterator();
        while (iterator.hasNext()) {
            IdeaPluginDescriptorImpl ideaPluginDescriptorImpl = descriptor = iterator.next();
            Intrinsics.checkNotNullExpressionValue((Object)ideaPluginDescriptorImpl, (String)"descriptor");
            if (ideaPluginDescriptorImpl.isBundled()) continue;
            incompatiblePlugins.add(descriptor);
        }
    }

    @TestOnly
    @NotNull
    public static final List<IdeaPluginDescriptor> testLoadDescriptorsFromClassPath(@NotNull ClassLoader loader) {
        Intrinsics.checkNotNullParameter((Object)loader, (String)"loader");
        Map<URL, String> urlToFilename = PluginDescriptorLoader.collectPluginFilesInClassPath(loader);
        BuildNumber buildNumber = BuildNumber.fromString("2042.42");
        Intrinsics.checkNotNull((Object)buildNumber);
        Intrinsics.checkNotNullExpressionValue((Object)buildNumber, (String)"BuildNumber.fromString(\"2042.42\")!!");
        BuildNumber buildNumber2 = buildNumber;
        Set set = Collections.emptySet();
        Intrinsics.checkNotNullExpressionValue(set, (String)"Collections.emptySet()");
        DescriptorListLoadingContext context2 = new DescriptorListLoadingContext(set, new PluginLoadingResult(MapsKt.emptyMap(), new Supplier(buildNumber2){
            final /* synthetic */ BuildNumber $buildNumber;

            @NotNull
            public final BuildNumber get() {
                return this.$buildNumber;
            }
            {
                this.$buildNumber = buildNumber;
            }
        }, false), false, false, false, false, 60, null);
        new LoadDescriptorsFromClassPathAction(urlToFilename, context2, new ClassPathXmlPathResolver(loader, false), true).compute();
        context2.result.finishLoading();
        return context2.result.getEnabledPlugins();
    }

    public static final /* synthetic */ Logger access$getLOG$p() {
        return PluginDescriptorLoader.getLOG();
    }

    public static final /* synthetic */ boolean access$fileNameIsLikeVersionedLibraryName(String name) {
        return PluginDescriptorLoader.fileNameIsLikeVersionedLibraryName(name);
    }
}

