/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.ide.util;

import com.intellij.openapi.util.Key;
import com.intellij.psi.JavaRecursiveElementVisitor;
import com.intellij.psi.JavaRecursiveElementWalkingVisitor;
import com.intellij.psi.PsiAnonymousClass;
import com.intellij.psi.PsiClass;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiExpression;
import com.intellij.psi.PsiExpressionList;
import com.intellij.psi.util.CachedValueProvider;
import com.intellij.psi.util.CachedValuesManager;
import com.intellij.psi.util.ParameterizedCachedValue;
import com.intellij.psi.util.ParameterizedCachedValueProvider;
import com.intellij.psi.util.PsiTreeUtil;
import java.util.HashMap;
import java.util.Map;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public final class JavaAnonymousClassesHelper {
    private static final Key<ParameterizedCachedValue<Map<PsiAnonymousClass, String>, PsiClass>> ANONYMOUS_CLASS_NAME = Key.create("ANONYMOUS_CLASS_NAME");
    private static final AnonClassProvider ANON_CLASS_PROVIDER = new AnonClassProvider();

    @Nullable
    public static String getName(@NotNull PsiAnonymousClass cls) {
        PsiClass upper;
        if (cls == null) {
            JavaAnonymousClassesHelper.$$$reportNull$$$0(0);
        }
        if ((upper = PsiTreeUtil.getParentOfType((PsiElement)cls, PsiClass.class)) == null) {
            return null;
        }
        ParameterizedCachedValue<Map<PsiAnonymousClass, String>, PsiClass> value = upper.getUserData(ANONYMOUS_CLASS_NAME);
        if (value == null) {
            value = CachedValuesManager.getManager(upper.getProject()).createParameterizedCachedValue(ANON_CLASS_PROVIDER, false);
            upper.putUserData(ANONYMOUS_CLASS_NAME, value);
        }
        return value.getValue(upper).get(cls);
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "cls", "com/intellij/ide/util/JavaAnonymousClassesHelper", "getName"));
    }

    private static final class AnonClassProvider
    implements ParameterizedCachedValueProvider<Map<PsiAnonymousClass, String>, PsiClass> {
        private AnonClassProvider() {
        }

        @Override
        public CachedValueProvider.Result<Map<PsiAnonymousClass, String>> compute(final PsiClass upper) {
            final HashMap map2 = new HashMap();
            upper.accept(new JavaRecursiveElementWalkingVisitor(){
                int index;

                @Override
                public void visitAnonymousClass(PsiAnonymousClass aClass) {
                    if (upper == aClass) {
                        super.visitAnonymousClass(aClass);
                        return;
                    }
                    PsiExpressionList arguments = aClass.getArgumentList();
                    if (arguments != null) {
                        for (PsiExpression expression : arguments.getExpressions()) {
                            expression.acceptChildren(new JavaRecursiveElementVisitor(){

                                @Override
                                public void visitAnonymousClass(PsiAnonymousClass aClass) {
                                    ++index;
                                    map2.put(aClass, "$" + index);
                                }
                            });
                        }
                    }
                    ++this.index;
                    map2.put(aClass, "$" + this.index);
                }

                @Override
                public void visitClass(PsiClass aClass) {
                    if (aClass == upper) {
                        super.visitClass(aClass);
                    }
                }
            });
            return CachedValueProvider.Result.create(map2, upper);
        }
    }
}

