/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.psi.impl.java.stubs.impl;

import com.intellij.psi.JavaPsiFacade;
import com.intellij.psi.PsiClassType;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiElementFactory;
import com.intellij.psi.PsiJavaCodeReferenceElement;
import com.intellij.psi.PsiReferenceList;
import com.intellij.psi.impl.cache.TypeAnnotationContainer;
import com.intellij.psi.impl.cache.TypeInfo;
import com.intellij.psi.impl.compiled.ClsJavaCodeReferenceElementImpl;
import com.intellij.psi.impl.java.stubs.JavaClassReferenceListElementType;
import com.intellij.psi.impl.java.stubs.PsiClassReferenceListStub;
import com.intellij.psi.impl.source.PsiClassReferenceType;
import com.intellij.psi.impl.source.PsiJavaCodeReferenceElementImpl;
import com.intellij.psi.stubs.StubBase;
import com.intellij.psi.stubs.StubElement;
import com.intellij.util.ArrayUtil;
import com.intellij.util.IncorrectOperationException;
import com.intellij.util.containers.ContainerUtil;
import org.jetbrains.annotations.NotNull;

public class PsiClassReferenceListStubImpl
extends StubBase<PsiReferenceList>
implements PsiClassReferenceListStub {
    private final TypeInfo @NotNull [] myInfos;
    private volatile PsiClassType[] myTypes;

    public PsiClassReferenceListStubImpl(@NotNull JavaClassReferenceListElementType type, StubElement parent, String @NotNull [] names) {
        if (type == null) {
            PsiClassReferenceListStubImpl.$$$reportNull$$$0(0);
        }
        if (names == null) {
            PsiClassReferenceListStubImpl.$$$reportNull$$$0(1);
        }
        this(type, parent, ContainerUtil.map2Array(names, TypeInfo.class, TypeInfo::new));
    }

    public PsiClassReferenceListStubImpl(@NotNull JavaClassReferenceListElementType type, StubElement parent, TypeInfo @NotNull [] infos) {
        if (type == null) {
            PsiClassReferenceListStubImpl.$$$reportNull$$$0(2);
        }
        if (infos == null) {
            PsiClassReferenceListStubImpl.$$$reportNull$$$0(3);
        }
        super(parent, type);
        for (TypeInfo info : infos) {
            if (info == null) {
                throw new IllegalArgumentException();
            }
            if (info.text != null) continue;
            throw new IllegalArgumentException();
        }
        this.myInfos = infos;
    }

    @Override
    public PsiClassType @NotNull [] getReferencedTypes() {
        PsiClassType[] types = this.myTypes;
        if (types == null) {
            this.myTypes = types = this.createTypes();
        }
        PsiClassType[] psiClassTypeArray = (PsiClassType[])types.clone();
        if (psiClassTypeArray == null) {
            PsiClassReferenceListStubImpl.$$$reportNull$$$0(4);
        }
        return psiClassTypeArray;
    }

    private boolean shouldSkipSoleObject() {
        boolean compiled = ((JavaClassReferenceListElementType)this.getStubType()).isCompiled(this);
        return compiled && this.myInfos.length == 1 && this.myInfos[0].text.equals("java.lang.Object") && this.myInfos[0].getTypeAnnotations().isEmpty();
    }

    private PsiClassType @NotNull [] createTypes() {
        PsiClassType[] types = this.myInfos.length == 0 ? PsiClassType.EMPTY_ARRAY : new PsiClassType[this.myInfos.length];
        boolean compiled = ((JavaClassReferenceListElementType)this.getStubType()).isCompiled(this);
        if (compiled) {
            if (this.shouldSkipSoleObject()) {
                if (PsiClassType.EMPTY_ARRAY == null) {
                    PsiClassReferenceListStubImpl.$$$reportNull$$$0(5);
                }
                return PsiClassType.EMPTY_ARRAY;
            }
            for (int i = 0; i < types.length; ++i) {
                TypeInfo info = this.myInfos[i];
                TypeAnnotationContainer annotations = info.getTypeAnnotations();
                ClsJavaCodeReferenceElementImpl reference = new ClsJavaCodeReferenceElementImpl((PsiElement)this.getPsi(), info.text, annotations);
                types[i] = new PsiClassReferenceType(reference, null).annotate(annotations.getProvider(reference));
            }
        } else {
            PsiElementFactory factory = JavaPsiFacade.getElementFactory(this.getProject());
            int nullCount = 0;
            PsiReferenceList psi = (PsiReferenceList)this.getPsi();
            for (int i = 0; i < types.length; ++i) {
                try {
                    PsiJavaCodeReferenceElement ref = factory.createReferenceFromText(this.myInfos[i].text, psi);
                    ((PsiJavaCodeReferenceElementImpl)ref).setKindWhenDummy(PsiJavaCodeReferenceElementImpl.Kind.CLASS_NAME_KIND);
                    types[i] = factory.createType(ref);
                    continue;
                }
                catch (IncorrectOperationException e) {
                    types[i] = null;
                    ++nullCount;
                }
            }
            if (nullCount > 0) {
                PsiClassType[] newTypes = new PsiClassType[types.length - nullCount];
                int cnt = 0;
                for (PsiClassType type : types) {
                    if (type == null) continue;
                    newTypes[cnt++] = type;
                }
                types = newTypes;
            }
        }
        if (types == null) {
            PsiClassReferenceListStubImpl.$$$reportNull$$$0(6);
        }
        return types;
    }

    @Override
    public String @NotNull [] getReferencedNames() {
        if (this.myInfos.length == 0 || this.shouldSkipSoleObject()) {
            if (ArrayUtil.EMPTY_STRING_ARRAY == null) {
                PsiClassReferenceListStubImpl.$$$reportNull$$$0(7);
            }
            return ArrayUtil.EMPTY_STRING_ARRAY;
        }
        String[] stringArray = ContainerUtil.map2Array(this.myInfos, String.class, info -> info.text);
        if (stringArray == null) {
            PsiClassReferenceListStubImpl.$$$reportNull$$$0(8);
        }
        return stringArray;
    }

    @Override
    @NotNull
    public @NotNull TypeInfo @NotNull [] getTypes() {
        if (this.myInfos.length == 0 || this.shouldSkipSoleObject()) {
            if (TypeInfo.EMPTY_ARRAY == null) {
                PsiClassReferenceListStubImpl.$$$reportNull$$$0(9);
            }
            return TypeInfo.EMPTY_ARRAY;
        }
        TypeInfo[] typeInfoArray = (TypeInfo[])this.myInfos.clone();
        if (typeInfoArray == null) {
            PsiClassReferenceListStubImpl.$$$reportNull$$$0(10);
        }
        return typeInfoArray;
    }

    @Override
    @NotNull
    public PsiReferenceList.Role getRole() {
        PsiReferenceList.Role role = JavaClassReferenceListElementType.elementTypeToRole(this.getStubType());
        if (role == null) {
            PsiClassReferenceListStubImpl.$$$reportNull$$$0(11);
        }
        return role;
    }

    @Override
    public String toString() {
        return "PsiRefListStub[" + (Object)((Object)this.getRole()) + ':' + String.join((CharSequence)", ", this.getReferencedNames()) + ']';
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string2;
        switch (n) {
            default: {
                string2 = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 4: 
            case 5: 
            case 6: 
            case 7: 
            case 8: 
            case 9: 
            case 10: 
            case 11: {
                string2 = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 4: 
            case 5: 
            case 6: 
            case 7: 
            case 8: 
            case 9: 
            case 10: 
            case 11: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "type";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "names";
                break;
            }
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "infos";
                break;
            }
            case 4: 
            case 5: 
            case 6: 
            case 7: 
            case 8: 
            case 9: 
            case 10: 
            case 11: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/psi/impl/java/stubs/impl/PsiClassReferenceListStubImpl";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/psi/impl/java/stubs/impl/PsiClassReferenceListStubImpl";
                break;
            }
            case 4: {
                objectArray = objectArray2;
                objectArray2[1] = "getReferencedTypes";
                break;
            }
            case 5: 
            case 6: {
                objectArray = objectArray2;
                objectArray2[1] = "createTypes";
                break;
            }
            case 7: 
            case 8: {
                objectArray = objectArray2;
                objectArray2[1] = "getReferencedNames";
                break;
            }
            case 9: 
            case 10: {
                objectArray = objectArray2;
                objectArray2[1] = "getTypes";
                break;
            }
            case 11: {
                objectArray = objectArray2;
                objectArray2[1] = "getRole";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "<init>";
                break;
            }
            case 4: 
            case 5: 
            case 6: 
            case 7: 
            case 8: 
            case 9: 
            case 10: 
            case 11: {
                break;
            }
        }
        String string3 = String.format(string2, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string3);
                break;
            }
            case 4: 
            case 5: 
            case 6: 
            case 7: 
            case 8: 
            case 9: 
            case 10: 
            case 11: {
                runtimeException = new IllegalStateException(string3);
                break;
            }
        }
        throw runtimeException;
    }
}

