/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.psi.impl.java.stubs.impl;

import com.intellij.psi.PsiPackageAccessibilityStatement;
import com.intellij.psi.impl.java.stubs.JavaPackageAccessibilityStatementElementType;
import com.intellij.psi.impl.java.stubs.PsiPackageAccessibilityStatementStub;
import com.intellij.psi.stubs.IStubElementType;
import com.intellij.psi.stubs.StubBase;
import com.intellij.psi.stubs.StubElement;
import com.intellij.util.ObjectUtils;
import java.util.Collections;
import java.util.List;

public class PsiPackageAccessibilityStatementStubImpl
extends StubBase<PsiPackageAccessibilityStatement>
implements PsiPackageAccessibilityStatementStub {
    private final String myPackageName;
    private final List<String> myTargets;

    public PsiPackageAccessibilityStatementStubImpl(StubElement parent, IStubElementType type, String packageName, List<String> targets) {
        super(parent, type);
        this.myPackageName = ObjectUtils.notNull(packageName, "");
        this.myTargets = targets == null || targets.isEmpty() ? Collections.emptyList() : Collections.unmodifiableList(targets);
    }

    @Override
    public String getPackageName() {
        return this.myPackageName;
    }

    @Override
    public List<String> getTargets() {
        return this.myTargets;
    }

    @Override
    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("PsiPackageAccessibilityStatementStub[").append((Object)JavaPackageAccessibilityStatementElementType.typeToRole(this.getStubType())).append("]:").append(this.myPackageName);
        for (String target : this.myTargets) {
            sb.append(':').append(target);
        }
        return sb.toString();
    }
}

