/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.psi.stubs;

import com.intellij.openapi.project.Project;
import com.intellij.psi.PsiElement;
import com.intellij.psi.stubs.IStubElementType;
import com.intellij.psi.stubs.MaterialStubList;
import com.intellij.psi.stubs.ObjectStubBase;
import com.intellij.psi.stubs.StubElement;
import com.intellij.psi.stubs.StubList;
import com.intellij.psi.tree.IElementType;
import com.intellij.psi.tree.TokenSet;
import com.intellij.util.ArrayFactory;
import com.intellij.util.ArrayUtil;
import java.util.List;
import java.util.Objects;
import java.util.concurrent.atomic.AtomicReferenceFieldUpdater;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public abstract class StubBase<T extends PsiElement>
extends ObjectStubBase<StubElement<?>>
implements StubElement<T> {
    StubList myStubList;
    private volatile T myPsi;
    private static final AtomicReferenceFieldUpdater<StubBase, PsiElement> myPsiUpdater = AtomicReferenceFieldUpdater.newUpdater(StubBase.class, PsiElement.class, "myPsi");

    protected StubBase(@Nullable StubElement parent, IStubElementType elementType) {
        super(parent);
        this.myStubList = parent == null ? new MaterialStubList(10) : ((StubBase)parent).myStubList;
        this.myStubList.addStub(this, (StubBase)parent, elementType);
    }

    @Override
    public StubElement getParentStub() {
        return (StubElement)this.myParent;
    }

    @Override
    @NotNull
    public List<StubElement> getChildrenStubs() {
        List<StubElement> list = this.myStubList.getChildrenStubs(this.id);
        if (list == null) {
            StubBase.$$$reportNull$$$0(0);
        }
        return list;
    }

    @Override
    @Nullable
    public <P extends PsiElement, S extends StubElement<P>> S findChildStubByType(@NotNull IStubElementType<S, P> elementType) {
        if (elementType == null) {
            StubBase.$$$reportNull$$$0(1);
        }
        return this.myStubList.findChildStubByType(this.id, elementType);
    }

    public void setPsi(@NotNull T psi) {
        if (psi == null) {
            StubBase.$$$reportNull$$$0(2);
        }
        assert (this.myPsi == null || this.myPsi == psi);
        this.myPsi = psi;
    }

    @Nullable
    final T getCachedPsi() {
        return this.myPsi;
    }

    @Override
    public T getPsi() {
        Object psi = this.myPsi;
        if (psi != null) {
            return psi;
        }
        psi = this.getStubType().createPsi(this);
        return (T)(myPsiUpdater.compareAndSet(this, (PsiElement)null, (PsiElement)psi) ? psi : (PsiElement)Objects.requireNonNull(this.myPsi));
    }

    @Override
    public <E extends PsiElement> E @NotNull [] getChildrenByType(@NotNull IElementType elementType, E[] array) {
        if (elementType == null) {
            StubBase.$$$reportNull$$$0(3);
        }
        List<StubElement> childrenStubs = this.getChildrenStubs();
        int count2 = StubBase.countChildren(elementType, childrenStubs);
        array = (PsiElement[])ArrayUtil.ensureExactSize(count2, array);
        if (count2 == 0) {
            if (array == null) {
                StubBase.$$$reportNull$$$0(4);
            }
            return array;
        }
        StubBase.fillFilteredChildren((IElementType)elementType, array, childrenStubs);
        if (array == null) {
            StubBase.$$$reportNull$$$0(5);
        }
        return array;
    }

    @Override
    public <E extends PsiElement> E @NotNull [] getChildrenByType(@NotNull TokenSet filter2, E[] array) {
        if (filter2 == null) {
            StubBase.$$$reportNull$$$0(6);
        }
        List<StubElement> childrenStubs = this.getChildrenStubs();
        int count2 = StubBase.countChildren(filter2, childrenStubs);
        array = (PsiElement[])ArrayUtil.ensureExactSize(count2, array);
        if (count2 == 0) {
            if (array == null) {
                StubBase.$$$reportNull$$$0(7);
            }
            return array;
        }
        StubBase.fillFilteredChildren((TokenSet)filter2, array, childrenStubs);
        if (array == null) {
            StubBase.$$$reportNull$$$0(8);
        }
        return array;
    }

    @Override
    public <E extends PsiElement> E @NotNull [] getChildrenByType(@NotNull IElementType elementType, @NotNull ArrayFactory<E> f) {
        if (elementType == null) {
            StubBase.$$$reportNull$$$0(9);
        }
        if (f == null) {
            StubBase.$$$reportNull$$$0(10);
        }
        List<StubElement> childrenStubs = this.getChildrenStubs();
        int count2 = StubBase.countChildren(elementType, childrenStubs);
        PsiElement[] result2 = (PsiElement[])f.create(count2);
        if (count2 > 0) {
            StubBase.fillFilteredChildren((IElementType)elementType, (PsiElement[])result2, childrenStubs);
        }
        if (result2 == null) {
            StubBase.$$$reportNull$$$0(11);
        }
        return result2;
    }

    private static int countChildren(IElementType elementType, List<? extends StubElement> childrenStubs) {
        int count2 = 0;
        int childrenStubsSize = childrenStubs.size();
        for (int i = 0; i < childrenStubsSize; ++i) {
            StubElement childStub = childrenStubs.get(i);
            if (childStub.getStubType() != elementType) continue;
            ++count2;
        }
        return count2;
    }

    private static int countChildren(TokenSet types, List<? extends StubElement> childrenStubs) {
        int count2 = 0;
        int childrenStubsSize = childrenStubs.size();
        for (int i = 0; i < childrenStubsSize; ++i) {
            StubElement childStub = childrenStubs.get(i);
            if (!types.contains(childStub.getStubType())) continue;
            ++count2;
        }
        return count2;
    }

    private static <E extends PsiElement> void fillFilteredChildren(IElementType type, E[] result2, List<? extends StubElement> childrenStubs) {
        int count2 = 0;
        int childrenStubsSize = childrenStubs.size();
        for (int i = 0; i < childrenStubsSize; ++i) {
            StubElement childStub = childrenStubs.get(i);
            if (childStub.getStubType() != type) continue;
            result2[count2++] = childStub.getPsi();
        }
        assert (count2 == result2.length);
    }

    private static <E extends PsiElement> void fillFilteredChildren(TokenSet set, E[] result2, List<? extends StubElement> childrenStubs) {
        int count2 = 0;
        int childrenStubsSize = childrenStubs.size();
        for (int i = 0; i < childrenStubsSize; ++i) {
            StubElement childStub = childrenStubs.get(i);
            if (!set.contains(childStub.getStubType())) continue;
            result2[count2++] = childStub.getPsi();
        }
        assert (count2 == result2.length);
    }

    @Override
    public <E extends PsiElement> E @NotNull [] getChildrenByType(@NotNull TokenSet filter2, @NotNull ArrayFactory<E> f) {
        if (filter2 == null) {
            StubBase.$$$reportNull$$$0(12);
        }
        if (f == null) {
            StubBase.$$$reportNull$$$0(13);
        }
        List<StubElement> childrenStubs = this.getChildrenStubs();
        int count2 = StubBase.countChildren(filter2, childrenStubs);
        PsiElement[] array = (PsiElement[])f.create(count2);
        if (count2 == 0) {
            if (array == null) {
                StubBase.$$$reportNull$$$0(14);
            }
            return array;
        }
        StubBase.fillFilteredChildren((TokenSet)filter2, (PsiElement[])array, childrenStubs);
        if (array == null) {
            StubBase.$$$reportNull$$$0(15);
        }
        return array;
    }

    @Override
    @Nullable
    public <E extends PsiElement> E getParentStubOfType(@NotNull Class<E> parentClass) {
        if (parentClass == null) {
            StubBase.$$$reportNull$$$0(16);
        }
        for (StubElement parent = (StubElement)this.myParent; parent != null; parent = parent.getParentStub()) {
            Object psi = parent.getPsi();
            if (!parentClass.isInstance(psi)) continue;
            return (E)psi;
        }
        return null;
    }

    @Override
    public IStubElementType getStubType() {
        return this.myStubList.getStubType(this.id);
    }

    public Project getProject() {
        return this.getPsi().getProject();
    }

    public String printTree() {
        StringBuilder builder = new StringBuilder();
        this.printTree(builder, 0);
        return builder.toString();
    }

    private void printTree(StringBuilder builder, int nestingLevel) {
        for (int i = 0; i < nestingLevel; ++i) {
            builder.append("  ");
        }
        builder.append(this).append('\n');
        for (StubElement child : this.getChildrenStubs()) {
            ((StubBase)child).printTree(builder, nestingLevel + 1);
        }
    }

    @Override
    public String toString() {
        return this.getClass().getSimpleName();
    }

    public int compareByOrderWith(ObjectStubBase<?> another) {
        return Integer.compare(this.getStubId(), another.getStubId());
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string2;
        switch (n) {
            default: {
                string2 = "@NotNull method %s.%s must not return null";
                break;
            }
            case 1: 
            case 2: 
            case 3: 
            case 6: 
            case 9: 
            case 10: 
            case 12: 
            case 13: 
            case 16: {
                string2 = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 2;
                break;
            }
            case 1: 
            case 2: 
            case 3: 
            case 6: 
            case 9: 
            case 10: 
            case 12: 
            case 13: 
            case 16: {
                n2 = 3;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/psi/stubs/StubBase";
                break;
            }
            case 1: 
            case 3: 
            case 9: {
                objectArray2 = objectArray3;
                objectArray3[0] = "elementType";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "psi";
                break;
            }
            case 6: 
            case 12: {
                objectArray2 = objectArray3;
                objectArray3[0] = "filter";
                break;
            }
            case 10: 
            case 13: {
                objectArray2 = objectArray3;
                objectArray3[0] = "f";
                break;
            }
            case 16: {
                objectArray2 = objectArray3;
                objectArray3[0] = "parentClass";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "getChildrenStubs";
                break;
            }
            case 1: 
            case 2: 
            case 3: 
            case 6: 
            case 9: 
            case 10: 
            case 12: 
            case 13: 
            case 16: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/psi/stubs/StubBase";
                break;
            }
            case 4: 
            case 5: 
            case 7: 
            case 8: 
            case 11: 
            case 14: 
            case 15: {
                objectArray = objectArray2;
                objectArray2[1] = "getChildrenByType";
                break;
            }
        }
        switch (n) {
            default: {
                break;
            }
            case 1: {
                objectArray = objectArray;
                objectArray[2] = "findChildStubByType";
                break;
            }
            case 2: {
                objectArray = objectArray;
                objectArray[2] = "setPsi";
                break;
            }
            case 3: 
            case 6: 
            case 9: 
            case 10: 
            case 12: 
            case 13: {
                objectArray = objectArray;
                objectArray[2] = "getChildrenByType";
                break;
            }
            case 16: {
                objectArray = objectArray;
                objectArray[2] = "getParentStubOfType";
                break;
            }
        }
        String string3 = String.format(string2, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalStateException(string3);
                break;
            }
            case 1: 
            case 2: 
            case 3: 
            case 6: 
            case 9: 
            case 10: 
            case 12: 
            case 13: 
            case 16: {
                runtimeException = new IllegalArgumentException(string3);
                break;
            }
        }
        throw runtimeException;
    }
}

