/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.util;

import com.intellij.openapi.util.SystemInfo;
import com.intellij.openapi.util.io.FileUtil;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.util.AbstractPathMapper;
import com.intellij.util.xmlb.XmlSerializer;
import com.intellij.util.xmlb.annotations.Attribute;
import com.intellij.util.xmlb.annotations.Tag;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import org.jdom.Element;
import org.jetbrains.annotations.Contract;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class PathMappingSettings
extends AbstractPathMapper
implements Cloneable {
    @NotNull
    private List<PathMapping> myPathMappings;

    public PathMappingSettings(@Nullable List<? extends PathMapping> pathMappings) {
        this.myPathMappings = PathMappingSettings.create(pathMappings);
    }

    @NotNull
    private static List<PathMapping> create(@Nullable List<? extends PathMapping> mappings) {
        ArrayList<PathMapping> result2 = new ArrayList<PathMapping>();
        if (mappings != null) {
            for (PathMapping pathMapping : mappings) {
                if (pathMapping == null || PathMappingSettings.isAnyEmpty(pathMapping.getLocalRoot(), pathMapping.getRemoteRoot())) continue;
                result2.add(pathMapping);
            }
        }
        ArrayList<PathMapping> arrayList = result2;
        if (arrayList == null) {
            PathMappingSettings.$$$reportNull$$$0(0);
        }
        return arrayList;
    }

    public PathMappingSettings() {
        this.myPathMappings = new ArrayList<PathMapping>();
    }

    @NotNull
    static String norm(@NotNull String path) {
        if (path == null) {
            PathMappingSettings.$$$reportNull$$$0(1);
        }
        String string2 = FileUtil.toSystemIndependentName(path);
        if (string2 == null) {
            PathMappingSettings.$$$reportNull$$$0(2);
        }
        return string2;
    }

    @NotNull
    private static String normLocal(@NotNull String path) {
        if (path == null) {
            PathMappingSettings.$$$reportNull$$$0(3);
        }
        if (SystemInfo.isWindows) {
            path = StringUtil.toLowerCase(path);
        }
        return PathMappingSettings.norm(path);
    }

    @Override
    public boolean isEmpty() {
        return this.myPathMappings.isEmpty();
    }

    @Override
    @NotNull
    public String convertToLocal(@NotNull String remotePath) {
        String localPath;
        if (remotePath == null) {
            PathMappingSettings.$$$reportNull$$$0(4);
        }
        String string2 = (localPath = PathMappingSettings.convertToLocal(remotePath, this.myPathMappings)) != null ? localPath : remotePath;
        if (string2 == null) {
            PathMappingSettings.$$$reportNull$$$0(5);
        }
        return string2;
    }

    @Override
    @NotNull
    public String convertToRemote(@NotNull String localPath) {
        String remotePath;
        if (localPath == null) {
            PathMappingSettings.$$$reportNull$$$0(6);
        }
        String string2 = (remotePath = PathMappingSettings.convertToRemote(localPath, this.myPathMappings)) != null ? remotePath : localPath;
        if (string2 == null) {
            PathMappingSettings.$$$reportNull$$$0(7);
        }
        return string2;
    }

    public void add(@Nullable PathMapping mapping) {
        if (mapping == null) {
            return;
        }
        if (PathMappingSettings.isAnyEmpty(mapping.getLocalRoot(), mapping.getRemoteRoot())) {
            return;
        }
        this.myPathMappings.add(mapping);
    }

    public void addMapping(@Nullable String local, @Nullable String remote) {
        PathMapping mapping = new PathMapping(local, remote);
        this.add(mapping);
    }

    public void addMappingCheckUnique(@NotNull String local, @NotNull String remote) {
        PathMapping mapping;
        if (local == null) {
            PathMappingSettings.$$$reportNull$$$0(8);
        }
        if (remote == null) {
            PathMappingSettings.$$$reportNull$$$0(9);
        }
        if (this.myPathMappings.contains(mapping = new PathMapping(local, remote))) {
            return;
        }
        this.add(mapping);
    }

    private static boolean pathEquals(@NotNull String path1, @NotNull String path2) {
        if (path1 == null) {
            PathMappingSettings.$$$reportNull$$$0(10);
        }
        if (path2 == null) {
            PathMappingSettings.$$$reportNull$$$0(11);
        }
        return PathMappingSettings.norm(path1).equals(PathMappingSettings.norm(path2));
    }

    @Override
    @NotNull
    protected final Collection<PathMapping> getAvailablePathMappings() {
        Collection<PathMapping> collection = Collections.unmodifiableCollection(this.myPathMappings);
        if (collection == null) {
            PathMappingSettings.$$$reportNull$$$0(12);
        }
        return collection;
    }

    @NotNull
    public List<PathMapping> getPathMappings() {
        List<PathMapping> list = this.myPathMappings;
        if (list == null) {
            PathMappingSettings.$$$reportNull$$$0(13);
        }
        return list;
    }

    public void setPathMappings(@Nullable List<? extends PathMapping> pathMappings) {
        this.myPathMappings = PathMappingSettings.create(pathMappings);
    }

    @NotNull
    public static String mapToLocal(@NotNull String path, @Nullable String remoteRoot, @Nullable String localRoot) {
        String remotePrefix;
        if (path == null) {
            PathMappingSettings.$$$reportNull$$$0(14);
        }
        if (PathMappingSettings.isAnyEmpty(localRoot, remoteRoot)) {
            String string2 = path;
            if (string2 == null) {
                PathMappingSettings.$$$reportNull$$$0(15);
            }
            return string2;
        }
        if (PathMappingSettings.canReplaceRemote(path = PathMappingSettings.norm(path), remotePrefix = PathMappingSettings.norm(remoteRoot))) {
            String left = PathMappingSettings.norm(localRoot);
            String right = path.substring(remotePrefix.length());
            path = left.endsWith("/") || left.endsWith("\\") || right.startsWith("/") || right.startsWith("\\") || StringUtil.isEmpty(left) || StringUtil.isEmpty(right) ? left + right : left + "/" + right;
        }
        String string3 = path;
        if (string3 == null) {
            PathMappingSettings.$$$reportNull$$$0(16);
        }
        return string3;
    }

    @Contract(value="null, _ -> true; _, null -> true", pure=true)
    public static boolean isAnyEmpty(@Nullable String localRoot, @Nullable String remoteRoot) {
        return StringUtil.isEmpty(localRoot) || StringUtil.isEmpty(remoteRoot);
    }

    @Nullable
    public static PathMappingSettings readExternal(@Nullable Element element) {
        if (element == null) {
            return null;
        }
        Element settingsElement = element.getChild(PathMappingSettings.class.getSimpleName());
        if (settingsElement == null) {
            return null;
        }
        return XmlSerializer.deserialize(settingsElement, PathMappingSettings.class);
    }

    public static void writeExternal(@Nullable Element element, @Nullable PathMappingSettings mappings) {
        if (element == null || mappings == null || mappings.isEmpty()) {
            return;
        }
        element.addContent(XmlSerializer.serialize(mappings));
    }

    public void addAll(@NotNull PathMappingSettings settings) {
        if (settings == null) {
            PathMappingSettings.$$$reportNull$$$0(17);
        }
        this.myPathMappings.addAll(settings.getPathMappings());
    }

    public void addAll(@NotNull List<? extends PathMapping> mappings) {
        if (mappings == null) {
            PathMappingSettings.$$$reportNull$$$0(18);
        }
        this.myPathMappings.addAll(mappings);
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        PathMappingSettings settings = (PathMappingSettings)o;
        return this.myPathMappings.equals(settings.myPathMappings);
    }

    public int hashCode() {
        return this.myPathMappings.hashCode();
    }

    private static boolean canReplaceRemote(@NotNull String path, @NotNull String remotePrefix) {
        if (path == null) {
            PathMappingSettings.$$$reportNull$$$0(19);
        }
        if (remotePrefix == null) {
            PathMappingSettings.$$$reportNull$$$0(20);
        }
        return (path = PathMappingSettings.norm(path)).startsWith(remotePrefix = PathMappingSettings.norm(remotePrefix)) && (path.length() == remotePrefix.length() || remotePrefix.endsWith("/") || path.substring(remotePrefix.length()).startsWith("/"));
    }

    public String toString() {
        return "PathMappingSettings{myPathMappings=" + this.myPathMappings + "} " + super.toString();
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string2;
        switch (n) {
            default: {
                string2 = "@NotNull method %s.%s must not return null";
                break;
            }
            case 1: 
            case 3: 
            case 4: 
            case 6: 
            case 8: 
            case 9: 
            case 10: 
            case 11: 
            case 14: 
            case 17: 
            case 18: 
            case 19: 
            case 20: {
                string2 = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 2;
                break;
            }
            case 1: 
            case 3: 
            case 4: 
            case 6: 
            case 8: 
            case 9: 
            case 10: 
            case 11: 
            case 14: 
            case 17: 
            case 18: 
            case 19: 
            case 20: {
                n2 = 3;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/util/PathMappingSettings";
                break;
            }
            case 1: 
            case 3: 
            case 14: 
            case 19: {
                objectArray2 = objectArray3;
                objectArray3[0] = "path";
                break;
            }
            case 4: {
                objectArray2 = objectArray3;
                objectArray3[0] = "remotePath";
                break;
            }
            case 6: {
                objectArray2 = objectArray3;
                objectArray3[0] = "localPath";
                break;
            }
            case 8: {
                objectArray2 = objectArray3;
                objectArray3[0] = "local";
                break;
            }
            case 9: {
                objectArray2 = objectArray3;
                objectArray3[0] = "remote";
                break;
            }
            case 10: {
                objectArray2 = objectArray3;
                objectArray3[0] = "path1";
                break;
            }
            case 11: {
                objectArray2 = objectArray3;
                objectArray3[0] = "path2";
                break;
            }
            case 17: {
                objectArray2 = objectArray3;
                objectArray3[0] = "settings";
                break;
            }
            case 18: {
                objectArray2 = objectArray3;
                objectArray3[0] = "mappings";
                break;
            }
            case 20: {
                objectArray2 = objectArray3;
                objectArray3[0] = "remotePrefix";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "create";
                break;
            }
            case 1: 
            case 3: 
            case 4: 
            case 6: 
            case 8: 
            case 9: 
            case 10: 
            case 11: 
            case 14: 
            case 17: 
            case 18: 
            case 19: 
            case 20: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/util/PathMappingSettings";
                break;
            }
            case 2: {
                objectArray = objectArray2;
                objectArray2[1] = "norm";
                break;
            }
            case 5: {
                objectArray = objectArray2;
                objectArray2[1] = "convertToLocal";
                break;
            }
            case 7: {
                objectArray = objectArray2;
                objectArray2[1] = "convertToRemote";
                break;
            }
            case 12: {
                objectArray = objectArray2;
                objectArray2[1] = "getAvailablePathMappings";
                break;
            }
            case 13: {
                objectArray = objectArray2;
                objectArray2[1] = "getPathMappings";
                break;
            }
            case 15: 
            case 16: {
                objectArray = objectArray2;
                objectArray2[1] = "mapToLocal";
                break;
            }
        }
        switch (n) {
            default: {
                break;
            }
            case 1: {
                objectArray = objectArray;
                objectArray[2] = "norm";
                break;
            }
            case 3: {
                objectArray = objectArray;
                objectArray[2] = "normLocal";
                break;
            }
            case 4: {
                objectArray = objectArray;
                objectArray[2] = "convertToLocal";
                break;
            }
            case 6: {
                objectArray = objectArray;
                objectArray[2] = "convertToRemote";
                break;
            }
            case 8: 
            case 9: {
                objectArray = objectArray;
                objectArray[2] = "addMappingCheckUnique";
                break;
            }
            case 10: 
            case 11: {
                objectArray = objectArray;
                objectArray[2] = "pathEquals";
                break;
            }
            case 14: {
                objectArray = objectArray;
                objectArray[2] = "mapToLocal";
                break;
            }
            case 17: 
            case 18: {
                objectArray = objectArray;
                objectArray[2] = "addAll";
                break;
            }
            case 19: 
            case 20: {
                objectArray = objectArray;
                objectArray[2] = "canReplaceRemote";
                break;
            }
        }
        String string3 = String.format(string2, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalStateException(string3);
                break;
            }
            case 1: 
            case 3: 
            case 4: 
            case 6: 
            case 8: 
            case 9: 
            case 10: 
            case 11: 
            case 14: 
            case 17: 
            case 18: 
            case 19: 
            case 20: {
                runtimeException = new IllegalArgumentException(string3);
                break;
            }
        }
        throw runtimeException;
    }

    @Tag(value="mapping")
    public static class PathMapping {
        private String myLocalRoot;
        private String myRemoteRoot;

        public PathMapping() {
        }

        public PathMapping(@Nullable String localRoot, @Nullable String remoteRoot) {
            this.myLocalRoot = PathMapping.normalize(localRoot);
            this.myRemoteRoot = PathMapping.normalize(remoteRoot);
        }

        @Nullable
        private static String normalize(@Nullable String path) {
            if (path == null) {
                return null;
            }
            return PathMapping.trimSlash(FileUtil.toSystemIndependentName(path));
        }

        @Attribute(value="local-root")
        public String getLocalRoot() {
            return this.myLocalRoot;
        }

        @Attribute(value="remote-root")
        public String getRemoteRoot() {
            return this.myRemoteRoot;
        }

        public int getLocalLen() {
            return this.myLocalRoot != null ? this.myLocalRoot.length() : -1;
        }

        public int getRemoteLen() {
            return this.myRemoteRoot != null ? this.myRemoteRoot.length() : -1;
        }

        public void setLocalRoot(@Nullable String localRoot) {
            this.myLocalRoot = PathMapping.normalize(localRoot);
        }

        public void setRemoteRoot(@Nullable String remoteRoot) {
            this.myRemoteRoot = PathMapping.normalize(remoteRoot);
        }

        @NotNull
        public String mapToLocal(@NotNull String path) {
            if (path == null) {
                PathMapping.$$$reportNull$$$0(0);
            }
            String string2 = PathMappingSettings.mapToLocal(path, this.myRemoteRoot, this.myLocalRoot);
            if (string2 == null) {
                PathMapping.$$$reportNull$$$0(1);
            }
            return string2;
        }

        public boolean canReplaceLocal(@NotNull String path) {
            if (path == null) {
                PathMapping.$$$reportNull$$$0(2);
            }
            if (this.isEmpty()) {
                return false;
            }
            String localPrefix = PathMappingSettings.normLocal(this.myLocalRoot);
            if (localPrefix.isEmpty()) {
                return false;
            }
            String localPath = PathMappingSettings.normLocal(path);
            int prefixLength = localPrefix.length();
            return localPath.startsWith(localPrefix) && (localPath.length() == prefixLength || localPath.charAt(prefixLength) == '/');
        }

        public String mapToRemote(@NotNull String path) {
            if (path == null) {
                PathMapping.$$$reportNull$$$0(3);
            }
            if (this.isEmpty()) {
                return path;
            }
            if (this.canReplaceLocal(path)) {
                return PathMappingSettings.norm(this.myRemoteRoot) + PathMappingSettings.norm(path).substring(PathMappingSettings.normLocal(this.myLocalRoot).length());
            }
            return path;
        }

        private boolean isEmpty() {
            return PathMappingSettings.isAnyEmpty(this.myLocalRoot, this.myRemoteRoot);
        }

        private static String trimSlash(@NotNull String s) {
            if (s == null) {
                PathMapping.$$$reportNull$$$0(4);
            }
            if (s.equals("/")) {
                return s;
            }
            return StringUtil.trimEnd(s, "/");
        }

        public boolean canReplaceRemote(@NotNull String path) {
            if (path == null) {
                PathMapping.$$$reportNull$$$0(5);
            }
            if (this.isEmpty()) {
                return false;
            }
            return PathMappingSettings.canReplaceRemote(path, this.myRemoteRoot);
        }

        public PathMapping clone() {
            return new PathMapping(this.myLocalRoot, this.myRemoteRoot);
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (o == null || this.getClass() != o.getClass()) {
                return false;
            }
            PathMapping mapping = (PathMapping)o;
            if (!Objects.equals(this.myLocalRoot, mapping.myLocalRoot)) {
                return false;
            }
            return Objects.equals(this.myRemoteRoot, mapping.myRemoteRoot);
        }

        public String toString() {
            return "{'" + this.myLocalRoot + "' <=> '" + this.myRemoteRoot + "'}";
        }

        public int hashCode() {
            int result2 = this.myLocalRoot != null ? this.myLocalRoot.hashCode() : 0;
            result2 = 31 * result2 + (this.myRemoteRoot != null ? this.myRemoteRoot.hashCode() : 0);
            return result2;
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            RuntimeException runtimeException;
            Object[] objectArray;
            Object[] objectArray2;
            int n2;
            String string2;
            switch (n) {
                default: {
                    string2 = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                    break;
                }
                case 1: {
                    string2 = "@NotNull method %s.%s must not return null";
                    break;
                }
            }
            switch (n) {
                default: {
                    n2 = 3;
                    break;
                }
                case 1: {
                    n2 = 2;
                    break;
                }
            }
            Object[] objectArray3 = new Object[n2];
            switch (n) {
                default: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "path";
                    break;
                }
                case 1: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "com/intellij/util/PathMappingSettings$PathMapping";
                    break;
                }
                case 4: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "s";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[1] = "com/intellij/util/PathMappingSettings$PathMapping";
                    break;
                }
                case 1: {
                    objectArray = objectArray2;
                    objectArray2[1] = "mapToLocal";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray;
                    objectArray[2] = "mapToLocal";
                    break;
                }
                case 1: {
                    break;
                }
                case 2: {
                    objectArray = objectArray;
                    objectArray[2] = "canReplaceLocal";
                    break;
                }
                case 3: {
                    objectArray = objectArray;
                    objectArray[2] = "mapToRemote";
                    break;
                }
                case 4: {
                    objectArray = objectArray;
                    objectArray[2] = "trimSlash";
                    break;
                }
                case 5: {
                    objectArray = objectArray;
                    objectArray[2] = "canReplaceRemote";
                    break;
                }
            }
            String string3 = String.format(string2, objectArray);
            switch (n) {
                default: {
                    runtimeException = new IllegalArgumentException(string3);
                    break;
                }
                case 1: {
                    runtimeException = new IllegalStateException(string3);
                    break;
                }
            }
            throw runtimeException;
        }
    }

    public static class BestMappingSelector {
        private int myBestWeight = -1;
        private PathMapping myBest = null;

        public void consider(PathMapping mapping, int weight) {
            if (weight > this.myBestWeight) {
                this.myBestWeight = weight;
                this.myBest = mapping;
            }
        }

        @Nullable
        public PathMapping get() {
            return this.myBest;
        }
    }
}

