/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.util.containers;

import com.intellij.util.containers.ConcurrentBitSetImpl;
import com.intellij.util.containers.ConcurrentPackedBitsArray;

class ConcurrentPackedBitsArrayImpl
implements ConcurrentPackedBitsArray {
    private final int bitsPerChunk;
    private final ConcurrentBitSetImpl bits = new ConcurrentBitSetImpl();
    private final int mask;
    private final int chunksPerWord;

    ConcurrentPackedBitsArrayImpl(int bitsPerChunk) {
        if (bitsPerChunk <= 0 || bitsPerChunk > 32) {
            throw new IllegalArgumentException("Bits-to-pack number must be between 1 and 32, but got: " + bitsPerChunk);
        }
        this.bitsPerChunk = bitsPerChunk;
        this.mask = bitsPerChunk == 32 ? -1 : (1 << bitsPerChunk) - 1;
        this.chunksPerWord = 32 / bitsPerChunk;
    }

    @Override
    public long get(int id) {
        assert (id >= 0) : id;
        int bitIndex = id / this.chunksPerWord * 32 + id % this.chunksPerWord * this.bitsPerChunk;
        return this.bits.getWord(bitIndex) >> bitIndex;
    }

    @Override
    public long set(int id, long flags) {
        assert (id >= 0) : id;
        if ((flags & (long)(~this.mask)) != 0L) {
            throw new IllegalArgumentException("Flags must be between 0 and " + this.mask + " but got:" + flags);
        }
        int bitIndex = id / this.chunksPerWord * 32 + id % this.chunksPerWord * this.bitsPerChunk;
        int prevChunk = this.bits.changeWord(bitIndex, word -> word & ~(this.mask << bitIndex) | (int)flags << bitIndex) >> bitIndex;
        return prevChunk;
    }

    @Override
    public void clear() {
        this.bits.clear();
    }
}

