/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.util.containers;

import java.util.AbstractSequentialList;
import java.util.LinkedList;
import java.util.List;
import java.util.function.ToIntFunction;
import org.jetbrains.annotations.NotNull;

public class LinkedListWithSum<E>
extends AbstractSequentialList<E>
implements List<E> {
    private final LinkedList<ItemWithValue<E>> myList;
    private final ToIntFunction<? super E> myEvaluator;
    private long mySum;

    public LinkedListWithSum(@NotNull ToIntFunction<? super E> evaluator) {
        if (evaluator == null) {
            LinkedListWithSum.$$$reportNull$$$0(0);
        }
        this.myList = new LinkedList();
        this.myEvaluator = evaluator;
    }

    private ItemWithValue<E> createItem(E e) {
        return new ItemWithValue(e, this.myEvaluator.applyAsInt(e));
    }

    public long getSum() {
        return this.mySum;
    }

    @Override
    public int size() {
        return this.myList.size();
    }

    @NotNull
    public ListIterator listIterator(int index) {
        return new ListIterator(this.myList.listIterator(index));
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "evaluator", "com/intellij/util/containers/LinkedListWithSum", "<init>"));
    }

    public final class ListIterator
    implements java.util.ListIterator<E> {
        private final java.util.ListIterator<ItemWithValue<E>> it;
        private ItemWithValue<E> lastItem;

        private ListIterator(java.util.ListIterator<ItemWithValue<E>> it) {
            this.it = it;
        }

        @Override
        public boolean hasNext() {
            return this.it.hasNext();
        }

        @Override
        public E next() {
            this.lastItem = this.it.next();
            return this.lastItem.item;
        }

        @Override
        public boolean hasPrevious() {
            return this.it.hasPrevious();
        }

        @Override
        public E previous() {
            this.lastItem = this.it.previous();
            return this.lastItem.item;
        }

        @Override
        public int nextIndex() {
            return this.it.nextIndex();
        }

        @Override
        public int previousIndex() {
            return this.it.previousIndex();
        }

        @Override
        public void remove() {
            this.it.remove();
            LinkedListWithSum.this.mySum -= this.lastItem.value;
        }

        @Override
        public void set(E e) {
            ItemWithValue item = LinkedListWithSum.this.createItem(e);
            this.it.set(item);
            LinkedListWithSum.this.mySum -= this.lastItem.value;
            LinkedListWithSum.this.mySum += item.value;
        }

        @Override
        public void add(E e) {
            ItemWithValue item = LinkedListWithSum.this.createItem(e);
            this.it.add(item);
            LinkedListWithSum.this.mySum += item.value;
        }

        public int getValue() {
            return this.lastItem.value;
        }
    }

    private static final class ItemWithValue<E> {
        private final E item;
        private final int value;

        private ItemWithValue(E item, int value) {
            this.item = item;
            this.value = value;
        }
    }
}

