/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.util.io;

import com.intellij.openapi.diagnostic.Logger;
import com.intellij.util.SmartList;
import com.intellij.util.SystemProperties;
import com.intellij.util.containers.hash.LinkedHashMap;
import com.intellij.util.io.DirectBufferWrapper;
import com.intellij.util.io.IOStatistics;
import com.intellij.util.io.PagedFileStorage;
import com.intellij.util.io.StorageLockContext;
import com.intellij.util.lang.CompoundRuntimeException;
import com.intellij.util.system.CpuArch;
import it.unimi.dsi.fastutil.ints.Int2ObjectMap;
import it.unimi.dsi.fastutil.ints.Int2ObjectMaps;
import it.unimi.dsi.fastutil.ints.Int2ObjectOpenHashMap;
import java.io.IOException;
import java.lang.reflect.Field;
import java.lang.reflect.Method;
import java.util.Comparator;
import java.util.Iterator;
import java.util.Map;
import java.util.TreeMap;
import java.util.concurrent.ConcurrentLinkedQueue;
import java.util.concurrent.locks.ReentrantLock;
import org.jetbrains.annotations.ApiStatus;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@ApiStatus.Internal
public final class FilePageCache {
    private static final Logger LOG = Logger.getInstance(FilePageCache.class);
    static final int MAX_PAGES_COUNT = 65535;
    private static final int MAX_LIVE_STORAGES_COUNT = 65535;
    private static final int FILE_INDEX_MASK = -65536;
    private static final int FILE_INDEX_SHIFT = 16;
    private static final int LOWER_LIMIT;
    private static final int UPPER_LIMIT;
    static final int BUFFER_SIZE;
    private final Int2ObjectMap<PagedFileStorage> myIndex2Storage = Int2ObjectMaps.synchronize(new Int2ObjectOpenHashMap());
    private final LinkedHashMap<Integer, DirectBufferWrapper> mySegments;
    private final ReentrantLock mySegmentsAccessLock = new ReentrantLock();
    private final ReentrantLock mySegmentsAllocationLock = new ReentrantLock();
    private final ConcurrentLinkedQueue<DirectBufferWrapper> mySegmentsToRemove = new ConcurrentLinkedQueue();
    private final long mySizeLimit = UPPER_LIMIT;
    private long mySize;
    private volatile int myMappingChangeCount;

    void assertUnderSegmentAllocationLock() {
        assert (this.mySegmentsAllocationLock.isHeldByCurrentThread());
    }

    private static long maxDirectMemory() {
        try {
            Class<?> aClass = Class.forName("sun.misc.VM");
            Method maxDirectMemory = aClass.getMethod("maxDirectMemory", new Class[0]);
            return (Long)maxDirectMemory.invoke(null, new Object[0]);
        }
        catch (Throwable aClass) {
            try {
                Class<?> aClass2 = Class.forName("java.nio.Bits");
                Field maxMemory = aClass2.getDeclaredField("maxMemory");
                maxMemory.setAccessible(true);
                return (Long)maxMemory.get(null);
            }
            catch (Throwable throwable) {
                return Runtime.getRuntime().maxMemory();
            }
        }
    }

    public FilePageCache() {
        this.mySegments = new LinkedHashMap<Integer, DirectBufferWrapper>(10, 0.75f, true){

            @Override
            protected boolean removeEldestEntry(Map.Entry<Integer, DirectBufferWrapper> eldest) {
                assert (FilePageCache.this.mySegmentsAccessLock.isHeldByCurrentThread());
                return FilePageCache.this.mySize > FilePageCache.this.mySizeLimit;
            }

            @Override
            @Nullable
            public DirectBufferWrapper remove(Object key) {
                assert (FilePageCache.this.mySegmentsAccessLock.isHeldByCurrentThread());
                DirectBufferWrapper wrapper = (DirectBufferWrapper)super.remove(key);
                if (wrapper != null) {
                    ++FilePageCache.this.myMappingChangeCount;
                    FilePageCache.this.mySegmentsToRemove.offer(wrapper);
                    FilePageCache.this.mySize -= wrapper.getLength();
                }
                return wrapper;
            }
        };
    }

    int getMappingChangeCount() {
        return this.myMappingChangeCount;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    int registerPagedFileStorage(@NotNull PagedFileStorage storage) {
        if (storage == null) {
            FilePageCache.$$$reportNull$$$0(0);
        }
        Int2ObjectMap<PagedFileStorage> int2ObjectMap = this.myIndex2Storage;
        synchronized (int2ObjectMap) {
            int registered = this.myIndex2Storage.size();
            assert (registered <= 65535);
            int value = registered << 16;
            while (this.myIndex2Storage.get(value) != null) {
                assert (++registered <= 65535);
                value = registered << 16;
            }
            this.myIndex2Storage.put(value, storage);
            return value;
        }
    }

    @NotNull(value="Seems accessed storage has been closed")
    private @NotNull(value="Seems accessed storage has been closed") PagedFileStorage getRegisteredPagedFileStorageByIndex(int key) {
        int storageIndex = key & 0xFFFF0000;
        PagedFileStorage pagedFileStorage = (PagedFileStorage)this.myIndex2Storage.get(storageIndex);
        if (pagedFileStorage == null) {
            FilePageCache.$$$reportNull$$$0(1);
        }
        return pagedFileStorage;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    DirectBufferWrapper get(Integer key, boolean read, boolean readOnly) throws IOException {
        DirectBufferWrapper wrapper;
        try {
            this.mySegmentsAccessLock.lock();
            wrapper = this.mySegments.get(key);
            if (wrapper != null) {
                DirectBufferWrapper directBufferWrapper = wrapper;
                return directBufferWrapper;
            }
        }
        finally {
            this.mySegmentsAccessLock.unlock();
        }
        this.mySegmentsAllocationLock.lock();
        try {
            long finished;
            this.mySegmentsAccessLock.lock();
            try {
                wrapper = this.mySegments.get(key);
                if (wrapper != null) {
                    DirectBufferWrapper directBufferWrapper = wrapper;
                    return directBufferWrapper;
                }
            }
            finally {
                this.mySegmentsAccessLock.unlock();
            }
            long started = IOStatistics.DEBUG ? System.currentTimeMillis() : 0L;
            PagedFileStorage fileStorage = this.getRegisteredPagedFileStorageByIndex(key);
            this.disposeRemovedSegments();
            wrapper = FilePageCache.createValue(key, read, readOnly, fileStorage);
            if (IOStatistics.DEBUG && (finished = System.currentTimeMillis()) - started > 100L) {
                IOStatistics.dump("Mapping " + wrapper + " for " + (finished - started));
            }
            this.mySegmentsAccessLock.lock();
            try {
                this.mySegments.put(key, wrapper);
                this.mySize += (long)wrapper.getLength();
            }
            finally {
                this.mySegmentsAccessLock.unlock();
            }
            this.ensureSize(this.mySizeLimit);
            DirectBufferWrapper directBufferWrapper = wrapper;
            return directBufferWrapper;
        }
        finally {
            this.mySegmentsAllocationLock.unlock();
        }
    }

    private void disposeRemovedSegments() {
        this.assertUnderSegmentAllocationLock();
        if (this.mySegmentsToRemove.isEmpty()) {
            return;
        }
        Iterator<DirectBufferWrapper> iterator = this.mySegmentsToRemove.iterator();
        while (iterator.hasNext()) {
            try {
                iterator.next().release();
            }
            catch (IOException e) {
                LOG.error(e);
            }
            iterator.remove();
        }
    }

    private void ensureSize(long sizeLimit) {
        this.mySegmentsAllocationLock.isHeldByCurrentThread();
        try {
            this.mySegmentsAccessLock.lock();
            while (this.mySize > sizeLimit) {
                this.mySegments.doRemoveEldestEntry();
            }
        }
        finally {
            this.mySegmentsAccessLock.unlock();
        }
        this.disposeRemovedSegments();
    }

    @NotNull
    private static DirectBufferWrapper createValue(Integer key, boolean read, boolean readOnly, PagedFileStorage owner) throws IOException {
        StorageLockContext context2 = owner.getStorageLockContext();
        if (read) {
            context2.checkReadAccess();
        } else {
            context2.checkWriteAccess();
        }
        long off = (long)(key & 0xFFFF) * (long)owner.myPageSize;
        long ownerLength = owner.length();
        if (off > ownerLength) {
            throw new IndexOutOfBoundsException("off=" + off + " key.owner.length()=" + ownerLength);
        }
        int min = (int)Math.min(ownerLength - off, (long)owner.myPageSize);
        DirectBufferWrapper directBufferWrapper = readOnly ? DirectBufferWrapper.readOnlyDirect(owner, off, min) : DirectBufferWrapper.readWriteDirect(owner, off, min);
        if (directBufferWrapper == null) {
            FilePageCache.$$$reportNull$$$0(2);
        }
        return directBufferWrapper;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @NotNull
    private Map<Integer, DirectBufferWrapper> getBuffersOrderedForOwner(@NotNull StorageLockContext storageLockContext) {
        if (storageLockContext == null) {
            FilePageCache.$$$reportNull$$$0(3);
        }
        this.mySegmentsAccessLock.lock();
        storageLockContext.checkReadAccess();
        TreeMap<Integer, DirectBufferWrapper> mineBuffers = new TreeMap<Integer, DirectBufferWrapper>(Comparator.comparingInt(o -> o));
        for (Map.Entry<Integer, DirectBufferWrapper> entry : this.mySegments.entrySet()) {
            if (!entry.getValue().belongs(storageLockContext)) continue;
            mineBuffers.put(entry.getKey(), entry.getValue());
        }
        TreeMap<Integer, DirectBufferWrapper> treeMap = mineBuffers;
        Object object = treeMap;
        if (object == null) {
            FilePageCache.$$$reportNull$$$0(4);
        }
        return object;
        finally {
            this.mySegmentsAccessLock.unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void unmapBuffersForOwner(@NotNull StorageLockContext storageLockContext) {
        Map<Integer, DirectBufferWrapper> buffers;
        if (storageLockContext == null) {
            FilePageCache.$$$reportNull$$$0(5);
        }
        if (!(buffers = this.getBuffersOrderedForOwner(storageLockContext)).isEmpty()) {
            this.mySegmentsAccessLock.lock();
            try {
                for (Integer key : buffers.keySet()) {
                    this.mySegments.remove(key);
                }
            }
            finally {
                this.mySegmentsAccessLock.unlock();
            }
            this.mySegmentsAllocationLock.lock();
            try {
                this.disposeRemovedSegments();
            }
            finally {
                this.mySegmentsAllocationLock.unlock();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void flushBuffersForOwner(StorageLockContext storageLockContext) throws IOException {
        storageLockContext.checkReadAccess();
        Map<Integer, DirectBufferWrapper> buffers = this.getBuffersOrderedForOwner(storageLockContext);
        if (!buffers.isEmpty()) {
            SmartList<IOException> exceptions = new SmartList<IOException>();
            this.mySegmentsAllocationLock.lock();
            try {
                try {
                    for (DirectBufferWrapper buffer : buffers.values()) {
                        if (!buffer.isDirty() || buffer.isReleased()) continue;
                        buffer.force();
                    }
                }
                catch (IOException e) {
                    exceptions.add(e);
                }
            }
            finally {
                this.mySegmentsAllocationLock.unlock();
            }
            if (!exceptions.isEmpty()) {
                throw new IOException(new CompoundRuntimeException(exceptions));
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void invalidateBuffer(int page, @NotNull StorageLockContext storageLockContext) {
        if (storageLockContext == null) {
            FilePageCache.$$$reportNull$$$0(6);
        }
        this.mySegmentsAccessLock.lock();
        try {
            this.mySegments.remove(page);
        }
        finally {
            this.mySegmentsAccessLock.unlock();
        }
        this.mySegmentsAllocationLock.lock();
        try {
            this.disposeRemovedSegments();
        }
        finally {
            this.mySegmentsAllocationLock.unlock();
        }
    }

    void removeStorage(int index) {
        this.myIndex2Storage.remove(index);
    }

    static {
        int lower = 100;
        int upper = CpuArch.is32Bit() ? 200 : 500;
        BUFFER_SIZE = Math.max(1, SystemProperties.getIntProperty("idea.paged.storage.page.size", 10)) * 0x100000;
        long max = FilePageCache.maxDirectMemory() - 2L * (long)BUFFER_SIZE;
        LOWER_LIMIT = (int)Math.min(0x6400000L, max);
        UPPER_LIMIT = (int)Math.min((long)Math.max(LOWER_LIMIT, SystemProperties.getIntProperty("idea.max.paged.storage.cache", upper) * 0x100000), max);
        LOG.info("lower=" + LOWER_LIMIT / 0x100000 + "; upper=" + UPPER_LIMIT / 0x100000 + "; buffer=" + BUFFER_SIZE / 0x100000 + "; max=" + max / 0x100000L);
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        int n2;
        String string2;
        switch (n) {
            default: {
                string2 = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 1: {
                string2 = "Seems accessed storage has been closed";
                break;
            }
            case 2: 
            case 4: {
                string2 = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 1: {
                n2 = 0;
                break;
            }
            case 2: 
            case 4: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray = new Object[n2];
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[0] = "storage";
                break;
            }
            case 1: {
                break;
            }
            case 2: 
            case 4: {
                objectArray = objectArray;
                objectArray[0] = "com/intellij/util/io/FilePageCache";
                break;
            }
            case 3: 
            case 5: 
            case 6: {
                objectArray = objectArray;
                objectArray[0] = "storageLockContext";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[1] = "com/intellij/util/io/FilePageCache";
                break;
            }
            case 1: {
                break;
            }
            case 2: {
                objectArray = objectArray;
                objectArray[1] = "createValue";
                break;
            }
            case 4: {
                objectArray = objectArray;
                objectArray[1] = "getBuffersOrderedForOwner";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "registerPagedFileStorage";
                break;
            }
            case 1: 
            case 2: 
            case 4: {
                break;
            }
            case 3: {
                objectArray = objectArray;
                objectArray[2] = "getBuffersOrderedForOwner";
                break;
            }
            case 5: {
                objectArray = objectArray;
                objectArray[2] = "unmapBuffersForOwner";
                break;
            }
            case 6: {
                objectArray = objectArray;
                objectArray[2] = "invalidateBuffer";
                break;
            }
        }
        String string3 = String.format(string2, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string3);
                break;
            }
            case 1: 
            case 2: 
            case 4: {
                runtimeException = new IllegalStateException(string3);
                break;
            }
        }
        throw runtimeException;
    }
}

