/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.util.text;

import com.intellij.UtilBundle;
import com.intellij.jna.JnaLoader;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.util.Clock;
import com.intellij.openapi.util.NlsSafe;
import com.intellij.openapi.util.SystemInfo;
import com.intellij.util.text.SyncDateFormat;
import com.sun.jna.Library;
import com.sun.jna.Native;
import com.sun.jna.Pointer;
import com.sun.jna.Structure;
import com.sun.jna.win32.StdCallLibrary;
import java.text.DateFormat;
import java.text.SimpleDateFormat;
import java.util.Calendar;
import java.util.Date;
import java.util.Locale;
import java.util.TimeZone;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public final class DateFormatUtil {
    private static final Logger LOG = Logger.getInstance(DateFormatUtil.class);
    public static final long SECOND = 1000L;
    public static final long MINUTE = 60000L;
    public static final long HOUR = 3600000L;
    public static final long DAY = 86400000L;
    public static final long WEEK = 604800000L;
    public static final long MONTH = 2592000000L;
    public static final long YEAR = 31536000000L;
    public static final long DAY_FACTOR = 86400000L;
    private static final SyncDateFormat DATE_FORMAT;
    private static final SyncDateFormat TIME_FORMAT;
    private static final SyncDateFormat TIME_WITH_SECONDS_FORMAT;
    private static final SyncDateFormat DATE_TIME_FORMAT;
    private static final SyncDateFormat ISO8601_FORMAT;
    private static final long[] DENOMINATORS;
    private static final Period[] PERIODS;

    private DateFormatUtil() {
    }

    public static long getDifferenceInDays(@NotNull Date startDate, @NotNull Date endDate) {
        if (startDate == null) {
            DateFormatUtil.$$$reportNull$$$0(0);
        }
        if (endDate == null) {
            DateFormatUtil.$$$reportNull$$$0(1);
        }
        return (endDate.getTime() - startDate.getTime() + 86400000L - 1000L) / 86400000L;
    }

    @NotNull
    public static SyncDateFormat getDateFormat() {
        SyncDateFormat syncDateFormat = DATE_FORMAT;
        if (syncDateFormat == null) {
            DateFormatUtil.$$$reportNull$$$0(2);
        }
        return syncDateFormat;
    }

    @NotNull
    public static SyncDateFormat getTimeFormat() {
        SyncDateFormat syncDateFormat = TIME_FORMAT;
        if (syncDateFormat == null) {
            DateFormatUtil.$$$reportNull$$$0(3);
        }
        return syncDateFormat;
    }

    @NotNull
    public static SyncDateFormat getTimeWithSecondsFormat() {
        SyncDateFormat syncDateFormat = TIME_WITH_SECONDS_FORMAT;
        if (syncDateFormat == null) {
            DateFormatUtil.$$$reportNull$$$0(4);
        }
        return syncDateFormat;
    }

    @NotNull
    public static SyncDateFormat getDateTimeFormat() {
        SyncDateFormat syncDateFormat = DATE_TIME_FORMAT;
        if (syncDateFormat == null) {
            DateFormatUtil.$$$reportNull$$$0(5);
        }
        return syncDateFormat;
    }

    @NotNull
    public static SyncDateFormat getIso8601Format() {
        SyncDateFormat syncDateFormat = ISO8601_FORMAT;
        if (syncDateFormat == null) {
            DateFormatUtil.$$$reportNull$$$0(6);
        }
        return syncDateFormat;
    }

    @NlsSafe
    @NotNull
    public static String formatTime(@NotNull Date time) {
        if (time == null) {
            DateFormatUtil.$$$reportNull$$$0(7);
        }
        return DateFormatUtil.formatTime(time.getTime());
    }

    @NlsSafe
    @NotNull
    public static String formatTime(long time) {
        String string2 = DateFormatUtil.getTimeFormat().format(time);
        if (string2 == null) {
            DateFormatUtil.$$$reportNull$$$0(8);
        }
        return string2;
    }

    @NlsSafe
    @NotNull
    public static String formatTimeWithSeconds(@NotNull Date time) {
        if (time == null) {
            DateFormatUtil.$$$reportNull$$$0(9);
        }
        return DateFormatUtil.formatTimeWithSeconds(time.getTime());
    }

    @NlsSafe
    @NotNull
    public static String formatTimeWithSeconds(long time) {
        String string2 = DateFormatUtil.getTimeWithSecondsFormat().format(time);
        if (string2 == null) {
            DateFormatUtil.$$$reportNull$$$0(10);
        }
        return string2;
    }

    @NlsSafe
    @NotNull
    public static String formatDate(@NotNull Date time) {
        if (time == null) {
            DateFormatUtil.$$$reportNull$$$0(11);
        }
        return DateFormatUtil.formatDate(time.getTime());
    }

    @NlsSafe
    @NotNull
    public static String formatDate(long time) {
        String string2 = DateFormatUtil.getDateFormat().format(time);
        if (string2 == null) {
            DateFormatUtil.$$$reportNull$$$0(12);
        }
        return string2;
    }

    @NlsSafe
    @NotNull
    public static String formatPrettyDate(@NotNull Date date) {
        if (date == null) {
            DateFormatUtil.$$$reportNull$$$0(13);
        }
        return DateFormatUtil.formatPrettyDate(date.getTime());
    }

    @NlsSafe
    @NotNull
    public static String formatPrettyDate(long time) {
        String pretty = DateFormatUtil.doFormatPretty(time, false);
        String string2 = pretty != null ? pretty : DATE_FORMAT.format(time);
        if (string2 == null) {
            DateFormatUtil.$$$reportNull$$$0(14);
        }
        return string2;
    }

    @NlsSafe
    @NotNull
    public static String formatDateTime(Date date) {
        return DateFormatUtil.formatDateTime(date.getTime());
    }

    @NlsSafe
    @NotNull
    public static String formatDateTime(long time) {
        String string2 = DateFormatUtil.getDateTimeFormat().format(time);
        if (string2 == null) {
            DateFormatUtil.$$$reportNull$$$0(15);
        }
        return string2;
    }

    @NlsSafe
    @NotNull
    public static String formatPrettyDateTime(@NotNull Date date) {
        if (date == null) {
            DateFormatUtil.$$$reportNull$$$0(16);
        }
        return DateFormatUtil.formatPrettyDateTime(date.getTime());
    }

    @NlsSafe
    @NotNull
    public static String formatPrettyDateTime(long time) {
        String pretty = DateFormatUtil.doFormatPretty(time, true);
        String string2 = pretty != null ? pretty : DATE_TIME_FORMAT.format(time);
        if (string2 == null) {
            DateFormatUtil.$$$reportNull$$$0(17);
        }
        return string2;
    }

    public static boolean isPrettyFormattingPossible(long time) {
        return DateFormatUtil.doFormatPretty(time, true) != null;
    }

    @Nullable
    private static String doFormatPretty(long time, boolean formatTime) {
        boolean isYesterday;
        boolean isToday;
        long delta;
        long currentTime = Clock.getTime();
        Calendar c = Calendar.getInstance();
        c.setTimeInMillis(currentTime);
        int currentYear = c.get(1);
        int currentDayOfYear = c.get(6);
        c.setTimeInMillis(time);
        int year = c.get(1);
        int dayOfYear = c.get(6);
        if (LOG.isTraceEnabled()) {
            LOG.trace("now=" + currentTime + " t=" + time + " z=" + c.getTimeZone());
        }
        if (formatTime && (delta = currentTime - time) >= 0L && delta <= 3660000L) {
            return UtilBundle.message("date.format.minutes.ago", (int)Math.rint((double)delta / 60000.0));
        }
        boolean bl = isToday = currentYear == year && currentDayOfYear == dayOfYear;
        if (isToday) {
            String result2 = UtilBundle.message("date.format.today", new Object[0]);
            return formatTime ? result2 + " " + TIME_FORMAT.format(time) : result2;
        }
        boolean isYesterdayOnPreviousYear = currentYear == year + 1 && currentDayOfYear == 1 && dayOfYear == c.getActualMaximum(6);
        boolean bl2 = isYesterday = isYesterdayOnPreviousYear || currentYear == year && currentDayOfYear == dayOfYear + 1;
        if (isYesterday) {
            String result3 = UtilBundle.message("date.format.yesterday", new Object[0]);
            return formatTime ? result3 + " " + TIME_FORMAT.format(time) : result3;
        }
        return null;
    }

    @NlsSafe
    @NotNull
    public static String formatFrequency(long time) {
        String string2 = UtilBundle.message("date.frequency", DateFormatUtil.formatBetweenDates(time, 0L));
        if (string2 == null) {
            DateFormatUtil.$$$reportNull$$$0(18);
        }
        return string2;
    }

    @NlsSafe
    @NotNull
    public static String formatBetweenDates(long d1, long d2) {
        int i;
        long delta = Math.abs(d1 - d2);
        if (delta == 0L) {
            String string2 = UtilBundle.message("date.format.right.now", new Object[0]);
            if (string2 == null) {
                DateFormatUtil.$$$reportNull$$$0(19);
            }
            return string2;
        }
        int n = -1;
        for (i = 0; i < DENOMINATORS.length; ++i) {
            long denominator = DENOMINATORS[i];
            if (delta < denominator) continue;
            n = (int)(delta / denominator);
            break;
        }
        if (d2 > d1) {
            if (n <= 0) {
                String string3 = UtilBundle.message("date.format.a.few.moments.ago", new Object[0]);
                if (string3 == null) {
                    DateFormatUtil.$$$reportNull$$$0(20);
                }
                return string3;
            }
            String string4 = DateFormatUtil.someTimeAgoMessage(PERIODS[i], n);
            if (string4 == null) {
                DateFormatUtil.$$$reportNull$$$0(21);
            }
            return string4;
        }
        if (d2 < d1) {
            if (n <= 0) {
                String string5 = UtilBundle.message("date.format.in.a.few.moments", new Object[0]);
                if (string5 == null) {
                    DateFormatUtil.$$$reportNull$$$0(22);
                }
                return string5;
            }
            String string6 = DateFormatUtil.composeInSomeTimeMessage(PERIODS[i], n);
            if (string6 == null) {
                DateFormatUtil.$$$reportNull$$$0(23);
            }
            return string6;
        }
        return "";
    }

    @Deprecated
    @NlsSafe
    @NotNull
    public static String formatAboutDialogDate(@NotNull Date date) {
        if (date == null) {
            DateFormatUtil.$$$reportNull$$$0(24);
        }
        return DateFormatUtil.formatAboutDialogDate(date.getTime());
    }

    @Deprecated
    @NlsSafe
    @NotNull
    public static String formatAboutDialogDate(long time) {
        String string2 = DateFormat.getDateInstance(1, Locale.US).format(time);
        if (string2 == null) {
            DateFormatUtil.$$$reportNull$$$0(25);
        }
        return string2;
    }

    @NotNull
    public static Date getSampleDateTime() {
        Date date;
        Date date2 = date = new Date(100, 11, 31, 23, 59);
        if (date2 == null) {
            DateFormatUtil.$$$reportNull$$$0(26);
        }
        return date2;
    }

    private static String someTimeAgoMessage(Period period, int n) {
        switch (period) {
            case DAY: {
                return UtilBundle.message("date.format.n.days.ago", n);
            }
            case MINUTE: {
                return UtilBundle.message("date.format.n.minutes.ago", n);
            }
            case HOUR: {
                return UtilBundle.message("date.format.n.hours.ago", n);
            }
            case MONTH: {
                return UtilBundle.message("date.format.n.months.ago", n);
            }
            case WEEK: {
                return UtilBundle.message("date.format.n.weeks.ago", n);
            }
        }
        return UtilBundle.message("date.format.n.years.ago", n);
    }

    private static String composeInSomeTimeMessage(Period period, int n) {
        switch (period) {
            case DAY: {
                return UtilBundle.message("date.format.in.n.days", n);
            }
            case MINUTE: {
                return UtilBundle.message("date.format.in.n.minutes", n);
            }
            case HOUR: {
                return UtilBundle.message("date.format.in.n.hours", n);
            }
            case MONTH: {
                return UtilBundle.message("date.format.in.n.months", n);
            }
            case WEEK: {
                return UtilBundle.message("date.format.in.n.weeks", n);
            }
        }
        return UtilBundle.message("date.format.in.n.years", n);
    }

    private static SyncDateFormat[] getDateTimeFormats() {
        DateFormat[] formats = null;
        try {
            if (SystemInfo.isMac && JnaLoader.isLoaded()) {
                formats = DateFormatUtil.getMacFormats();
            } else if (SystemInfo.isUnix) {
                formats = DateFormatUtil.getUnixFormats();
            } else if (SystemInfo.isWindows && JnaLoader.isLoaded()) {
                formats = DateFormatUtil.getWindowsFormats();
            }
        }
        catch (Throwable t) {
            LOG.error(t);
        }
        if (formats == null) {
            LOG.info("cannot load system formats (JNA=" + JnaLoader.isLoaded() + "), resorting to JRE for " + Locale.getDefault(Locale.Category.FORMAT));
            formats = new DateFormat[]{DateFormat.getDateInstance(3), DateFormat.getTimeInstance(3), DateFormat.getTimeInstance(2), DateFormat.getDateTimeInstance(3, 3)};
        }
        SyncDateFormat[] synced = new SyncDateFormat[4];
        for (int i = 0; i < formats.length; ++i) {
            synced[i] = new SyncDateFormat(formats[i]);
        }
        return synced;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static DateFormat[] getMacFormats() {
        CF cf = Native.load("CoreFoundation", CF.class);
        Pointer localeRef = cf.CFLocaleCopyCurrent();
        try {
            String localeId = DateFormatUtil.getMacString(cf, cf.CFLocaleGetIdentifier(localeRef));
            if (LOG.isTraceEnabled()) {
                LOG.trace("id=" + localeId);
            }
            Locale locale = DateFormatUtil.getLocaleById(localeId);
            DateFormat[] dateFormatArray = new DateFormat[]{DateFormatUtil.getMacFormat(cf, localeRef, 1L, 0L, locale), DateFormatUtil.getMacFormat(cf, localeRef, 0L, 1L, locale), DateFormatUtil.getMacFormat(cf, localeRef, 0L, 2L, locale), DateFormatUtil.getMacFormat(cf, localeRef, 1L, 1L, locale)};
            return dateFormatArray;
        }
        finally {
            cf.CFRelease(localeRef);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static DateFormat getMacFormat(CF cf, Pointer localeRef, long dateStyle, long timeStyle, Locale locale) {
        Pointer formatter = cf.CFDateFormatterCreate(null, localeRef, dateStyle, timeStyle);
        if (formatter == null) {
            throw new IllegalStateException("CFDateFormatterCreate: null");
        }
        try {
            Pointer format = cf.CFDateFormatterGetFormat(formatter);
            DateFormat dateFormat = DateFormatUtil.formatFromString(DateFormatUtil.getMacString(cf, format), locale);
            return dateFormat;
        }
        finally {
            cf.CFRelease(formatter);
        }
    }

    private static String getMacString(CF cf, Pointer ref) {
        int length = (int)cf.CFStringGetLength(ref);
        char[] buffer = new char[length];
        cf.CFStringGetCharacters(ref, new CF.CFRange(0L, (long)length), buffer);
        return new String(buffer);
    }

    private static DateFormat @Nullable [] getUnixFormats() {
        String localeStr = System.getenv("LC_TIME");
        if (LOG.isTraceEnabled()) {
            LOG.trace("LC_TIME=" + localeStr);
        }
        if (localeStr == null) {
            return null;
        }
        Locale locale = DateFormatUtil.getLocaleById(localeStr.trim());
        return new DateFormat[]{DateFormat.getDateInstance(3, locale), DateFormat.getTimeInstance(3, locale), DateFormat.getTimeInstance(2, locale), DateFormat.getDateTimeInstance(3, 3, locale)};
    }

    private static Locale getLocaleById(String localeStr) {
        int p = localeStr.indexOf(46);
        if (p > 0) {
            localeStr = localeStr.substring(0, p);
        }
        if ((p = localeStr.indexOf(64)) > 0) {
            localeStr = localeStr.substring(0, p);
        }
        if ((p = localeStr.indexOf(95)) < 0) {
            return new Locale(localeStr);
        }
        return new Locale(localeStr.substring(0, p), localeStr.substring(p + 1));
    }

    private static DateFormat[] getWindowsFormats() {
        int bufferSize;
        char[] buffer;
        Kernel32 kernel32 = Native.load("Kernel32", Kernel32.class);
        int rv = kernel32.GetLocaleInfoEx(null, 31, buffer = new char[bufferSize = 128], bufferSize);
        if (rv < 2) {
            throw new IllegalStateException("GetLocaleInfoEx: " + kernel32.GetLastError());
        }
        String shortDate = DateFormatUtil.fixWindowsFormat(new String(buffer, 0, rv - 1));
        rv = kernel32.GetLocaleInfoEx(null, 121, buffer, bufferSize);
        if (rv < 2) {
            throw new IllegalStateException("GetLocaleInfoEx: " + kernel32.GetLastError());
        }
        String shortTime = DateFormatUtil.fixWindowsFormat(new String(buffer, 0, rv - 1));
        rv = kernel32.GetLocaleInfoEx(null, 4099, buffer, bufferSize);
        if (rv < 2) {
            throw new IllegalStateException("GetLocaleInfoEx: " + kernel32.GetLastError());
        }
        String mediumTime = DateFormatUtil.fixWindowsFormat(new String(buffer, 0, rv - 1));
        Locale locale = Locale.getDefault(Locale.Category.FORMAT);
        return new DateFormat[]{DateFormatUtil.formatFromString(shortDate, locale), DateFormatUtil.formatFromString(shortTime, locale), DateFormatUtil.formatFromString(mediumTime, locale), DateFormatUtil.formatFromString(shortDate + ' ' + shortTime, locale)};
    }

    private static String fixWindowsFormat(String format) {
        return format.replaceAll("g+", "G").replace("tt", "a");
    }

    private static DateFormat formatFromString(String format, Locale locale) {
        try {
            if (LOG.isTraceEnabled()) {
                LOG.trace("'" + format + "' in " + locale);
            }
            return new SimpleDateFormat(format.trim(), locale);
        }
        catch (IllegalArgumentException e) {
            throw new IllegalArgumentException("unrecognized format string '" + format + "'");
        }
    }

    static {
        SyncDateFormat[] formats = DateFormatUtil.getDateTimeFormats();
        DATE_FORMAT = formats[0];
        TIME_FORMAT = formats[1];
        TIME_WITH_SECONDS_FORMAT = formats[2];
        DATE_TIME_FORMAT = formats[3];
        SimpleDateFormat iso8601 = new SimpleDateFormat("yyyy-MM-dd'T'HH:mm:ss.SSSZ");
        iso8601.setTimeZone(TimeZone.getTimeZone("UTC"));
        ISO8601_FORMAT = new SyncDateFormat(iso8601);
        DENOMINATORS = new long[]{31536000000L, 2592000000L, 604800000L, 86400000L, 3600000L, 60000L};
        PERIODS = new Period[]{Period.YEAR, Period.MONTH, Period.WEEK, Period.DAY, Period.HOUR, Period.MINUTE};
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string2;
        switch (n) {
            default: {
                string2 = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 2: 
            case 3: 
            case 4: 
            case 5: 
            case 6: 
            case 8: 
            case 10: 
            case 12: 
            case 14: 
            case 15: 
            case 17: 
            case 18: 
            case 19: 
            case 20: 
            case 21: 
            case 22: 
            case 23: 
            case 25: 
            case 26: {
                string2 = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 2: 
            case 3: 
            case 4: 
            case 5: 
            case 6: 
            case 8: 
            case 10: 
            case 12: 
            case 14: 
            case 15: 
            case 17: 
            case 18: 
            case 19: 
            case 20: 
            case 21: 
            case 22: 
            case 23: 
            case 25: 
            case 26: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "startDate";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "endDate";
                break;
            }
            case 2: 
            case 3: 
            case 4: 
            case 5: 
            case 6: 
            case 8: 
            case 10: 
            case 12: 
            case 14: 
            case 15: 
            case 17: 
            case 18: 
            case 19: 
            case 20: 
            case 21: 
            case 22: 
            case 23: 
            case 25: 
            case 26: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/util/text/DateFormatUtil";
                break;
            }
            case 7: 
            case 9: 
            case 11: {
                objectArray2 = objectArray3;
                objectArray3[0] = "time";
                break;
            }
            case 13: 
            case 16: 
            case 24: {
                objectArray2 = objectArray3;
                objectArray3[0] = "date";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/util/text/DateFormatUtil";
                break;
            }
            case 2: {
                objectArray = objectArray2;
                objectArray2[1] = "getDateFormat";
                break;
            }
            case 3: {
                objectArray = objectArray2;
                objectArray2[1] = "getTimeFormat";
                break;
            }
            case 4: {
                objectArray = objectArray2;
                objectArray2[1] = "getTimeWithSecondsFormat";
                break;
            }
            case 5: {
                objectArray = objectArray2;
                objectArray2[1] = "getDateTimeFormat";
                break;
            }
            case 6: {
                objectArray = objectArray2;
                objectArray2[1] = "getIso8601Format";
                break;
            }
            case 8: {
                objectArray = objectArray2;
                objectArray2[1] = "formatTime";
                break;
            }
            case 10: {
                objectArray = objectArray2;
                objectArray2[1] = "formatTimeWithSeconds";
                break;
            }
            case 12: {
                objectArray = objectArray2;
                objectArray2[1] = "formatDate";
                break;
            }
            case 14: {
                objectArray = objectArray2;
                objectArray2[1] = "formatPrettyDate";
                break;
            }
            case 15: {
                objectArray = objectArray2;
                objectArray2[1] = "formatDateTime";
                break;
            }
            case 17: {
                objectArray = objectArray2;
                objectArray2[1] = "formatPrettyDateTime";
                break;
            }
            case 18: {
                objectArray = objectArray2;
                objectArray2[1] = "formatFrequency";
                break;
            }
            case 19: 
            case 20: 
            case 21: 
            case 22: 
            case 23: {
                objectArray = objectArray2;
                objectArray2[1] = "formatBetweenDates";
                break;
            }
            case 25: {
                objectArray = objectArray2;
                objectArray2[1] = "formatAboutDialogDate";
                break;
            }
            case 26: {
                objectArray = objectArray2;
                objectArray2[1] = "getSampleDateTime";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "getDifferenceInDays";
                break;
            }
            case 2: 
            case 3: 
            case 4: 
            case 5: 
            case 6: 
            case 8: 
            case 10: 
            case 12: 
            case 14: 
            case 15: 
            case 17: 
            case 18: 
            case 19: 
            case 20: 
            case 21: 
            case 22: 
            case 23: 
            case 25: 
            case 26: {
                break;
            }
            case 7: {
                objectArray = objectArray;
                objectArray[2] = "formatTime";
                break;
            }
            case 9: {
                objectArray = objectArray;
                objectArray[2] = "formatTimeWithSeconds";
                break;
            }
            case 11: {
                objectArray = objectArray;
                objectArray[2] = "formatDate";
                break;
            }
            case 13: {
                objectArray = objectArray;
                objectArray[2] = "formatPrettyDate";
                break;
            }
            case 16: {
                objectArray = objectArray;
                objectArray[2] = "formatPrettyDateTime";
                break;
            }
            case 24: {
                objectArray = objectArray;
                objectArray[2] = "formatAboutDialogDate";
                break;
            }
        }
        String string3 = String.format(string2, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string3);
                break;
            }
            case 2: 
            case 3: 
            case 4: 
            case 5: 
            case 6: 
            case 8: 
            case 10: 
            case 12: 
            case 14: 
            case 15: 
            case 17: 
            case 18: 
            case 19: 
            case 20: 
            case 21: 
            case 22: 
            case 23: 
            case 25: 
            case 26: {
                runtimeException = new IllegalStateException(string3);
                break;
            }
        }
        throw runtimeException;
    }

    private static interface Kernel32
    extends StdCallLibrary {
        public static final int LOCALE_SSHORTDATE = 31;
        public static final int LOCALE_SSHORTTIME = 121;
        public static final int LOCALE_STIMEFORMAT = 4099;

        public int GetLocaleInfoEx(String var1, int var2, char[] var3, int var4);

        public int GetLastError();
    }

    private static interface CF
    extends Library {
        public static final long kCFDateFormatterNoStyle = 0L;
        public static final long kCFDateFormatterShortStyle = 1L;
        public static final long kCFDateFormatterMediumStyle = 2L;

        public Pointer CFLocaleCopyCurrent();

        public Pointer CFLocaleGetIdentifier(Pointer var1);

        public Pointer CFDateFormatterCreate(Pointer var1, Pointer var2, long var3, long var5);

        public Pointer CFDateFormatterGetFormat(Pointer var1);

        public long CFStringGetLength(Pointer var1);

        public void CFStringGetCharacters(Pointer var1, CFRange var2, char[] var3);

        public void CFRelease(Pointer var1);

        @Structure.FieldOrder(value={"location", "length"})
        public static class CFRange
        extends Structure
        implements Structure.ByValue {
            public long location;
            public long length;

            public CFRange(long location, long length) {
                this.location = location;
                this.length = length;
            }
        }
    }

    private static enum Period {
        YEAR,
        MONTH,
        WEEK,
        DAY,
        HOUR,
        MINUTE;

    }
}

