/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.lint;

import com.android.tools.analytics.AnalyticsSettings;
import com.android.tools.analytics.Anonymizer;
import com.android.tools.analytics.CommonMetricsData;
import com.android.tools.analytics.UsageTracker;
import com.android.tools.lint.LintCliFlags;
import com.android.tools.lint.client.api.IssueRegistry;
import com.android.tools.lint.client.api.LintClient;
import com.android.tools.lint.client.api.LintDriver;
import com.android.tools.lint.detector.api.Incident;
import com.android.tools.lint.detector.api.Issue;
import com.android.tools.lint.detector.api.Project;
import com.android.tools.lint.detector.api.Severity;
import com.android.tools.lint.detector.api.SeverityKt;
import com.android.tools.lint.model.LintModelSeverity;
import com.android.utils.ILogger;
import com.android.utils.NullLogger;
import com.android.utils.StdLogger;
import com.google.wireless.android.sdk.stats.AndroidStudioEvent;
import com.google.wireless.android.sdk.stats.LintIssueId;
import com.google.wireless.android.sdk.stats.LintPerformance;
import com.google.wireless.android.sdk.stats.LintSession;
import com.intellij.concurrency.JobScheduler;
import com.intellij.openapi.application.ApplicationManager;
import java.io.File;
import java.io.IOException;
import java.util.Collection;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.concurrent.ScheduledExecutorService;
import java.util.concurrent.TimeUnit;
import kotlin.Metadata;
import kotlin._Assertions;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={1, 6, 0}, k=1, xi=48, d1={"\u0000v\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0010\u001e\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010$\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\u0018\u00002\u00020\u0001B\u0005\u00a2\u0006\u0002\u0010\u0002J\u0010\u0010\u0003\u001a\u00020\u00042\u0006\u0010\u0005\u001a\u00020\u0006H\u0002J\u0018\u0010\u0007\u001a\u0004\u0018\u00010\b2\f\u0010\t\u001a\b\u0012\u0004\u0012\u00020\u000b0\nH\u0002J2\u0010\f\u001a\u000e\u0012\u0004\u0012\u00020\b\u0012\u0004\u0012\u00020\u000e0\r2\f\u0010\u000f\u001a\b\u0012\u0004\u0012\u00020\u00110\u00102\u0006\u0010\u0005\u001a\u00020\u00062\u0006\u0010\u0012\u001a\u00020\u0013H\u0002J\u0010\u0010\u0014\u001a\u00020\u00152\u0006\u0010\u0016\u001a\u00020\u0017H\u0002J\u0014\u0010\u0018\u001a\u0004\u0018\u00010\b2\b\u0010\u0019\u001a\u0004\u0018\u00010\u001aH\u0002J\u0018\u0010\u0018\u001a\u0004\u0018\u00010\b2\f\u0010\t\u001a\b\u0012\u0004\u0012\u00020\u000b0\nH\u0002J:\u0010\u001b\u001a\u00020\u001c2\u0006\u0010\u0012\u001a\u00020\u00132\u0006\u0010\u0005\u001a\u00020\u00062\u0006\u0010\u0016\u001a\u00020\u00172\f\u0010\t\u001a\b\u0012\u0004\u0012\u00020\u000b0\n2\f\u0010\u000f\u001a\b\u0012\u0004\u0012\u00020\u00110\u0010J<\u0010\u001d\u001a\u00020\u001c2\"\u0010\u001e\u001a\u001e\u0012\u0004\u0012\u00020\b\u0012\u0004\u0012\u00020\u000e0\u001fj\u000e\u0012\u0004\u0012\u00020\b\u0012\u0004\u0012\u00020\u000e` 2\u0006\u0010!\u001a\u00020\b2\u0006\u0010\"\u001a\u00020#H\u0002J\f\u0010$\u001a\u00020%*\u00020#H\u0002\u00a8\u0006&"}, d2={"Lcom/android/tools/lint/LintBatchAnalytics;", "", "()V", "computeAnalysisType", "Lcom/google/wireless/android/sdk/stats/LintSession$AnalysisType;", "flags", "Lcom/android/tools/lint/LintCliFlags;", "computeApplicationId", "", "projects", "", "Lcom/android/tools/lint/detector/api/Project;", "computeIssueData", "", "Lcom/google/wireless/android/sdk/stats/LintIssueId$Builder;", "incidents", "", "Lcom/android/tools/lint/detector/api/Incident;", "registry", "Lcom/android/tools/lint/client/api/IssueRegistry;", "computePerformance", "Lcom/google/wireless/android/sdk/stats/LintPerformance;", "driver", "Lcom/android/tools/lint/client/api/LintDriver;", "computeProjectId", "projectPath", "Ljava/io/File;", "logSession", "", "recordSeverityOverride", "map", "Ljava/util/HashMap;", "Lkotlin/collections/HashMap;", "id", "lintSeverity", "Lcom/android/tools/lint/detector/api/Severity;", "toAnalyticsSeverity", "Lcom/google/wireless/android/sdk/stats/LintIssueId$LintSeverity;", "lint-cli"})
public final class LintBatchAnalytics {
    public final void logSession(@NotNull IssueRegistry registry, @NotNull LintCliFlags flags, @NotNull LintDriver driver, @NotNull Collection<? extends Project> projects, @NotNull List<Incident> incidents) {
        AndroidStudioEvent.Builder builder;
        boolean scheduler2;
        Object clientName;
        Intrinsics.checkNotNullParameter((Object)registry, (String)"registry");
        Intrinsics.checkNotNullParameter((Object)flags, (String)"flags");
        Intrinsics.checkNotNullParameter((Object)driver, (String)"driver");
        Intrinsics.checkNotNullParameter(projects, (String)"projects");
        Intrinsics.checkNotNullParameter(incidents, (String)"incidents");
        LintClient client = driver.getClient();
        if (LintClient.Companion.isUnitTest()) {
            return;
        }
        try {
            if (!AnalyticsSettings.getInitialized()) {
                AnalyticsSettings.initialize$default((ILogger)((ILogger)new StdLogger(StdLogger.Level.WARNING)), null, null, (int)6, null);
            }
        }
        catch (Throwable failure) {
            client.log(failure, "Could not initialize analytics", new Object[0]);
            return;
        }
        if (!AnalyticsSettings.getOptedIn()) {
            return;
        }
        boolean initializedUsageTracker = false;
        if (!UsageTracker.INSTANCE.getInitialized()) {
            initializedUsageTracker = true;
            ScheduledExecutorService scheduledExecutorService = JobScheduler.getScheduler();
            Intrinsics.checkNotNullExpressionValue((Object)scheduledExecutorService, (String)"getScheduler()");
            ScheduledExecutorService scheduler2 = scheduledExecutorService;
            UsageTracker.initialize((ScheduledExecutorService)scheduler2);
            UsageTracker.setMaxJournalTime((long)10L, (TimeUnit)TimeUnit.MINUTES);
            UsageTracker.setMaxJournalSize((int)1000);
            clientName = client.getClientDisplayName();
            String string = client.getClientDisplayRevision();
            if (string == null) {
                string = "unknown";
            }
            String clientVersion = string;
            UsageTracker.setVersion((String)((String)clientName + " " + clientVersion));
            if (Boolean.getBoolean("idea.is.internal") || ApplicationManager.getApplication().isInternal()) {
                UsageTracker.setIdeaIsInternal((boolean)true);
            }
        }
        boolean bl = scheduler2 = !projects.isEmpty();
        if (_Assertions.ENABLED && !scheduler2) {
            clientName = "Assertion failed";
            throw new AssertionError(clientName);
        }
        LintSession.Builder $this$logSession_u24lambda_u2d0 = clientName = LintSession.newBuilder();
        boolean bl2 = false;
        $this$logSession_u24lambda_u2d0.setAnalysisType(this.computeAnalysisType(flags));
        $this$logSession_u24lambda_u2d0.setProjectId(this.computeProjectId(projects));
        $this$logSession_u24lambda_u2d0.setLintPerformance(this.computePerformance(driver));
        $this$logSession_u24lambda_u2d0.setBaselineEnabled(driver.getBaseline() != null);
        $this$logSession_u24lambda_u2d0.setIncludingGeneratedSources(driver.getCheckGeneratedSources());
        $this$logSession_u24lambda_u2d0.setIncludingTestSources(driver.getCheckTestSources());
        $this$logSession_u24lambda_u2d0.setIncludingDependencies(driver.getCheckDependencies());
        $this$logSession_u24lambda_u2d0.setAbortOnError(flags.isSetExitCode());
        $this$logSession_u24lambda_u2d0.setIgnoreWarnings(flags.isIgnoreWarnings());
        $this$logSession_u24lambda_u2d0.setWarningsAsErrors(flags.isWarningsAsErrors());
        for (LintIssueId.Builder issueBuilder : this.computeIssueData(incidents, flags, registry).values()) {
            $this$logSession_u24lambda_u2d0.addIssueIds(issueBuilder);
        }
        LintSession session = clientName.build();
        AndroidStudioEvent.Builder $this$logSession_u24lambda_u2d2 = builder = AndroidStudioEvent.newBuilder();
        boolean bl3 = false;
        $this$logSession_u24lambda_u2d2.setKind(AndroidStudioEvent.EventKind.LINT_SESSION);
        $this$logSession_u24lambda_u2d2.setLintSession(session);
        $this$logSession_u24lambda_u2d2.setJavaProcessStats(CommonMetricsData.getJavaProcessStats());
        $this$logSession_u24lambda_u2d2.setJvmDetails(CommonMetricsData.getJvmDetails());
        String string = this.computeApplicationId(projects);
        if (string != null) {
            String it = string;
            boolean bl4 = false;
            $this$logSession_u24lambda_u2d2.setRawProjectId(it);
        }
        AndroidStudioEvent.Builder event = builder;
        Intrinsics.checkNotNullExpressionValue((Object)event, (String)"event");
        UsageTracker.log((AndroidStudioEvent.Builder)event);
        if (initializedUsageTracker) {
            UsageTracker.deinitialize();
        }
    }

    private final String computeApplicationId(Collection<? extends Project> projects) {
        for (Project project : projects) {
            if (!project.isAndroidProject() || project.isLibrary()) continue;
            String string = project.getApplicationId();
            if (string == null) continue;
            return string;
        }
        for (Project project : projects) {
            if (!project.isAndroidProject()) continue;
            String string = project.getApplicationId();
            if (string == null) continue;
            return string;
        }
        return null;
    }

    private final LintSession.AnalysisType computeAnalysisType(LintCliFlags flags) {
        return flags.isFatalOnly() ? LintSession.AnalysisType.VITAL : LintSession.AnalysisType.BUILD;
    }

    private final String computeProjectId(Collection<? extends Project> projects) {
        Project project = (Project)CollectionsKt.firstOrNull((Iterable)projects);
        return this.computeProjectId(project != null ? project.getDir() : null);
    }

    private final String computeProjectId(File projectPath) {
        String string;
        if (projectPath == null) {
            return null;
        }
        try {
            string = Anonymizer.anonymizeUtf8((ILogger)((ILogger)new NullLogger()), (String)projectPath.getAbsolutePath());
        }
        catch (IOException e) {
            string = "*ANONYMIZATION_ERROR*";
        }
        return string;
    }

    private final LintPerformance computePerformance(LintDriver driver) {
        LintPerformance.Builder builder;
        LintPerformance.Builder $this$computePerformance_u24lambda_u2d3 = builder = LintPerformance.newBuilder();
        boolean bl = false;
        $this$computePerformance_u24lambda_u2d3.setAnalysisTimeMs(System.currentTimeMillis() - driver.getAnalysisStartTime());
        $this$computePerformance_u24lambda_u2d3.setFileCount((long)driver.getFileCount());
        $this$computePerformance_u24lambda_u2d3.setModuleCount((long)driver.getModuleCount());
        $this$computePerformance_u24lambda_u2d3.setJavaSourceCount((long)driver.getJavaFileCount());
        $this$computePerformance_u24lambda_u2d3.setKotlinSourceCount((long)driver.getKotlinFileCount());
        $this$computePerformance_u24lambda_u2d3.setResourceFileCount((long)driver.getResourceFileCount());
        $this$computePerformance_u24lambda_u2d3.setTestSourceCount((long)driver.getTestSourceCount());
        $this$computePerformance_u24lambda_u2d3.setInitializeTimeMs(driver.getInitializeTimeMs());
        $this$computePerformance_u24lambda_u2d3.setRegisterCustomDetectorsTimeMs(driver.getRegisterCustomDetectorsTimeMs());
        $this$computePerformance_u24lambda_u2d3.setComputeDetectorsTimeMs(driver.getComputeDetectorsTimeMs());
        $this$computePerformance_u24lambda_u2d3.setCheckProjectTimeMs(driver.getCheckProjectTimeMs());
        $this$computePerformance_u24lambda_u2d3.setExtraPhasesTimeMs(driver.getExtraPhasesTimeMs());
        $this$computePerformance_u24lambda_u2d3.setReportBaselineIssuesTimeMs(driver.getReportBaselineIssuesTimeMs());
        $this$computePerformance_u24lambda_u2d3.setDisposeProjectsTimeMs(driver.getDisposeProjectsTimeMs());
        $this$computePerformance_u24lambda_u2d3.setReportGenerationTimeMs(driver.getReportGenerationTimeMs());
        LintPerformance lintPerformance = builder.build();
        Intrinsics.checkNotNullExpressionValue((Object)lintPerformance, (String)"newBuilder().apply {\n   \u2026nTimeMs\n        }.build()");
        return lintPerformance;
    }

    private final void recordSeverityOverride(HashMap<String, LintIssueId.Builder> map, String id, Severity lintSeverity) {
        LintIssueId.Builder builder;
        LintIssueId.Builder builder2 = map.get(id);
        if (builder2 != null) {
            return;
        }
        LintIssueId.Builder $this$recordSeverityOverride_u24lambda_u2d4 = builder = LintIssueId.newBuilder();
        boolean bl = false;
        Map map2 = map;
        Intrinsics.checkNotNullExpressionValue((Object)$this$recordSeverityOverride_u24lambda_u2d4, (String)"this");
        map2.put(id, $this$recordSeverityOverride_u24lambda_u2d4);
        $this$recordSeverityOverride_u24lambda_u2d4.setIssueId(id);
        $this$recordSeverityOverride_u24lambda_u2d4.setCount(0L);
        $this$recordSeverityOverride_u24lambda_u2d4.setSeverity(this.toAnalyticsSeverity(lintSeverity));
    }

    private final LintIssueId.LintSeverity toAnalyticsSeverity(Severity $this$toAnalyticsSeverity) {
        LintIssueId.LintSeverity lintSeverity;
        switch (WhenMappings.$EnumSwitchMapping$0[$this$toAnalyticsSeverity.ordinal()]) {
            case 1: {
                lintSeverity = LintIssueId.LintSeverity.FATAL_SEVERITY;
                break;
            }
            case 2: {
                lintSeverity = LintIssueId.LintSeverity.ERROR_SEVERITY;
                break;
            }
            case 3: {
                lintSeverity = LintIssueId.LintSeverity.WARNING_SEVERITY;
                break;
            }
            case 4: {
                lintSeverity = LintIssueId.LintSeverity.INFORMATIONAL_SEVERITY;
                break;
            }
            case 5: {
                lintSeverity = LintIssueId.LintSeverity.IGNORE_SEVERITY;
                break;
            }
            default: {
                lintSeverity = LintIssueId.LintSeverity.UNKNOWN_SEVERITY;
            }
        }
        return lintSeverity;
    }

    private final Map<String, LintIssueId.Builder> computeIssueData(List<Incident> incidents, LintCliFlags flags, IssueRegistry registry) {
        LinkedHashMap map = new LinkedHashMap(registry.getIssues().size());
        for (Incident incident : incidents) {
            Issue issue = incident.getIssue();
            String id = issue.getId();
            LintIssueId.Builder builder = (LintIssueId.Builder)map.get(id);
            if (builder == null) {
                LintIssueId.Builder builder2;
                LintBatchAnalytics $this$computeIssueData_u24lambda_u2d6 = this;
                boolean bl = false;
                LintIssueId.Builder $this$computeIssueData_u24lambda_u2d6_u24lambda_u2d5 = builder2 = LintIssueId.newBuilder();
                boolean bl2 = false;
                Map map2 = map;
                Intrinsics.checkNotNullExpressionValue((Object)$this$computeIssueData_u24lambda_u2d6_u24lambda_u2d5, (String)"this");
                map2.put(id, $this$computeIssueData_u24lambda_u2d6_u24lambda_u2d5);
                $this$computeIssueData_u24lambda_u2d6_u24lambda_u2d5.setIssueId(issue.getId());
                $this$computeIssueData_u24lambda_u2d6_u24lambda_u2d5.setSeverity(incident.getSeverity() == issue.getDefaultSeverity() ? LintIssueId.LintSeverity.DEFAULT_SEVERITY : $this$computeIssueData_u24lambda_u2d6.toAnalyticsSeverity(incident.getSeverity()));
                builder = builder2;
            }
            LintIssueId.Builder issueBuilder = builder;
            issueBuilder.setCount(issueBuilder.getCount() + 1L);
        }
        for (Map.Entry entry : flags.getSeverityOverrides().entrySet()) {
            String id = (String)entry.getKey();
            LintModelSeverity severity = (LintModelSeverity)entry.getValue();
            HashMap hashMap = map;
            Intrinsics.checkNotNullExpressionValue((Object)id, (String)"id");
            Intrinsics.checkNotNullExpressionValue((Object)severity, (String)"severity");
            this.recordSeverityOverride(hashMap, id, SeverityKt.getSeverity((LintModelSeverity)severity, (Issue)registry.getIssue(id)));
        }
        for (String string : flags.getSuppressedIds()) {
            HashMap hashMap = map;
            Intrinsics.checkNotNullExpressionValue((Object)string, (String)"id");
            this.recordSeverityOverride(hashMap, string, Severity.IGNORE);
        }
        for (String string : flags.getEnabledIds()) {
            HashMap hashMap = map;
            Intrinsics.checkNotNullExpressionValue((Object)string, (String)"id");
            Issue issue = registry.getIssue(string);
            if (issue == null || (issue = issue.getDefaultSeverity()) == null) {
                issue = Severity.WARNING;
            }
            this.recordSeverityOverride(hashMap, string, (Severity)issue);
        }
        return map;
    }

    @Metadata(mv={1, 6, 0}, k=3, xi=48)
    public final class WhenMappings {
        public static final /* synthetic */ int[] $EnumSwitchMapping$0;

        static {
            int[] nArray = new int[Severity.values().length];
            nArray[Severity.FATAL.ordinal()] = 1;
            nArray[Severity.ERROR.ordinal()] = 2;
            nArray[Severity.WARNING.ordinal()] = 3;
            nArray[Severity.INFORMATIONAL.ordinal()] = 4;
            nArray[Severity.IGNORE.ordinal()] = 5;
            $EnumSwitchMapping$0 = nArray;
        }
    }
}

