/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.lint;

import com.android.tools.lint.LintCliClient;
import com.android.tools.lint.LintFixPerformer;
import com.android.tools.lint.Reporter;
import com.android.tools.lint.ReporterKt;
import com.android.tools.lint.XmlFileType;
import com.android.tools.lint.XmlWriter;
import com.android.tools.lint.detector.api.AllOfConstraint;
import com.android.tools.lint.detector.api.AnyOfConstraint;
import com.android.tools.lint.detector.api.ApplicableVariants;
import com.android.tools.lint.detector.api.Constraint;
import com.android.tools.lint.detector.api.Incident;
import com.android.tools.lint.detector.api.IsAndroidProject;
import com.android.tools.lint.detector.api.IsLibraryProject;
import com.android.tools.lint.detector.api.Issue;
import com.android.tools.lint.detector.api.Lint;
import com.android.tools.lint.detector.api.LintFix;
import com.android.tools.lint.detector.api.LintMap;
import com.android.tools.lint.detector.api.Location;
import com.android.tools.lint.detector.api.MinSdkAtLeast;
import com.android.tools.lint.detector.api.MinSdkLessThan;
import com.android.tools.lint.detector.api.NotAndroidProject;
import com.android.tools.lint.detector.api.NotLibraryProject;
import com.android.tools.lint.detector.api.Position;
import com.android.tools.lint.detector.api.Project;
import com.android.tools.lint.detector.api.Severity;
import com.android.tools.lint.detector.api.TargetSdkAtLeast;
import com.android.tools.lint.detector.api.TargetSdkLessThan;
import com.android.tools.lint.detector.api.TextFormat;
import com.android.tools.lint.model.PathVariables;
import com.android.utils.XmlUtils;
import com.google.common.base.Joiner;
import com.intellij.psi.PsiMethod;
import java.io.BufferedWriter;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.Writer;
import java.nio.charset.Charset;
import java.util.Base64;
import java.util.Collection;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Set;
import kotlin.Metadata;
import kotlin.Pair;
import kotlin.TuplesKt;
import kotlin._Assertions;
import kotlin.collections.CollectionsKt;
import kotlin.collections.MapsKt;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.Intrinsics;
import kotlin.text.Charsets;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 6, 0}, k=1, xi=48, d1={"\u0000\u0094\u0001\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\b\n\u0002\b\u0003\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0002\u0010\u000e\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0007\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010$\n\u0002\u0018\u0002\n\u0002\b\u0006\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000b\n\u0000\b\u0016\u0018\u00002\u00020\u0001B\u001f\b\u0016\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u0012\u0006\u0010\u0006\u001a\u00020\u0007\u00a2\u0006\u0002\u0010\bB%\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0006\u001a\u00020\u0007\u0012\u0006\u0010\t\u001a\u00020\n\u0012\u0006\u0010\u000b\u001a\u00020\f\u00a2\u0006\u0002\u0010\rJ\u0006\u0010\u000e\u001a\u00020\u000fJ\u0018\u0010\u0010\u001a\u00020\u000f2\u0006\u0010\u0011\u001a\u00020\u00122\u0006\u0010\u0013\u001a\u00020\u0014H\u0002J\"\u0010\u0015\u001a\u00020\u000f2\u0006\u0010\u0011\u001a\u00020\u00122\u0006\u0010\u0013\u001a\u00020\u00142\b\b\u0002\u0010\u0016\u001a\u00020\u0017H\u0002J\u0018\u0010\u0018\u001a\u00020\u000f2\u0006\u0010\u0011\u001a\u00020\u00122\u0006\u0010\u0013\u001a\u00020\u0014H\u0002J\u0018\u0010\u0019\u001a\u00020\u000f2\u0006\u0010\u0013\u001a\u00020\u00142\u0006\u0010\u0016\u001a\u00020\u0017H\u0002J\u001c\u0010\u001a\u001a\u0016\u0012\u0012\u0012\u0010\u0012\u0004\u0012\u00020\u001d\u0012\u0006\u0012\u0004\u0018\u00010\u001d0\u001c0\u001bH\u0002J\u001a\u0010\u001e\u001a\u00020\u001d2\u0006\u0010\u001f\u001a\u00020\u00052\b\u0010 \u001a\u0004\u0018\u00010!H\u0002J\u0010\u0010\u0016\u001a\u00020\u000f2\u0006\u0010\u0016\u001a\u00020\u0017H\u0002J(\u0010\"\u001a\u00020\u000f2\u0006\u0010\t\u001a\u00020\n2\u0006\u0010\u0016\u001a\u00020\u00172\u0006\u0010#\u001a\u00020\u001d2\u0006\u0010$\u001a\u00020\u001dH\u0002J\u001a\u0010%\u001a\u00020\u000f2\u0006\u0010&\u001a\u00020\u001d2\b\b\u0002\u0010\u0016\u001a\u00020\u0017H\u0002J&\u0010'\u001a\u00020\u000f2\u0006\u0010(\u001a\u00020)2\b\b\u0002\u0010\u0016\u001a\u00020\u00172\n\b\u0002\u0010*\u001a\u0004\u0018\u00010\u001dH\u0002J\u001a\u0010+\u001a\u00020\u000f2\u0012\u0010,\u001a\u000e\u0012\u0004\u0012\u00020\u001d\u0012\u0004\u0012\u00020.0-J\u001a\u0010/\u001a\u00020\u000f2\u0006\u0010\u0011\u001a\u00020\u00122\b\b\u0002\u0010\u0016\u001a\u00020\u0017H\u0002J2\u00100\u001a\u00020\u000f2\f\u00101\u001a\b\u0012\u0004\u0012\u00020\u00120\u001b2\u001c\b\u0002\u00102\u001a\u0016\u0012\u0012\u0012\u0010\u0012\u0004\u0012\u00020\u001d\u0012\u0006\u0012\u0004\u0018\u00010\u001d0\u001c0\u001bJ&\u00103\u001a\u00020\u000f2\u0006\u00104\u001a\u0002052\b\b\u0002\u0010\u0016\u001a\u00020\u00172\n\b\u0002\u0010#\u001a\u0004\u0018\u00010\u001dH\u0002J:\u00106\u001a\u00020\u000f2\b\u0010 \u001a\u0004\u0018\u00010!2\u0006\u00107\u001a\u0002082\b\b\u0002\u0010&\u001a\u00020\u001d2\b\b\u0002\u0010\u0016\u001a\u00020\u00172\n\b\u0002\u0010*\u001a\u0004\u0018\u00010\u001dH\u0002J0\u00109\u001a\u00020\u000f2\u0006\u0010&\u001a\u00020\u001d2\u0014\u0010:\u001a\u0010\u0012\u0004\u0012\u00020\u001d\u0012\u0006\u0012\u0004\u0018\u00010\u001d0-2\b\b\u0002\u0010\u0016\u001a\u00020\u0017H\u0002J\u001a\u0010;\u001a\u00020\u000f2\u0012\u0010<\u001a\u000e\u0012\u0004\u0012\u00020=\u0012\u0004\u0012\u0002050-J\b\u0010>\u001a\u00020\u000fH\u0002J\f\u0010?\u001a\u00020@*\u00020\u001dH\u0002R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u000b\u001a\u00020\fX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0006\u001a\u00020\u0007X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\t\u001a\u00020\nX\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006A"}, d2={"Lcom/android/tools/lint/XmlWriter;", "", "client", "Lcom/android/tools/lint/LintCliClient;", "output", "Ljava/io/File;", "type", "Lcom/android/tools/lint/XmlFileType;", "(Lcom/android/tools/lint/LintCliClient;Ljava/io/File;Lcom/android/tools/lint/XmlFileType;)V", "writer", "Ljava/io/Writer;", "pathVariables", "Lcom/android/tools/lint/model/PathVariables;", "(Lcom/android/tools/lint/LintCliClient;Lcom/android/tools/lint/XmlFileType;Ljava/io/Writer;Lcom/android/tools/lint/model/PathVariables;)V", "close", "", "emitEdit", "incident", "Lcom/android/tools/lint/detector/api/Incident;", "lintFix", "Lcom/android/tools/lint/detector/api/LintFix;", "emitFixDescriptors", "indent", "", "emitFixEdits", "emitFixSharedAttributes", "getDefaultRootAttributes", "", "Lkotlin/Pair;", "", "getPath", "file", "project", "Lcom/android/tools/lint/detector/api/Project;", "writeAttribute", "name", "value", "writeCloseTag", "tag", "writeCondition", "constraint", "Lcom/android/tools/lint/detector/api/Constraint;", "key", "writeConfiguredIssues", "severityMap", "", "Lcom/android/tools/lint/detector/api/Severity;", "writeIncident", "writeIncidents", "incidents", "extraAttributes", "writeLintMap", "map", "Lcom/android/tools/lint/detector/api/LintMap;", "writeLocation", "location", "Lcom/android/tools/lint/detector/api/Location;", "writeOpenTag", "attributes", "writePartialResults", "resultMap", "Lcom/android/tools/lint/detector/api/Issue;", "writeProlog", "isParentDirectoryPath", "", "lint-cli"})
public class XmlWriter {
    @NotNull
    private final LintCliClient client;
    @NotNull
    private XmlFileType type;
    @NotNull
    private final Writer writer;
    @NotNull
    private final PathVariables pathVariables;

    public XmlWriter(@NotNull LintCliClient client, @NotNull XmlFileType type, @NotNull Writer writer, @NotNull PathVariables pathVariables) {
        Intrinsics.checkNotNullParameter((Object)((Object)client), (String)"client");
        Intrinsics.checkNotNullParameter((Object)((Object)type), (String)"type");
        Intrinsics.checkNotNullParameter((Object)writer, (String)"writer");
        Intrinsics.checkNotNullParameter((Object)pathVariables, (String)"pathVariables");
        this.client = client;
        this.type = type;
        this.writer = writer;
        this.pathVariables = pathVariables;
    }

    public XmlWriter(@NotNull LintCliClient client, @NotNull File output, @NotNull XmlFileType type) {
        Intrinsics.checkNotNullParameter((Object)((Object)client), (String)"client");
        Intrinsics.checkNotNullParameter((Object)output, (String)"output");
        Intrinsics.checkNotNullParameter((Object)((Object)type), (String)"type");
        File file = output;
        Charset charset = Charsets.UTF_8;
        int n = 8192;
        Object object = file;
        object = new OutputStreamWriter((OutputStream)new FileOutputStream((File)object), charset);
        this(client, type, object instanceof BufferedWriter ? (BufferedWriter)object : new BufferedWriter((Writer)object, n), client.getPathVariables());
    }

    public final void close() {
        this.writer.close();
    }

    private final void writeProlog() {
        this.writer.write("<?xml version=\"1.0\" encoding=\"UTF-8\"?>\n");
    }

    /*
     * WARNING - void declaration
     */
    private final List<Pair<String, String>> getDefaultRootAttributes() {
        String string;
        Pair pair;
        Object[] objectArray = new Pair[3];
        objectArray[0] = TuplesKt.to((Object)"format", (Object)"6");
        Object[] objectArray2 = objectArray;
        int n = 1;
        String string2 = this.client.getClientDisplayRevision();
        if (string2 != null) {
            void it;
            String string3 = string2;
            int n2 = n;
            Object[] objectArray3 = objectArray2;
            boolean bl = false;
            Pair pair2 = TuplesKt.to((Object)"by", (Object)("lint " + (String)it));
            objectArray2 = objectArray3;
            n = n2;
            pair = pair2;
        } else {
            pair = objectArray2[n] = null;
        }
        if (this.type != XmlFileType.REPORT) {
            String string4 = this.type.name();
            Locale locale = Locale.ROOT;
            Intrinsics.checkNotNullExpressionValue((Object)locale, (String)"ROOT");
            String string5 = string4.toLowerCase(locale);
            string = string5;
            Intrinsics.checkNotNullExpressionValue((Object)string5, (String)"this as java.lang.String).toLowerCase(locale)");
        } else {
            string = null;
        }
        objectArray[2] = TuplesKt.to((Object)"type", string);
        return CollectionsKt.listOfNotNull((Object[])objectArray);
    }

    private final void writeOpenTag(String tag, Map<String, String> attributes, int indent) {
        this.indent(indent);
        this.writer.write("<" + tag);
        if (!attributes.isEmpty()) {
            for (Map.Entry<String, String> entry : attributes.entrySet()) {
                String key = entry.getKey();
                String value = entry.getValue();
                if (value == null) continue;
                this.writer.write(" ");
                this.writer.write(key);
                this.writer.write("=\"");
                this.writer.write(XmlUtils.toXmlAttributeValue((String)value));
                this.writer.write("\"");
            }
        }
        this.writer.write(">\n");
    }

    static /* synthetic */ void writeOpenTag$default(XmlWriter xmlWriter, String string, Map map, int n, int n2, Object object) {
        if (object != null) {
            throw new UnsupportedOperationException("Super calls with default arguments not supported in this target, function: writeOpenTag");
        }
        if ((n2 & 4) != 0) {
            n = 0;
        }
        xmlWriter.writeOpenTag(string, map, n);
    }

    private final void writeCloseTag(String tag, int indent) {
        if (indent == 0) {
            this.writer.write("\n");
        } else {
            this.indent(indent);
        }
        this.writer.write("</" + tag + ">\n");
    }

    static /* synthetic */ void writeCloseTag$default(XmlWriter xmlWriter, String string, int n, int n2, Object object) {
        if (object != null) {
            throw new UnsupportedOperationException("Super calls with default arguments not supported in this target, function: writeCloseTag");
        }
        if ((n2 & 2) != 0) {
            n = 0;
        }
        xmlWriter.writeCloseTag(string, n);
    }

    private final void writeCondition(Constraint constraint, int indent, String key) {
        this.indent(indent);
        this.writer.write("<condition");
        String string = key;
        if (string != null) {
            String it = string;
            boolean bl = false;
            this.writeAttribute(this.writer, -1, "id", it);
        }
        int ind = indent + 1;
        Constraint constraint2 = constraint;
        if (constraint2 instanceof MinSdkAtLeast) {
            this.writeAttribute(this.writer, -1, "minGE", String.valueOf(((MinSdkAtLeast)constraint).getMinSdkVersion()));
        } else if (constraint2 instanceof TargetSdkAtLeast) {
            this.writeAttribute(this.writer, -1, "targetGE", String.valueOf(((TargetSdkAtLeast)constraint).getTargetSdkVersion()));
        } else if (constraint2 instanceof MinSdkLessThan) {
            this.writeAttribute(this.writer, -1, "minLT", String.valueOf(((MinSdkLessThan)constraint).getMinSdkVersion()));
        } else if (constraint2 instanceof TargetSdkLessThan) {
            this.writeAttribute(this.writer, -1, "targetLT", String.valueOf(((TargetSdkLessThan)constraint).getTargetSdkVersion()));
        } else if (constraint2 instanceof IsLibraryProject) {
            this.writeAttribute(this.writer, -1, "library", "true");
        } else if (constraint2 instanceof NotLibraryProject) {
            this.writeAttribute(this.writer, -1, "library", "false");
        } else if (constraint2 instanceof IsAndroidProject) {
            this.writeAttribute(this.writer, -1, "android", "true");
        } else if (constraint2 instanceof NotAndroidProject) {
            this.writeAttribute(this.writer, -1, "android", "false");
        } else {
            if (constraint instanceof AllOfConstraint) {
                this.writeAttribute(this.writer, ind, "allOf", "true");
                this.writer.write(">");
                XmlWriter.writeCondition$default(this, ((AllOfConstraint)constraint).getLeft(), ind, null, 4, null);
                XmlWriter.writeCondition$default(this, ((AllOfConstraint)constraint).getRight(), ind, null, 4, null);
                this.writer.write("\n");
                this.indent(indent);
                this.writer.write("</condition>");
                return;
            }
            if (constraint instanceof AnyOfConstraint) {
                this.writeAttribute(this.writer, ind, "anyOf", "true");
                this.writer.write(">");
                XmlWriter.writeCondition$default(this, ((AnyOfConstraint)constraint).getLeft(), ind, null, 4, null);
                XmlWriter.writeCondition$default(this, ((AnyOfConstraint)constraint).getRight(), ind, null, 4, null);
                this.writer.write("\n");
                this.indent(indent);
                this.writer.write("</condition>");
                return;
            }
            throw new IllegalStateException(("Unexpected condition " + constraint + ": needs serialization").toString());
        }
        this.writer.write("/>\n");
    }

    static /* synthetic */ void writeCondition$default(XmlWriter xmlWriter, Constraint constraint, int n, String string, int n2, Object object) {
        if (object != null) {
            throw new UnsupportedOperationException("Super calls with default arguments not supported in this target, function: writeCondition");
        }
        if ((n2 & 2) != 0) {
            n = 1;
        }
        if ((n2 & 4) != 0) {
            string = null;
        }
        xmlWriter.writeCondition(constraint, n, string);
    }

    private final void writeIncident(Incident incident, int indent) {
        Location location;
        ApplicableVariants applicableVariants;
        int index2;
        int index1;
        String line2;
        this.writer.write("\n");
        this.indent(indent);
        String tag = this.type.isPersistenceFile() ? "incident" : "issue";
        this.writer.write("<" + tag);
        Issue issue = incident.getIssue();
        this.writeAttribute(this.writer, indent + 1, "id", issue.getId());
        if (this.type != XmlFileType.BASELINE) {
            this.writeAttribute(this.writer, indent + 1, "severity", this.type.isPersistenceFile() ? incident.getSeverity().toName() : incident.getSeverity().getDescription());
        }
        this.writeAttribute(this.writer, indent + 1, "message", incident.getMessage());
        if (this.type.includeIssueMetadata()) {
            this.writeAttribute(this.writer, indent + 1, "category", issue.getCategory().getFullName());
            this.writeAttribute(this.writer, indent + 1, "priority", String.valueOf(issue.getPriority()));
            this.writeAttribute(this.writer, indent + 1, "summary", issue.getBriefDescription(TextFormat.RAW));
            this.writeAttribute(this.writer, indent + 1, "explanation", issue.getExplanation(TextFormat.RAW));
            List moreInfo = issue.getMoreInfo();
            if (!((Collection)moreInfo).isEmpty()) {
                this.writeAttribute(this.writer, indent + 1, "url", (String)moreInfo.get(0));
                String string = Joiner.on((char)',').join((Iterable)issue.getMoreInfo());
                Intrinsics.checkNotNullExpressionValue((Object)string, (String)"on(',').join(issue.moreInfo)");
                this.writeAttribute(this.writer, indent + 1, "urls", string);
            }
        }
        if (this.client.getFlags().isShowSourceLines() && this.type.includeSourceLines() && (line2 = ReporterKt.getErrorLines(incident, (Function1<? super File, ? extends CharSequence>)((Function1)new Function1<File, CharSequence>(this){
            final /* synthetic */ XmlWriter this$0;
            {
                this.this$0 = $receiver;
                super(1);
            }

            @Nullable
            public final CharSequence invoke(@NotNull File it) {
                Intrinsics.checkNotNullParameter((Object)it, (String)"it");
                return XmlWriter.access$getClient$p(this.this$0).getSourceText(it);
            }
        }))) != null && ((CharSequence)line2).length() > 0 && (index1 = StringsKt.indexOf$default((CharSequence)line2, (char)'\n', (int)0, (boolean)false, (int)6, null)) != -1 && (index2 = StringsKt.indexOf$default((CharSequence)line2, (char)'\n', (int)(index1 + 1), (boolean)false, (int)4, null)) != -1) {
            String string = line2.substring(0, index1);
            Intrinsics.checkNotNullExpressionValue((Object)string, (String)"this as java.lang.String\u2026ing(startIndex, endIndex)");
            String line1 = string;
            String string2 = line2.substring(index1 + 1, index2);
            Intrinsics.checkNotNullExpressionValue((Object)string2, (String)"this as java.lang.String\u2026ing(startIndex, endIndex)");
            String line22 = string2;
            this.writeAttribute(this.writer, indent + 1, "errorLine1", line1);
            this.writeAttribute(this.writer, indent + 1, "errorLine2", line22);
        }
        if ((applicableVariants = incident.getApplicableVariants()) != null && applicableVariants.getVariantSpecific()) {
            String string = Joiner.on((char)',').join((Iterable)applicableVariants.getIncludedVariantNames());
            Intrinsics.checkNotNullExpressionValue((Object)string, (String)"on(',').join(applicableV\u2026nts.includedVariantNames)");
            this.writeAttribute(this.writer, indent + 1, "includedVariants", string);
            String string3 = Joiner.on((char)',').join((Iterable)applicableVariants.getExcludedVariantNames());
            Intrinsics.checkNotNullExpressionValue((Object)string3, (String)"on(',').join(applicableV\u2026nts.excludedVariantNames)");
            this.writeAttribute(this.writer, indent + 1, "excludedVariants", string3);
        }
        if (this.type == XmlFileType.REPORT_WITH_FIXES && (incident.getFix() != null || Reporter.Companion.hasAutoFix(issue))) {
            this.writeAttribute(this.writer, indent + 1, "quickfix", "studio");
        }
        boolean hasChildren = false;
        LintFix fixData = incident.getFix();
        if (fixData != null) {
            if (this.type == XmlFileType.REPORT_WITH_FIXES) {
                this.writer.write(">\n");
                this.emitFixEdits(incident, fixData);
                hasChildren = true;
            }
            if (this.type.isPersistenceFile() && !hasChildren) {
                this.writer.write(">\n");
                hasChildren = true;
                XmlWriter.emitFixDescriptors$default(this, incident, fixData, 0, 4, null);
            }
        }
        if ((location = incident.getLocation()) != null) {
            if (!hasChildren) {
                this.writer.write(">\n");
            }
            while (location != null) {
                XmlWriter.writeLocation$default(this, incident.getProject(), location, null, 0, null, 28, null);
                location = location.getSecondary();
            }
            hasChildren = true;
        }
        if (this.type.isPersistenceFile()) {
            LintMap lintMap = incident.getClientProperties();
            if (lintMap != null) {
                LintMap map = lintMap;
                boolean bl = false;
                if (!hasChildren) {
                    this.writer.write(">\n");
                    hasChildren = true;
                }
                XmlWriter.writeLintMap$default(this, map, 0, null, 6, null);
            }
        }
        if (hasChildren) {
            this.indent(1);
            this.writer.write("</" + tag + ">\n");
        } else {
            this.writer.write("\n");
            this.indent(1);
            this.writer.write("/>\n");
        }
    }

    static /* synthetic */ void writeIncident$default(XmlWriter xmlWriter, Incident incident, int n, int n2, Object object) {
        if (object != null) {
            throw new UnsupportedOperationException("Super calls with default arguments not supported in this target, function: writeIncident");
        }
        if ((n2 & 2) != 0) {
            n = 1;
        }
        xmlWriter.writeIncident(incident, n);
    }

    private final void writeLintMap(LintMap map, int indent, String name) {
        Set entries = LintMap.Companion.getInternalMap(map).entrySet();
        if (entries.isEmpty()) {
            return;
        }
        this.indent(indent);
        this.writer.write("<");
        this.writer.write("map");
        if (name != null) {
            this.writer.write(" ");
            this.writer.write("id");
            this.writer.write("=\"");
            this.writer.write(XmlUtils.toXmlAttributeValue((String)name));
            this.writer.write("\"");
        }
        this.writer.write(">\n");
        for (Map.Entry entry : entries) {
            String string;
            String key = (String)entry.getKey();
            Object value = entry.getValue();
            Object v = value;
            if (v instanceof String) {
                string = "string";
            } else if (v instanceof Integer) {
                string = "int";
            } else if (v instanceof Boolean) {
                string = "boolean";
            } else if (v instanceof Severity) {
                string = "severity";
            } else {
                if (v instanceof Location) {
                    this.writeLocation(null, (Location)value, "location", indent + 1, key);
                    continue;
                }
                if (v instanceof LintMap) {
                    this.writeLintMap((LintMap)value, indent + 2, key);
                    continue;
                }
                if (v instanceof Incident) {
                    this.writeIncident((Incident)value, indent + 2);
                    continue;
                }
                if (v instanceof Constraint) {
                    String id = !Intrinsics.areEqual((Object)key, (Object)"_condition_") ? key : null;
                    this.writeCondition((Constraint)value, indent + 1, id);
                    continue;
                }
                throw new IllegalStateException(("Unexpected map value type " + value.getClass()).toString());
            }
            String valueName = string;
            this.indent(indent + 1);
            this.writer.write("<");
            this.writer.write("entry");
            this.writeAttribute(this.writer, indent + 2, "name", key);
            String valueString2 = value.toString();
            this.writeAttribute(this.writer, indent + 2, valueName, valueString2);
            this.writer.write("/>\n");
        }
        this.indent(indent);
        this.writer.write("</map>\n");
    }

    static /* synthetic */ void writeLintMap$default(XmlWriter xmlWriter, LintMap lintMap, int n, String string, int n2, Object object) {
        if (object != null) {
            throw new UnsupportedOperationException("Super calls with default arguments not supported in this target, function: writeLintMap");
        }
        if ((n2 & 2) != 0) {
            n = 2;
        }
        if ((n2 & 4) != 0) {
            string = null;
        }
        xmlWriter.writeLintMap(lintMap, n, string);
    }

    private final void writeLocation(Project project, Location location, String tag, int indent, String key) {
        this.indent(indent);
        int indented = indent + 1;
        this.writer.write("<");
        this.writer.write(tag);
        if (key != null) {
            this.writer.write(" ");
            this.writer.write("id");
            this.writer.write("=\"");
            this.writer.write(XmlUtils.toXmlAttributeValue((String)key));
            this.writer.write("\"");
        }
        String neutralPath = this.getPath(location.getFile(), project);
        this.writeAttribute(this.writer, indent + 1, "file", neutralPath);
        Position start = location.getStart();
        if (start != null) {
            int line2 = start.getLine();
            int column = start.getColumn();
            if (line2 >= 0) {
                this.writeAttribute(this.writer, indented, "line", String.valueOf(line2 + 1));
                if (column >= 0) {
                    this.writeAttribute(this.writer, indented, "column", String.valueOf(column + 1));
                }
            }
            if (this.type.includeOffsets()) {
                this.writeAttribute(this.writer, indented, "startOffset", String.valueOf(start.getOffset()));
                Position end = location.getEnd();
                if (end != null) {
                    if (line2 != -1) {
                        int endLine = end.getLine() + 1;
                        int endColumn = end.getColumn() + 1;
                        this.writeAttribute(this.writer, indented, "endLine", String.valueOf(endLine));
                        this.writeAttribute(this.writer, indented, "endColumn", String.valueOf(endColumn));
                    }
                    this.writeAttribute(this.writer, indented, "endOffset", String.valueOf(end.getOffset()));
                }
            }
        }
        String string = location.getMessage();
        if (string != null) {
            String it = string;
            boolean bl = false;
            this.writeAttribute(this.writer, indented, "message", it);
        }
        this.writer.write("/>\n");
    }

    static /* synthetic */ void writeLocation$default(XmlWriter xmlWriter, Project project, Location location, String string, int n, String string2, int n2, Object object) {
        if (object != null) {
            throw new UnsupportedOperationException("Super calls with default arguments not supported in this target, function: writeLocation");
        }
        if ((n2 & 4) != 0) {
            string = "location";
        }
        if ((n2 & 8) != 0) {
            n = 2;
        }
        if ((n2 & 0x10) != 0) {
            string2 = null;
        }
        xmlWriter.writeLocation(project, location, string, n, string2);
    }

    private final void emitFixEdits(Incident incident, LintFix lintFix) {
        List fixes = lintFix instanceof LintFix.LintFixGroup && ((LintFix.LintFixGroup)lintFix).getType() == LintFix.GroupType.ALTERNATIVES ? ((LintFix.LintFixGroup)lintFix).getFixes() : CollectionsKt.listOf((Object)lintFix);
        for (LintFix fix : fixes) {
            this.emitEdit(incident, fix);
        }
    }

    private final String getPath(File file, Project project) {
        String path = null;
        if (this.type.relativePaths() && this.type.variables() && this.pathVariables.any()) {
            if (this.type == XmlFileType.BASELINE && this.isParentDirectoryPath(path = this.client.getDisplayPath(project, file, false)) && !this.client.getFlags().isCheckDependencies()) {
                path = null;
            }
            if (path == null) {
                String relativePath;
                if (Lint.assertionsEnabled()) {
                    boolean bl = file.isAbsolute();
                    if (_Assertions.ENABLED && !bl) {
                        boolean bl2 = false;
                        String string = file.getPath();
                        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"file.path");
                        String string2 = string;
                        throw new AssertionError((Object)string2);
                    }
                }
                if ((path = PathVariables.toPathStringIfMatched$default((PathVariables)this.pathVariables, (File)file, null, (boolean)this.type.unixPaths(), (int)2, null)) != null && PathVariables.Companion.startsWithVariable(path, "HOME") && !this.isParentDirectoryPath(relativePath = this.client.getDisplayPath(project, file, false))) {
                    path = relativePath;
                }
            }
        }
        if (path == null) {
            boolean absolute = !this.type.relativePaths() && this.client.getFlags().isFullPath();
            path = this.client.getDisplayPath(project, file, absolute);
        }
        return this.type.unixPaths() ? StringsKt.replace$default(path, (char)'\\', (char)'/', (boolean)false, (int)4, null) : path;
    }

    private final boolean isParentDirectoryPath(String $this$isParentDirectoryPath) {
        return StringsKt.startsWith$default((String)$this$isParentDirectoryPath, (String)"..", (boolean)false, (int)2, null);
    }

    private final void emitEdit(Incident incident, LintFix lintFix) {
        this.indent(2);
        this.writer.write("<");
        this.writer.write("fix");
        String string = lintFix.getDisplayName();
        if (string != null) {
            String it = string;
            boolean bl = false;
            this.writeAttribute(this.writer, 3, "description", it);
        }
        this.writeAttribute(this.writer, 3, "auto", String.valueOf(LintFixPerformer.Companion.canAutoFix(lintFix)));
        boolean haveChildren = false;
        LintFixPerformer performer = new LintFixPerformer(this.client, false, false, false, 12, null);
        List<LintFixPerformer.PendingEditFile> files = performer.computeEdits(incident, lintFix);
        if (!((Collection)files).isEmpty()) {
            haveChildren = true;
            this.writer.write(">\n");
            for (LintFixPerformer.PendingEditFile file : files) {
                for (LintFixPerformer.PendingEdit edit : file.getEdits()) {
                    String before;
                    String after;
                    this.indent(3);
                    this.writer.write("<edit");
                    String neutralPath = this.getPath(file.getFile(), incident.getProject());
                    this.writeAttribute(this.writer, 4, "file", neutralPath);
                    LintFixPerformer.PendingEdit $this$emitEdit_u24lambda_u2d6 = edit;
                    boolean bl = false;
                    Intrinsics.checkNotNullExpressionValue((Object)$this$emitEdit_u24lambda_u2d6.getSource().substring(Math.max($this$emitEdit_u24lambda_u2d6.getStartOffset() - 12, 0), $this$emitEdit_u24lambda_u2d6.getStartOffset()), (String)"this as java.lang.String\u2026ing(startIndex, endIndex)");
                    Intrinsics.checkNotNullExpressionValue((Object)$this$emitEdit_u24lambda_u2d6.getSource().substring($this$emitEdit_u24lambda_u2d6.getStartOffset(), Math.min(Math.max($this$emitEdit_u24lambda_u2d6.getStartOffset() + 12, $this$emitEdit_u24lambda_u2d6.getEndOffset()), $this$emitEdit_u24lambda_u2d6.getSource().length())), (String)"this as java.lang.String\u2026ing(startIndex, endIndex)");
                    this.writeAttribute(this.writer, 4, "offset", String.valueOf($this$emitEdit_u24lambda_u2d6.getStartOffset()));
                    this.writeAttribute(this.writer, 4, "after", after);
                    this.writeAttribute(this.writer, 4, "before", before);
                    if ($this$emitEdit_u24lambda_u2d6.getEndOffset() > $this$emitEdit_u24lambda_u2d6.getStartOffset()) {
                        String string2 = $this$emitEdit_u24lambda_u2d6.getSource().substring($this$emitEdit_u24lambda_u2d6.getStartOffset(), $this$emitEdit_u24lambda_u2d6.getEndOffset());
                        Intrinsics.checkNotNullExpressionValue((Object)string2, (String)"this as java.lang.String\u2026ing(startIndex, endIndex)");
                        this.writeAttribute(this.writer, 4, "delete", string2);
                    }
                    if (((CharSequence)$this$emitEdit_u24lambda_u2d6.getReplacement()).length() > 0) {
                        this.writeAttribute(this.writer, 4, "insert", $this$emitEdit_u24lambda_u2d6.getReplacement());
                    }
                    this.writer.write("/>\n");
                }
            }
        }
        if (haveChildren) {
            this.indent(2);
            this.writer.write("</fix>\n");
        } else {
            this.writer.write("/>\n");
        }
    }

    private final void emitFixDescriptors(Incident incident, LintFix lintFix, int indent) {
        int indented = indent + 1;
        LintFix lintFix2 = lintFix;
        if (lintFix2 instanceof LintFix.ReplaceString) {
            Location range;
            String it;
            this.indent(indent);
            this.writer.write("<fix-replace");
            this.emitFixSharedAttributes(lintFix, indented);
            String string = ((LintFix.ReplaceString)lintFix).getOldString();
            if (string != null) {
                it = string;
                boolean bl = false;
                this.writeAttribute(this.writer, indented, "oldString", it);
            }
            String string2 = ((LintFix.ReplaceString)lintFix).getOldPattern();
            if (string2 != null) {
                it = string2;
                boolean bl = false;
                this.writeAttribute(this.writer, indented, "oldPattern", it);
            }
            String string3 = ((LintFix.ReplaceString)lintFix).getSelectPattern();
            if (string3 != null) {
                it = string3;
                boolean bl = false;
                this.writeAttribute(this.writer, indented, "selectPattern", it);
            }
            this.writeAttribute(this.writer, indented, "replacement", ((LintFix.ReplaceString)lintFix).getReplacement());
            if (((LintFix.ReplaceString)lintFix).getShortenNames()) {
                this.writeAttribute(this.writer, indented, "shortenNames", "true");
            }
            if (((LintFix.ReplaceString)lintFix).getReformat()) {
                this.writeAttribute(this.writer, indented, "reformat", "value");
            }
            if (!((Collection)((LintFix.ReplaceString)lintFix).getImports()).isEmpty()) {
                this.writeAttribute(this.writer, indented, "imports", CollectionsKt.joinToString$default((Iterable)((LintFix.ReplaceString)lintFix).getImports(), (CharSequence)",", null, null, (int)0, null, null, (int)62, null));
            }
            if ((range = lintFix.getRange()) != null) {
                this.writer.write(">\n");
                XmlWriter.writeLocation$default(this, incident.getProject(), range, "range", indented, null, 16, null);
                this.indent(indent);
                this.writer.write("</");
                this.writer.write("fix-replace");
                this.writer.write(">\n");
            } else {
                this.writer.write("/>\n");
            }
        } else if (lintFix2 instanceof LintFix.SetAttribute) {
            Location range;
            String it;
            this.indent(indent);
            this.writer.write("<");
            this.writer.write("fix-attribute");
            this.emitFixSharedAttributes(lintFix, indented);
            String string = ((LintFix.SetAttribute)lintFix).getNamespace();
            if (string != null) {
                it = string;
                boolean bl = false;
                this.writeAttribute(this.writer, indented, "namespace", it);
            }
            this.writeAttribute(this.writer, indented, "attribute", ((LintFix.SetAttribute)lintFix).getAttribute());
            String string4 = ((LintFix.SetAttribute)lintFix).getValue();
            if (string4 != null) {
                it = string4;
                boolean bl = false;
                this.writeAttribute(this.writer, indented, "value", it);
            }
            if (((LintFix.SetAttribute)lintFix).getDot() != Integer.MIN_VALUE) {
                this.writeAttribute(this.writer, indented, "dot", String.valueOf(((LintFix.SetAttribute)lintFix).getDot()));
            }
            if (((LintFix.SetAttribute)lintFix).getMark() != Integer.MIN_VALUE) {
                this.writeAttribute(this.writer, indented, "mark", String.valueOf(((LintFix.SetAttribute)lintFix).getMark()));
            }
            if ((range = lintFix.getRange()) != null) {
                this.writer.write(">\n");
                XmlWriter.writeLocation$default(this, incident.getProject(), range, "range", indented, null, 16, null);
                this.indent(indent);
                this.writer.write("</");
                this.writer.write("fix-attribute");
                this.writer.write(">\n");
            } else {
                this.writer.write("/>\n");
            }
        } else if (lintFix2 instanceof LintFix.LintFixGroup) {
            String string;
            this.indent(indent);
            switch (WhenMappings.$EnumSwitchMapping$0[((LintFix.LintFixGroup)lintFix).getType().ordinal()]) {
                case 1: {
                    string = "fix-alternatives";
                    break;
                }
                case 2: {
                    string = "fix-composite";
                    break;
                }
                default: {
                    throw new IllegalStateException(("Unexpected fix type " + ((LintFix.LintFixGroup)lintFix).getType()).toString());
                }
            }
            String tag = string;
            this.writer.write("<");
            this.writer.write(tag);
            this.emitFixSharedAttributes(lintFix, indented);
            this.writer.write(">\n");
            for (LintFix fix : ((LintFix.LintFixGroup)lintFix).getFixes()) {
                this.emitFixDescriptors(incident, fix, indented);
            }
            this.indent(indent);
            this.writer.write("</");
            this.writer.write(tag);
            this.writer.write(">\n");
        } else if (lintFix2 instanceof LintFix.ShowUrl) {
            this.indent(indent);
            this.writer.write("<");
            this.writer.write("show-url");
            this.emitFixSharedAttributes(lintFix, indented);
            this.writeAttribute(this.writer, indented, "url", ((LintFix.ShowUrl)lintFix).getUrl());
            this.writer.write("/>\n");
        } else if (lintFix2 instanceof LintFix.AnnotateFix) {
            Location range;
            this.indent(indent);
            this.writer.write("<");
            this.writer.write("annotate");
            this.emitFixSharedAttributes(lintFix, indented);
            this.writeAttribute(this.writer, indented, "source", ((LintFix.AnnotateFix)lintFix).getAnnotation());
            if (((LintFix.AnnotateFix)lintFix).getReplace()) {
                this.writeAttribute(this.writer, indented, "replace", String.valueOf(((LintFix.AnnotateFix)lintFix).getReplace()));
            }
            if ((range = lintFix.getRange()) != null) {
                this.writer.write(">\n");
                XmlWriter.writeLocation$default(this, incident.getProject(), range, "range", indented, null, 16, null);
                this.indent(indent);
                this.writer.write("</");
                this.writer.write("annotate");
                this.writer.write(">\n");
            } else {
                this.writer.write("/>\n");
            }
        } else if (lintFix2 instanceof LintFix.CreateFileFix) {
            Object it;
            this.indent(indent);
            this.writer.write("<");
            this.writer.write("create-file");
            this.emitFixSharedAttributes(lintFix, indented);
            String neutralPath = this.getPath(((LintFix.CreateFileFix)lintFix).getFile(), incident.getProject());
            this.writeAttribute(this.writer, indent + 1, "file", neutralPath);
            if (((LintFix.CreateFileFix)lintFix).getDelete()) {
                this.writeAttribute(this.writer, indented, "delete", "true");
            }
            String string = ((LintFix.CreateFileFix)lintFix).getSelectPattern();
            if (string != null) {
                it = string;
                boolean bl = false;
                this.writeAttribute(this.writer, indented, "selectPattern", (String)it);
            }
            String string5 = ((LintFix.CreateFileFix)lintFix).getText();
            if (string5 != null) {
                it = string5;
                boolean bl = false;
                this.writeAttribute(this.writer, indented, "replacement", (String)it);
            }
            byte[] byArray = ((LintFix.CreateFileFix)lintFix).getBinary();
            if (byArray != null) {
                it = byArray;
                boolean bl = false;
                String string6 = Base64.getEncoder().encodeToString((byte[])it);
                Intrinsics.checkNotNullExpressionValue((Object)string6, (String)"getEncoder().encodeToString(it)");
                this.writeAttribute(this.writer, indented, "binary", string6);
            }
            this.writer.write("/>\n");
        } else if (lintFix2 instanceof LintFix.DataMap) {
            this.indent(indent);
            this.writer.write("<");
            this.writer.write("fix-data");
            this.emitFixSharedAttributes(lintFix, indented);
            for (String key : ((LintFix.DataMap)lintFix).keys()) {
                String string;
                Object value = ((LintFix.DataMap)lintFix).get(key);
                if (value instanceof String) {
                    string = (String)value;
                } else if (value instanceof Integer ? true : value instanceof Boolean) {
                    string = value.toString();
                } else if (value instanceof File) {
                    string = this.getPath((File)value, incident.getProject());
                } else if (value instanceof List) {
                    string = CollectionsKt.joinToString$default((Iterable)((Iterable)value), null, null, null, (int)0, null, (Function1)emitFixDescriptors.valueString.1.INSTANCE, (int)31, null);
                } else if (value instanceof PsiMethod ? true : value instanceof Throwable) {
                    string = null;
                } else {
                    Object object = value;
                    throw new IllegalStateException(("Unexpected fix map value type " + (object != null ? object.getClass() : null)).toString());
                }
                if (string == null) continue;
                String valueString2 = string;
                this.writeAttribute(this.writer, -1, key, valueString2);
            }
            this.writer.write("/>\n");
        } else {
            throw new IllegalStateException(("Unsupported quickfix " + lintFix.getClass()).toString());
        }
    }

    static /* synthetic */ void emitFixDescriptors$default(XmlWriter xmlWriter, Incident incident, LintFix lintFix, int n, int n2, Object object) {
        if (object != null) {
            throw new UnsupportedOperationException("Super calls with default arguments not supported in this target, function: emitFixDescriptors");
        }
        if ((n2 & 4) != 0) {
            n = 2;
        }
        xmlWriter.emitFixDescriptors(incident, lintFix, n);
    }

    private final void emitFixSharedAttributes(LintFix lintFix, int indent) {
        String it;
        String string = lintFix.getDisplayName();
        if (string != null) {
            it = string;
            boolean bl = false;
            this.writeAttribute(this.writer, indent, "description", it);
        }
        String string2 = lintFix.getFamilyName();
        if (string2 != null) {
            it = string2;
            boolean bl = false;
            this.writeAttribute(this.writer, indent, "family", it);
        }
        if (lintFix.robot) {
            this.writeAttribute(this.writer, indent, "robot", "true");
        }
        if (lintFix.independent) {
            this.writeAttribute(this.writer, indent, "independent", "true");
        }
    }

    private final void writeAttribute(Writer writer, int indent, String name, String value) throws IOException {
        if (indent >= 0) {
            writer.write("\n");
            this.indent(indent);
        } else {
            writer.write(" ");
        }
        writer.write(name);
        writer.write("=\"");
        writer.write(XmlUtils.toXmlAttributeValue((String)value));
        writer.write("\"");
    }

    private final void indent(int indent) throws IOException {
        for (int level = 0; level < indent; ++level) {
            this.writer.write("    ");
        }
    }

    public final void writeIncidents(@NotNull List<Incident> incidents, @NotNull List<Pair<String, String>> extraAttributes) {
        Intrinsics.checkNotNullParameter(incidents, (String)"incidents");
        Intrinsics.checkNotNullParameter(extraAttributes, (String)"extraAttributes");
        this.writeProlog();
        String rootTag = this.type.isPersistenceFile() ? "incidents" : "issues";
        Map attributeMap = MapsKt.toMap((Iterable)CollectionsKt.plus((Collection)this.getDefaultRootAttributes(), (Iterable)extraAttributes));
        XmlWriter.writeOpenTag$default(this, rootTag, attributeMap, 0, 4, null);
        if (!((Collection)incidents).isEmpty()) {
            for (Incident incident : incidents) {
                this.writeIncident(incident, 1);
            }
        }
        XmlWriter.writeCloseTag$default(this, rootTag, 0, 2, null);
        this.close();
    }

    public static /* synthetic */ void writeIncidents$default(XmlWriter xmlWriter, List list2, List list3, int n, Object object) {
        if (object != null) {
            throw new UnsupportedOperationException("Super calls with default arguments not supported in this target, function: writeIncidents");
        }
        if ((n & 2) != 0) {
            list3 = CollectionsKt.emptyList();
        }
        xmlWriter.writeIncidents(list2, list3);
    }

    public final void writePartialResults(@NotNull Map<Issue, LintMap> resultMap) {
        Intrinsics.checkNotNullParameter(resultMap, (String)"resultMap");
        this.writeProlog();
        XmlWriter.writeOpenTag$default(this, "incidents", MapsKt.toMap((Iterable)this.getDefaultRootAttributes()), 0, 4, null);
        if (!resultMap.isEmpty()) {
            for (Map.Entry<Issue, LintMap> entry : resultMap.entrySet()) {
                Issue issue = entry.getKey();
                LintMap map = entry.getValue();
                String id = issue.getId();
                if (!map.isNotEmpty()) continue;
                this.writeLintMap(map, 1, id);
            }
        }
        XmlWriter.writeCloseTag$default(this, "incidents", 0, 2, null);
        this.close();
    }

    public final void writeConfiguredIssues(@NotNull Map<String, ? extends Severity> severityMap) {
        Intrinsics.checkNotNullParameter(severityMap, (String)"severityMap");
        this.writeProlog();
        XmlWriter.writeOpenTag$default(this, "incidents", MapsKt.toMap((Iterable)this.getDefaultRootAttributes()), 0, 4, null);
        if (!severityMap.isEmpty()) {
            for (Map.Entry<String, ? extends Severity> entry : severityMap.entrySet()) {
                String id = entry.getKey();
                Severity severity = entry.getValue();
                this.indent(1);
                this.writer.write("<config id=\"" + id + "\" severity=\"" + severity.toName() + "\"/>\n");
            }
        }
        XmlWriter.writeCloseTag$default(this, "incidents", 0, 2, null);
        this.close();
    }

    public static final /* synthetic */ LintCliClient access$getClient$p(XmlWriter $this) {
        return $this.client;
    }

    @Metadata(mv={1, 6, 0}, k=3, xi=48)
    public final class WhenMappings {
        public static final /* synthetic */ int[] $EnumSwitchMapping$0;

        static {
            int[] nArray = new int[LintFix.GroupType.values().length];
            nArray[LintFix.GroupType.ALTERNATIVES.ordinal()] = 1;
            nArray[LintFix.GroupType.COMPOSITE.ordinal()] = 2;
            $EnumSwitchMapping$0 = nArray;
        }
    }
}

