/*
 * Decompiled with CFR 0.152.
 */
package com.android.ddmuilib.log.event;

import com.android.ddmlib.log.EventContainer;
import com.android.ddmlib.log.EventLogParser;
import com.android.ddmlib.log.EventValueDescription;
import com.android.ddmlib.log.InvalidTypeException;
import com.android.ddmuilib.log.event.EventDisplay;
import com.android.ddmuilib.log.event.OccurrenceRenderer;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Date;
import java.util.HashMap;
import java.util.Map;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.jfree.chart.axis.AxisLocation;
import org.jfree.chart.axis.NumberAxis;
import org.jfree.chart.axis.ValueAxis;
import org.jfree.chart.plot.XYPlot;
import org.jfree.chart.renderer.xy.XYAreaRenderer;
import org.jfree.chart.renderer.xy.XYItemRenderer;
import org.jfree.chart.renderer.xy.XYLineAndShapeRenderer;
import org.jfree.data.time.Millisecond;
import org.jfree.data.time.TimeSeries;
import org.jfree.data.time.TimeSeriesCollection;
import org.jfree.data.xy.XYDataset;

public class DisplayGraph
extends EventDisplay {
    public DisplayGraph(String name) {
        super(name);
    }

    @Override
    void resetUI() {
        Collection datasets = this.mValueTypeDataSetMap.values();
        for (TimeSeriesCollection dataset : datasets) {
            dataset.removeAllSeries();
        }
        if (this.mOccurrenceDataSet != null) {
            this.mOccurrenceDataSet.removeAllSeries();
        }
        this.mValueDescriptorSeriesMap.clear();
        this.mOcurrenceDescriptorSeriesMap.clear();
    }

    @Override
    public Control createComposite(Composite parent, EventLogParser logParser, EventDisplay.ILogColumnListener listener) {
        String title = this.getChartTitle(logParser);
        return this.createCompositeChart(parent, logParser, title);
    }

    @Override
    void newEvent(EventContainer event, EventLogParser logParser) {
        ArrayList<EventDisplay.ValueDisplayDescriptor> valueDescriptors = new ArrayList<EventDisplay.ValueDisplayDescriptor>();
        ArrayList<EventDisplay.OccurrenceDisplayDescriptor> occurrenceDescriptors = new ArrayList<EventDisplay.OccurrenceDisplayDescriptor>();
        if (this.filterEvent(event, valueDescriptors, occurrenceDescriptors)) {
            this.updateChart(event, logParser, valueDescriptors, occurrenceDescriptors);
        }
    }

    private void updateChart(EventContainer event, EventLogParser logParser, ArrayList<EventDisplay.ValueDisplayDescriptor> valueDescriptors, ArrayList<EventDisplay.OccurrenceDisplayDescriptor> occurrenceDescriptors) {
        TimeSeries timeSeries;
        Map tagMap = logParser.getTagMap();
        Millisecond millisecondTime = null;
        long msec = -1L;
        boolean accumulateValues = false;
        double accumulatedValue = 0.0;
        if (event.mTag == 2721) {
            accumulateValues = true;
            for (EventDisplay.ValueDisplayDescriptor valueDisplayDescriptor : valueDescriptors) {
                accumulateValues &= valueDisplayDescriptor.valueIndex != 0;
            }
        }
        for (EventDisplay.ValueDisplayDescriptor valueDisplayDescriptor : valueDescriptors) {
            try {
                HashMap<Integer, TimeSeries> map2 = (HashMap<Integer, TimeSeries>)this.mValueDescriptorSeriesMap.get(valueDisplayDescriptor);
                if (map2 == null) {
                    map2 = new HashMap<Integer, TimeSeries>();
                    this.mValueDescriptorSeriesMap.put(valueDisplayDescriptor, map2);
                }
                if ((timeSeries = (TimeSeries)map2.get(event.pid)) == null) {
                    String seriesFullName = null;
                    String seriesLabel = this.getSeriesLabel(event, valueDisplayDescriptor);
                    switch (this.mValueDescriptorCheck) {
                        case 1: {
                            seriesFullName = String.format("%1$s / %2$s", seriesLabel, valueDisplayDescriptor.valueName);
                            break;
                        }
                        case 2: {
                            seriesFullName = String.format("%1$s", seriesLabel);
                            break;
                        }
                        default: {
                            seriesFullName = String.format("%1$s / %2$s: %3$s", seriesLabel, tagMap.get(valueDisplayDescriptor.eventTag), valueDisplayDescriptor.valueName);
                        }
                    }
                    TimeSeriesCollection dataset = this.getValueDataset(((EventValueDescription[])logParser.getEventInfoMap().get(event.mTag))[valueDisplayDescriptor.valueIndex].getValueType(), accumulateValues);
                    timeSeries = new TimeSeries((Comparable)((Object)seriesFullName), Millisecond.class);
                    if (this.mMaximumChartItemAge != -1L) {
                        timeSeries.setMaximumItemAge(this.mMaximumChartItemAge * 1000L);
                    }
                    dataset.addSeries(timeSeries);
                    map2.put(event.pid, timeSeries);
                }
                double value = event.getValueAsDouble(valueDisplayDescriptor.valueIndex);
                if (accumulateValues) {
                    accumulatedValue += value;
                    value = accumulatedValue;
                }
                if (millisecondTime == null) {
                    msec = (long)event.sec * 1000L + (long)event.nsec / 1000000L;
                    millisecondTime = new Millisecond(new Date(msec));
                }
                timeSeries.addOrUpdate(millisecondTime, value);
            }
            catch (InvalidTypeException map2) {}
        }
        for (EventDisplay.OccurrenceDisplayDescriptor occurrenceDisplayDescriptor : occurrenceDescriptors) {
            try {
                HashMap<Integer, TimeSeries> map3 = (HashMap<Integer, TimeSeries>)this.mOcurrenceDescriptorSeriesMap.get(occurrenceDisplayDescriptor);
                if (map3 == null) {
                    map3 = new HashMap<Integer, TimeSeries>();
                    this.mOcurrenceDescriptorSeriesMap.put(occurrenceDisplayDescriptor, map3);
                }
                if ((timeSeries = (TimeSeries)map3.get(event.pid)) == null) {
                    String seriesLabel = this.getSeriesLabel(event, occurrenceDisplayDescriptor);
                    String seriesFullName = String.format("[%1$s:%2$s]", tagMap.get(occurrenceDisplayDescriptor.eventTag), seriesLabel);
                    timeSeries = new TimeSeries((Comparable)((Object)seriesFullName), Millisecond.class);
                    if (this.mMaximumChartItemAge != -1L) {
                        timeSeries.setMaximumItemAge(this.mMaximumChartItemAge);
                    }
                    this.getOccurrenceDataSet().addSeries(timeSeries);
                    map3.put(event.pid, timeSeries);
                }
                if (millisecondTime == null) {
                    msec = (long)event.sec * 1000L + (long)event.nsec / 1000000L;
                    millisecondTime = new Millisecond(new Date(msec));
                }
                timeSeries.addOrUpdate(millisecondTime, 0.0);
            }
            catch (InvalidTypeException map3) {}
        }
        if (msec != -1L && this.mMaximumChartItemAge != -1L) {
            Collection seriesCollection;
            Collection pidMapValues = this.mValueDescriptorSeriesMap.values();
            for (HashMap pidMapValue : pidMapValues) {
                seriesCollection = pidMapValue.values();
                for (TimeSeries timeSeries2 : seriesCollection) {
                    timeSeries2.removeAgedItems(msec, true);
                }
            }
            pidMapValues = this.mOcurrenceDescriptorSeriesMap.values();
            for (HashMap pidMapValue : pidMapValues) {
                seriesCollection = pidMapValue.values();
                for (TimeSeries timeSeries2 : seriesCollection) {
                    timeSeries2.removeAgedItems(msec, true);
                }
            }
        }
    }

    private TimeSeriesCollection getValueDataset(EventValueDescription.ValueType type, boolean accumulateValues) {
        TimeSeriesCollection dataset = (TimeSeriesCollection)this.mValueTypeDataSetMap.get(type);
        if (dataset == null) {
            XYAreaRenderer renderer;
            dataset = new TimeSeriesCollection();
            this.mValueTypeDataSetMap.put(type, dataset);
            if (type == EventValueDescription.ValueType.PERCENT && accumulateValues) {
                renderer = new XYAreaRenderer();
            } else {
                XYLineAndShapeRenderer r = new XYLineAndShapeRenderer();
                r.setBaseShapesVisible(type != EventValueDescription.ValueType.PERCENT);
                renderer = r;
            }
            XYPlot xyPlot = this.mChart.getXYPlot();
            xyPlot.setDataset(this.mDataSetCount, (XYDataset)dataset);
            xyPlot.setRenderer(this.mDataSetCount, (XYItemRenderer)renderer);
            NumberAxis axis = new NumberAxis(type.toString());
            if (type == EventValueDescription.ValueType.PERCENT) {
                axis.setAutoRange(false);
                axis.setRange(0.0, 100.0);
            }
            int count = this.mDataSetCount;
            if (this.mOccurrenceDataSet != null) {
                --count;
            }
            xyPlot.setRangeAxis(count, (ValueAxis)axis);
            if (count % 2 == 0) {
                xyPlot.setRangeAxisLocation(count, AxisLocation.BOTTOM_OR_LEFT);
            } else {
                xyPlot.setRangeAxisLocation(count, AxisLocation.TOP_OR_RIGHT);
            }
            xyPlot.mapDatasetToRangeAxis(this.mDataSetCount, count);
            ++this.mDataSetCount;
        }
        return dataset;
    }

    private String getSeriesLabel(EventContainer event, EventDisplay.OccurrenceDisplayDescriptor descriptor) throws InvalidTypeException {
        if (descriptor.seriesValueIndex != -1) {
            if (!descriptor.includePid) {
                return event.getValueAsString(descriptor.seriesValueIndex);
            }
            return String.format("%1$s (%2$d)", event.getValueAsString(descriptor.seriesValueIndex), event.pid);
        }
        return Integer.toString(event.pid);
    }

    private TimeSeriesCollection getOccurrenceDataSet() {
        if (this.mOccurrenceDataSet == null) {
            this.mOccurrenceDataSet = new TimeSeriesCollection();
            XYPlot xyPlot = this.mChart.getXYPlot();
            xyPlot.setDataset(this.mDataSetCount, (XYDataset)this.mOccurrenceDataSet);
            OccurrenceRenderer renderer = new OccurrenceRenderer();
            renderer.setBaseShapesVisible(false);
            xyPlot.setRenderer(this.mDataSetCount, (XYItemRenderer)renderer);
            ++this.mDataSetCount;
        }
        return this.mOccurrenceDataSet;
    }

    @Override
    int getDisplayType() {
        return 2;
    }

    @Override
    protected void setNewLogParser(EventLogParser logParser) {
        if (this.mChart != null) {
            this.mChart.setTitle(this.getChartTitle(logParser));
        }
    }

    private String getChartTitle(EventLogParser logParser) {
        if (this.mValueDescriptors.size() > 0) {
            String chartDesc = null;
            switch (this.mValueDescriptorCheck) {
                case 1: {
                    if (logParser == null) break;
                    chartDesc = (String)logParser.getTagMap().get(((EventDisplay.ValueDisplayDescriptor)this.mValueDescriptors.get((int)0)).eventTag);
                    break;
                }
                case 2: {
                    if (logParser == null) break;
                    chartDesc = String.format("%1$s / %2$s", logParser.getTagMap().get(((EventDisplay.ValueDisplayDescriptor)this.mValueDescriptors.get((int)0)).eventTag), ((EventDisplay.ValueDisplayDescriptor)this.mValueDescriptors.get((int)0)).valueName);
                }
            }
            if (chartDesc != null) {
                return String.format("%1$s - %2$s", this.mName, chartDesc);
            }
        }
        return this.mName;
    }
}

