/*
 * Decompiled with CFR 0.152.
 */
package com.android.fakeadbserver;

import com.android.fakeadbserver.DeviceState;
import com.android.fakeadbserver.FakeAdbServer;
import com.android.fakeadbserver.devicecommandhandlers.DeviceCommandHandler;
import com.android.fakeadbserver.hostcommandhandlers.HostCommandHandler;
import com.android.fakeadbserver.shellcommandhandlers.ShellCommandHandler;
import java.io.IOException;
import java.io.OutputStream;
import java.net.Socket;
import java.nio.charset.StandardCharsets;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.Set;
import java.util.concurrent.ExecutionException;
import java.util.function.Supplier;

final class ConnectionHandler
implements Runnable {
    private static final Set<String> NON_WILDCARD_TRANSPORT_DEVICE_COMMANDS = Collections.unmodifiableSet(new HashSet<String>(Arrays.asList("version", "kill", "devices", "devices-l", "track-devices", "emulator", "transport", "transport-usb", "transport-local", "transport-any")));
    private final FakeAdbServer mServer;
    private final Socket mSocket;
    private final Map<String, Supplier<HostCommandHandler>> mHostCommandHandlers;
    private final Map<String, Supplier<DeviceCommandHandler>> mDeviceCommandHandlers;
    private final Map<String, Supplier<ShellCommandHandler>> mShellCommandHandlers;

    ConnectionHandler(FakeAdbServer server, Socket socket, Map<String, Supplier<HostCommandHandler>> hostCommandHandlers, Map<String, Supplier<DeviceCommandHandler>> deviceCommandHandlers, Map<String, Supplier<ShellCommandHandler>> shellCommandHandlers) {
        this.mServer = server;
        this.mSocket = socket;
        this.mHostCommandHandlers = hostCommandHandlers;
        this.mDeviceCommandHandlers = deviceCommandHandlers;
        this.mShellCommandHandlers = shellCommandHandlers;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @Override
    public void run() {
        boolean keepRunning = true;
        DeviceState targetDevice = null;
        try {
            while (keepRunning) {
                Request request;
                if (targetDevice == null) {
                    request = this.parseHostRequest();
                    if (request == null) {
                        return;
                    }
                    if (request.mCommand.startsWith("transport")) {
                        targetDevice = request.mTargetDevice;
                        this.sendOkay();
                        continue;
                    }
                    if (this.mHostCommandHandlers.containsKey(request.mCommand)) {
                        keepRunning = this.mHostCommandHandlers.get(request.mCommand).get().invoke(this.mServer, this.mSocket, request.mTargetDevice, request.mArguments);
                        continue;
                    }
                    this.sendFailWithReason("Unimplemented host command received: " + request.mCommand);
                    continue;
                }
                request = this.parseDeviceRequest();
                if (request == null) {
                    return;
                }
                if (request.mCommand.equals("shell")) {
                    String[] splitShellString = request.mArguments.split(" ", 2);
                    if (this.mShellCommandHandlers.containsKey(splitShellString[0])) {
                        if (this.mShellCommandHandlers.get(splitShellString[0]).get().invoke(this.mServer, this.mSocket, targetDevice, splitShellString.length > 1 ? splitShellString[1] : null)) continue;
                        return;
                    }
                    this.sendFailWithReason("Unimplemented shell command received: " + request.mCommand);
                    continue;
                }
                if (this.mDeviceCommandHandlers.containsKey(request.mCommand)) {
                    if (this.mDeviceCommandHandlers.get(request.mCommand).get().invoke(this.mServer, this.mSocket, targetDevice, request.mArguments)) continue;
                    return;
                }
                this.sendFailWithReason("Unimplemented device command received: " + request.mCommand);
            }
            return;
        }
        catch (RuntimeException e) {
            this.sendFailWithReason("Bad request received: " + e.toString());
            return;
        }
        catch (IOException ignored) {
            this.sendFailWithReason("IOException occurred when processing request.");
            return;
        }
        finally {
            try {
                this.mSocket.close();
            }
            catch (IOException e) {}
        }
    }

    private HostRequest parseHostRequest() throws IOException {
        byte[] lengthString = new byte[4];
        this.readFully(lengthString);
        int requestLength = Integer.parseInt(new String(lengthString), 16);
        assert (requestLength > "host:".length());
        byte[] payloadBytes = new byte[requestLength];
        this.readFully(payloadBytes);
        String payload = new String(payloadBytes, StandardCharsets.US_ASCII);
        String[] splitPayload = payload.split(":", 2);
        if (splitPayload.length < 2) {
            this.sendFailWithReason("Invalid host command: " + payload);
            return null;
        }
        DeviceState device = null;
        switch (splitPayload[0]) {
            case "host": {
                String[] transportSplit = splitPayload[1].split(":");
                String command = transportSplit[0];
                if (!NON_WILDCARD_TRANSPORT_DEVICE_COMMANDS.contains(command)) {
                    device = this.findAnyDeviceWithProtocol(Arrays.asList(DeviceState.HostConnectionType.LOCAL, DeviceState.HostConnectionType.USB));
                    if (device != null) break;
                    return null;
                }
                if (!command.startsWith("transport")) break;
                switch (command) {
                    case "transport": {
                        device = this.findDeviceWithSerial(transportSplit[1]);
                        break;
                    }
                    case "transport-usb": {
                        device = this.findAnyDeviceWithProtocol(Collections.singletonList(DeviceState.HostConnectionType.USB));
                        break;
                    }
                    case "transport-local": {
                        device = this.findAnyDeviceWithProtocol(Collections.singletonList(DeviceState.HostConnectionType.LOCAL));
                        break;
                    }
                    case "transport-any": {
                        device = this.findAnyDeviceWithProtocol(Arrays.asList(DeviceState.HostConnectionType.LOCAL, DeviceState.HostConnectionType.USB));
                        break;
                    }
                    default: {
                        this.sendFailWithReason("Invalid command specified in payload: " + payload);
                        return null;
                    }
                }
                if (device != null) break;
                return null;
            }
            case "host-usb": {
                device = this.findAnyDeviceWithProtocol(Collections.singletonList(DeviceState.HostConnectionType.USB));
                if (device != null) break;
                return null;
            }
            case "host-local": {
                device = this.findAnyDeviceWithProtocol(Collections.singletonList(DeviceState.HostConnectionType.LOCAL));
                if (device != null) break;
                return null;
            }
            case "host-serial": {
                splitPayload = splitPayload[1].split(":", 2);
                String serial = splitPayload[0];
                device = this.findDeviceWithSerial(serial);
                break;
            }
            default: {
                this.sendFailWithReason("Invalid transport specified in payload: " + payload);
                return null;
            }
        }
        splitPayload = splitPayload[1].split(":", 2);
        return new HostRequest(device, splitPayload[0], splitPayload.length > 1 ? splitPayload[1] : "");
    }

    private DeviceState findAnyDeviceWithProtocol(List<DeviceState.HostConnectionType> acceptibleConnectionTypes) {
        List<DeviceState> deviceList;
        try {
            deviceList = this.mServer.getDeviceListCopy().get();
        }
        catch (InterruptedException | ExecutionException ignored) {
            this.sendFailWithReason("Internal server failure while processing command.");
            return null;
        }
        DeviceState foundDevice = null;
        for (DeviceState device : deviceList) {
            if (!acceptibleConnectionTypes.contains((Object)device.getHostConnectionType())) continue;
            if (foundDevice == null) {
                foundDevice = device;
                continue;
            }
            this.sendFailWithReason("More than one device on the USB bus. Please specify which.");
            return null;
        }
        if (foundDevice == null) {
            this.sendFailWithReason("No devices available on the USB bus.");
            return null;
        }
        return foundDevice;
    }

    private DeviceState findDeviceWithSerial(String serial) {
        try {
            List<DeviceState> devices = this.mServer.getDeviceListCopy().get();
            Optional<DeviceState> streamResult = devices.stream().filter(streamDevice -> serial.equals(streamDevice.getDeviceId())).findAny();
            if (!streamResult.isPresent()) {
                this.sendFailWithReason("No device with serial: " + serial + " is connected.");
                return null;
            }
            return streamResult.get();
        }
        catch (InterruptedException | ExecutionException e) {
            this.sendFailWithReason("Internal server error while retrieving device list.");
            return null;
        }
    }

    private Request parseDeviceRequest() throws IOException {
        String[] splitPayload;
        String[] stringArray;
        byte[] lengthString = new byte[4];
        this.readFully(lengthString);
        int requestLength = Integer.parseInt(new String(lengthString), 16);
        byte[] payloadBytes = new byte[requestLength];
        this.readFully(payloadBytes);
        String payload = new String(payloadBytes, StandardCharsets.US_ASCII);
        if (payload.equals("track-jdwp")) {
            String[] stringArray2 = new String[2];
            stringArray2[0] = payload;
            stringArray = stringArray2;
            stringArray2[1] = "";
        } else {
            stringArray = splitPayload = payload.split(":", 2);
        }
        if (splitPayload.length < 2) {
            this.sendFailWithReason("Invalid host command: " + payload);
            return null;
        }
        return new Request(splitPayload[0], splitPayload[1]);
    }

    private void readFully(byte[] buffer) throws IOException {
        for (int bytesRead = 0; bytesRead < buffer.length; bytesRead += this.mSocket.getInputStream().read(buffer, bytesRead, buffer.length - bytesRead)) {
        }
    }

    private void sendOkay() throws IOException {
        OutputStream stream = this.mSocket.getOutputStream();
        stream.write("OKAY".getBytes(StandardCharsets.US_ASCII));
    }

    private void sendFailWithReason(String reason) {
        try {
            OutputStream stream = this.mSocket.getOutputStream();
            stream.write("FAIL".getBytes(StandardCharsets.US_ASCII));
            byte[] reasonBytes = reason.getBytes(StandardCharsets.UTF_8);
            assert (reasonBytes.length < 65536);
            stream.write(String.format("%x4d", reason.length()).getBytes(StandardCharsets.US_ASCII));
            stream.write(reasonBytes);
            stream.flush();
        }
        catch (IOException iOException) {
            // empty catch block
        }
    }

    private static class HostRequest
    extends Request {
        protected DeviceState mTargetDevice;

        private HostRequest(DeviceState targetDevice, String command, String arguments) {
            super(command, arguments);
            this.mTargetDevice = targetDevice;
        }
    }

    private static class Request {
        protected String mCommand;
        protected String mArguments;

        private Request(String command, String arguments) {
            this.mCommand = command;
            this.mArguments = arguments;
        }
    }
}

