/*
 * Decompiled with CFR 0.152.
 */
package com.android.fakeadbserver.hostcommandhandlers;

import com.android.fakeadbserver.DeviceState;
import com.android.fakeadbserver.FakeAdbServer;
import com.android.fakeadbserver.hostcommandhandlers.HostCommandHandler;
import com.android.fakeadbserver.hostcommandhandlers.ListDevicesCommandHandler;
import com.android.fakeadbserver.statechangehubs.DeviceStateChangeHandlerFactory;
import com.android.fakeadbserver.statechangehubs.StateChangeHandlerFactory;
import com.android.fakeadbserver.statechangehubs.StateChangeQueue;
import java.io.IOException;
import java.io.OutputStream;
import java.net.Socket;
import java.nio.charset.StandardCharsets;
import java.util.Collection;
import java.util.concurrent.Callable;
import java.util.concurrent.ExecutionException;

public class TrackDevicesCommandHandler
extends HostCommandHandler {
    public static final String COMMAND = "track-devices";

    private static Callable<StateChangeHandlerFactory.HandlerResult> sendDeviceList(Socket responseSocket, FakeAdbServer server) {
        return () -> {
            try {
                OutputStream stream = responseSocket.getOutputStream();
                String deviceListString = ListDevicesCommandHandler.formatDeviceList(server.getDeviceListCopy().get());
                TrackDevicesCommandHandler.write4ByteHexIntString(stream, deviceListString.length());
                stream.write(deviceListString.getBytes(StandardCharsets.US_ASCII));
                stream.flush();
                return new StateChangeHandlerFactory.HandlerResult(true);
            }
            catch (IOException | InterruptedException | ExecutionException e) {
                return new StateChangeHandlerFactory.HandlerResult(false);
            }
        };
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean invoke(final FakeAdbServer fakeAdbServer, final Socket responseSocket, DeviceState device, String args) {
        StateChangeQueue queue = fakeAdbServer.getDeviceChangeHub().subscribe(new DeviceStateChangeHandlerFactory(){

            @Override
            public Callable<StateChangeHandlerFactory.HandlerResult> createDeviceListChangedHandler(Collection<DeviceState> deviceList) {
                return TrackDevicesCommandHandler.sendDeviceList(responseSocket, fakeAdbServer);
            }

            @Override
            public Callable<StateChangeHandlerFactory.HandlerResult> createDeviceStateChangedHandler(DeviceState device, DeviceState.DeviceStatus status) {
                return TrackDevicesCommandHandler.sendDeviceList(responseSocket, fakeAdbServer);
            }
        });
        if (queue == null) {
            return false;
        }
        try {
            TrackDevicesCommandHandler.writeOkay(responseSocket.getOutputStream());
            TrackDevicesCommandHandler.sendDeviceList(responseSocket, fakeAdbServer).call();
            try {
                while (queue.take().call().mShouldContinue) {
                }
            }
            catch (InterruptedException ignored) {
                // empty catch block
            }
        }
        catch (Exception exception) {
        }
        finally {
            fakeAdbServer.getDeviceChangeHub().unsubscribe(queue);
        }
        return false;
    }
}

