/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.util;

import com.intellij.openapi.util.SystemInfo;
import com.intellij.util.AppleHiDPIScaledImage;
import com.intellij.util.ImageLoader;
import com.intellij.util.JBHiDPIScaledImage;
import com.intellij.util.ui.UIUtil;
import java.awt.Graphics2D;
import java.awt.GraphicsConfiguration;
import java.awt.Image;
import java.awt.image.BufferedImage;
import java.awt.image.ImageObserver;
import org.jetbrains.annotations.NotNull;

public class RetinaImage {
    public static Image createFrom(Image image) {
        return RetinaImage.createFrom(image, 2, (ImageObserver)ImageLoader.ourComponent);
    }

    @NotNull
    public static Image createFrom(Image image, int scale, ImageObserver observer) {
        Image image2 = RetinaImage.createFrom(image, (float)scale, observer);
        if (image2 == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/util/RetinaImage", "createFrom"));
        }
        return image2;
    }

    @NotNull
    public static Image createFrom(Image image, float scale, ImageObserver observer) {
        int w = image.getWidth(observer);
        int h = image.getHeight(observer);
        JBHiDPIScaledImage hidpi = new JBHiDPIScaledImage(image, (int)((float)w / scale), (int)((float)h / scale), 2);
        if (SystemInfo.isAppleJvm) {
            Graphics2D g = (Graphics2D)((Image)hidpi).getGraphics();
            g.scale(1.0f / scale, 1.0f / scale);
            g.drawImage(image, 0, 0, null);
            g.dispose();
        }
        JBHiDPIScaledImage jBHiDPIScaledImage = hidpi;
        if (jBHiDPIScaledImage == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/util/RetinaImage", "createFrom"));
        }
        return jBHiDPIScaledImage;
    }

    @NotNull
    public static BufferedImage create(int width, int height, int type) {
        JBHiDPIScaledImage jBHiDPIScaledImage = new JBHiDPIScaledImage(width, height, type);
        if (jBHiDPIScaledImage == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/util/RetinaImage", "create"));
        }
        return jBHiDPIScaledImage;
    }

    @NotNull
    public static BufferedImage create(Graphics2D g, int width, int height, int type) {
        JBHiDPIScaledImage jBHiDPIScaledImage = new JBHiDPIScaledImage(g, width, height, type);
        if (jBHiDPIScaledImage == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/util/RetinaImage", "create"));
        }
        return jBHiDPIScaledImage;
    }

    @NotNull
    public static BufferedImage create(GraphicsConfiguration gc, int width, int height, int type) {
        JBHiDPIScaledImage jBHiDPIScaledImage = new JBHiDPIScaledImage(gc, width, height, type);
        if (jBHiDPIScaledImage == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/util/RetinaImage", "create"));
        }
        return jBHiDPIScaledImage;
    }

    public static boolean isAppleHiDPIScaledImage(Image image) {
        return UIUtil.isAppleRetina() && AppleHiDPIScaledImage.is(image);
    }
}

