/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.profgen;

import com.android.tools.profgen.ClassMapping;
import com.android.tools.profgen.ClassParser;
import com.android.tools.profgen.MemberParser;
import com.android.tools.profgen.ObfuscationMap;
import com.android.tools.profgen.Parseable;
import com.android.tools.profgen.ParsingKt;
import com.android.tools.profgen.TypeParser;
import java.io.Closeable;
import java.io.File;
import java.io.FileInputStream;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.Reader;
import java.nio.charset.Charset;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import kotlin.KotlinNothingValueException;
import kotlin.Metadata;
import kotlin.Pair;
import kotlin.TuplesKt;
import kotlin.collections.CollectionsKt;
import kotlin.collections.MapsKt;
import kotlin.io.CloseableKt;
import kotlin.io.TextStreamsKt;
import kotlin.jvm.internal.Intrinsics;
import kotlin.text.Charsets;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={1, 6, 0}, k=2, xi=48, d1={"\u0000J\n\u0000\n\u0002\u0010$\n\u0002\u0010\u000e\n\u0002\u0010\f\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\b\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\u001a\u000e\u0010\u0004\u001a\u00020\u00052\u0006\u0010\u0006\u001a\u00020\u0007\u001a\u000e\u0010\u0004\u001a\u00020\u00052\u0006\u0010\b\u001a\u00020\t\u001a\u0018\u0010\n\u001a\u00020\u000b2\u0006\u0010\f\u001a\u00020\u00022\u0006\u0010\r\u001a\u00020\u000bH\u0002\u001a\u0014\u0010\u000e\u001a\u00020\u000f*\u00020\u00102\u0006\u0010\f\u001a\u00020\u0002H\u0002\u001a\u001c\u0010\u0011\u001a\u00020\u000b*\u00020\u00122\u0006\u0010\f\u001a\u00020\u00022\u0006\u0010\r\u001a\u00020\u000bH\u0002\u001a\u001c\u0010\u0013\u001a\u00020\u000b*\u00020\u00122\u0006\u0010\f\u001a\u00020\u00022\u0006\u0010\r\u001a\u00020\u000bH\u0002\u001a\u001c\u0010\u0014\u001a\u00020\u000f*\u00020\u00152\u0006\u0010\f\u001a\u00020\u00022\u0006\u0010\u0016\u001a\u00020\u0017H\u0002\u001a$\u0010\u0018\u001a\u00020\u000b*\u00020\u00152\u0006\u0010\f\u001a\u00020\u00022\u0006\u0010\r\u001a\u00020\u000b2\u0006\u0010\u0016\u001a\u00020\u0017H\u0002\u001a\u001c\u0010\u0019\u001a\u00020\u000b*\u00020\u00172\u0006\u0010\f\u001a\u00020\u00022\u0006\u0010\r\u001a\u00020\u000bH\u0002\"\u001a\u0010\u0000\u001a\u000e\u0012\u0004\u0012\u00020\u0002\u0012\u0004\u0012\u00020\u00030\u0001X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u001a"}, d2={"PRIMITIVE_MAP", "", "", "", "ObfuscationMap", "Lcom/android/tools/profgen/ObfuscationMap;", "file", "Ljava/io/File;", "src", "Ljava/io/InputStreamReader;", "maybeSkipRange", "", "line", "start", "parse", "", "Lcom/android/tools/profgen/ClassParser;", "parseFqn", "Lcom/android/tools/profgen/Parseable;", "parseIdentifier", "parseMemberLine", "Lcom/android/tools/profgen/MemberParser;", "typeParser", "Lcom/android/tools/profgen/TypeParser;", "parseParameters", "parseType", "unnamed"})
public final class ObfuscationMapKt {
    @NotNull
    private static final Map<String, Character> PRIMITIVE_MAP;

    @NotNull
    public static final ObfuscationMap ObfuscationMap(@NotNull InputStreamReader src) {
        Intrinsics.checkNotNullParameter((Object)src, (String)"src");
        List lines = TextStreamsKt.readLines((Reader)src);
        List mappings = new ArrayList();
        ClassMapping currentClass = ClassMapping.Companion.getEmpty();
        MemberParser memberParser = new MemberParser(80);
        ClassParser classParser = new ClassParser(80);
        TypeParser typeParser = new TypeParser(80);
        int n = lines.size();
        for (int i = 0; i < n; ++i) {
            char c;
            String line = (String)lines.get(i);
            if (((CharSequence)line).length() == 0 || (c = line.charAt(0)) == '#') continue;
            if (c == ' ') {
                ObfuscationMapKt.parseMemberLine(memberParser, line, typeParser);
                currentClass.addMemberFromParser$unnamed(memberParser);
                memberParser.clear();
                continue;
            }
            if (!Intrinsics.areEqual((Object)currentClass, (Object)ClassMapping.Companion.getEmpty())) {
                mappings.add(currentClass);
            }
            ObfuscationMapKt.parse(classParser, line);
            currentClass = classParser.buildAndClear();
        }
        if (!Intrinsics.areEqual((Object)currentClass, (Object)ClassMapping.Companion.getEmpty())) {
            mappings.add(currentClass);
        }
        return new ObfuscationMap(mappings);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @NotNull
    public static final ObfuscationMap ObfuscationMap(@NotNull File file) {
        ObfuscationMap obfuscationMap;
        Intrinsics.checkNotNullParameter((Object)file, (String)"file");
        Object object = file;
        Object object2 = Charsets.UTF_8;
        object = new InputStreamReader((InputStream)new FileInputStream((File)object), (Charset)object2);
        object2 = null;
        try {
            InputStreamReader it = (InputStreamReader)object;
            boolean bl = false;
            obfuscationMap = ObfuscationMapKt.ObfuscationMap(it);
        }
        catch (Throwable throwable) {
            object2 = throwable;
            throw throwable;
        }
        finally {
            CloseableKt.closeFinally((Closeable)object, (Throwable)object2);
        }
        return obfuscationMap;
    }

    private static final void parseMemberLine(MemberParser $this$parseMemberLine, String line, TypeParser typeParser) {
        int i = 0;
        i = ParsingKt.whitespace(line, i);
        i = ObfuscationMapKt.maybeSkipRange(line, i);
        i = ObfuscationMapKt.parseType(typeParser, line, i);
        $this$parseMemberLine.setReturnType(typeParser.getDescriptor());
        i = ParsingKt.consume(' ', line, i);
        i = ObfuscationMapKt.parseIdentifier($this$parseMemberLine, line, i);
        $this$parseMemberLine.setOriginal($this$parseMemberLine.flush());
        char c = line.charAt(i);
        if (c == ' ') {
            $this$parseMemberLine.setMethodRenaming(false);
            return;
        }
        if (c == '.') {
            $this$parseMemberLine.setMethodRenaming(false);
            return;
        }
        if (c != '(') {
            ParsingKt.illegalToken(line, i);
            throw new KotlinNothingValueException();
        }
        $this$parseMemberLine.setMethodRenaming(true);
        i = ParsingKt.consume('(', line, i);
        i = ObfuscationMapKt.parseParameters($this$parseMemberLine, line, i, typeParser);
        i = ParsingKt.consume(')', line, i);
        i = ObfuscationMapKt.maybeSkipRange(line, i);
        i = ParsingKt.consume(" -> ", line, i);
        i = ObfuscationMapKt.parseIdentifier($this$parseMemberLine, line, i);
        $this$parseMemberLine.setObfuscated($this$parseMemberLine.flush());
        if (!(i == line.length())) {
            String string = "Failed requirement.";
            throw new IllegalArgumentException(string.toString());
        }
    }

    private static final int parseParameters(MemberParser $this$parseParameters, String line, int start, TypeParser typeParser) {
        if (line.charAt(start) == ')') {
            return start;
        }
        int i = start;
        while (i < line.length()) {
            char c = line.charAt(i);
            if (c == ')') {
                $this$parseParameters.getParameters().add(typeParser.getDescriptor());
                break;
            }
            if (c == ',') {
                $this$parseParameters.getParameters().add(typeParser.getDescriptor());
                ++i;
                continue;
            }
            i = ObfuscationMapKt.parseType(typeParser, line, i);
        }
        return i;
    }

    private static final void parse(ClassParser $this$parse, String line) {
        int i = 0;
        i = ObfuscationMapKt.parseFqn($this$parse, line, i);
        $this$parse.setBefore($this$parse.flush());
        i = ParsingKt.consume(" -> ", line, i);
        i = ObfuscationMapKt.parseFqn($this$parse, line, i);
        $this$parse.setAfter($this$parse.flush());
        i = ParsingKt.consume(':', line, i);
        if (!(line.length() == i)) {
            String string = "Failed requirement.";
            throw new IllegalArgumentException(string.toString());
        }
    }

    private static final int maybeSkipRange(String line, int start) {
        char c;
        int i;
        for (i = start; i < line.length() && ((c = line.charAt(i)) == ':' || Character.isDigit(c)); ++i) {
        }
        return i;
    }

    private static final int parseFqn(Parseable $this$parseFqn, String line, int start) {
        char c;
        int i;
        $this$parseFqn.append('L');
        for (i = start; i < line.length() && !((c = line.charAt(i)) == ' ' ? true : c == ':'); ++i) {
            if (c == '.') {
                $this$parseFqn.append('/');
                continue;
            }
            $this$parseFqn.append(c);
        }
        $this$parseFqn.append(';');
        return i;
    }

    private static final int parseIdentifier(Parseable $this$parseIdentifier, String line, int start) {
        char c;
        int i;
        for (i = start; i < line.length() && !((((c = line.charAt(i)) == ' ' ? true : c == '.') ? true : c == '(') ? true : c == '['); ++i) {
            $this$parseIdentifier.append(c);
        }
        return i;
    }

    private static final int parseType(TypeParser $this$parseType, String line, int start) {
        Character primitive;
        char c;
        $this$parseType.clear();
        int i = start;
        while (i < line.length() && !(((c = line.charAt(i)) == ' ' ? true : c == ',') ? true : c == ')')) {
            if (c == '[') {
                int n = $this$parseType.getArrayDimensionsNumber();
                $this$parseType.setArrayDimensionsNumber(n + 1);
                i = ParsingKt.consume(']', line, i + 1);
                continue;
            }
            if (c == '.') {
                $this$parseType.setObject(true);
                $this$parseType.append('/');
            } else {
                $this$parseType.append(c);
            }
            ++i;
        }
        String result = $this$parseType.flush();
        if ($this$parseType.getArrayDimensionsNumber() > 0) {
            $this$parseType.append(StringsKt.repeat((CharSequence)"[", (int)$this$parseType.getArrayDimensionsNumber()));
        }
        if ((primitive = PRIMITIVE_MAP.get(result)) != null) {
            $this$parseType.append(primitive.charValue());
        } else {
            $this$parseType.setObject(true);
            $this$parseType.append('L');
            $this$parseType.append(result);
            $this$parseType.append(';');
        }
        $this$parseType.setDescriptor($this$parseType.flush());
        return i;
    }

    static {
        Object[] objectArray = new Pair[]{TuplesKt.to((Object)"boolean", (Object)Character.valueOf('Z')), TuplesKt.to((Object)"byte", (Object)Character.valueOf('B')), TuplesKt.to((Object)"char", (Object)Character.valueOf('C')), TuplesKt.to((Object)"short", (Object)Character.valueOf('S')), TuplesKt.to((Object)"int", (Object)Character.valueOf('I')), TuplesKt.to((Object)"long", (Object)Character.valueOf('J')), TuplesKt.to((Object)"float", (Object)Character.valueOf('F')), TuplesKt.to((Object)"double", (Object)Character.valueOf('D')), TuplesKt.to((Object)"void", (Object)Character.valueOf('V'))};
        PRIMITIVE_MAP = MapsKt.toMap((Iterable)CollectionsKt.listOf((Object[])objectArray));
    }
}

