/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.lint;

import com.android.tools.lint.LintCliFlags;
import com.android.tools.lint.detector.api.Category;
import com.android.tools.lint.model.LintModelLintOptions;
import com.android.tools.lint.model.LintModelModule;
import java.util.Collection;
import java.util.Map;
import java.util.Set;
import kotlin.Metadata;
import kotlin.collections.MapsKt;
import kotlin.jvm.JvmName;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={1, 6, 0}, k=2, xi=48, d1={"\u0000\u0014\n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\u001a\u0016\u0010\u0000\u001a\u00020\u00012\u0006\u0010\u0002\u001a\u00020\u00032\u0006\u0010\u0004\u001a\u00020\u0005\u00a8\u0006\u0006"}, d2={"syncTo", "", "project", "Lcom/android/tools/lint/model/LintModelModule;", "flags", "Lcom/android/tools/lint/LintCliFlags;", "lint-cli"})
@JvmName(name="SyncOptions")
public final class SyncOptions {
    public static final void syncTo(@NotNull LintModelModule project, @NotNull LintCliFlags flags) {
        Set check;
        Set enabled;
        Intrinsics.checkNotNullParameter((Object)project, (String)"project");
        Intrinsics.checkNotNullParameter((Object)flags, (String)"flags");
        LintModelLintOptions options = project.getLintOptions();
        Set disabled = options.getDisable();
        if (!((Collection)disabled).isEmpty()) {
            for (Object id : disabled) {
                Category category = Category.Companion.getCategory((String)id);
                if (category != null) {
                    flags.addDisabledCategory(category);
                    continue;
                }
                flags.getSuppressedIds().add((String)id);
            }
        }
        if (!((Collection)(enabled = options.getEnable())).isEmpty()) {
            for (Object id : enabled) {
                Category category = Category.Companion.getCategory((String)id);
                if (category != null) {
                    flags.addEnabledCategory(category);
                    continue;
                }
                flags.getEnabledIds().add((String)id);
            }
        }
        if ((check = options.getCheck()) != null && !((Collection)check).isEmpty()) {
            for (String id : check) {
                Category category = Category.Companion.getCategory(id);
                if (category != null) {
                    flags.addExactCategory(category);
                    continue;
                }
                flags.addExactId(id);
            }
        }
        flags.setSetExitCode(options.getAbortOnError());
        flags.setFullPath(options.getAbsolutePaths());
        flags.setShowSourceLines(!options.getNoLines());
        flags.setQuiet(options.getQuiet());
        flags.setCheckAllWarnings(options.getCheckAllWarnings());
        flags.setIgnoreWarnings(options.getIgnoreWarnings());
        flags.setWarningsAsErrors(options.getWarningsAsErrors());
        flags.setCheckTestSources(options.getCheckTestSources());
        flags.setIgnoreTestSources(options.getIgnoreTestSources());
        flags.setIgnoreTestFixturesSources(options.getIgnoreTestFixturesSources());
        flags.setCheckGeneratedSources(options.getCheckGeneratedSources());
        flags.setCheckDependencies(options.getCheckDependencies());
        flags.setShowEverything(options.getShowAll());
        flags.setLintConfig(options.getLintConfig());
        flags.setExplainIssues(options.getExplainIssues());
        flags.setBaselineFile(options.getBaselineFile());
        Map severityOverrides = options.getSeverityOverrides();
        if (severityOverrides != null) {
            flags.setSeverityOverrides(severityOverrides);
        } else {
            flags.setSeverityOverrides(MapsKt.emptyMap());
        }
    }
}

