/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.lint;

import com.android.tools.lint.LintExternalAnnotationsManager;
import com.android.tools.lint.LintInferredAnnotationsManager;
import com.android.tools.lint.UastEnvironment;
import com.android.tools.lint.UastEnvironmentUtilsKt;
import com.intellij.codeInsight.CustomExceptionHandler;
import com.intellij.codeInsight.ExternalAnnotationsManager;
import com.intellij.codeInsight.InferredAnnotationsManager;
import com.intellij.core.CoreApplicationEnvironment;
import com.intellij.mock.MockProject;
import com.intellij.openapi.Disposable;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.extensions.ExtensionPointName;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.roots.LanguageLevelProjectExtension;
import com.intellij.openapi.util.Disposer;
import com.intellij.openapi.util.registry.Registry;
import com.intellij.pom.java.LanguageLevel;
import java.util.concurrent.locks.ReentrantLock;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.kotlin.cli.common.CLIConfigurationKeys;
import org.jetbrains.kotlin.cli.common.messages.GradleStyleMessageRenderer;
import org.jetbrains.kotlin.cli.common.messages.MessageRenderer;
import org.jetbrains.kotlin.cli.common.messages.PrintingMessageCollector;
import org.jetbrains.kotlin.config.CommonConfigurationKeys;
import org.jetbrains.kotlin.config.CompilerConfiguration;
import org.jetbrains.kotlin.config.JVMConfigurationKeys;
import org.jetbrains.kotlin.resolve.diagnostics.DiagnosticSuppressor;
import org.jetbrains.uast.UastLanguagePlugin;
import org.jetbrains.uast.evaluation.UEvaluatorExtension;
import org.jetbrains.uast.java.JavaUastLanguagePlugin;
import org.jetbrains.uast.kotlin.evaluation.KotlinEvaluatorExtension;

@Metadata(mv={1, 6, 0}, k=2, xi=48, d1={"\u00006\n\u0000\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\u001a$\u0010\u0006\u001a\u00020\u00072\u0006\u0010\b\u001a\u00020\t2\u0012\u0010\n\u001a\u000e\u0012\u0004\u0012\u00020\t\u0012\u0004\u0012\u00020\u00070\u000bH\u0000\u001a\u0018\u0010\f\u001a\u00020\u00072\u0006\u0010\r\u001a\u00020\u000e2\u0006\u0010\u000f\u001a\u00020\u0010H\u0000\u001a\b\u0010\u0011\u001a\u00020\u0012H\u0000\"\u000e\u0010\u0000\u001a\u00020\u0001X\u0082\u000e\u00a2\u0006\u0002\n\u0000\"\u0014\u0010\u0002\u001a\u00020\u0003X\u0080\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0004\u0010\u0005\u00a8\u0006\u0013"}, d2={"appConfigured", "", "appLock", "Ljava/util/concurrent/locks/ReentrantLock;", "getAppLock", "()Ljava/util/concurrent/locks/ReentrantLock;", "configureApplicationEnvironment", "", "appEnv", "Lcom/intellij/core/CoreApplicationEnvironment;", "configurator", "Lkotlin/Function1;", "configureProjectEnvironment", "project", "Lcom/intellij/mock/MockProject;", "config", "Lcom/android/tools/lint/UastEnvironment$Configuration;", "createCommonKotlinCompilerConfig", "Lorg/jetbrains/kotlin/config/CompilerConfiguration;", "lint-cli"})
public final class UastEnvironmentUtilsKt {
    @NotNull
    private static final ReentrantLock appLock = new ReentrantLock();
    private static boolean appConfigured;

    @NotNull
    public static final CompilerConfiguration createCommonKotlinCompilerConfig() {
        CompilerConfiguration config = new CompilerConfiguration();
        config.put(CommonConfigurationKeys.MODULE_NAME, (Object)"lint-module");
        PrintingMessageCollector logger = new PrintingMessageCollector(System.err, (MessageRenderer)new GradleStyleMessageRenderer(), false);
        config.put(CLIConfigurationKeys.MESSAGE_COLLECTOR_KEY, (Object)logger);
        config.put(JVMConfigurationKeys.USE_PSI_CLASS_FILES_READING, (Object)true);
        return config;
    }

    public static final void configureProjectEnvironment(@NotNull MockProject project, @NotNull UastEnvironment.Configuration config) {
        Intrinsics.checkNotNullParameter((Object)project, (String)"project");
        Intrinsics.checkNotNullParameter((Object)config, (String)"config");
        project.registerService(ExternalAnnotationsManager.class, LintExternalAnnotationsManager.class);
        project.registerService(InferredAnnotationsManager.class, LintInferredAnnotationsManager.class);
        LanguageLevel javaLanguageLevel = config.getJavaLanguageLevel();
        if (javaLanguageLevel != null) {
            LanguageLevelProjectExtension.getInstance((Project)((Project)project)).setLanguageLevel(javaLanguageLevel);
        }
    }

    @NotNull
    public static final ReentrantLock getAppLock() {
        return appLock;
    }

    public static final void configureApplicationEnvironment(@NotNull CoreApplicationEnvironment appEnv, @NotNull Function1<? super CoreApplicationEnvironment, Unit> configurator) {
        Intrinsics.checkNotNullParameter((Object)appEnv, (String)"appEnv");
        Intrinsics.checkNotNullParameter(configurator, (String)"configurator");
        if (!appLock.isHeldByCurrentThread()) {
            String string = "Check failed.";
            throw new IllegalStateException(string.toString());
        }
        if (appConfigured) {
            return;
        }
        if (!Logger.isInitialized()) {
            Logger.setFactory((Logger.Factory)configureApplicationEnvironment.1.INSTANCE);
        }
        Registry.markAsLoaded();
        CoreApplicationEnvironment.registerApplicationExtensionPoint((ExtensionPointName)UastLanguagePlugin.Companion.getExtensionPointName(), UastLanguagePlugin.class);
        CoreApplicationEnvironment.registerApplicationExtensionPoint((ExtensionPointName)UEvaluatorExtension.Companion.getEXTENSION_POINT_NAME(), UEvaluatorExtension.class);
        appEnv.addExtension(UastLanguagePlugin.Companion.getExtensionPointName(), (Object)new JavaUastLanguagePlugin());
        appEnv.addExtension(UEvaluatorExtension.Companion.getEXTENSION_POINT_NAME(), (Object)new KotlinEvaluatorExtension());
        configurator.invoke((Object)appEnv);
        CoreApplicationEnvironment.registerApplicationExtensionPoint((ExtensionPointName)CustomExceptionHandler.KEY, CustomExceptionHandler.class);
        CoreApplicationEnvironment.registerApplicationExtensionPoint((ExtensionPointName)DiagnosticSuppressor.Companion.getEP_NAME(), DiagnosticSuppressor.class);
        appConfigured = true;
        Disposer.register((Disposable)appEnv.getParentDisposable(), (Disposable)configureApplicationEnvironment.2.INSTANCE);
    }

    public static final /* synthetic */ void access$setAppConfigured$p(boolean bl) {
        appConfigured = bl;
    }
}

