/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.apk.analyzer.internal;

import com.google.common.collect.Iterators;
import java.io.IOException;
import java.nio.file.DirectoryStream;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;

public class ProguardMappingFiles {
    private static final String EXT = ".txt";
    private static final String MAPPING_BASE = "mapping";
    private static final String USAGE_BASE = "usage";
    private static final String SEEDS_BASE = "seeds";
    private static final String MAPPING_FILENAME = "mapping.txt";
    private static final String USAGE_FILENAME = "usage.txt";
    private static final String SEEDS_FILENAME = "seeds.txt";
    public final Path mappingFile;
    public final Path seedsFile;
    public final Path usageFile;

    public ProguardMappingFiles(Path mappingFile, Path seedsFile, Path usageFile) {
        this.mappingFile = mappingFile;
        this.seedsFile = seedsFile;
        this.usageFile = usageFile;
    }

    public static ProguardMappingFiles from(Path[] paths) throws IOException {
        if (paths.length == 0) {
            return new ProguardMappingFiles(null, null, null);
        }
        if (paths.length > 1) {
            for (Path path : paths) {
                if (!Files.isDirectory(path, new LinkOption[0])) continue;
                throw new IllegalArgumentException("Please select a folder or 1 to 3 files for loading Proguard mappings.");
            }
        }
        Path[] filesToCheck = null;
        if (Files.isDirectory(paths[0], new LinkOption[0])) {
            try (DirectoryStream<Path> stream = Files.newDirectoryStream(paths[0], "*{mapping,usage,seeds}*.txt");){
                filesToCheck = (Path[])Iterators.toArray(stream.iterator(), Path.class);
            }
        } else {
            filesToCheck = paths;
        }
        Path mappingFile = null;
        Path seedsFile = null;
        Path usageFile = null;
        for (Path file : filesToCheck) {
            if (mappingFile == null && file.getFileName().toString().equals(MAPPING_FILENAME)) {
                mappingFile = file;
            }
            if (seedsFile == null && file.getFileName().toString().equals(SEEDS_FILENAME)) {
                seedsFile = file;
            }
            if (usageFile != null || !file.getFileName().toString().equals(USAGE_FILENAME)) continue;
            usageFile = file;
        }
        if (mappingFile == null || usageFile == null || seedsFile == null) {
            for (Path file : filesToCheck) {
                if (mappingFile == null && file.getFileName().toString().contains(MAPPING_BASE)) {
                    mappingFile = file;
                } else if (usageFile == null && file.getFileName().toString().contains(SEEDS_BASE)) {
                    usageFile = file;
                } else if (seedsFile == null && file.getFileName().toString().contains(USAGE_BASE)) {
                    seedsFile = file;
                }
                if (mappingFile != null && usageFile != null && seedsFile != null) break;
            }
        }
        return new ProguardMappingFiles(mappingFile, seedsFile, usageFile);
    }
}

