/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.lang.jvm.util;

import com.intellij.lang.jvm.JvmClass;
import com.intellij.lang.jvm.JvmClassKind;
import com.intellij.lang.jvm.JvmMethod;
import com.intellij.lang.jvm.JvmModifier;
import com.intellij.lang.jvm.JvmParameter;
import com.intellij.lang.jvm.types.JvmArrayType;
import com.intellij.lang.jvm.types.JvmPrimitiveType;
import com.intellij.lang.jvm.types.JvmPrimitiveTypeKind;
import com.intellij.lang.jvm.types.JvmReferenceType;
import com.intellij.lang.jvm.types.JvmType;
import com.intellij.lang.jvm.util.JvmHierarchyUtil;
import com.intellij.lang.jvm.util.JvmUtil;
import com.intellij.util.containers.ContainerUtil;
import java.util.Objects;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public final class JvmMainMethodUtil {
    private static final String MAIN = "main";

    private JvmMainMethodUtil() {
    }

    public static boolean isMainMethod(@NotNull JvmMethod method) {
        if (method == null) {
            JvmMainMethodUtil.$$$reportNull$$$0(0);
        }
        if (!MAIN.equals(method.getName())) {
            return false;
        }
        JvmClass containingClass = method.getContainingClass();
        return containingClass != null && JvmMainMethodUtil.canBeMainClass(containingClass) && JvmMainMethodUtil.hasMainMethodSignature(method);
    }

    public static boolean hasMainMethodInHierarchy(@NotNull JvmClass clazz) {
        if (clazz == null) {
            JvmMainMethodUtil.$$$reportNull$$$0(1);
        }
        if (!JvmMainMethodUtil.canBeMainClass(clazz)) {
            return false;
        }
        return JvmMainMethodUtil.findMainMethodInHierarchy(clazz) != null;
    }

    private static boolean canBeMainClass(@NotNull JvmClass clazz) {
        if (clazz == null) {
            JvmMainMethodUtil.$$$reportNull$$$0(2);
        }
        if (clazz.getName() == null) {
            return false;
        }
        JvmClassKind kind = clazz.getClassKind();
        if (kind == JvmClassKind.ANNOTATION) {
            return false;
        }
        return clazz.getContainingClass() == null || clazz.hasModifier(JvmModifier.STATIC);
    }

    @Nullable
    private static JvmMethod findMainMethodInHierarchy(@NotNull JvmClass clazz) {
        if (clazz == null) {
            JvmMainMethodUtil.$$$reportNull$$$0(3);
        }
        return JvmHierarchyUtil.traverseSupers(clazz, superClazz -> {
            if (superClazz.getClassKind() == JvmClassKind.INTERFACE) {
                return null;
            }
            return JvmMainMethodUtil.findMainMethodInClass(superClazz);
        });
    }

    @Nullable
    private static JvmMethod findMainMethodInClass(@NotNull JvmClass clazz) {
        if (clazz == null) {
            JvmMainMethodUtil.$$$reportNull$$$0(4);
        }
        JvmMethod[] candidates = clazz.findMethodsByName(MAIN);
        return ContainerUtil.find(candidates, JvmMainMethodUtil::hasMainMethodSignature);
    }

    private static boolean hasMainMethodSignature(@NotNull JvmMethod method) {
        if (method == null) {
            JvmMainMethodUtil.$$$reportNull$$$0(5);
        }
        if (method.isConstructor()) {
            return false;
        }
        if (!method.hasModifier(JvmModifier.PUBLIC)) {
            return false;
        }
        if (!method.hasModifier(JvmModifier.STATIC)) {
            return false;
        }
        JvmType returnType = Objects.requireNonNull(method.getReturnType(), () -> "Non-constructors should have return type: " + method);
        if (!JvmMainMethodUtil.isVoid(returnType)) {
            return false;
        }
        JvmParameter[] parameters = method.getParameters();
        if (parameters.length != 1) {
            return false;
        }
        return JvmMainMethodUtil.isStringArray(parameters[0].getType());
    }

    private static boolean isVoid(@NotNull JvmType type) {
        if (type == null) {
            JvmMainMethodUtil.$$$reportNull$$$0(6);
        }
        return type instanceof JvmPrimitiveType && ((JvmPrimitiveType)type).getKind() == JvmPrimitiveTypeKind.VOID;
    }

    private static boolean isStringArray(@NotNull JvmType type) {
        if (type == null) {
            JvmMainMethodUtil.$$$reportNull$$$0(7);
        }
        if (!(type instanceof JvmArrayType)) {
            return false;
        }
        JvmType componentType = ((JvmArrayType)type).getComponentType();
        if (!(componentType instanceof JvmReferenceType)) {
            return false;
        }
        JvmClass resolved = JvmUtil.resolveClass((JvmReferenceType)componentType);
        return resolved != null && "java.lang.String".equals(resolved.getQualifiedName());
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[3];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "method";
                break;
            }
            case 1: 
            case 2: 
            case 3: 
            case 4: {
                objectArray2 = objectArray3;
                objectArray3[0] = "clazz";
                break;
            }
            case 6: 
            case 7: {
                objectArray2 = objectArray3;
                objectArray3[0] = "type";
                break;
            }
        }
        objectArray2[1] = "com/intellij/lang/jvm/util/JvmMainMethodUtil";
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[2] = "isMainMethod";
                break;
            }
            case 1: {
                objectArray = objectArray2;
                objectArray2[2] = "hasMainMethodInHierarchy";
                break;
            }
            case 2: {
                objectArray = objectArray2;
                objectArray2[2] = "canBeMainClass";
                break;
            }
            case 3: {
                objectArray = objectArray2;
                objectArray2[2] = "findMainMethodInHierarchy";
                break;
            }
            case 4: {
                objectArray = objectArray2;
                objectArray2[2] = "findMainMethodInClass";
                break;
            }
            case 5: {
                objectArray = objectArray2;
                objectArray2[2] = "hasMainMethodSignature";
                break;
            }
            case 6: {
                objectArray = objectArray2;
                objectArray2[2] = "isVoid";
                break;
            }
            case 7: {
                objectArray = objectArray2;
                objectArray2[2] = "isStringArray";
                break;
            }
        }
        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
    }
}

