/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.model.psi.impl;

import com.intellij.model.psi.PsiExternalReferenceHost;
import com.intellij.model.psi.PsiSymbolReference;
import com.intellij.model.psi.PsiSymbolReferenceHints;
import com.intellij.model.psi.PsiSymbolReferenceProvider;
import com.intellij.model.psi.PsiSymbolReferenceProviderBean;
import com.intellij.model.psi.PsiSymbolReferenceService;
import com.intellij.model.psi.impl.ReferenceProviders;
import com.intellij.psi.PsiElement;
import com.intellij.psi.util.CachedValueProvider;
import com.intellij.psi.util.CachedValuesManager;
import com.intellij.psi.util.PsiModificationTracker;
import com.intellij.util.SmartList;
import com.intellij.util.containers.ContainerUtil;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import org.jetbrains.annotations.ApiStatus;
import org.jetbrains.annotations.NotNull;

@ApiStatus.Internal
final class PsiSymbolReferenceServiceImpl
implements PsiSymbolReferenceService {
    private static final PsiSymbolReferenceHints EMPTY_HINTS = new PsiSymbolReferenceHints(){};

    PsiSymbolReferenceServiceImpl() {
    }

    @Override
    @NotNull
    public Collection<? extends PsiSymbolReference> getReferences(@NotNull PsiElement element) {
        if (element == null) {
            PsiSymbolReferenceServiceImpl.$$$reportNull$$$0(0);
        }
        Collection collection = (Collection)CachedValuesManager.getCachedValue(element, () -> CachedValueProvider.Result.create(Collections.unmodifiableList(this.getReferences(element, EMPTY_HINTS)), PsiModificationTracker.MODIFICATION_COUNT));
        if (collection == null) {
            PsiSymbolReferenceServiceImpl.$$$reportNull$$$0(1);
        }
        return collection;
    }

    @Override
    @NotNull
    public <T extends PsiSymbolReference> Collection<T> getReferences(@NotNull PsiElement host, @NotNull Class<T> referenceClass) {
        if (host == null) {
            PsiSymbolReferenceServiceImpl.$$$reportNull$$$0(2);
        }
        if (referenceClass == null) {
            PsiSymbolReferenceServiceImpl.$$$reportNull$$$0(3);
        }
        Collection collection = this.getReferences(host, PsiSymbolReferenceHints.referenceClassHint(referenceClass));
        if (collection == null) {
            PsiSymbolReferenceServiceImpl.$$$reportNull$$$0(4);
        }
        return collection;
    }

    @NotNull
    public List<PsiSymbolReference> getReferences(@NotNull PsiElement element, @NotNull PsiSymbolReferenceHints hints) {
        ArrayList<PsiSymbolReference> result2;
        if (element == null) {
            PsiSymbolReferenceServiceImpl.$$$reportNull$$$0(5);
        }
        if (hints == null) {
            PsiSymbolReferenceServiceImpl.$$$reportNull$$$0(6);
        }
        if ((result2 = new ArrayList<PsiSymbolReference>(element.getOwnReferences())).isEmpty() && element instanceof PsiExternalReferenceHost) {
            result2.addAll(PsiSymbolReferenceServiceImpl.doGetExternalReferences((PsiExternalReferenceHost)element, hints));
        }
        return PsiSymbolReferenceServiceImpl.applyHints(result2, hints);
    }

    @Override
    @NotNull
    public Collection<? extends PsiSymbolReference> getExternalReferences(@NotNull PsiExternalReferenceHost element, @NotNull PsiSymbolReferenceHints hints) {
        if (element == null) {
            PsiSymbolReferenceServiceImpl.$$$reportNull$$$0(7);
        }
        if (hints == null) {
            PsiSymbolReferenceServiceImpl.$$$reportNull$$$0(8);
        }
        return PsiSymbolReferenceServiceImpl.applyHints(PsiSymbolReferenceServiceImpl.doGetExternalReferences(element, hints), hints);
    }

    @NotNull
    private static List<PsiSymbolReference> doGetExternalReferences(@NotNull PsiExternalReferenceHost element, @NotNull PsiSymbolReferenceHints hints) {
        List<PsiSymbolReferenceProviderBean> beans;
        if (element == null) {
            PsiSymbolReferenceServiceImpl.$$$reportNull$$$0(9);
        }
        if (hints == null) {
            PsiSymbolReferenceServiceImpl.$$$reportNull$$$0(10);
        }
        if ((beans = ReferenceProviders.byLanguage(element.getLanguage()).byHostClass(element.getClass())).isEmpty()) {
            List<PsiSymbolReference> list = Collections.emptyList();
            if (list == null) {
                PsiSymbolReferenceServiceImpl.$$$reportNull$$$0(11);
            }
            return list;
        }
        Class<? extends PsiSymbolReference> requiredReferenceClass = hints.getReferenceClass();
        SmartList<PsiSymbolReference> result2 = new SmartList<PsiSymbolReference>();
        for (PsiSymbolReferenceProviderBean bean : beans) {
            if (requiredReferenceClass != PsiSymbolReference.class && !bean.anyReferenceClass && !requiredReferenceClass.isAssignableFrom(bean.getReferenceClass())) continue;
            result2.addAll(((PsiSymbolReferenceProvider)bean.getInstance()).getReferences(element, hints));
        }
        SmartList<PsiSymbolReference> smartList = result2;
        if (smartList == null) {
            PsiSymbolReferenceServiceImpl.$$$reportNull$$$0(12);
        }
        return smartList;
    }

    @NotNull
    private static List<PsiSymbolReference> applyHints(@NotNull List<PsiSymbolReference> references, @NotNull PsiSymbolReferenceHints hints) {
        int offsetInElement;
        if (references == null) {
            PsiSymbolReferenceServiceImpl.$$$reportNull$$$0(13);
        }
        if (hints == null) {
            PsiSymbolReferenceServiceImpl.$$$reportNull$$$0(14);
        }
        if (hints == EMPTY_HINTS) {
            List<PsiSymbolReference> list = references;
            if (list == null) {
                PsiSymbolReferenceServiceImpl.$$$reportNull$$$0(15);
            }
            return list;
        }
        List<PsiSymbolReference> result2 = references;
        Class<? extends PsiSymbolReference> referenceClass = hints.getReferenceClass();
        if (referenceClass != PsiSymbolReference.class) {
            result2 = ContainerUtil.filterIsInstance(result2, referenceClass);
        }
        if ((offsetInElement = hints.getOffsetInElement()) >= 0) {
            result2 = ContainerUtil.filter(result2, it -> it.getRangeInElement().containsOffset(offsetInElement));
        }
        List<PsiSymbolReference> list = result2;
        if (list == null) {
            PsiSymbolReferenceServiceImpl.$$$reportNull$$$0(16);
        }
        return list;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string2;
        switch (n) {
            default: {
                string2 = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 1: 
            case 4: 
            case 11: 
            case 12: 
            case 15: 
            case 16: {
                string2 = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 1: 
            case 4: 
            case 11: 
            case 12: 
            case 15: 
            case 16: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "element";
                break;
            }
            case 1: 
            case 4: 
            case 11: 
            case 12: 
            case 15: 
            case 16: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/model/psi/impl/PsiSymbolReferenceServiceImpl";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "host";
                break;
            }
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "referenceClass";
                break;
            }
            case 6: 
            case 8: 
            case 10: 
            case 14: {
                objectArray2 = objectArray3;
                objectArray3[0] = "hints";
                break;
            }
            case 13: {
                objectArray2 = objectArray3;
                objectArray3[0] = "references";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/model/psi/impl/PsiSymbolReferenceServiceImpl";
                break;
            }
            case 1: 
            case 4: {
                objectArray = objectArray2;
                objectArray2[1] = "getReferences";
                break;
            }
            case 11: 
            case 12: {
                objectArray = objectArray2;
                objectArray2[1] = "doGetExternalReferences";
                break;
            }
            case 15: 
            case 16: {
                objectArray = objectArray2;
                objectArray2[1] = "applyHints";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "getReferences";
                break;
            }
            case 1: 
            case 4: 
            case 11: 
            case 12: 
            case 15: 
            case 16: {
                break;
            }
            case 7: 
            case 8: {
                objectArray = objectArray;
                objectArray[2] = "getExternalReferences";
                break;
            }
            case 9: 
            case 10: {
                objectArray = objectArray;
                objectArray[2] = "doGetExternalReferences";
                break;
            }
            case 13: 
            case 14: {
                objectArray = objectArray;
                objectArray[2] = "applyHints";
                break;
            }
        }
        String string3 = String.format(string2, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string3);
                break;
            }
            case 1: 
            case 4: 
            case 11: 
            case 12: 
            case 15: 
            case 16: {
                runtimeException = new IllegalStateException(string3);
                break;
            }
        }
        throw runtimeException;
    }
}

