/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.openapi.editor.ex.util;

import com.intellij.openapi.editor.ex.util.DataStorage;
import com.intellij.openapi.editor.ex.util.SegmentArray;
import com.intellij.psi.tree.IElementType;
import com.intellij.util.ArrayUtil;
import org.jetbrains.annotations.NotNull;

public class SegmentArrayWithData
extends SegmentArray {
    private DataStorage myStorage;

    public SegmentArrayWithData(DataStorage storage) {
        this.myStorage = storage;
    }

    public DataStorage createStorage() {
        return this.myStorage.createStorage();
    }

    public void setElementAt(int i, int startOffset, int endOffset, int data) {
        this.setElementAt(i, startOffset, endOffset);
        this.myStorage.setData(i, data);
    }

    @Override
    public void remove(int startIndex, int endIndex) {
        this.myStorage.remove(startIndex, endIndex, this.mySegmentCount);
        super.remove(startIndex, endIndex);
    }

    public void replace(int startIndex, int endIndex, @NotNull SegmentArrayWithData newData) {
        if (newData == null) {
            SegmentArrayWithData.$$$reportNull$$$0(0);
        }
        int oldLen = endIndex - startIndex;
        int newLen = newData.getSegmentCount();
        int delta = newLen - oldLen;
        if (delta < 0) {
            this.remove(endIndex + delta, endIndex);
        } else if (delta > 0) {
            SegmentArrayWithData deltaData = new SegmentArrayWithData(this.myStorage.createStorage());
            for (int i = oldLen; i < newLen; ++i) {
                deltaData.setElementAt(i - oldLen, newData.getSegmentStart(i), newData.getSegmentEnd(i), newData.getSegmentData(i));
            }
            this.insert(deltaData, startIndex + oldLen);
        }
        int common = Math.min(newLen, oldLen);
        this.replace(startIndex, newData, common);
    }

    protected void replace(int startOffset, @NotNull SegmentArrayWithData data, int len) {
        if (data == null) {
            SegmentArrayWithData.$$$reportNull$$$0(1);
        }
        this.myStorage.replace(data.myStorage, startOffset, len);
        super.replace(startOffset, data, len);
    }

    public void insert(@NotNull SegmentArrayWithData segmentArray, int startIndex) {
        if (segmentArray == null) {
            SegmentArrayWithData.$$$reportNull$$$0(2);
        }
        this.myStorage.insert(segmentArray.myStorage, startIndex, segmentArray.getSegmentCount(), this.mySegmentCount);
        super.insert(segmentArray, startIndex);
    }

    public int getSegmentData(int index) {
        if (index < 0 || index >= this.mySegmentCount) {
            throw new IndexOutOfBoundsException("Wrong index: " + index);
        }
        return this.myStorage.getData(index);
    }

    protected static int @NotNull [] reallocateArray(int @NotNull [] array, int index) {
        if (array == null) {
            SegmentArrayWithData.$$$reportNull$$$0(3);
        }
        if (index < array.length) {
            if (array == null) {
                SegmentArrayWithData.$$$reportNull$$$0(4);
            }
            return array;
        }
        int[] nArray = ArrayUtil.realloc(array, SegmentArrayWithData.calcCapacity(array.length, index));
        if (nArray == null) {
            SegmentArrayWithData.$$$reportNull$$$0(5);
        }
        return nArray;
    }

    public SegmentArrayWithData copy() {
        SegmentArrayWithData sa = new SegmentArrayWithData(this.createStorage());
        sa.mySegmentCount = this.mySegmentCount;
        sa.myStarts = (int[])this.myStarts.clone();
        sa.myEnds = (int[])this.myEnds.clone();
        sa.myStorage = this.myStorage.copy();
        return sa;
    }

    public int unpackStateFromData(int data) {
        return this.myStorage.unpackStateFromData(data);
    }

    @NotNull
    public IElementType unpackTokenFromData(int data) {
        IElementType iElementType = this.myStorage.unpackTokenFromData(data);
        if (iElementType == null) {
            SegmentArrayWithData.$$$reportNull$$$0(6);
        }
        return iElementType;
    }

    public int packData(IElementType tokenType, int state, boolean isRestartableState) {
        return this.myStorage.packData(tokenType, state, isRestartableState);
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string2;
        switch (n) {
            default: {
                string2 = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 4: 
            case 5: 
            case 6: {
                string2 = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 4: 
            case 5: 
            case 6: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "newData";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "data";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "segmentArray";
                break;
            }
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "array";
                break;
            }
            case 4: 
            case 5: 
            case 6: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/openapi/editor/ex/util/SegmentArrayWithData";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/openapi/editor/ex/util/SegmentArrayWithData";
                break;
            }
            case 4: 
            case 5: {
                objectArray = objectArray2;
                objectArray2[1] = "reallocateArray";
                break;
            }
            case 6: {
                objectArray = objectArray2;
                objectArray2[1] = "unpackTokenFromData";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "replace";
                break;
            }
            case 2: {
                objectArray = objectArray;
                objectArray[2] = "insert";
                break;
            }
            case 3: {
                objectArray = objectArray;
                objectArray[2] = "reallocateArray";
                break;
            }
            case 4: 
            case 5: 
            case 6: {
                break;
            }
        }
        String string3 = String.format(string2, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string3);
                break;
            }
            case 4: 
            case 5: 
            case 6: {
                runtimeException = new IllegalStateException(string3);
                break;
            }
        }
        throw runtimeException;
    }
}

