/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.openapi.editor.markup;

import com.intellij.openapi.editor.markup.EffectType;
import com.intellij.openapi.editor.markup.TextAttributesEffectsBuilder;
import com.intellij.openapi.util.Comparing;
import com.intellij.openapi.util.DefaultJDOMExternalizer;
import com.intellij.openapi.util.InvalidDataException;
import com.intellij.openapi.util.JDOMExternalizerUtil;
import com.intellij.util.ConcurrencyUtil;
import java.awt.Color;
import java.util.Collections;
import java.util.EnumMap;
import java.util.Map;
import java.util.Objects;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentMap;
import org.intellij.lang.annotations.JdkConstants;
import org.jdom.Element;
import org.jetbrains.annotations.ApiStatus;
import org.jetbrains.annotations.NonNls;
import org.jetbrains.annotations.NotNull;

public final class AttributesFlyweight {
    private static final ConcurrentMap<FlyweightKey, AttributesFlyweight> entries = new ConcurrentHashMap<FlyweightKey, AttributesFlyweight>();
    private static final ThreadLocal<FlyweightKey> ourKey = new ThreadLocal();
    private final int myHashCode;
    private final Color myForeground;
    private final Color myBackground;
    @JdkConstants.FontStyle
    private final int myFontType;
    private final Color myEffectColor;
    private final EffectType myEffectType;
    @NotNull
    private final @NotNull Map<@NotNull EffectType, ? extends @NotNull Color> myAdditionalEffects;
    private final Color myErrorStripeColor;
    private static final int EFFECT_BORDER = 0;
    private static final int EFFECT_LINE = 1;
    private static final int EFFECT_WAVE = 2;
    private static final int EFFECT_STRIKEOUT = 3;
    private static final int EFFECT_BOLD_LINE = 4;
    private static final int EFFECT_BOLD_DOTTED_LINE = 5;

    @NotNull
    public static AttributesFlyweight create(Color foreground, Color background, @JdkConstants.FontStyle int fontType, Color effectColor, EffectType effectType, Color errorStripeColor) {
        return AttributesFlyweight.create(foreground, background, fontType, effectColor, effectType, Collections.emptyMap(), errorStripeColor);
    }

    @ApiStatus.Experimental
    @NotNull
    public static AttributesFlyweight create(Color foreground, Color background, @JdkConstants.FontStyle int fontType, Color effectColor, EffectType effectType, @NotNull @NotNull Map<@NotNull EffectType, ? extends @NotNull Color> additionalEffects, Color errorStripeColor) {
        FlyweightKey key;
        if (additionalEffects == null) {
            AttributesFlyweight.$$$reportNull$$$0(0);
        }
        if ((key = ourKey.get()) == null) {
            key = new FlyweightKey();
            ourKey.set(key);
        }
        key.foreground = foreground;
        key.background = background;
        key.fontType = fontType;
        key.effectColor = effectColor;
        key.effectType = effectType;
        key.myAdditionalEffects = additionalEffects.isEmpty() ? Collections.emptyMap() : new EnumMap<EffectType, Color>(additionalEffects);
        key.errorStripeColor = errorStripeColor;
        AttributesFlyweight flyweight = (AttributesFlyweight)entries.get(key);
        if (flyweight != null) {
            AttributesFlyweight attributesFlyweight = flyweight;
            if (attributesFlyweight == null) {
                AttributesFlyweight.$$$reportNull$$$0(1);
            }
            return attributesFlyweight;
        }
        AttributesFlyweight attributesFlyweight = ConcurrencyUtil.cacheOrGet(entries, key.clone(), new AttributesFlyweight(key));
        if (attributesFlyweight == null) {
            AttributesFlyweight.$$$reportNull$$$0(2);
        }
        return attributesFlyweight;
    }

    private AttributesFlyweight(@NotNull FlyweightKey key) {
        if (key == null) {
            AttributesFlyweight.$$$reportNull$$$0(3);
        }
        this.myForeground = key.foreground;
        this.myBackground = key.background;
        this.myFontType = key.fontType;
        this.myEffectColor = key.effectColor;
        this.myEffectType = key.effectType;
        this.myErrorStripeColor = key.errorStripeColor;
        this.myAdditionalEffects = key.myAdditionalEffects;
        this.myHashCode = key.hashCode();
    }

    @NotNull
    static AttributesFlyweight create(@NotNull Element element) throws InvalidDataException {
        if (element == null) {
            AttributesFlyweight.$$$reportNull$$$0(4);
        }
        Color FOREGROUND = DefaultJDOMExternalizer.toColor(JDOMExternalizerUtil.readField(element, "FOREGROUND"));
        Color BACKGROUND = DefaultJDOMExternalizer.toColor(JDOMExternalizerUtil.readField(element, "BACKGROUND"));
        Color EFFECT_COLOR = DefaultJDOMExternalizer.toColor(JDOMExternalizerUtil.readField(element, "EFFECT_COLOR"));
        Color ERROR_STRIPE_COLOR = DefaultJDOMExternalizer.toColor(JDOMExternalizerUtil.readField(element, "ERROR_STRIPE_COLOR"));
        int fontType = DefaultJDOMExternalizer.toInt(JDOMExternalizerUtil.readField(element, "FONT_TYPE", "0"));
        if (fontType < 0 || fontType > 3) {
            fontType = 0;
        }
        int FONT_TYPE = fontType;
        int EFFECT_TYPE = DefaultJDOMExternalizer.toInt(JDOMExternalizerUtil.readField(element, "EFFECT_TYPE", "0"));
        return AttributesFlyweight.create(FOREGROUND, BACKGROUND, FONT_TYPE, EFFECT_COLOR, AttributesFlyweight.toEffectType(EFFECT_TYPE), Collections.emptyMap(), ERROR_STRIPE_COLOR);
    }

    private static void writeColor(@NotNull Element element, @NotNull String fieldName, Color color) {
        if (element == null) {
            AttributesFlyweight.$$$reportNull$$$0(5);
        }
        if (fieldName == null) {
            AttributesFlyweight.$$$reportNull$$$0(6);
        }
        if (color != null) {
            String string2 = Integer.toString(color.getRGB() & 0xFFFFFF, 16);
            JDOMExternalizerUtil.writeField(element, fieldName, string2);
        }
    }

    void writeExternal(@NotNull Element element) {
        if (element == null) {
            AttributesFlyweight.$$$reportNull$$$0(7);
        }
        AttributesFlyweight.writeColor(element, "FOREGROUND", this.getForeground());
        AttributesFlyweight.writeColor(element, "BACKGROUND", this.getBackground());
        int fontType = this.getFontType();
        if (fontType != 0) {
            JDOMExternalizerUtil.writeField(element, "FONT_TYPE", String.valueOf(fontType));
        }
        AttributesFlyweight.writeColor(element, "EFFECT_COLOR", this.getEffectColor());
        AttributesFlyweight.writeColor(element, "ERROR_STRIPE_COLOR", this.getErrorStripeColor());
        int effectType = AttributesFlyweight.fromEffectType(this.getEffectType());
        if (effectType != 0) {
            JDOMExternalizerUtil.writeField(element, "EFFECT_TYPE", String.valueOf(effectType));
        }
    }

    private static int fromEffectType(EffectType effectType) {
        if (effectType == null) {
            return -1;
        }
        switch (effectType) {
            case BOXED: {
                return 0;
            }
            case LINE_UNDERSCORE: {
                return 1;
            }
            case BOLD_LINE_UNDERSCORE: {
                return 4;
            }
            case STRIKEOUT: {
                return 3;
            }
            case WAVE_UNDERSCORE: {
                return 2;
            }
            case BOLD_DOTTED_LINE: {
                return 5;
            }
        }
        return -1;
    }

    private static EffectType toEffectType(int effectType) {
        switch (effectType) {
            case 0: {
                return EffectType.BOXED;
            }
            case 4: {
                return EffectType.BOLD_LINE_UNDERSCORE;
            }
            case 1: {
                return EffectType.LINE_UNDERSCORE;
            }
            case 3: {
                return EffectType.STRIKEOUT;
            }
            case 2: {
                return EffectType.WAVE_UNDERSCORE;
            }
            case 5: {
                return EffectType.BOLD_DOTTED_LINE;
            }
        }
        return null;
    }

    public Color getForeground() {
        return this.myForeground;
    }

    public Color getBackground() {
        return this.myBackground;
    }

    @JdkConstants.FontStyle
    public int getFontType() {
        return this.myFontType;
    }

    public Color getEffectColor() {
        return this.myEffectColor;
    }

    public EffectType getEffectType() {
        return this.myEffectType;
    }

    @NotNull
    @NotNull Map<@NotNull EffectType, ? extends @NotNull Color> getAdditionalEffects() {
        Map<EffectType, ? extends Color> map2 = this.myAdditionalEffects;
        if (map2 == null) {
            AttributesFlyweight.$$$reportNull$$$0(8);
        }
        return map2;
    }

    @ApiStatus.Experimental
    public boolean hasEffects() {
        return this.myEffectColor != null && this.myEffectType != null || !this.myAdditionalEffects.isEmpty();
    }

    @NotNull
    Map<EffectType, Color> getAllEffects() {
        if (this.myAdditionalEffects.isEmpty()) {
            Map<EffectType, Color> map2 = this.myEffectType == null || this.myEffectColor == null ? Collections.emptyMap() : Collections.singletonMap(this.myEffectType, this.myEffectColor);
            if (map2 == null) {
                AttributesFlyweight.$$$reportNull$$$0(9);
            }
            return map2;
        }
        TextAttributesEffectsBuilder builder = TextAttributesEffectsBuilder.create();
        this.myAdditionalEffects.forEach(builder::coverWith);
        builder.coverWith(this.myEffectType, this.myEffectColor);
        Map<EffectType, Color> map3 = builder.getEffectsMap();
        if (map3 == null) {
            AttributesFlyweight.$$$reportNull$$$0(10);
        }
        return map3;
    }

    Color getErrorStripeColor() {
        return this.myErrorStripeColor;
    }

    @NotNull
    public AttributesFlyweight withForeground(Color foreground) {
        return Comparing.equal(foreground, this.myForeground) ? this : AttributesFlyweight.create(foreground, this.myBackground, this.myFontType, this.myEffectColor, this.myEffectType, this.myAdditionalEffects, this.myErrorStripeColor);
    }

    @NotNull
    public AttributesFlyweight withBackground(Color background) {
        return Comparing.equal(background, this.myBackground) ? this : AttributesFlyweight.create(this.myForeground, background, this.myFontType, this.myEffectColor, this.myEffectType, this.myAdditionalEffects, this.myErrorStripeColor);
    }

    @NotNull
    public AttributesFlyweight withFontType(@JdkConstants.FontStyle int fontType) {
        return fontType == this.myFontType ? this : AttributesFlyweight.create(this.myForeground, this.myBackground, fontType, this.myEffectColor, this.myEffectType, this.myAdditionalEffects, this.myErrorStripeColor);
    }

    @NotNull
    public AttributesFlyweight withEffectColor(Color effectColor) {
        return Comparing.equal(effectColor, this.myEffectColor) ? this : AttributesFlyweight.create(this.myForeground, this.myBackground, this.myFontType, effectColor, this.myEffectType, this.myAdditionalEffects, this.myErrorStripeColor);
    }

    @NotNull
    public AttributesFlyweight withEffectType(EffectType effectType) {
        return Comparing.equal(effectType, this.myEffectType) ? this : AttributesFlyweight.create(this.myForeground, this.myBackground, this.myFontType, this.myEffectColor, effectType, this.myAdditionalEffects, this.myErrorStripeColor);
    }

    @NotNull
    public AttributesFlyweight withErrorStripeColor(Color stripeColor) {
        return Comparing.equal(stripeColor, this.myErrorStripeColor) ? this : AttributesFlyweight.create(this.myForeground, this.myBackground, this.myFontType, this.myEffectColor, this.myEffectType, this.myAdditionalEffects, stripeColor);
    }

    @ApiStatus.Experimental
    @NotNull
    public AttributesFlyweight withAdditionalEffects(@NotNull @NotNull Map<@NotNull EffectType, ? extends @NotNull Color> additionalEffects) {
        if (additionalEffects == null) {
            AttributesFlyweight.$$$reportNull$$$0(11);
        }
        return Comparing.equal(additionalEffects, this.myAdditionalEffects) ? this : AttributesFlyweight.create(this.myForeground, this.myBackground, this.myFontType, this.myEffectColor, this.myEffectType, additionalEffects, this.myErrorStripeColor);
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        AttributesFlyweight that = (AttributesFlyweight)o;
        if (this.myFontType != that.myFontType) {
            return false;
        }
        if (!Objects.equals(this.myBackground, that.myBackground)) {
            return false;
        }
        if (!Objects.equals(this.myEffectColor, that.myEffectColor)) {
            return false;
        }
        if (this.myEffectType != that.myEffectType) {
            return false;
        }
        if (!Objects.equals(this.myErrorStripeColor, that.myErrorStripeColor)) {
            return false;
        }
        if (!Objects.equals(this.myForeground, that.myForeground)) {
            return false;
        }
        return this.myAdditionalEffects.equals(that.myAdditionalEffects);
    }

    public int hashCode() {
        return this.myHashCode;
    }

    @NonNls
    public String toString() {
        return "AttributesFlyweight{myForeground=" + this.myForeground + ", myBackground=" + this.myBackground + ", myFontType=" + this.myFontType + ", myEffectColor=" + this.myEffectColor + ", myEffectType=" + (Object)((Object)this.myEffectType) + ", myErrorStripeColor=" + this.myErrorStripeColor + '}';
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string2;
        switch (n) {
            default: {
                string2 = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 1: 
            case 2: 
            case 8: 
            case 9: 
            case 10: {
                string2 = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 1: 
            case 2: 
            case 8: 
            case 9: 
            case 10: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "additionalEffects";
                break;
            }
            case 1: 
            case 2: 
            case 8: 
            case 9: 
            case 10: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/openapi/editor/markup/AttributesFlyweight";
                break;
            }
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "key";
                break;
            }
            case 4: 
            case 5: 
            case 7: {
                objectArray2 = objectArray3;
                objectArray3[0] = "element";
                break;
            }
            case 6: {
                objectArray2 = objectArray3;
                objectArray3[0] = "fieldName";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/openapi/editor/markup/AttributesFlyweight";
                break;
            }
            case 1: 
            case 2: {
                objectArray = objectArray2;
                objectArray2[1] = "create";
                break;
            }
            case 8: {
                objectArray = objectArray2;
                objectArray2[1] = "getAdditionalEffects";
                break;
            }
            case 9: 
            case 10: {
                objectArray = objectArray2;
                objectArray2[1] = "getAllEffects";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "create";
                break;
            }
            case 1: 
            case 2: 
            case 8: 
            case 9: 
            case 10: {
                break;
            }
            case 3: {
                objectArray = objectArray;
                objectArray[2] = "<init>";
                break;
            }
            case 5: 
            case 6: {
                objectArray = objectArray;
                objectArray[2] = "writeColor";
                break;
            }
            case 7: {
                objectArray = objectArray;
                objectArray[2] = "writeExternal";
                break;
            }
            case 11: {
                objectArray = objectArray;
                objectArray[2] = "withAdditionalEffects";
                break;
            }
        }
        String string3 = String.format(string2, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string3);
                break;
            }
            case 1: 
            case 2: 
            case 8: 
            case 9: 
            case 10: {
                runtimeException = new IllegalStateException(string3);
                break;
            }
        }
        throw runtimeException;
    }

    private static final class FlyweightKey
    implements Cloneable {
        private Color foreground;
        private Color background;
        @JdkConstants.FontStyle
        private int fontType;
        private Color effectColor;
        private EffectType effectType;
        private Color errorStripeColor;
        @NotNull
        private @NotNull Map<@NotNull EffectType, ? extends @NotNull Color> myAdditionalEffects = Collections.emptyMap();

        private FlyweightKey() {
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (!(o instanceof FlyweightKey)) {
                return false;
            }
            FlyweightKey key = (FlyweightKey)o;
            if (this.fontType != key.fontType) {
                return false;
            }
            if (!Objects.equals(this.background, key.background)) {
                return false;
            }
            if (!Objects.equals(this.effectColor, key.effectColor)) {
                return false;
            }
            if (this.effectType != key.effectType) {
                return false;
            }
            if (!Objects.equals(this.errorStripeColor, key.errorStripeColor)) {
                return false;
            }
            if (!Objects.equals(this.foreground, key.foreground)) {
                return false;
            }
            return this.myAdditionalEffects.equals(key.myAdditionalEffects);
        }

        public int hashCode() {
            int result2 = this.foreground != null ? this.foreground.hashCode() : 0;
            result2 = 31 * result2 + (this.background != null ? this.background.hashCode() : 0);
            result2 = 31 * result2 + this.fontType;
            result2 = 31 * result2 + (this.effectColor != null ? this.effectColor.hashCode() : 0);
            result2 = 31 * result2 + (this.effectType != null ? this.effectType.hashCode() : 0);
            result2 = 31 * result2 + (this.errorStripeColor != null ? this.errorStripeColor.hashCode() : 0);
            result2 = 31 * result2 + this.myAdditionalEffects.hashCode();
            return result2;
        }

        protected FlyweightKey clone() {
            try {
                return (FlyweightKey)super.clone();
            }
            catch (CloneNotSupportedException e) {
                throw new RuntimeException(e);
            }
        }
    }
}

