/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.patterns;

import com.intellij.openapi.util.text.StringUtil;
import com.intellij.patterns.StringPattern;
import com.intellij.patterns.ValuePatternCondition;
import com.intellij.util.ProcessingContext;
import dk.brics.automaton.Automaton;
import dk.brics.automaton.AutomatonProvider;
import dk.brics.automaton.DatatypesAutomatonProvider;
import dk.brics.automaton.RegExp;
import dk.brics.automaton.RunAutomaton;
import java.util.Collection;
import java.util.Collections;
import org.jetbrains.annotations.NonNls;
import org.jetbrains.annotations.NotNull;

public class StringPatternUtil {
    @NotNull
    public static StringPattern matchesBrics(StringPattern pattern, final @NonNls @NotNull String s) {
        String escaped;
        if (s == null) {
            StringPatternUtil.$$$reportNull$$$0(0);
        }
        if ((escaped = StringUtil.escapeToRegexp(s)).equals(s)) {
            StringPattern stringPattern = (StringPattern)pattern.equalTo(s);
            if (stringPattern == null) {
                StringPatternUtil.$$$reportNull$$$0(1);
            }
            return stringPattern;
        }
        @NonNls StringBuilder sb = new StringBuilder(s.length() * 5);
        for (int i = 0; i < s.length(); ++i) {
            char c = s.charAt(i);
            if (c == ' ') {
                sb.append("<whitespacechar>");
                continue;
            }
            if (Character.isUpperCase(c)) {
                sb.append('[').append(Character.toUpperCase(c)).append(Character.toLowerCase(c)).append(']');
                continue;
            }
            sb.append(c);
        }
        RegExp regExp = new RegExp(sb.toString());
        Automaton automaton = regExp.toAutomaton((AutomatonProvider)new DatatypesAutomatonProvider());
        final RunAutomaton runAutomaton = new RunAutomaton(automaton, true);
        StringPattern stringPattern = (StringPattern)pattern.with(new ValuePatternCondition<String>("matchesBrics"){

            @Override
            public boolean accepts(@NotNull String str, ProcessingContext context2) {
                if (str == null) {
                    1.$$$reportNull$$$0(0);
                }
                return runAutomaton.run(str);
            }

            @Override
            public Collection<String> getValues() {
                return Collections.singleton(s);
            }

            private static /* synthetic */ void $$$reportNull$$$0(int n) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "str", "com/intellij/patterns/StringPatternUtil$1", "accepts"));
            }
        });
        if (stringPattern == null) {
            StringPatternUtil.$$$reportNull$$$0(2);
        }
        return stringPattern;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string2;
        switch (n) {
            default: {
                string2 = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 1: 
            case 2: {
                string2 = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 1: 
            case 2: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "s";
                break;
            }
            case 1: 
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/patterns/StringPatternUtil";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/patterns/StringPatternUtil";
                break;
            }
            case 1: 
            case 2: {
                objectArray = objectArray2;
                objectArray2[1] = "matchesBrics";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "matchesBrics";
                break;
            }
            case 1: 
            case 2: {
                break;
            }
        }
        String string3 = String.format(string2, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string3);
                break;
            }
            case 1: 
            case 2: {
                runtimeException = new IllegalStateException(string3);
                break;
            }
        }
        throw runtimeException;
    }
}

