/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.psi.impl.source.resolve.graphInference.constraints;

import com.intellij.codeInsight.daemon.impl.analysis.JavaGenericsUtil;
import com.intellij.core.JavaPsiBundle;
import com.intellij.openapi.util.Pair;
import com.intellij.psi.JavaPsiFacade;
import com.intellij.psi.JavaResolveResult;
import com.intellij.psi.LambdaUtil;
import com.intellij.psi.PsiCall;
import com.intellij.psi.PsiClass;
import com.intellij.psi.PsiClassType;
import com.intellij.psi.PsiConditionalExpression;
import com.intellij.psi.PsiDiamondType;
import com.intellij.psi.PsiDisjunctionType;
import com.intellij.psi.PsiExpression;
import com.intellij.psi.PsiExpressionList;
import com.intellij.psi.PsiLambdaExpression;
import com.intellij.psi.PsiLambdaParameterType;
import com.intellij.psi.PsiMethod;
import com.intellij.psi.PsiMethodReferenceExpression;
import com.intellij.psi.PsiParameter;
import com.intellij.psi.PsiParenthesizedExpression;
import com.intellij.psi.PsiSubstitutor;
import com.intellij.psi.PsiSwitchExpression;
import com.intellij.psi.PsiType;
import com.intellij.psi.PsiTypeParameter;
import com.intellij.psi.impl.source.resolve.graphInference.InferenceSession;
import com.intellij.psi.impl.source.resolve.graphInference.InferenceVariable;
import com.intellij.psi.impl.source.resolve.graphInference.PsiPolyExpressionUtil;
import com.intellij.psi.impl.source.resolve.graphInference.constraints.ConstraintFormula;
import com.intellij.psi.impl.source.resolve.graphInference.constraints.InputOutputConstraintFormula;
import com.intellij.psi.impl.source.resolve.graphInference.constraints.LambdaExpressionCompatibilityConstraint;
import com.intellij.psi.impl.source.resolve.graphInference.constraints.PsiMethodReferenceCompatibilityConstraint;
import com.intellij.psi.impl.source.resolve.graphInference.constraints.TypeCompatibilityConstraint;
import com.intellij.psi.infos.MethodCandidateInfo;
import com.intellij.psi.util.PsiUtil;
import com.intellij.psi.util.TypeConversionUtil;
import com.intellij.util.ArrayUtil;
import java.util.List;
import java.util.Set;
import org.jetbrains.annotations.NotNull;

public class ExpressionCompatibilityConstraint
extends InputOutputConstraintFormula {
    private final PsiExpression myExpression;

    public ExpressionCompatibilityConstraint(@NotNull PsiExpression expression, @NotNull PsiType type) {
        if (expression == null) {
            ExpressionCompatibilityConstraint.$$$reportNull$$$0(0);
        }
        if (type == null) {
            ExpressionCompatibilityConstraint.$$$reportNull$$$0(1);
        }
        super(type);
        this.myExpression = expression;
    }

    @Override
    public boolean reduce(InferenceSession session, List<? super ConstraintFormula> constraints) {
        PsiExpression expression2;
        PsiType myT = this.getCurrentType();
        if (!PsiPolyExpressionUtil.isPolyExpression(this.myExpression)) {
            PsiType exprType = this.myExpression.getType();
            if (session.isProperType(myT)) {
                boolean assignmentCompatible;
                boolean bl = assignmentCompatible = exprType == null || TypeConversionUtil.isAssignable(myT, exprType);
                if (!assignmentCompatible) {
                    PsiType type = this.myExpression.getType();
                    session.registerIncompatibleErrorMessage(JavaPsiBundle.message("error.incompatible.type", type != null ? type.getPresentableText() : this.myExpression.getText(), session.getPresentableText(myT)));
                } else if (TypeCompatibilityConstraint.isUncheckedConversion(myT, exprType, session) && !JavaGenericsUtil.isReifiableType(myT)) {
                    session.setErased();
                }
                return assignmentCompatible;
            }
            if (exprType instanceof PsiLambdaParameterType) {
                return false;
            }
            if (exprType instanceof PsiClassType && ((PsiClassType)exprType).resolve() == null) {
                return true;
            }
            if (exprType != null && exprType != PsiType.NULL) {
                if (exprType instanceof PsiDisjunctionType) {
                    exprType = ((PsiDisjunctionType)exprType).getLeastUpperBound();
                }
                constraints.add(new TypeCompatibilityConstraint(myT, exprType));
            }
            return true;
        }
        if (this.myExpression instanceof PsiParenthesizedExpression && (expression2 = ((PsiParenthesizedExpression)this.myExpression).getExpression()) != null && !InferenceSession.ignoreLambdaConstraintTree(expression2)) {
            constraints.add(new ExpressionCompatibilityConstraint(expression2, myT));
            return true;
        }
        if (this.myExpression instanceof PsiConditionalExpression) {
            PsiExpression elseExpression;
            PsiExpression thenExpression = ((PsiConditionalExpression)this.myExpression).getThenExpression();
            if (thenExpression != null && !InferenceSession.ignoreLambdaConstraintTree(thenExpression)) {
                constraints.add(new ExpressionCompatibilityConstraint(thenExpression, myT));
            }
            if ((elseExpression = ((PsiConditionalExpression)this.myExpression).getElseExpression()) != null && !InferenceSession.ignoreLambdaConstraintTree(elseExpression)) {
                constraints.add(new ExpressionCompatibilityConstraint(elseExpression, myT));
            }
            return true;
        }
        if (this.myExpression instanceof PsiSwitchExpression) {
            PsiUtil.getSwitchResultExpressions((PsiSwitchExpression)this.myExpression).forEach(expression -> {
                if (!InferenceSession.ignoreLambdaConstraintTree(expression)) {
                    constraints.add(new ExpressionCompatibilityConstraint((PsiExpression)expression, myT));
                }
            });
            return true;
        }
        if (this.myExpression instanceof PsiCall) {
            InferenceSession callSession = ExpressionCompatibilityConstraint.reduceExpressionCompatibilityConstraint(session, this.myExpression, myT, true);
            if (callSession == null) {
                return false;
            }
            if (callSession != session) {
                MethodCandidateInfo resolveResult;
                session.getInferenceSessionContainer().registerNestedSession(callSession);
                session.propagateVariables(callSession);
                for (Pair<InferenceVariable[], PsiClassType> pair : callSession.myIncorporationPhase.getCaptures()) {
                    session.myIncorporationPhase.addCapture((InferenceVariable[])pair.first, (PsiClassType)pair.second);
                }
                MethodCandidateInfo currentMethod = session.getCurrentMethod(((PsiCall)((Object)this.myExpression)).getArgumentList());
                JavaResolveResult javaResolveResult = resolveResult = currentMethod != null ? currentMethod : PsiDiamondType.getDiamondsAwareResolveResult((PsiCall)((Object)this.myExpression));
                if (resolveResult instanceof MethodCandidateInfo && callSession.isErased()) {
                    resolveResult.setErased();
                }
            }
            return true;
        }
        if (this.myExpression instanceof PsiMethodReferenceExpression) {
            constraints.add(new PsiMethodReferenceCompatibilityConstraint((PsiMethodReferenceExpression)this.myExpression, myT));
            return true;
        }
        if (this.myExpression instanceof PsiLambdaExpression) {
            constraints.add(new LambdaExpressionCompatibilityConstraint((PsiLambdaExpression)this.myExpression, myT));
            return true;
        }
        return true;
    }

    public static InferenceSession reduceExpressionCompatibilityConstraint(InferenceSession session, PsiExpression expression, PsiType targetType, boolean registerErrorOnFailure) {
        if (!PsiPolyExpressionUtil.isPolyExpression(expression)) {
            return session;
        }
        PsiExpressionList argumentList = ((PsiCall)((Object)expression)).getArgumentList();
        if (argumentList != null) {
            PsiMethod method;
            JavaResolveResult resolveResult;
            MethodCandidateInfo currentMethod = session.getCurrentMethod(argumentList);
            PsiType returnType = null;
            PsiTypeParameter[] typeParams = null;
            JavaResolveResult javaResolveResult = resolveResult = currentMethod != null ? null : PsiDiamondType.getDiamondsAwareResolveResult((PsiCall)((Object)expression));
            PsiMethod psiMethod = currentMethod != null ? currentMethod.getElement() : (method = resolveResult instanceof MethodCandidateInfo ? ((MethodCandidateInfo)resolveResult).getElement() : null);
            if (method != null && !method.isConstructor()) {
                returnType = method.getReturnType();
                typeParams = method.getTypeParameters();
            } else if (resolveResult != null) {
                PsiClass psiClass;
                PsiClass psiClass2 = psiClass = method != null ? method.getContainingClass() : (PsiClass)resolveResult.getElement();
                if (psiClass != null) {
                    returnType = JavaPsiFacade.getElementFactory(argumentList.getProject()).createType(psiClass, PsiSubstitutor.EMPTY);
                    typeParams = psiClass.getTypeParameters();
                    if (method != null && method.hasTypeParameters()) {
                        typeParams = ArrayUtil.mergeArrays(typeParams, method.getTypeParameters());
                    }
                }
            } else {
                return session;
            }
            if (typeParams != null) {
                List<String> messages;
                PsiSubstitutor siteSubstitutor = InferenceSession.chooseSiteSubstitutor(currentMethod, resolveResult, method);
                InferenceSession callSession = new InferenceSession(typeParams, siteSubstitutor, expression.getManager(), expression, session.getInferencePolicy());
                callSession.propagateVariables(session);
                if (method != null) {
                    PsiExpression[] args2 = argumentList.getExpressions();
                    PsiParameter[] parameters = method.getParameterList().getParameters();
                    callSession.initExpressionConstraints(parameters, args2, method, InferenceSession.chooseVarargsMode(currentMethod, resolveResult));
                }
                if (callSession.repeatInferencePhases()) {
                    if (PsiType.VOID.equals(targetType)) {
                        return callSession;
                    }
                    if (returnType != null) {
                        callSession.registerReturnTypeConstraints(siteSubstitutor.substitute(returnType), targetType, expression);
                    }
                    if (callSession.repeatInferencePhases()) {
                        if (callSession.isErased() && !JavaGenericsUtil.isReifiableType(targetType) && session.getInferenceVariable(targetType) == null) {
                            session.setErased();
                        }
                        return callSession;
                    }
                }
                if ((messages = callSession.getIncompatibleErrorMessages()) != null) {
                    for (String message2 : messages) {
                        session.registerIncompatibleErrorMessage(message2);
                    }
                }
                return null;
            }
            if (registerErrorOnFailure) {
                session.registerIncompatibleErrorMessage(JavaPsiBundle.message("error.incompatible.type.failed.to.resolve.argument", new Object[0]));
                return null;
            }
        }
        return session;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        ExpressionCompatibilityConstraint that = (ExpressionCompatibilityConstraint)o;
        return this.myExpression.equals(that.myExpression);
    }

    public int hashCode() {
        return this.myExpression.hashCode();
    }

    @Override
    public PsiExpression getExpression() {
        return this.myExpression;
    }

    @Override
    protected InputOutputConstraintFormula createSelfConstraint(PsiType type, PsiExpression expression) {
        return new ExpressionCompatibilityConstraint(expression, type);
    }

    @Override
    protected void collectReturnTypeVariables(InferenceSession session, PsiExpression psiExpression, PsiType returnType, Set<? super InferenceVariable> result2) {
        if (psiExpression instanceof PsiLambdaExpression && !PsiType.VOID.equals(returnType)) {
            List<PsiExpression> returnExpressions = LambdaUtil.getReturnExpressions((PsiLambdaExpression)psiExpression);
            for (PsiExpression expression : returnExpressions) {
                Set<InferenceVariable> resultInputVars = this.createSelfConstraint(returnType, expression).getInputVariables(session);
                if (resultInputVars == null) continue;
                result2.addAll(resultInputVars);
            }
        }
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2 = new Object[3];
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[0] = "expression";
                break;
            }
            case 1: {
                objectArray = objectArray2;
                objectArray2[0] = "type";
                break;
            }
        }
        objectArray[1] = "com/intellij/psi/impl/source/resolve/graphInference/constraints/ExpressionCompatibilityConstraint";
        objectArray[2] = "<init>";
        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
    }
}

