/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.psi.util;

import com.intellij.core.JavaPsiBundle;
import com.intellij.openapi.progress.ProcessCanceledException;
import com.intellij.openapi.util.NlsSafe;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.psi.PsiAnonymousClass;
import com.intellij.psi.PsiArrayType;
import com.intellij.psi.PsiClass;
import com.intellij.psi.PsiClassType;
import com.intellij.psi.PsiDeclarationStatement;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiEllipsisType;
import com.intellij.psi.PsiExpression;
import com.intellij.psi.PsiField;
import com.intellij.psi.PsiInvalidElementAccessException;
import com.intellij.psi.PsiJavaCodeReferenceElement;
import com.intellij.psi.PsiMethod;
import com.intellij.psi.PsiModifier;
import com.intellij.psi.PsiModifierList;
import com.intellij.psi.PsiModifierListOwner;
import com.intellij.psi.PsiPackage;
import com.intellij.psi.PsiParameter;
import com.intellij.psi.PsiReferenceList;
import com.intellij.psi.PsiSubstitutor;
import com.intellij.psi.PsiType;
import com.intellij.psi.PsiTypeParameter;
import com.intellij.psi.PsiTypeParameterListOwner;
import com.intellij.psi.PsiVariable;
import com.intellij.psi.util.ClassUtil;
import com.intellij.psi.util.PsiExpressionTrimRenderer;
import com.intellij.psi.util.PsiFormatUtilBase;
import com.intellij.psi.util.PsiTreeUtil;
import com.intellij.psi.util.PsiUtil;
import com.intellij.psi.util.TypeConversionUtil;
import com.intellij.util.BitUtil;
import com.intellij.util.ExceptionUtil;
import com.intellij.util.ObjectUtils;
import com.intellij.util.VisibilityUtil;
import java.util.StringJoiner;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class PsiFormatUtil
extends PsiFormatUtilBase {
    @NlsSafe
    public static String formatVariable(@NotNull PsiVariable variable, @FormatVariableOptions int options, PsiSubstitutor substitutor) {
        if (variable == null) {
            PsiFormatUtil.$$$reportNull$$$0(0);
        }
        StringBuilder buffer = new StringBuilder();
        PsiFormatUtil.formatVariable(variable, options, substitutor, buffer);
        return buffer.toString();
    }

    private static void formatVariable(@NotNull PsiVariable variable, @FormatVariableOptions int options, PsiSubstitutor substitutor, @NotNull StringBuilder buffer) {
        PsiExpression initializer;
        String name;
        if (variable == null) {
            PsiFormatUtil.$$$reportNull$$$0(1);
        }
        if (buffer == null) {
            PsiFormatUtil.$$$reportNull$$$0(2);
        }
        if (BitUtil.isSet(options, 8) && !BitUtil.isSet(options, 16)) {
            PsiFormatUtil.formatModifiers(variable, options, buffer);
        }
        if (BitUtil.isSet(options, 2) && !BitUtil.isSet(options, 4)) {
            PsiFormatUtil.appendSpaceIfNeeded(buffer);
            buffer.append(PsiFormatUtil.formatTypeSafe(variable, variable.getType(), options, substitutor));
        }
        if (variable instanceof PsiField && BitUtil.isSet(options, 4096)) {
            String className;
            PsiClass aClass = ((PsiField)variable).getContainingClass();
            if (aClass != null && (className = aClass.getName()) != null) {
                PsiFormatUtil.appendSpaceIfNeeded(buffer);
                if (BitUtil.isSet(options, 2048)) {
                    buffer.append(ObjectUtils.notNull(aClass.getQualifiedName(), className));
                } else {
                    buffer.append(className);
                }
                buffer.append('.');
            }
            if (BitUtil.isSet(options, 1)) {
                buffer.append(variable.getName());
            }
        } else if (BitUtil.isSet(options, 1) && StringUtil.isNotEmpty(name = variable.getName())) {
            PsiFormatUtil.appendSpaceIfNeeded(buffer);
            buffer.append(name);
        }
        if (BitUtil.isSet(options, 2) && BitUtil.isSet(options, 4)) {
            if (BitUtil.isSet(options, 1) && variable.getName() != null) {
                buffer.append(':');
            }
            buffer.append(PsiFormatUtil.formatTypeSafe(variable, variable.getType(), options, substitutor));
        }
        if (BitUtil.isSet(options, 8) && BitUtil.isSet(options, 16)) {
            PsiFormatUtil.formatModifiers(variable, options, buffer);
        }
        if (BitUtil.isSet(options, 128) && (initializer = variable.getInitializer()) != null) {
            int index2;
            buffer.append(" = ");
            String text = PsiExpressionTrimRenderer.render(initializer);
            int index1 = text.lastIndexOf(10);
            if (index1 < 0) {
                index1 = text.length();
            }
            if ((index2 = text.lastIndexOf(13)) < 0) {
                index2 = text.length();
            }
            int index = Math.min(index1, index2);
            buffer.append(text, 0, index);
            if (index < text.length()) {
                buffer.append(" ...");
            }
        }
    }

    @NlsSafe
    public static String formatMethod(@NotNull PsiMethod method, @NotNull PsiSubstitutor substitutor, @FormatMethodOptions int options, @FormatVariableOptions int parameterOptions) {
        if (method == null) {
            PsiFormatUtil.$$$reportNull$$$0(3);
        }
        if (substitutor == null) {
            PsiFormatUtil.$$$reportNull$$$0(4);
        }
        return PsiFormatUtil.formatMethod(method, substitutor, options, parameterOptions, 7);
    }

    public static String formatMethod(@NotNull PsiMethod method, @NotNull PsiSubstitutor substitutor, @FormatMethodOptions int options, @FormatVariableOptions int parameterOptions, int maxParametersToShow) {
        if (method == null) {
            PsiFormatUtil.$$$reportNull$$$0(5);
        }
        if (substitutor == null) {
            PsiFormatUtil.$$$reportNull$$$0(6);
        }
        StringBuilder buffer = new StringBuilder();
        PsiFormatUtil.formatMethod(method, substitutor, options, parameterOptions, maxParametersToShow, buffer);
        return buffer.toString();
    }

    private static void formatMethod(@NotNull PsiMethod method, @NotNull PsiSubstitutor substitutor, @FormatMethodOptions int options, @FormatVariableOptions int parameterOptions, int maxParametersToShow, StringBuilder buffer) {
        String throwsText;
        PsiType type;
        if (method == null) {
            PsiFormatUtil.$$$reportNull$$$0(7);
        }
        if (substitutor == null) {
            PsiFormatUtil.$$$reportNull$$$0(8);
        }
        if (BitUtil.isSet(options, 8) && !BitUtil.isSet(options, 16)) {
            PsiFormatUtil.formatModifiers(method, options, buffer);
        }
        if (BitUtil.isSet(options, 2) && !BitUtil.isSet(options, 4) && (type = method.getReturnType()) != null) {
            PsiFormatUtil.appendSpaceIfNeeded(buffer);
            buffer.append(PsiFormatUtil.formatTypeSafe(method, type, options, substitutor));
        }
        if (BitUtil.isSet(options, 4096)) {
            PsiClass aClass = method.getContainingClass();
            if (aClass != null) {
                PsiFormatUtil.appendSpaceIfNeeded(buffer);
                String name = aClass.getName();
                if (name != null) {
                    if (BitUtil.isSet(options, 2048)) {
                        buffer.append(ObjectUtils.notNull(aClass.getQualifiedName(), name));
                    } else {
                        buffer.append(name);
                    }
                    buffer.append('.');
                }
            }
            if (BitUtil.isSet(options, 1)) {
                buffer.append(method.getName());
            }
        } else if (BitUtil.isSet(options, 1)) {
            PsiFormatUtil.appendSpaceIfNeeded(buffer);
            buffer.append(method.getName());
        }
        if (BitUtil.isSet(options, 256)) {
            buffer.append('(');
            PsiParameter[] params = method.getParameterList().getParameters();
            for (int i = 0; i < Math.min(params.length, maxParametersToShow); ++i) {
                if (i > 0) {
                    buffer.append(", ");
                }
                buffer.append(PsiFormatUtil.formatVariable(params[i], parameterOptions, substitutor));
            }
            if (params.length > maxParametersToShow) {
                buffer.append(", ...");
            }
            buffer.append(')');
        }
        if (BitUtil.isSet(options, 2) && BitUtil.isSet(options, 4) && (type = method.getReturnType()) != null) {
            if (buffer.length() > 0) {
                buffer.append(':');
            }
            buffer.append(PsiFormatUtil.formatTypeSafe(method, type, options, substitutor));
        }
        if (BitUtil.isSet(options, 8) && BitUtil.isSet(options, 16)) {
            PsiFormatUtil.formatModifiers(method, options, buffer);
        }
        if (BitUtil.isSet(options, 512) && !(throwsText = PsiFormatUtil.formatReferenceList(method.getThrowsList(), options)).isEmpty()) {
            PsiFormatUtil.appendSpaceIfNeeded(buffer);
            buffer.append("throws ").append(throwsText);
        }
    }

    private static String formatTypeSafe(PsiElement parent, PsiType type, int options, PsiSubstitutor substitutor) {
        try {
            return PsiFormatUtil.formatType(type, options, substitutor);
        }
        catch (ProcessCanceledException e) {
            throw e;
        }
        catch (Throwable e) {
            if (ExceptionUtil.getRootCause(e) instanceof PsiInvalidElementAccessException) {
                throw new RuntimeException("Invalid type in " + parent.getClass(), e);
            }
            throw e;
        }
    }

    @NotNull
    @NlsSafe
    public static String formatClass(@NotNull PsiClass aClass, @FormatClassOptions int options) {
        if (aClass == null) {
            PsiFormatUtil.$$$reportNull$$$0(9);
        }
        StringBuilder buffer = new StringBuilder();
        if (BitUtil.isSet(options, 8) && !BitUtil.isSet(options, 16)) {
            PsiFormatUtil.formatModifiers(aClass, options, buffer);
        }
        if (BitUtil.isSet(options, 1)) {
            if (aClass instanceof PsiAnonymousClass && BitUtil.isSet(options, 32768)) {
                PsiClassType baseClassReference = ((PsiAnonymousClass)aClass).getBaseClassType();
                PsiClass baseClass = baseClassReference.resolve();
                String name = baseClass == null ? baseClassReference.getPresentableText() : PsiFormatUtil.formatClass(baseClass, options);
                buffer.append(JavaPsiBundle.message("anonymous.class.derived.display", name));
            } else {
                String name = aClass.getName();
                if (name != null) {
                    PsiFormatUtil.appendSpaceIfNeeded(buffer);
                    if (BitUtil.isSet(options, 2048)) {
                        String qName = aClass.getQualifiedName();
                        if (qName != null) {
                            buffer.append(qName);
                        } else {
                            buffer.append(aClass.getName());
                        }
                    } else {
                        buffer.append(aClass.getName());
                    }
                }
            }
        }
        if (BitUtil.isSet(options, 8) && BitUtil.isSet(options, 16)) {
            PsiFormatUtil.formatModifiers(aClass, options, buffer);
        }
        if (BitUtil.isSet(options, 1024)) {
            String implementsText;
            PsiReferenceList implementsList;
            String extendsText;
            PsiReferenceList extendsList = aClass.getExtendsList();
            if (extendsList != null && !(extendsText = PsiFormatUtil.formatReferenceList(extendsList, options)).isEmpty()) {
                PsiFormatUtil.appendSpaceIfNeeded(buffer);
                buffer.append("extends ").append(extendsText);
            }
            if ((implementsList = aClass.getImplementsList()) != null && !(implementsText = PsiFormatUtil.formatReferenceList(implementsList, options)).isEmpty()) {
                PsiFormatUtil.appendSpaceIfNeeded(buffer);
                buffer.append("implements ").append(implementsText);
            }
        }
        String string2 = buffer.toString();
        if (string2 == null) {
            PsiFormatUtil.$$$reportNull$$$0(10);
        }
        return string2;
    }

    @NotNull
    public static String formatModifiers(@NotNull PsiModifierListOwner element, int options) {
        if (element == null) {
            PsiFormatUtil.$$$reportNull$$$0(11);
        }
        StringBuilder buffer = new StringBuilder();
        PsiFormatUtil.formatModifiers(element, options, buffer);
        String string2 = buffer.toString();
        if (string2 == null) {
            PsiFormatUtil.$$$reportNull$$$0(12);
        }
        return string2;
    }

    private static void formatModifiers(PsiModifierListOwner element, int options, StringBuilder buffer) {
        boolean isInterface;
        PsiModifierList list = element.getModifierList();
        if (list == null) {
            return;
        }
        if (!BitUtil.isSet(options, 32) ? list.hasExplicitModifier("public") : list.hasModifierProperty("public")) {
            PsiFormatUtil.appendModifier(buffer, "public");
        }
        if (list.hasModifierProperty("protected")) {
            PsiFormatUtil.appendModifier(buffer, "protected");
        }
        if (list.hasModifierProperty("private")) {
            PsiFormatUtil.appendModifier(buffer, "private");
        }
        if (!BitUtil.isSet(options, 32) ? list.hasExplicitModifier("packageLocal") : list.hasModifierProperty("packageLocal")) {
            if (element instanceof PsiClass && element.getParent() instanceof PsiDeclarationStatement) {
                PsiFormatUtil.append(buffer, JavaPsiBundle.message("local.class.preposition", new Object[0]));
            } else {
                PsiFormatUtil.appendModifier(buffer, "packageLocal");
            }
        }
        if (!(!(!BitUtil.isSet(options, 32) ? list.hasExplicitModifier("static") : list.hasModifierProperty("static")) || BitUtil.isSet(options, 16384) && element instanceof PsiClass && ((PsiClass)element).isEnum())) {
            PsiFormatUtil.appendModifier(buffer, "static");
        }
        boolean bl = isInterface = element instanceof PsiClass && ((PsiClass)element).isInterface();
        if (!isInterface && (!BitUtil.isSet(options, 32) ? list.hasExplicitModifier("abstract") : list.hasModifierProperty("abstract"))) {
            PsiFormatUtil.appendModifier(buffer, "abstract");
        }
        if (!(!(!BitUtil.isSet(options, 32) ? list.hasExplicitModifier("final") : list.hasModifierProperty("final")) || BitUtil.isSet(options, 16384) && element instanceof PsiClass && ((PsiClass)element).isEnum())) {
            PsiFormatUtil.appendModifier(buffer, "final");
        }
        if (list.hasModifierProperty("native") && !BitUtil.isSet(options, 16384)) {
            PsiFormatUtil.appendModifier(buffer, "native");
        }
        if (list.hasModifierProperty("synchronized") && !BitUtil.isSet(options, 16384)) {
            PsiFormatUtil.appendModifier(buffer, "synchronized");
        }
        if (list.hasModifierProperty("strictfp") && !BitUtil.isSet(options, 16384)) {
            PsiFormatUtil.appendModifier(buffer, "strictfp");
        }
        if (list.hasModifierProperty("transient") && element instanceof PsiVariable) {
            PsiFormatUtil.appendModifier(buffer, "transient");
        }
        if (list.hasModifierProperty("volatile")) {
            PsiFormatUtil.appendModifier(buffer, "volatile");
        }
    }

    private static void appendModifier(StringBuilder buffer, @PsiModifier.ModifierConstant @NotNull String modifier) {
        if (modifier == null) {
            PsiFormatUtil.$$$reportNull$$$0(13);
        }
        PsiFormatUtil.append(buffer, VisibilityUtil.toPresentableText(modifier));
    }

    private static void append(StringBuilder buffer, String modifier) {
        PsiFormatUtil.appendSpaceIfNeeded(buffer);
        buffer.append(modifier);
    }

    private static String formatReferenceList(PsiReferenceList list, int options) {
        StringJoiner buffer = new StringJoiner(", ");
        if (BitUtil.isSet(options, 65536)) {
            PsiClassType[] types;
            for (PsiClassType type : types = list.getReferencedTypes()) {
                buffer.add(PsiFormatUtil.formatType(type, options, PsiSubstitutor.EMPTY));
            }
        } else {
            PsiJavaCodeReferenceElement[] refs;
            for (PsiJavaCodeReferenceElement ref : refs = list.getReferenceElements()) {
                buffer.add(PsiFormatUtil.formatReference(ref, options));
            }
        }
        return buffer.toString();
    }

    public static String formatType(@Nullable PsiType type, int options, @NotNull PsiSubstitutor substitutor) {
        if (substitutor == null) {
            PsiFormatUtil.$$$reportNull$$$0(14);
        }
        type = substitutor.substitute(type);
        if (BitUtil.isSet(options, 65536)) {
            type = TypeConversionUtil.erasure(type);
        } else if (BitUtil.isSet(options, 131072) && !(PsiUtil.resolveClassInType(type) instanceof PsiTypeParameter)) {
            boolean preserveEllipsis = type instanceof PsiEllipsisType;
            type = TypeConversionUtil.erasure(type);
            if (preserveEllipsis && type instanceof PsiArrayType) {
                type = new PsiEllipsisType(((PsiArrayType)type).getComponentType());
            }
        }
        if (type == null) {
            return "null";
        }
        return !BitUtil.isSet(options, 8192) ? type.getPresentableText(false) : (!BitUtil.isSet(options, 262144) ? type.getCanonicalText(false) : type.getInternalCanonicalText());
    }

    public static String formatReference(PsiJavaCodeReferenceElement ref, int options) {
        return BitUtil.isSet(options, 8192) ? ref.getCanonicalText() : ref.getText();
    }

    @Nullable
    public static String getExternalName(PsiModifierListOwner owner) {
        return PsiFormatUtil.getExternalName(owner, true);
    }

    @Nullable
    public static String getExternalName(PsiModifierListOwner owner, boolean showParamName) {
        return PsiFormatUtil.getExternalName(owner, showParamName, 7);
    }

    @Nullable
    public static String getExternalName(PsiModifierListOwner owner, boolean showParamName, int maxParamsToShow) {
        if (owner instanceof PsiPackage) {
            return ((PsiPackage)owner).getQualifiedName();
        }
        StringBuilder builder = new StringBuilder();
        if (owner instanceof PsiClass) {
            ClassUtil.formatClassName((PsiClass)owner, builder);
            return builder.toString();
        }
        PsiClass psiClass = PsiTreeUtil.getContextOfType((PsiElement)owner, PsiClass.class, false);
        if (psiClass == null) {
            return null;
        }
        ClassUtil.formatClassName(psiClass, builder);
        if (owner instanceof PsiMethod) {
            builder.append(' ');
            int options = 10499;
            int parameterOptions = showParamName ? 8195 : 8194;
            PsiFormatUtil.formatMethod((PsiMethod)owner, PsiSubstitutor.EMPTY, options, parameterOptions, maxParamsToShow, builder);
        } else if (owner instanceof PsiField) {
            builder.append(' ').append(((PsiField)owner).getName());
        } else if (owner instanceof PsiParameter) {
            PsiElement declarationScope = ((PsiParameter)owner).getDeclarationScope();
            if (!(declarationScope instanceof PsiMethod)) {
                return null;
            }
            PsiMethod psiMethod = (PsiMethod)declarationScope;
            builder.append(' ');
            int options = 10499;
            int parameterOptions = showParamName ? 8195 : 8194;
            PsiFormatUtil.formatMethod(psiMethod, PsiSubstitutor.EMPTY, options, parameterOptions, maxParamsToShow, builder);
            builder.append(' ');
            if (showParamName) {
                PsiFormatUtil.formatVariable((PsiVariable)owner, 1, PsiSubstitutor.EMPTY, builder);
            } else {
                builder.append(psiMethod.getParameterList().getParameterIndex((PsiParameter)owner));
            }
        } else {
            return null;
        }
        return builder.toString();
    }

    public static String getPackageDisplayName(@NotNull PsiClass psiClass) {
        if (psiClass == null) {
            PsiFormatUtil.$$$reportNull$$$0(15);
        }
        if (psiClass instanceof PsiTypeParameter) {
            PsiTypeParameterListOwner owner = ((PsiTypeParameter)psiClass).getOwner();
            String ownerName = null;
            if (owner instanceof PsiClass) {
                ownerName = ((PsiClass)owner).getQualifiedName();
                if (ownerName == null) {
                    ownerName = owner.getName();
                }
            } else if (owner instanceof PsiMethod) {
                ownerName = owner.getName();
            }
            return ownerName == null ? "type parameter" : "type parameter of " + ownerName;
        }
        if (PsiUtil.isLocalClass(psiClass)) {
            return "local class";
        }
        String packageName = psiClass.getQualifiedName();
        String string2 = packageName = packageName == null || packageName.lastIndexOf(46) <= 0 ? "" : packageName.substring(0, packageName.lastIndexOf(46));
        if (packageName.isEmpty()) {
            packageName = "default package";
        }
        return packageName;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string2;
        switch (n) {
            default: {
                string2 = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 10: 
            case 12: {
                string2 = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 10: 
            case 12: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "variable";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "buffer";
                break;
            }
            case 3: 
            case 5: 
            case 7: {
                objectArray2 = objectArray3;
                objectArray3[0] = "method";
                break;
            }
            case 4: 
            case 6: 
            case 8: 
            case 14: {
                objectArray2 = objectArray3;
                objectArray3[0] = "substitutor";
                break;
            }
            case 9: {
                objectArray2 = objectArray3;
                objectArray3[0] = "aClass";
                break;
            }
            case 10: 
            case 12: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/psi/util/PsiFormatUtil";
                break;
            }
            case 11: {
                objectArray2 = objectArray3;
                objectArray3[0] = "element";
                break;
            }
            case 13: {
                objectArray2 = objectArray3;
                objectArray3[0] = "modifier";
                break;
            }
            case 15: {
                objectArray2 = objectArray3;
                objectArray3[0] = "psiClass";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/psi/util/PsiFormatUtil";
                break;
            }
            case 10: {
                objectArray = objectArray2;
                objectArray2[1] = "formatClass";
                break;
            }
            case 12: {
                objectArray = objectArray2;
                objectArray2[1] = "formatModifiers";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "formatVariable";
                break;
            }
            case 3: 
            case 4: 
            case 5: 
            case 6: 
            case 7: 
            case 8: {
                objectArray = objectArray;
                objectArray[2] = "formatMethod";
                break;
            }
            case 9: {
                objectArray = objectArray;
                objectArray[2] = "formatClass";
                break;
            }
            case 10: 
            case 12: {
                break;
            }
            case 11: {
                objectArray = objectArray;
                objectArray[2] = "formatModifiers";
                break;
            }
            case 13: {
                objectArray = objectArray;
                objectArray[2] = "appendModifier";
                break;
            }
            case 14: {
                objectArray = objectArray;
                objectArray[2] = "formatType";
                break;
            }
            case 15: {
                objectArray = objectArray;
                objectArray[2] = "getPackageDisplayName";
                break;
            }
        }
        String string3 = String.format(string2, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string3);
                break;
            }
            case 10: 
            case 12: {
                runtimeException = new IllegalStateException(string3);
                break;
            }
        }
        throw runtimeException;
    }

    public static @interface FormatClassOptions {
    }

    public static @interface FormatMethodOptions {
    }

    public static @interface FormatVariableOptions {
    }
}

