/*
 * Decompiled with CFR 0.152.
 */
package net.n3.nanoxml;

import java.io.PrintStream;
import java.io.PrintWriter;

public class XMLException
extends Exception {
    private String msg;
    private String systemID;
    private int lineNr;
    private Exception encapsulatedException;

    public XMLException(String string2) {
        this(null, -1, null, string2, false);
    }

    public XMLException(Exception exception) {
        this(null, -1, exception, "Nested Exception", false);
    }

    public XMLException(String string2, int n, Exception exception) {
        this(string2, n, exception, "Nested Exception", true);
    }

    public XMLException(String string2, int n, String string3) {
        this(string2, n, null, string3, true);
    }

    public XMLException(String string2, int n, Exception exception, String string3, boolean bl) {
        super(XMLException.buildMessage(string2, n, exception, string3, bl));
        this.systemID = string2;
        this.lineNr = n;
        this.encapsulatedException = exception;
        this.msg = XMLException.buildMessage(string2, n, exception, string3, bl);
    }

    private static String buildMessage(String string2, int n, Exception exception, String string3, boolean bl) {
        String string4 = string3;
        if (bl) {
            if (string2 != null) {
                string4 = string4 + ", SystemID='" + string2 + "'";
            }
            if (n >= 0) {
                string4 = string4 + ", Line=" + n;
            }
            if (exception != null) {
                string4 = string4 + ", Exception: " + exception;
            }
        }
        return string4;
    }

    protected void finalize() throws Throwable {
        this.systemID = null;
        this.encapsulatedException = null;
        super.finalize();
    }

    public String getSystemID() {
        return this.systemID;
    }

    public int getLineNr() {
        return this.lineNr;
    }

    public Exception getException() {
        return this.encapsulatedException;
    }

    public void printStackTrace(PrintWriter printWriter) {
        super.printStackTrace(printWriter);
        if (this.encapsulatedException != null) {
            printWriter.println("*** Nested Exception:");
            this.encapsulatedException.printStackTrace(printWriter);
        }
    }

    public void printStackTrace(PrintStream printStream) {
        super.printStackTrace(printStream);
        if (this.encapsulatedException != null) {
            printStream.println("*** Nested Exception:");
            this.encapsulatedException.printStackTrace(printStream);
        }
    }

    public void printStackTrace() {
        super.printStackTrace();
        if (this.encapsulatedException != null) {
            System.err.println("*** Nested Exception:");
            this.encapsulatedException.printStackTrace();
        }
    }

    public String toString() {
        return this.msg;
    }
}

