/*
 * Decompiled with CFR 0.152.
 */
package net.n3.nanoxml;

import java.io.IOException;
import java.io.Reader;
import net.n3.nanoxml.IXMLEntityResolver;
import net.n3.nanoxml.IXMLReader;
import net.n3.nanoxml.XMLParseException;
import net.n3.nanoxml.XMLValidationException;

class XMLUtil {
    XMLUtil() {
    }

    static void skipComment(IXMLReader iXMLReader) throws IOException, XMLParseException {
        if (iXMLReader.read() != '-') {
            XMLUtil.errorExpectedInput(iXMLReader.getSystemID(), iXMLReader.getLineNr(), "<!--");
        }
        int n = 0;
        block4: while (true) {
            char c = iXMLReader.read();
            switch (c) {
                case '-': {
                    ++n;
                    continue block4;
                }
                case '>': {
                    if (n != 2) break;
                    return;
                }
            }
            n = 0;
        }
    }

    static void skipTag(IXMLReader iXMLReader) throws IOException, XMLParseException {
        int n = 1;
        while (n > 0) {
            char c = iXMLReader.read();
            switch (c) {
                case '<': {
                    ++n;
                    break;
                }
                case '>': {
                    --n;
                }
            }
        }
    }

    static String scanPublicID(StringBuffer stringBuffer, IXMLReader iXMLReader) throws IOException, XMLParseException {
        if (!XMLUtil.checkLiteral(iXMLReader, "UBLIC")) {
            return null;
        }
        XMLUtil.skipWhitespace(iXMLReader, null);
        stringBuffer.append(XMLUtil.scanString(iXMLReader, '\u0000', null));
        XMLUtil.skipWhitespace(iXMLReader, null);
        return XMLUtil.scanString(iXMLReader, '\u0000', null);
    }

    static String scanSystemID(IXMLReader iXMLReader) throws IOException, XMLParseException {
        if (!XMLUtil.checkLiteral(iXMLReader, "YSTEM")) {
            return null;
        }
        XMLUtil.skipWhitespace(iXMLReader, null);
        return XMLUtil.scanString(iXMLReader, '\u0000', null);
    }

    static String scanIdentifier(IXMLReader iXMLReader) throws IOException, XMLParseException {
        char c;
        StringBuffer stringBuffer = new StringBuffer();
        while ((c = iXMLReader.read()) == '_' || c == ':' || c == '-' || c == '.' || c >= 'a' && c <= 'z' || c >= 'A' && c <= 'Z' || c >= '0' && c <= '9' || c > '~') {
            stringBuffer.append(c);
        }
        iXMLReader.unread(c);
        return stringBuffer.toString();
    }

    static String scanString(IXMLReader iXMLReader, char c, IXMLEntityResolver iXMLEntityResolver) throws IOException, XMLParseException {
        StringBuffer stringBuffer = new StringBuffer();
        int n = iXMLReader.getStreamLevel();
        char c2 = iXMLReader.read();
        if (c2 != '\'' && c2 != '\"') {
            XMLUtil.errorExpectedInput(iXMLReader.getSystemID(), iXMLReader.getLineNr(), "delimited string");
        }
        while (true) {
            String string2;
            char c3;
            if ((c3 = (string2 = XMLUtil.read(iXMLReader, c)).charAt(0)) == c) {
                if (string2.charAt(1) == '#') {
                    stringBuffer.append(XMLUtil.processCharLiteral(string2));
                    continue;
                }
                XMLUtil.processEntity(string2, iXMLReader, iXMLEntityResolver);
                continue;
            }
            if (c3 == '&') {
                iXMLReader.unread(c3);
                string2 = XMLUtil.read(iXMLReader, '&');
                if (string2.charAt(1) == '#') {
                    stringBuffer.append(XMLUtil.processCharLiteral(string2));
                    continue;
                }
                stringBuffer.append(string2);
                continue;
            }
            if (iXMLReader.getStreamLevel() == n) {
                if (c3 == c2) break;
                if (c3 == '\t' || c3 == '\n' || c3 == '\r') {
                    stringBuffer.append(' ');
                    continue;
                }
                stringBuffer.append(c3);
                continue;
            }
            stringBuffer.append(c3);
        }
        return stringBuffer.toString();
    }

    static void processEntity(String string2, IXMLReader iXMLReader, IXMLEntityResolver iXMLEntityResolver) throws IOException, XMLParseException {
        boolean bl;
        Reader reader = iXMLEntityResolver.getEntity(iXMLReader, string2 = string2.substring(1, string2.length() - 1));
        if (reader == null) {
            XMLUtil.errorInvalidEntity(iXMLReader.getSystemID(), iXMLReader.getLineNr(), string2);
        }
        iXMLReader.startNewStream(reader, !(bl = iXMLEntityResolver.isExternalEntity(string2)));
    }

    static char processCharLiteral(String string2) throws IOException, XMLParseException {
        if (string2.charAt(2) == 'x') {
            string2 = string2.substring(3, string2.length() - 1);
            return (char)Integer.parseInt(string2, 16);
        }
        string2 = string2.substring(2, string2.length() - 1);
        return (char)Integer.parseInt(string2, 10);
    }

    static void skipWhitespace(IXMLReader iXMLReader, StringBuffer stringBuffer) throws IOException {
        char c;
        if (stringBuffer == null) {
            while ((c = iXMLReader.read()) == ' ' || c == '\t' || c == '\n') {
            }
        } else {
            while ((c = iXMLReader.read()) == ' ' || c == '\t' || c == '\n') {
                if (c == '\n') {
                    stringBuffer.append('\n');
                    continue;
                }
                stringBuffer.append(' ');
            }
        }
        iXMLReader.unread(c);
    }

    static String read(IXMLReader iXMLReader, char c) throws IOException, XMLParseException {
        char c2 = iXMLReader.read();
        StringBuffer stringBuffer = new StringBuffer();
        stringBuffer.append(c2);
        if (c2 == c) {
            while (c2 != ';') {
                c2 = iXMLReader.read();
                stringBuffer.append(c2);
            }
        }
        return stringBuffer.toString();
    }

    static char readChar(IXMLReader iXMLReader, char c) throws IOException, XMLParseException {
        String string2 = XMLUtil.read(iXMLReader, c);
        char c2 = string2.charAt(0);
        if (c2 == c) {
            XMLUtil.errorUnexpectedEntity(iXMLReader.getSystemID(), iXMLReader.getLineNr(), string2);
        }
        return c2;
    }

    static boolean checkLiteral(IXMLReader iXMLReader, String string2) throws IOException, XMLParseException {
        int n = 0;
        while (n < string2.length()) {
            if (iXMLReader.read() != string2.charAt(n)) {
                return false;
            }
            ++n;
        }
        return true;
    }

    static void errorExpectedInput(String string2, int n, String string3) throws XMLParseException {
        throw new XMLParseException(string2, n, "Expected: " + string3);
    }

    static void errorInvalidEntity(String string2, int n, String string3) throws XMLParseException {
        throw new XMLParseException(string2, n, "Invalid entity: `&" + string3 + ";'");
    }

    static void errorUnexpectedEntity(String string2, int n, String string3) throws XMLParseException {
        throw new XMLParseException(string2, n, "No entity reference is expected here (" + string3 + ")");
    }

    static void errorUnexpectedCDATA(String string2, int n) throws XMLParseException {
        throw new XMLParseException(string2, n, "No CDATA section is expected here");
    }

    static void errorInvalidInput(String string2, int n, String string3) throws XMLParseException {
        throw new XMLParseException(string2, n, "Invalid input: " + string3);
    }

    static void errorWrongClosingTag(String string2, int n, String string3, String string4) throws XMLParseException {
        throw new XMLParseException(string2, n, "Closing tag does not match opening tag: `" + string4 + "' != `" + string3 + "'");
    }

    static void errorClosingTagNotEmpty(String string2, int n) throws XMLParseException {
        throw new XMLParseException(string2, n, "Closing tag must be empty");
    }

    static void errorMissingElement(String string2, int n, String string3, String string4) throws XMLValidationException {
        throw new XMLValidationException(1, string2, n, string4, null, null, "Element " + string3 + " expects to have a " + string4);
    }

    static void errorUnexpectedElement(String string2, int n, String string3, String string4) throws XMLValidationException {
        throw new XMLValidationException(2, string2, n, string4, null, null, "Unexpected " + string4 + " in a " + string3);
    }

    static void errorMissingAttribute(String string2, int n, String string3, String string4) throws XMLValidationException {
        throw new XMLValidationException(3, string2, n, string3, string4, null, "Element " + string3 + " expects an attribute named " + string4);
    }

    static void errorUnexpectedAttribute(String string2, int n, String string3, String string4) throws XMLValidationException {
        throw new XMLValidationException(4, string2, n, string3, string4, null, "Element " + string3 + " did not expect an attribute " + "named " + string4);
    }

    static void errorInvalidAttributeValue(String string2, int n, String string3, String string4, String string5) throws XMLValidationException {
        throw new XMLValidationException(5, string2, n, string3, string4, string5, "Invalid value for attribute " + string4);
    }

    static void errorMissingPCData(String string2, int n, String string3) throws XMLValidationException {
        throw new XMLValidationException(6, string2, n, null, null, null, "Missing #PCDATA in element " + string3);
    }

    static void errorUnexpectedPCData(String string2, int n, String string3) throws XMLValidationException {
        throw new XMLValidationException(7, string2, n, null, null, null, "Unexpected #PCDATA in element " + string3);
    }

    static void validationError(String string2, int n, String string3, String string4, String string5, String string6) throws XMLValidationException {
        throw new XMLValidationException(0, string2, n, string4, string5, string6, string3);
    }
}

