/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.jps.model.java;

import com.intellij.openapi.util.text.StringUtil;
import com.intellij.util.lang.JavaVersion;
import com.intellij.util.system.CpuArch;
import java.util.concurrent.ExecutorService;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.jps.service.JpsServiceManager;

public abstract class JdkVersionDetector {
    public static JdkVersionDetector getInstance() {
        return JpsServiceManager.getInstance().getService(JdkVersionDetector.class);
    }

    @Nullable
    public abstract JdkVersionInfo detectJdkVersionInfo(@NotNull String var1);

    @Nullable
    public abstract JdkVersionInfo detectJdkVersionInfo(@NotNull String var1, @NotNull ExecutorService var2);

    @NotNull
    public static String formatVersionString(@NotNull JavaVersion version) {
        if (version == null) {
            JdkVersionDetector.$$$reportNull$$$0(0);
        }
        String string2 = "java version \"" + version + '\"';
        if (string2 == null) {
            JdkVersionDetector.$$$reportNull$$$0(1);
        }
        return string2;
    }

    public static boolean isVersionString(@NotNull String string2) {
        if (string2 == null) {
            JdkVersionDetector.$$$reportNull$$$0(2);
        }
        return string2.length() >= 16 && string2.startsWith("java version \"") && StringUtil.endsWithChar(string2, '\"');
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string2;
        switch (n) {
            default: {
                string2 = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 1: {
                string2 = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 1: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "version";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "org/jetbrains/jps/model/java/JdkVersionDetector";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "string";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "org/jetbrains/jps/model/java/JdkVersionDetector";
                break;
            }
            case 1: {
                objectArray = objectArray2;
                objectArray2[1] = "formatVersionString";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "formatVersionString";
                break;
            }
            case 1: {
                break;
            }
            case 2: {
                objectArray = objectArray;
                objectArray[2] = "isVersionString";
                break;
            }
        }
        String string3 = String.format(string2, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string3);
                break;
            }
            case 1: {
                runtimeException = new IllegalStateException(string3);
                break;
            }
        }
        throw runtimeException;
    }

    public static final class JdkVersionInfo {
        public final JavaVersion version;
        public final Variant variant;
        public final CpuArch arch;

        public JdkVersionInfo(@NotNull JavaVersion version, @Nullable Variant variant, @NotNull CpuArch arch) {
            if (version == null) {
                JdkVersionInfo.$$$reportNull$$$0(0);
            }
            if (arch == null) {
                JdkVersionInfo.$$$reportNull$$$0(1);
            }
            this.version = version;
            this.variant = variant != null ? variant : Variant.Unknown;
            this.arch = arch;
        }

        @NotNull
        public String suggestedName() {
            String f = this.version.toFeatureString();
            String string2 = this.variant.prefix != null ? this.variant.prefix + '-' + f : f;
            if (string2 == null) {
                JdkVersionInfo.$$$reportNull$$$0(2);
            }
            return string2;
        }

        @NotNull
        public String displayVersionString() {
            String s = "version " + this.version;
            String string2 = this.variant.displayName != null ? this.variant.displayName + ' ' + s : s;
            if (string2 == null) {
                JdkVersionInfo.$$$reportNull$$$0(3);
            }
            return string2;
        }

        public String toString() {
            return this.version + " " + (Object)((Object)this.arch);
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            RuntimeException runtimeException;
            Object[] objectArray;
            Object[] objectArray2;
            int n2;
            String string2;
            switch (n) {
                default: {
                    string2 = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                    break;
                }
                case 2: 
                case 3: {
                    string2 = "@NotNull method %s.%s must not return null";
                    break;
                }
            }
            switch (n) {
                default: {
                    n2 = 3;
                    break;
                }
                case 2: 
                case 3: {
                    n2 = 2;
                    break;
                }
            }
            Object[] objectArray3 = new Object[n2];
            switch (n) {
                default: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "version";
                    break;
                }
                case 1: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "arch";
                    break;
                }
                case 2: 
                case 3: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "org/jetbrains/jps/model/java/JdkVersionDetector$JdkVersionInfo";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[1] = "org/jetbrains/jps/model/java/JdkVersionDetector$JdkVersionInfo";
                    break;
                }
                case 2: {
                    objectArray = objectArray2;
                    objectArray2[1] = "suggestedName";
                    break;
                }
                case 3: {
                    objectArray = objectArray2;
                    objectArray2[1] = "displayVersionString";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray;
                    objectArray[2] = "<init>";
                    break;
                }
                case 2: 
                case 3: {
                    break;
                }
            }
            String string3 = String.format(string2, objectArray);
            switch (n) {
                default: {
                    runtimeException = new IllegalArgumentException(string3);
                    break;
                }
                case 2: 
                case 3: {
                    runtimeException = new IllegalStateException(string3);
                    break;
                }
            }
            throw runtimeException;
        }
    }

    public static enum Variant {
        AdoptOpenJdk_HS("adopt", "AdoptOpenJDK (HotSpot)"),
        AdoptOpenJdk_J9("adopt-j9", "AdoptOpenJDK (OpenJ9)"),
        Temurin("temurin", "Eclipse Temurin"),
        Semeru("semeru", "IBM Semeru"),
        Corretto("corretto", "Amazon Corretto"),
        GraalVM("graalvm", "GraalVM"),
        IBM("ibm", "IBM JDK"),
        JBR("jbr", "JetBrains Runtime"),
        Liberica("liberica", "BellSoft Liberica"),
        Oracle(null, "Oracle OpenJDK"),
        SapMachine("sap", "SAP SapMachine"),
        Zulu("zulu", "Azul Zulu"),
        Unknown(null, null);

        @Nullable
        public final String prefix;
        @Nullable
        public final String displayName;

        private Variant(String prefix, String displayName) {
            this.prefix = prefix;
            this.displayName = displayName;
        }
    }
}

