/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.jps.model.java.impl;

import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.util.SystemInfo;
import com.intellij.openapi.vfs.CharsetToolkit;
import com.intellij.util.io.BaseDataReader;
import com.intellij.util.io.BaseOutputReader;
import com.intellij.util.lang.JavaVersion;
import com.intellij.util.system.CpuArch;
import java.io.IOException;
import java.io.InputStream;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.util.List;
import java.util.Properties;
import java.util.concurrent.CopyOnWriteArrayList;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Future;
import java.util.jar.Attributes;
import java.util.jar.JarFile;
import java.util.jar.Manifest;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.jps.model.java.JdkVersionDetector;
import org.jetbrains.jps.service.SharedThreadPool;

public class JdkVersionDetectorImpl
extends JdkVersionDetector {
    private static final Logger LOG = Logger.getInstance(JdkVersionDetectorImpl.class);

    @Override
    @Nullable
    public JdkVersionDetector.JdkVersionInfo detectJdkVersionInfo(@NotNull String homePath) {
        if (homePath == null) {
            JdkVersionDetectorImpl.$$$reportNull$$$0(0);
        }
        return this.detectJdkVersionInfo(homePath, SharedThreadPool.getInstance());
    }

    @Override
    @Nullable
    public JdkVersionDetector.JdkVersionInfo detectJdkVersionInfo(@NotNull String homePath, @NotNull ExecutorService runner) {
        JdkVersionDetector.JdkVersionInfo version;
        if (homePath == null) {
            JdkVersionDetectorImpl.$$$reportNull$$$0(1);
        }
        if (runner == null) {
            JdkVersionDetectorImpl.$$$reportNull$$$0(2);
        }
        if ((version = JdkVersionDetectorImpl.detectFromRelease(homePath)) != null) {
            return version;
        }
        version = JdkVersionDetectorImpl.detectFromJar(homePath);
        if (version != null) {
            return version;
        }
        return JdkVersionDetectorImpl.detectFromOutput(homePath, runner);
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @Nullable
    private static JdkVersionDetector.JdkVersionInfo detectFromRelease(String homePath) {
        Path releaseFile = Paths.get(homePath, "release");
        if (!Files.isRegularFile(releaseFile, new LinkOption[0])) return null;
        Properties p = new Properties();
        try (InputStream stream = Files.newInputStream(releaseFile, new OpenOption[0]);){
            JdkVersionDetector.JdkVersionInfo fromJar;
            p.load(stream);
            String versionString = p.getProperty("JAVA_FULL_VERSION", p.getProperty("JAVA_VERSION"));
            if (versionString == null) return null;
            JavaVersion version = JavaVersion.parse(versionString);
            JdkVersionDetector.Variant variant = JdkVersionDetectorImpl.detectVariant(p);
            if (variant == null && version.feature < 9 && (fromJar = JdkVersionDetectorImpl.detectFromJar(homePath)) != null) {
                variant = fromJar.variant;
            }
            CpuArch arch = CpuArch.fromString(JdkVersionDetectorImpl.unquoteProperty(p, "OS_ARCH"));
            JdkVersionDetector.JdkVersionInfo jdkVersionInfo = new JdkVersionDetector.JdkVersionInfo(version, variant, arch);
            return jdkVersionInfo;
        }
        catch (IOException | IllegalArgumentException e) {
            LOG.info(releaseFile.toString(), e);
        }
        return null;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @Nullable
    private static JdkVersionDetector.JdkVersionInfo detectFromJar(String homePath) {
        Path rtFile = Paths.get(homePath, "jre/lib/rt.jar");
        if (!Files.isRegularFile(rtFile, new LinkOption[0])) return null;
        try (JarFile rtJar = new JarFile(rtFile.toFile(), false);){
            Manifest manifest = rtJar.getManifest();
            if (manifest == null) return null;
            String versionString = manifest.getMainAttributes().getValue(Attributes.Name.IMPLEMENTATION_VERSION);
            if (versionString == null) return null;
            JavaVersion version = JavaVersion.parse(versionString);
            boolean x64 = SystemInfo.isMac || Files.isDirectory(rtFile.resolveSibling("amd64"), new LinkOption[0]);
            String vendorString = manifest.getMainAttributes().getValue(Attributes.Name.IMPLEMENTATION_VENDOR);
            JdkVersionDetector.Variant variant = vendorString != null ? JdkVersionDetectorImpl.detectVendor(vendorString) : null;
            JdkVersionDetector.JdkVersionInfo jdkVersionInfo = new JdkVersionDetector.JdkVersionInfo(version, variant, x64 ? CpuArch.X86_64 : CpuArch.UNKNOWN);
            return jdkVersionInfo;
        }
        catch (IOException | IllegalArgumentException e) {
            LOG.info(rtFile.toString(), e);
        }
        return null;
    }

    @Nullable
    private static JdkVersionDetector.JdkVersionInfo detectFromOutput(String homePath, ExecutorService runner) {
        Path javaExe = Paths.get(homePath, "bin/" + (SystemInfo.isWindows ? "java.exe" : "java"));
        if (Files.isExecutable(javaExe)) {
            try {
                Process process = new ProcessBuilder(javaExe.toString(), "-version").redirectErrorStream(true).start();
                VersionOutputReader reader = new VersionOutputReader(process.getInputStream(), runner);
                try {
                    reader.waitFor();
                }
                catch (InterruptedException e) {
                    LOG.info(e);
                    process.destroy();
                }
                List lines = reader.myLines;
                while (!lines.isEmpty() && ((String)lines.get(0)).startsWith("Picked up ")) {
                    lines.remove(0);
                }
                if (!lines.isEmpty()) {
                    JavaVersion base = JavaVersion.parse((String)lines.get(0));
                    JavaVersion rt = JavaVersion.tryParse(lines.size() > 2 ? (String)lines.get(1) : null);
                    JavaVersion version = rt != null && rt.feature == base.feature && rt.minor == base.minor ? rt : base;
                    return new JdkVersionDetector.JdkVersionInfo(version, null, CpuArch.UNKNOWN);
                }
            }
            catch (IOException | IllegalArgumentException e) {
                LOG.info(javaExe.toString(), e);
            }
        }
        return null;
    }

    @Nullable
    private static String unquoteProperty(Properties properties, String name) {
        String value = properties.getProperty(name);
        if (value != null && value.length() >= 2 && value.charAt(0) == '\"') {
            value = value.substring(1, value.length() - 1);
        }
        return value;
    }

    @Nullable
    private static JdkVersionDetector.Variant detectVariant(Properties p) {
        String implementor;
        String implementorVersion = JdkVersionDetectorImpl.unquoteProperty(p, "IMPLEMENTOR_VERSION");
        if (implementorVersion != null) {
            if (implementorVersion.startsWith("AdoptOpenJDK")) {
                String variant = JdkVersionDetectorImpl.unquoteProperty(p, "JVM_VARIANT");
                return "OpenJ9".equalsIgnoreCase(variant) ? JdkVersionDetector.Variant.AdoptOpenJdk_J9 : JdkVersionDetector.Variant.AdoptOpenJdk_HS;
            }
            if (implementorVersion.startsWith("Corretto")) {
                return JdkVersionDetector.Variant.Corretto;
            }
            if (implementorVersion.endsWith("-IBM")) {
                return JdkVersionDetector.Variant.IBM;
            }
            if (implementorVersion.startsWith("JBR-")) {
                return JdkVersionDetector.Variant.JBR;
            }
            if (implementorVersion.startsWith("SapMachine")) {
                return JdkVersionDetector.Variant.SapMachine;
            }
            if (implementorVersion.startsWith("Zulu")) {
                return JdkVersionDetector.Variant.Zulu;
            }
        }
        if ((implementor = JdkVersionDetectorImpl.unquoteProperty(p, "IMPLEMENTOR")) != null) {
            if (implementor.startsWith("AdoptOpenJDK")) {
                String variant = JdkVersionDetectorImpl.unquoteProperty(p, "JVM_VARIANT");
                return "OpenJ9".equalsIgnoreCase(variant) ? JdkVersionDetector.Variant.AdoptOpenJdk_J9 : JdkVersionDetector.Variant.AdoptOpenJdk_HS;
            }
            if (implementor.startsWith("GraalVM")) {
                return JdkVersionDetector.Variant.GraalVM;
            }
            return JdkVersionDetectorImpl.detectVendor(implementor);
        }
        if (p.getProperty("GRAALVM_VERSION") != null) {
            return JdkVersionDetector.Variant.GraalVM;
        }
        return null;
    }

    @Nullable
    private static JdkVersionDetector.Variant detectVendor(String implementor) {
        if (implementor.startsWith("Amazon")) {
            return JdkVersionDetector.Variant.Corretto;
        }
        if (implementor.startsWith("Azul")) {
            return JdkVersionDetector.Variant.Zulu;
        }
        if (implementor.startsWith("BellSoft")) {
            return JdkVersionDetector.Variant.Liberica;
        }
        if (implementor.startsWith("Eclipse")) {
            return JdkVersionDetector.Variant.Temurin;
        }
        if (implementor.startsWith("IBM")) {
            return JdkVersionDetector.Variant.IBM;
        }
        if (implementor.startsWith("International Business")) {
            return JdkVersionDetector.Variant.Semeru;
        }
        if (implementor.startsWith("JetBrains")) {
            return JdkVersionDetector.Variant.JBR;
        }
        if (implementor.startsWith("Oracle")) {
            return JdkVersionDetector.Variant.Oracle;
        }
        if (implementor.startsWith("SAP")) {
            return JdkVersionDetector.Variant.SapMachine;
        }
        return null;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2 = new Object[3];
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[0] = "homePath";
                break;
            }
            case 2: {
                objectArray = objectArray2;
                objectArray2[0] = "runner";
                break;
            }
        }
        objectArray[1] = "org/jetbrains/jps/model/java/impl/JdkVersionDetectorImpl";
        objectArray[2] = "detectJdkVersionInfo";
        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
    }

    private static class VersionOutputReader
    extends BaseOutputReader {
        private static final BaseOutputReader.Options OPTIONS = new BaseOutputReader.Options(){

            @Override
            public BaseDataReader.SleepingPolicy policy() {
                return BaseDataReader.SleepingPolicy.BLOCKING;
            }

            @Override
            public boolean sendIncompleteLines() {
                return false;
            }

            @Override
            public boolean withSeparators() {
                return false;
            }
        };
        private final ExecutorService myRunner;
        private final List<String> myLines;

        VersionOutputReader(@NotNull InputStream stream, @NotNull ExecutorService runner) {
            if (stream == null) {
                VersionOutputReader.$$$reportNull$$$0(0);
            }
            if (runner == null) {
                VersionOutputReader.$$$reportNull$$$0(1);
            }
            super(stream, CharsetToolkit.getDefaultSystemCharset(), OPTIONS);
            this.myRunner = runner;
            this.myLines = new CopyOnWriteArrayList<String>();
            this.start("java -version");
        }

        @Override
        @NotNull
        protected Future<?> executeOnPooledThread(@NotNull Runnable runnable) {
            if (runnable == null) {
                VersionOutputReader.$$$reportNull$$$0(2);
            }
            Future<?> future = this.myRunner.submit(runnable);
            if (future == null) {
                VersionOutputReader.$$$reportNull$$$0(3);
            }
            return future;
        }

        @Override
        protected void onTextAvailable(@NotNull String text) {
            if (text == null) {
                VersionOutputReader.$$$reportNull$$$0(4);
            }
            this.myLines.add(text);
            LOG.trace("text: " + text);
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            RuntimeException runtimeException;
            Object[] objectArray;
            Object[] objectArray2;
            int n2;
            String string2;
            switch (n) {
                default: {
                    string2 = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                    break;
                }
                case 3: {
                    string2 = "@NotNull method %s.%s must not return null";
                    break;
                }
            }
            switch (n) {
                default: {
                    n2 = 3;
                    break;
                }
                case 3: {
                    n2 = 2;
                    break;
                }
            }
            Object[] objectArray3 = new Object[n2];
            switch (n) {
                default: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "stream";
                    break;
                }
                case 1: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "runner";
                    break;
                }
                case 2: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "runnable";
                    break;
                }
                case 3: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "org/jetbrains/jps/model/java/impl/JdkVersionDetectorImpl$VersionOutputReader";
                    break;
                }
                case 4: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "text";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[1] = "org/jetbrains/jps/model/java/impl/JdkVersionDetectorImpl$VersionOutputReader";
                    break;
                }
                case 3: {
                    objectArray = objectArray2;
                    objectArray2[1] = "executeOnPooledThread";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray;
                    objectArray[2] = "<init>";
                    break;
                }
                case 2: {
                    objectArray = objectArray;
                    objectArray[2] = "executeOnPooledThread";
                    break;
                }
                case 3: {
                    break;
                }
                case 4: {
                    objectArray = objectArray;
                    objectArray[2] = "onTextAvailable";
                    break;
                }
            }
            String string3 = String.format(string2, objectArray);
            switch (n) {
                default: {
                    runtimeException = new IllegalArgumentException(string3);
                    break;
                }
                case 3: {
                    runtimeException = new IllegalStateException(string3);
                    break;
                }
            }
            throw runtimeException;
        }
    }
}

