/*
 * Decompiled with CFR 0.152.
 */
package com.android.chimpchat.adb;

import com.android.SdkConstants;
import com.android.chimpchat.adb.AdbChimpDevice;
import com.android.chimpchat.core.IChimpBackend;
import com.android.chimpchat.core.IChimpDevice;
import com.android.ddmlib.AndroidDebugBridge;
import com.android.ddmlib.IDevice;
import com.google.common.collect.Lists;
import java.io.File;
import java.util.List;
import java.util.logging.Level;
import java.util.logging.Logger;
import java.util.regex.Pattern;

public class AdbBackend
implements IChimpBackend {
    private static Logger LOG = Logger.getLogger(AdbBackend.class.getCanonicalName());
    private static final int CONNECTION_ITERATION_TIMEOUT_MS = 200;
    private final List<IChimpDevice> devices = Lists.newArrayList();
    private final AndroidDebugBridge bridge;
    private final boolean initAdb;

    public AdbBackend() {
        this(null, false);
    }

    public AdbBackend(String adbLocation, boolean noInitAdb) {
        boolean bl = this.initAdb = !noInitAdb;
        if (adbLocation == null) {
            adbLocation = this.findAdb();
        }
        if (this.initAdb) {
            AndroidDebugBridge.init((boolean)false);
        }
        this.bridge = AndroidDebugBridge.createBridge((String)adbLocation, (boolean)true);
    }

    private String findAdb() {
        String mrParentLocation = System.getProperty("com.android.monkeyrunner.bindir");
        if (mrParentLocation != null && mrParentLocation.length() != 0) {
            File platformTools = new File(new File(mrParentLocation).getParent(), "platform-tools");
            if (platformTools.isDirectory()) {
                return platformTools.getAbsolutePath() + File.separator + SdkConstants.FN_ADB;
            }
            return mrParentLocation + File.separator + SdkConstants.FN_ADB;
        }
        return SdkConstants.FN_ADB;
    }

    private IDevice findAttachedDevice(String deviceIdRegex) {
        Pattern pattern = Pattern.compile(deviceIdRegex);
        for (IDevice device : this.bridge.getDevices()) {
            String serialNumber = device.getSerialNumber();
            if (!pattern.matcher(serialNumber).matches()) continue;
            return device;
        }
        return null;
    }

    @Override
    public IChimpDevice waitForConnection() {
        return this.waitForConnection(Integer.MAX_VALUE, ".*");
    }

    @Override
    public IChimpDevice waitForConnection(long timeoutMs, String deviceIdRegex) {
        do {
            IDevice device;
            if ((device = this.findAttachedDevice(deviceIdRegex)) != null && device.getState() == IDevice.DeviceState.ONLINE) {
                AdbChimpDevice chimpDevice = new AdbChimpDevice(device);
                this.devices.add(chimpDevice);
                return chimpDevice;
            }
            try {
                Thread.sleep(200L);
            }
            catch (InterruptedException e) {
                LOG.log(Level.SEVERE, "Error sleeping", e);
            }
        } while ((timeoutMs -= 200L) > 0L);
        return null;
    }

    @Override
    public void shutdown() {
        for (IChimpDevice device : this.devices) {
            device.dispose();
        }
        if (this.initAdb) {
            AndroidDebugBridge.terminate();
        }
    }
}

