/*
 * Decompiled with CFR 0.152.
 */
package com.android.chimpchat.core;

import com.android.chimpchat.core.IChimpImage;
import java.awt.Graphics2D;
import java.awt.Image;
import java.awt.image.BufferedImage;
import java.awt.image.RenderedImage;
import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.IOException;
import java.lang.ref.WeakReference;
import java.util.Iterator;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.imageio.ImageIO;
import javax.imageio.ImageWriter;
import javax.imageio.stream.ImageOutputStream;

public abstract class ChimpImageBase
implements IChimpImage {
    private static Logger LOG = Logger.getLogger(ChimpImageBase.class.getCanonicalName());
    private WeakReference<BufferedImage> cachedBufferedImage = null;

    @Override
    public abstract BufferedImage createBufferedImage();

    @Override
    public BufferedImage getBufferedImage() {
        BufferedImage img;
        if (this.cachedBufferedImage != null && (img = (BufferedImage)this.cachedBufferedImage.get()) != null) {
            return img;
        }
        img = this.createBufferedImage();
        this.cachedBufferedImage = new WeakReference<BufferedImage>(img);
        return img;
    }

    @Override
    public byte[] convertToBytes(String format) {
        BufferedImage argb = this.convertSnapshot();
        ByteArrayOutputStream os = new ByteArrayOutputStream();
        try {
            ImageIO.write((RenderedImage)argb, format, os);
        }
        catch (IOException e) {
            return new byte[0];
        }
        return os.toByteArray();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean writeToFile(String path, String format) {
        if (format != null) {
            return this.writeToFileHelper(path, format);
        }
        int offset = path.lastIndexOf(46);
        if (offset < 0) {
            return this.writeToFileHelper(path, "png");
        }
        String ext = path.substring(offset + 1);
        Iterator<ImageWriter> writers = ImageIO.getImageWritersBySuffix(ext);
        if (!writers.hasNext()) {
            return this.writeToFileHelper(path, "png");
        }
        ImageWriter writer = writers.next();
        BufferedImage image = this.convertSnapshot();
        try {
            File f = new File(path);
            f.delete();
            ImageOutputStream outputStream = ImageIO.createImageOutputStream(f);
            writer.setOutput(outputStream);
            try {
                writer.write(image);
            }
            finally {
                writer.dispose();
                outputStream.flush();
            }
        }
        catch (IOException e) {
            return false;
        }
        return true;
    }

    @Override
    public int getPixel(int x, int y) {
        BufferedImage image = this.getBufferedImage();
        return image.getRGB(x, y);
    }

    private BufferedImage convertSnapshot() {
        BufferedImage image = this.getBufferedImage();
        BufferedImage argb = new BufferedImage(image.getWidth(), image.getHeight(), 2);
        Graphics2D g = argb.createGraphics();
        g.drawImage((Image)image, 0, 0, null);
        g.dispose();
        return argb;
    }

    private boolean writeToFileHelper(String path, String format) {
        BufferedImage argb = this.convertSnapshot();
        try {
            ImageIO.write((RenderedImage)argb, format, new File(path));
        }
        catch (IOException e) {
            return false;
        }
        return true;
    }

    @Override
    public boolean sameAs(IChimpImage other, double percent) {
        BufferedImage otherImage = other.getBufferedImage();
        BufferedImage myImage = this.getBufferedImage();
        if (otherImage.getWidth() != myImage.getWidth()) {
            return false;
        }
        if (otherImage.getHeight() != myImage.getHeight()) {
            return false;
        }
        int[] otherPixel = new int[1];
        int[] myPixel = new int[1];
        int width = myImage.getWidth();
        int height = myImage.getHeight();
        int numDiffPixels = 0;
        for (int y = 0; y < height; ++y) {
            for (int x = 0; x < width; ++x) {
                if (myImage.getRGB(x, y) == otherImage.getRGB(x, y)) continue;
                ++numDiffPixels;
            }
        }
        double numberPixels = height * width;
        double diffPercent = (double)numDiffPixels / numberPixels;
        return percent <= 1.0 - diffPercent;
    }

    public static IChimpImage loadImageFromFile(String path) {
        File f = new File(path);
        if (f.exists() && f.canRead()) {
            try {
                BufferedImage bufferedImage = ImageIO.read(new File(path));
                if (bufferedImage == null) {
                    LOG.log(Level.WARNING, "Cannot decode file %s", path);
                    return null;
                }
                return new BufferedImageChimpImage(bufferedImage);
            }
            catch (IOException e) {
                LOG.log(Level.WARNING, "Exception trying to decode image", e);
                return null;
            }
        }
        LOG.log(Level.WARNING, "Cannot read file %s", path);
        return null;
    }

    @Override
    public IChimpImage getSubImage(int x, int y, int w, int h) {
        BufferedImage image = this.getBufferedImage();
        return new BufferedImageChimpImage(image.getSubimage(x, y, w, h));
    }

    private static class BufferedImageChimpImage
    extends ChimpImageBase {
        private final BufferedImage image;

        public BufferedImageChimpImage(BufferedImage image) {
            this.image = image;
        }

        @Override
        public BufferedImage createBufferedImage() {
            return this.image;
        }
    }
}

