/*
 * Decompiled with CFR 0.152.
 */
package com.android.chimpchat.core;

import java.util.HashMap;
import java.util.Map;

public enum TouchPressType {
    DOWN("down"),
    UP("up"),
    DOWN_AND_UP("downAndUp"),
    MOVE("move");

    private static final Map<String, TouchPressType> identifierToEnum;
    private String identifier;

    private TouchPressType(String identifier) {
        this.identifier = identifier;
    }

    public String getIdentifier() {
        return this.identifier;
    }

    public static TouchPressType fromIdentifier(String name) {
        return identifierToEnum.get(name);
    }

    static {
        identifierToEnum = new HashMap<String, TouchPressType>();
        for (TouchPressType type : TouchPressType.values()) {
            identifierToEnum.put(type.identifier, type);
        }
    }
}

