/*
 * Decompiled with CFR 0.152.
 */
package com.android.assetstudiolib;

import com.android.assetstudiolib.GeneratedIcon;
import com.android.assetstudiolib.GeneratedIcons;
import com.android.assetstudiolib.GeneratedImageIcon;
import com.android.assetstudiolib.GeneratedXmlResource;
import com.android.assetstudiolib.GraphicGenerator;
import com.android.assetstudiolib.GraphicGeneratorContext;
import com.android.assetstudiolib.IconCategory;
import com.android.assetstudiolib.LauncherIconGenerator;
import com.android.assetstudiolib.PrimitiveShapesHelper;
import com.android.ide.common.internal.WaitableExecutor;
import com.android.ide.common.util.AssetUtil;
import com.android.resources.Density;
import java.awt.AlphaComposite;
import java.awt.Color;
import java.awt.Dimension;
import java.awt.Graphics2D;
import java.awt.Image;
import java.awt.Paint;
import java.awt.Rectangle;
import java.awt.RenderingHints;
import java.awt.image.BufferedImage;
import java.nio.file.Paths;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.concurrent.Callable;

public class AdaptiveIconGenerator
extends GraphicGenerator {
    private static final Rectangle IMAGE_SIZE_VIEW_PORT_WEB_PX = new Rectangle(0, 0, 512, 512);
    private static final Rectangle IMAGE_SIZE_FULL_BLEED_WEB_PX = new Rectangle(0, 0, 768, 768);
    private static final Rectangle IMAGE_SIZE_FULL_BLEED_DP = new Rectangle(0, 0, 108, 108);
    private static final Rectangle IMAGE_SIZE_VIEWPORT_DP = new Rectangle(0, 0, 72, 72);
    private static final Rectangle IMAGE_SIZE_LEGACY_DP = new Rectangle(0, 0, 48, 48);
    private static final Rectangle IMAGE_SIZE_SAFE_ZONE_DP = new Rectangle(0, 0, 66, 66);

    @Override
    public GeneratedIcons generateIcons(GraphicGeneratorContext context, GraphicGenerator.Options options, String name) {
        List results;
        AdaptiveIconOptions adaptiveIconOptions = (AdaptiveIconOptions)options;
        ImageCache cache = new ImageCache(context);
        ArrayList<Callable<GeneratedIcon>> tasks = new ArrayList<Callable<GeneratedIcon>>();
        this.createOutputIconsTasks(cache, name, adaptiveIconOptions, tasks);
        this.createXmlDrawableResourcesTasks(name, adaptiveIconOptions, tasks);
        AdaptiveIconGenerator.createPreviewImagesTasks(cache, adaptiveIconOptions, tasks);
        WaitableExecutor executor = WaitableExecutor.useGlobalSharedThreadPool();
        tasks.forEach(arg_0 -> ((WaitableExecutor)executor).execute(arg_0));
        try {
            results = executor.waitForTasksWithQuickFail(true);
        }
        catch (InterruptedException e) {
            throw new RuntimeException(e);
        }
        GeneratedIcons icons = new GeneratedIcons();
        results.forEach(icons::add);
        return icons;
    }

    private void createOutputIconsTasks(ImageCache imageCache, String name, AdaptiveIconOptions options, List<Callable<GeneratedIcon>> tasks) {
        if (!options.generateOutputIcons) {
            return;
        }
        for (Density density : new Density[]{Density.MEDIUM, Density.HIGH, Density.XHIGH, Density.XXHIGH, Density.XXXHIGH}) {
            AdaptiveIconOptions localOptions = AdaptiveIconGenerator.cloneOptions(options);
            localOptions.density = density;
            localOptions.showGrid = false;
            localOptions.showSafeZone = false;
            this.createOutputIconsForSingleDensityTasks(imageCache, name, localOptions, density, tasks);
        }
        if (options.generateWebIcon) {
            tasks.add(() -> {
                AdaptiveIconOptions localOptions = AdaptiveIconGenerator.cloneOptions(options);
                localOptions.showGrid = false;
                localOptions.showSafeZone = false;
                localOptions.generateWebIcon = true;
                localOptions.generateOutputIcons = true;
                localOptions.generatePreviewIcons = false;
                localOptions.legacyIconShape = localOptions.webIconShape;
                BufferedImage image = AdaptiveIconGenerator.generateLegacyImage(imageCache, localOptions);
                return new GeneratedImageIcon(name, Paths.get(this.getIconPath(localOptions, name), new String[0]), IconCategory.WEB, Density.NODPI, image);
            });
        }
    }

    private void createOutputIconsForSingleDensityTasks(ImageCache imageCache, String name, AdaptiveIconOptions options, Density density, List<Callable<GeneratedIcon>> tasks) {
        tasks.add(() -> {
            AdaptiveIconOptions foregroundOptions = AdaptiveIconGenerator.cloneOptions(options);
            foregroundOptions.generateWebIcon = false;
            foregroundOptions.generatePreviewIcons = false;
            foregroundOptions.generateOutputIcons = true;
            BufferedImage foregroundImage = AdaptiveIconGenerator.generateAdaptiveIconForegroundLayer(imageCache, foregroundOptions);
            return new GeneratedImageIcon(foregroundOptions.foregroundLayerName, Paths.get(this.getIconPath(foregroundOptions, foregroundOptions.foregroundLayerName), new String[0]), IconCategory.ADAPTIVE_FOREGROUND_LAYER, density, foregroundImage);
        });
        if (AdaptiveIconGenerator.backgroundIsImage(options)) {
            tasks.add(() -> {
                AdaptiveIconOptions backgroundOptions = AdaptiveIconGenerator.cloneOptions(options);
                backgroundOptions.generateWebIcon = false;
                backgroundOptions.generatePreviewIcons = false;
                backgroundOptions.generateOutputIcons = true;
                BufferedImage backgroundImage = AdaptiveIconGenerator.generateAdaptiveIconBackgroundLayer(imageCache, backgroundOptions);
                return new GeneratedImageIcon(backgroundOptions.backgroundLayerName, Paths.get(this.getIconPath(backgroundOptions, backgroundOptions.backgroundLayerName), new String[0]), IconCategory.ADAPTIVE_BACKGROUND_LAYER, density, backgroundImage);
            });
        }
        if (options.generateLegacyIcon) {
            tasks.add(() -> {
                AdaptiveIconOptions legacyOptions = AdaptiveIconGenerator.cloneOptions(options);
                legacyOptions.previewShape = PreviewShape.LEGACY;
                legacyOptions.generateWebIcon = false;
                legacyOptions.generatePreviewIcons = false;
                legacyOptions.generateOutputIcons = true;
                BufferedImage legacy = AdaptiveIconGenerator.generateLegacyImage(imageCache, legacyOptions);
                return new GeneratedImageIcon(name, Paths.get(this.getIconPath(legacyOptions, name), new String[0]), IconCategory.LEGACY, density, legacy);
            });
        }
        if (options.generateRoundIcon) {
            tasks.add(() -> {
                AdaptiveIconOptions legacyOptions = AdaptiveIconGenerator.cloneOptions(options);
                legacyOptions.previewShape = PreviewShape.LEGACY_ROUND;
                legacyOptions.generateWebIcon = false;
                legacyOptions.generatePreviewIcons = false;
                legacyOptions.generateOutputIcons = true;
                legacyOptions.legacyIconShape = GraphicGenerator.Shape.CIRCLE;
                BufferedImage legacyRound = AdaptiveIconGenerator.generateLegacyImage(imageCache, legacyOptions);
                return new GeneratedImageIcon(name + "_round", Paths.get(this.getIconPath(legacyOptions, name + "_round"), new String[0]), IconCategory.ROUND_API_25, density, legacyRound);
            });
        }
    }

    private void createXmlDrawableResourcesTasks(String name, AdaptiveIconOptions options, List<Callable<GeneratedIcon>> tasks) {
        if (!options.generateOutputIcons) {
            return;
        }
        AdaptiveIconOptions xmlOptions = AdaptiveIconGenerator.cloneOptions(options);
        xmlOptions.density = Density.ANYDPI;
        xmlOptions.generateWebIcon = false;
        xmlOptions.iconFolderKind = GraphicGenerator.IconFolderKind.MIPMAP_V26;
        tasks.add(() -> {
            String xmlAdaptiveIcon = AdaptiveIconGenerator.getAdaptiveIconXml(xmlOptions);
            return new GeneratedXmlResource(name, Paths.get(this.getIconPath(xmlOptions, name), new String[0]), IconCategory.XML_RESOURCE, xmlAdaptiveIcon);
        });
        tasks.add(() -> {
            String xmlAdaptiveIcon = AdaptiveIconGenerator.getAdaptiveIconXml(xmlOptions);
            return new GeneratedXmlResource(name + "_round", Paths.get(this.getIconPath(xmlOptions, name + "_round"), new String[0]), IconCategory.XML_RESOURCE, xmlAdaptiveIcon);
        });
        if (xmlOptions.backgroundImage == null) {
            tasks.add(() -> {
                AdaptiveIconOptions iconPathOptions = AdaptiveIconGenerator.cloneOptions(xmlOptions);
                iconPathOptions.generateWebIcon = false;
                iconPathOptions.density = Density.ANYDPI;
                iconPathOptions.iconFolderKind = GraphicGenerator.IconFolderKind.VALUES;
                String xmlColor = String.format("<?xml version=\"1.0\" encoding=\"utf-8\"?>\n<resources>\n  <color name=\"%s\">#%06X</color>\n</resources>", adaptiveIconOptions.backgroundLayerName, adaptiveIconOptions.backgroundColor & 0xFFFFFF);
                return new GeneratedXmlResource(name, Paths.get(this.getIconPath(iconPathOptions, adaptiveIconOptions.backgroundLayerName), new String[0]), IconCategory.XML_RESOURCE, xmlColor);
            });
        }
    }

    private static String getAdaptiveIconXml(AdaptiveIconOptions options) {
        String xmlAdaptiveIcon;
        if (AdaptiveIconGenerator.backgroundIsImage(options)) {
            String xmlFormat = "<?xml version=\"1.0\" encoding=\"utf-8\"?>\n<adaptive-icon xmlns:android=\"http://schemas.android.com/apk/res/android\">\n    <background android:drawable=\"@mipmap/%s\"/>\n    <foreground android:drawable=\"@mipmap/%s\"/>\n</adaptive-icon>";
            xmlAdaptiveIcon = String.format(xmlFormat, options.backgroundLayerName, options.foregroundLayerName);
        } else {
            String xmlFormat = "<?xml version=\"1.0\" encoding=\"utf-8\"?>\n<adaptive-icon xmlns:android=\"http://schemas.android.com/apk/res/android\">\n    <background android:drawable=\"@color/%s\"/>\n    <foreground android:drawable=\"@mipmap/%s\"/>\n</adaptive-icon>";
            xmlAdaptiveIcon = String.format(xmlFormat, options.backgroundLayerName, options.foregroundLayerName);
        }
        return xmlAdaptiveIcon;
    }

    private static boolean backgroundIsImage(AdaptiveIconOptions adaptiveIconOptions) {
        return adaptiveIconOptions.backgroundImage != null;
    }

    private static void createPreviewImagesTasks(ImageCache imageCache, AdaptiveIconOptions options, List<Callable<GeneratedIcon>> tasks) {
        if (!options.generatePreviewIcons) {
            return;
        }
        ArrayList<PreviewShape> previewShapes = new ArrayList<PreviewShape>();
        previewShapes.add(PreviewShape.FULL_BLEED);
        previewShapes.add(PreviewShape.SQUIRCLE);
        previewShapes.add(PreviewShape.CIRCLE);
        previewShapes.add(PreviewShape.SQUARE);
        previewShapes.add(PreviewShape.ROUNDED_SQUARE);
        if (options.generateLegacyIcon) {
            previewShapes.add(PreviewShape.LEGACY);
        }
        if (options.generateRoundIcon) {
            previewShapes.add(PreviewShape.LEGACY_ROUND);
        }
        if (options.generateWebIcon) {
            previewShapes.add(PreviewShape.WEB);
        }
        for (PreviewShape previewShape : previewShapes) {
            tasks.add(() -> {
                AdaptiveIconOptions localOptions = AdaptiveIconGenerator.cloneOptions(options);
                localOptions.density = adaptiveIconOptions.previewDensity;
                localOptions.previewShape = previewShape;
                localOptions.generateLegacyIcon = previewShape == PreviewShape.LEGACY;
                localOptions.generateRoundIcon = previewShape == PreviewShape.LEGACY_ROUND;
                localOptions.generateWebIcon = previewShape == PreviewShape.WEB;
                BufferedImage image = AdaptiveIconGenerator.generatePreviewImage(imageCache, localOptions);
                return new GeneratedImageIcon(previewShape.id, null, IconCategory.PREVIEW, localOptions.density, image);
            });
        }
    }

    @Override
    public void generate(String category, Map<String, Map<String, BufferedImage>> categoryMap, GraphicGeneratorContext context, GraphicGenerator.Options options, String name) {
        AdaptiveIconOptions adaptiveIconOptions = (AdaptiveIconOptions)options;
        AdaptiveIconOptions localOptions = AdaptiveIconGenerator.cloneOptions(adaptiveIconOptions);
        localOptions.generateWebIcon = false;
        GeneratedIcons icons = this.generateIcons(context, options, name);
        icons.getList().stream().filter(x -> x instanceof GeneratedImageIcon).map(x -> (GeneratedImageIcon)x).filter(x -> x.getOutputPath() != null).forEach(x -> {
            assert (x.getOutputPath() != null);
            Map imageMap = categoryMap.computeIfAbsent(x.getCategory().toString(), k -> new LinkedHashMap());
            AdaptiveIconOptions iconOptions = AdaptiveIconGenerator.cloneOptions(localOptions);
            iconOptions.density = x.getDensity();
            iconOptions.iconFolderKind = GraphicGenerator.IconFolderKind.MIPMAP;
            iconOptions.generateWebIcon = x.getCategory() == IconCategory.WEB;
            imageMap.put(x.getOutputPath().toString(), x.getImage());
        });
    }

    @Override
    public BufferedImage generate(GraphicGeneratorContext context, GraphicGenerator.Options options) {
        ImageCache imageCache = new ImageCache(context);
        return AdaptiveIconGenerator.generatePreviewImage(imageCache, (AdaptiveIconOptions)options);
    }

    private static BufferedImage generatePreviewImage(ImageCache imageCache, AdaptiveIconOptions options) {
        switch (options.previewShape) {
            case CIRCLE: 
            case SQUIRCLE: 
            case ROUNDED_SQUARE: 
            case SQUARE: {
                return AdaptiveIconGenerator.generateViewportPreviewImage(imageCache, options);
            }
            case LEGACY: {
                options.generatePreviewIcons = true;
                options.generateWebIcon = false;
                return AdaptiveIconGenerator.generateLegacyImage(imageCache, options);
            }
            case LEGACY_ROUND: {
                options.generatePreviewIcons = true;
                options.generateWebIcon = false;
                options.legacyIconShape = GraphicGenerator.Shape.CIRCLE;
                return AdaptiveIconGenerator.generateLegacyImage(imageCache, options);
            }
            case FULL_BLEED: {
                BufferedImage image = AdaptiveIconGenerator.generateFullBleedPreviewImage(imageCache, options);
                return AdaptiveIconGenerator.scaledPreviewImage(image, 0.8f);
            }
            case WEB: {
                options.generatePreviewIcons = true;
                options.generateWebIcon = true;
                options.legacyIconShape = options.webIconShape;
                BufferedImage image = AdaptiveIconGenerator.generateLegacyImage(imageCache, options);
                image = AssetUtil.trimmedImage((BufferedImage)image);
                float scale = AdaptiveIconGenerator.getMdpiScaleFactor(options.previewDensity);
                return AdaptiveIconGenerator.scaledPreviewImage(image, 0.25f * scale);
            }
        }
        throw new IllegalArgumentException();
    }

    private static AdaptiveIconOptions cloneOptions(AdaptiveIconOptions options) {
        AdaptiveIconOptions localOptions = new AdaptiveIconOptions();
        localOptions.minSdk = options.minSdk;
        localOptions.sourceImage = options.sourceImage;
        localOptions.backgroundImage = options.backgroundImage;
        localOptions.density = options.density;
        localOptions.previewDensity = options.previewDensity;
        localOptions.iconFolderKind = options.iconFolderKind;
        localOptions.useForegroundColor = options.useForegroundColor;
        localOptions.foregroundColor = options.foregroundColor;
        localOptions.backgroundColor = options.backgroundColor;
        localOptions.generateLegacyIcon = options.generateLegacyIcon;
        localOptions.generateRoundIcon = options.generateRoundIcon;
        localOptions.generateWebIcon = options.generateWebIcon;
        localOptions.generateOutputIcons = options.generateOutputIcons;
        localOptions.generatePreviewIcons = options.generatePreviewIcons;
        localOptions.previewShape = options.previewShape;
        localOptions.legacyIconShape = options.legacyIconShape;
        localOptions.webIconShape = options.webIconShape;
        localOptions.showGrid = options.showGrid;
        localOptions.showSafeZone = options.showSafeZone;
        localOptions.foregroundLayerName = options.foregroundLayerName;
        localOptions.backgroundLayerName = options.backgroundLayerName;
        return localOptions;
    }

    private static BufferedImage generateFullBleedPreviewImage(ImageCache imageCache, AdaptiveIconOptions options) {
        Layers layers = AdaptiveIconGenerator.generateAdaptiveIconLayers(imageCache, options);
        BufferedImage result = AdaptiveIconGenerator.mergeLayers(layers, Color.BLACK);
        AdaptiveIconGenerator.drawGrid(options, result);
        return result;
    }

    private static BufferedImage generateLegacyImage(ImageCache imageCache, AdaptiveIconOptions options) {
        Density legacyOrWebDensity = options.generateWebIcon ? null : options.density;
        Rectangle viewportRect = AdaptiveIconGenerator.getViewportRectangle(options);
        Rectangle legacyRect = AdaptiveIconGenerator.getLegacyRectangle(options);
        Rectangle legacyShapeRect = LauncherIconGenerator.getTargetRect(options.legacyIconShape, legacyOrWebDensity);
        Layers layers = AdaptiveIconGenerator.generateAdaptiveIconLayers(imageCache, options);
        BufferedImage fullBleed = AdaptiveIconGenerator.mergeLayers(layers);
        float viewportScale = AdaptiveIconGenerator.getRectangleInsideScale(viewportRect, legacyShapeRect);
        BufferedImage scaledFullBleed = options.generatePreviewIcons ? AdaptiveIconGenerator.scaledPreviewImage(fullBleed, viewportScale) : AdaptiveIconGenerator.scaledImage(fullBleed, viewportScale);
        BufferedImage shapeImageBack = null;
        BufferedImage shapeImageFore = null;
        BufferedImage shapeImageMask = null;
        if (options.legacyIconShape != GraphicGenerator.Shape.NONE) {
            shapeImageBack = LauncherIconGenerator.loadBackImage(imageCache.getContext(), options.legacyIconShape, legacyOrWebDensity);
            shapeImageFore = LauncherIconGenerator.loadStyleImage(imageCache.getContext(), options.legacyIconShape, legacyOrWebDensity, GraphicGenerator.Style.SIMPLE);
            shapeImageMask = LauncherIconGenerator.loadMaskImage(imageCache.getContext(), options.legacyIconShape, legacyOrWebDensity);
        }
        BufferedImage legacyImage = AssetUtil.newArgbBufferedImage((int)legacyRect.width, (int)legacyRect.height);
        Graphics2D gLegacy = (Graphics2D)legacyImage.getGraphics();
        if (shapeImageBack != null) {
            AssetUtil.drawCentered((Graphics2D)gLegacy, (BufferedImage)shapeImageBack, (Rectangle)legacyRect);
        }
        if (shapeImageMask != null) {
            scaledFullBleed = AdaptiveIconGenerator.applyMask(scaledFullBleed, shapeImageMask);
        }
        AssetUtil.drawCentered((Graphics2D)gLegacy, (BufferedImage)scaledFullBleed, (Rectangle)legacyRect);
        if (shapeImageFore != null) {
            gLegacy.drawImage((Image)shapeImageFore, 0, 0, null);
        }
        gLegacy.dispose();
        return legacyImage;
    }

    private static float getRectangleInsideScale(Rectangle source, Rectangle destination) {
        return AssetUtil.getRectangleInsideScale((Rectangle)source, (Rectangle)destination);
    }

    private static BufferedImage scaledImage(BufferedImage image, float scale) {
        int width = Math.round((float)image.getWidth() * scale);
        int height = Math.round((float)image.getHeight() * scale);
        return AdaptiveIconGenerator.scaledImage(image, width, height);
    }

    public static BufferedImage scaledImage(BufferedImage image, int width, int height) {
        return AssetUtil.scaledImage((BufferedImage)image, (int)width, (int)height);
    }

    private static BufferedImage scaledPreviewImage(BufferedImage image, float scale) {
        int width = Math.round((float)image.getWidth() * scale);
        int height = Math.round((float)image.getHeight() * scale);
        return AdaptiveIconGenerator.scaledPreviewImage(image, width, height);
    }

    public static BufferedImage scaledPreviewImage(BufferedImage source, int width, int height) {
        if (source.getWidth() == width && source.getHeight() == height) {
            return source;
        }
        BufferedImage scaledBufImage = new BufferedImage(width, height, 2);
        Graphics2D g = scaledBufImage.createGraphics();
        g.setRenderingHint(RenderingHints.KEY_INTERPOLATION, RenderingHints.VALUE_INTERPOLATION_BILINEAR);
        g.drawImage(source, 0, 0, width, height, null);
        g.dispose();
        return scaledBufImage;
    }

    private static BufferedImage generateViewportPreviewImage(ImageCache imageCache, AdaptiveIconOptions options) {
        Layers layers = AdaptiveIconGenerator.generateAdaptiveIconLayers(imageCache, options);
        BufferedImage result = AdaptiveIconGenerator.mergeLayers(layers);
        BufferedImage mask = AdaptiveIconGenerator.generateMaskLayer(imageCache, options, options.previewShape);
        result = AdaptiveIconGenerator.cropImageToViewport(options, result);
        result = AdaptiveIconGenerator.applyMask(result, mask);
        AdaptiveIconGenerator.drawGrid(options, result);
        return result;
    }

    private static BufferedImage cropImageToViewport(AdaptiveIconOptions options, BufferedImage image) {
        return AdaptiveIconGenerator.cropImage(image, AdaptiveIconGenerator.getViewportRectangle(options));
    }

    private static BufferedImage cropImage(BufferedImage image, Rectangle targetRect) {
        Rectangle imageRect = new Rectangle(0, 0, image.getWidth(), image.getHeight());
        BufferedImage subImage = image.getSubimage((imageRect.width - targetRect.width) / 2, (imageRect.height - targetRect.height) / 2, targetRect.width, targetRect.height);
        BufferedImage viewportImage = AssetUtil.newArgbBufferedImage((int)targetRect.width, (int)targetRect.height);
        Graphics2D gViewport = (Graphics2D)viewportImage.getGraphics();
        gViewport.drawImage((Image)subImage, 0, 0, null);
        gViewport.dispose();
        return viewportImage;
    }

    private static BufferedImage mergeLayers(Layers layers) {
        return AdaptiveIconGenerator.mergeLayers(layers, null);
    }

    private static BufferedImage mergeLayers(Layers layers, Color fillColor) {
        int width = Math.max(layers.background.getWidth(), layers.foreground.getWidth());
        int height = Math.max(layers.background.getHeight(), layers.foreground.getHeight());
        BufferedImage outImage = AssetUtil.newArgbBufferedImage((int)width, (int)height);
        Graphics2D gOut = (Graphics2D)outImage.getGraphics();
        if (fillColor != null) {
            gOut.setPaint(fillColor);
            gOut.fillRect(0, 0, width, height);
        }
        gOut.drawImage((Image)layers.background, 0, 0, null);
        gOut.drawImage((Image)layers.foreground, 0, 0, null);
        gOut.dispose();
        return outImage;
    }

    private static Layers generateAdaptiveIconLayers(ImageCache imageCache, AdaptiveIconOptions options) {
        BufferedImage backgroundImage = AdaptiveIconGenerator.generateAdaptiveIconBackgroundLayer(imageCache, options);
        BufferedImage foregroundImage = AdaptiveIconGenerator.generateAdaptiveIconForegroundLayer(imageCache, options);
        return new Layers(backgroundImage, foregroundImage);
    }

    private static BufferedImage generateMaskLayer(ImageCache imageCache, AdaptiveIconOptions options, PreviewShape shape) {
        String maskName;
        switch (shape) {
            case CIRCLE: {
                maskName = "circle";
                break;
            }
            case SQUARE: {
                maskName = "square";
                break;
            }
            case ROUNDED_SQUARE: {
                maskName = "rounded_corner";
                break;
            }
            case SQUIRCLE: {
                maskName = "squircle";
                break;
            }
            default: {
                maskName = null;
            }
        }
        if (maskName == null) {
            return null;
        }
        if (options.generateWebIcon) {
            String resourceName = String.format("/images/adaptive_icons_masks/adaptive_%s-%s.png", maskName, Density.XXXHIGH.getResourceValue());
            BufferedImage mask = imageCache.getContext().loadImageResource(resourceName);
            if (mask == null) {
                return null;
            }
            Rectangle maskRect = new Rectangle(0, 0, mask.getWidth(), mask.getHeight());
            float scale = AdaptiveIconGenerator.getRectangleInsideScale(maskRect, AdaptiveIconGenerator.getViewportRectangle(options));
            return options.generatePreviewIcons ? AdaptiveIconGenerator.scaledPreviewImage(mask, scale) : AdaptiveIconGenerator.scaledImage(mask, scale);
        }
        String resourceName = String.format("/images/adaptive_icons_masks/adaptive_%s-%s.png", maskName, options.density.getResourceValue());
        return imageCache.getContext().loadImageResource(resourceName);
    }

    private static Rectangle getFullBleedRectangle(AdaptiveIconOptions options) {
        if (options.generateWebIcon) {
            return IMAGE_SIZE_FULL_BLEED_WEB_PX;
        }
        return AssetUtil.scaleRectangle((Rectangle)IMAGE_SIZE_FULL_BLEED_DP, (float)GraphicGenerator.getMdpiScaleFactor(options.density));
    }

    private static Rectangle getViewportRectangle(AdaptiveIconOptions options) {
        if (options.generateWebIcon) {
            return IMAGE_SIZE_VIEW_PORT_WEB_PX;
        }
        return AssetUtil.scaleRectangle((Rectangle)IMAGE_SIZE_VIEWPORT_DP, (float)GraphicGenerator.getMdpiScaleFactor(options.density));
    }

    private static Rectangle getLegacyRectangle(AdaptiveIconOptions options) {
        if (options.generateWebIcon) {
            return IMAGE_SIZE_VIEW_PORT_WEB_PX;
        }
        return AssetUtil.scaleRectangle((Rectangle)IMAGE_SIZE_LEGACY_DP, (float)GraphicGenerator.getMdpiScaleFactor(options.density));
    }

    private static BufferedImage generateAdaptiveIconBackgroundLayer(ImageCache imageCache, AdaptiveIconOptions options) {
        Rectangle imageRect = AdaptiveIconGenerator.getFullBleedRectangle(options);
        if (AdaptiveIconGenerator.backgroundIsImage(options)) {
            return AdaptiveIconGenerator.generateAdaptiveIconLayer(imageCache, options.backgroundImage, imageRect, false, 0);
        }
        return AdaptiveIconGenerator.generateAdaptiveIconBackgroundLayerFlatColor(options, imageRect);
    }

    private static BufferedImage generateAdaptiveIconForegroundLayer(ImageCache imageCache, AdaptiveIconOptions options) {
        Rectangle imageRect = AdaptiveIconGenerator.getFullBleedRectangle(options);
        return AdaptiveIconGenerator.generateAdaptiveIconLayer(imageCache, options.sourceImage, imageRect, options.useForegroundColor, options.foregroundColor);
    }

    private static BufferedImage generateAdaptiveIconBackgroundLayerFlatColor(AdaptiveIconOptions options, Rectangle imageRect) {
        BufferedImage tempImage = AssetUtil.newArgbBufferedImage((int)imageRect.width, (int)imageRect.height);
        Graphics2D gTemp = (Graphics2D)tempImage.getGraphics();
        gTemp.setPaint(new Color(options.backgroundColor));
        gTemp.fillRect(0, 0, imageRect.width, imageRect.height);
        gTemp.dispose();
        return tempImage;
    }

    private static BufferedImage applyMask(BufferedImage image, BufferedImage mask) {
        if (mask == null) {
            return image;
        }
        Rectangle imageRect = new Rectangle(0, 0, image.getWidth(), image.getHeight());
        BufferedImage tempImage = AssetUtil.newArgbBufferedImage((int)imageRect.width, (int)imageRect.height);
        Graphics2D gTemp = (Graphics2D)tempImage.getGraphics();
        AssetUtil.drawCentered((Graphics2D)gTemp, (BufferedImage)mask, (Rectangle)imageRect);
        gTemp.setComposite(AlphaComposite.SrcIn);
        AssetUtil.drawCentered((Graphics2D)gTemp, (BufferedImage)image, (Rectangle)imageRect);
        gTemp.dispose();
        return tempImage;
    }

    private static BufferedImage generateAdaptiveIconLayer(ImageCache imageCache, BufferedImage sourceImage, Rectangle imageRect, boolean useFillColor, int fillColor) {
        return imageCache.getOrCreate(sourceImage, imageRect.getSize(), useFillColor, fillColor, () -> {
            BufferedImage iconImage = AssetUtil.newArgbBufferedImage((int)rectangle.width, (int)rectangle.height);
            Graphics2D gIcon = (Graphics2D)iconImage.getGraphics();
            AssetUtil.drawCenterInside((Graphics2D)gIcon, (BufferedImage)sourceImage, (Rectangle)imageRect);
            AssetUtil.Effect[] effects = useFillColor ? new AssetUtil.Effect[]{new AssetUtil.FillEffect((Paint)new Color(fillColor), 1.0)} : new AssetUtil.Effect[]{};
            BufferedImage effectImage = AssetUtil.newArgbBufferedImage((int)rectangle.width, (int)rectangle.height);
            Graphics2D gEffect = (Graphics2D)effectImage.getGraphics();
            AssetUtil.drawEffects((Graphics2D)gEffect, (BufferedImage)iconImage, (int)0, (int)0, (AssetUtil.Effect[])effects);
            gIcon.dispose();
            gEffect.dispose();
            return effectImage;
        });
    }

    private static void drawGrid(AdaptiveIconOptions adaptiveIconOptions, BufferedImage image) {
        Graphics2D gOut = (Graphics2D)image.getGraphics();
        AdaptiveIconGenerator.drawGrid(adaptiveIconOptions, gOut);
        gOut.dispose();
    }

    private static void drawGrid(AdaptiveIconOptions adaptiveIconOptions, Graphics2D gOut) {
        if (adaptiveIconOptions.generateWebIcon) {
            return;
        }
        if (adaptiveIconOptions.previewShape == PreviewShape.FULL_BLEED) {
            if (adaptiveIconOptions.showGrid || adaptiveIconOptions.showSafeZone) {
                AdaptiveIconGenerator.drawFullBleedIconGrid(adaptiveIconOptions, gOut);
            }
            return;
        }
        if (adaptiveIconOptions.previewShape == PreviewShape.LEGACY || adaptiveIconOptions.previewShape == PreviewShape.LEGACY_ROUND) {
            if (adaptiveIconOptions.showGrid) {
                AdaptiveIconGenerator.drawLegacyIconGrid(adaptiveIconOptions, gOut);
            }
            return;
        }
        if (adaptiveIconOptions.showGrid || adaptiveIconOptions.showSafeZone) {
            AdaptiveIconGenerator.drawAdaptiveIconGrid(adaptiveIconOptions, gOut);
        }
    }

    private static void drawAdaptiveIconGrid(AdaptiveIconOptions options, Graphics2D out) {
        float scaleFactor = GraphicGenerator.getMdpiScaleFactor(options.density);
        int size = AdaptiveIconGenerator.IMAGE_SIZE_VIEWPORT_DP.width;
        int center = size / 2;
        Color c = new Color(0.0f, 0.0f, 0.0f, 0.2f);
        out.setColor(c);
        out.setRenderingHint(RenderingHints.KEY_ANTIALIASING, RenderingHints.VALUE_ANTIALIAS_ON);
        PrimitiveShapesHelper g = new PrimitiveShapesHelper(out, scaleFactor);
        if (options.showGrid) {
            g.drawRect(0, 0, size, size);
            g.drawLine(0, 0, size, size);
            g.drawLine(size, 0, 0, size);
            g.drawLine(0, center, size, center);
            g.drawLine(center, 0, center, size);
            int arcSize = 4;
            int rect1 = 36;
            int rect2 = 44;
            int rect3 = 52;
            g.drawRoundRect((size - rect1) / 2, (size - rect3) / 2, rect1, rect3, arcSize, arcSize);
            g.drawRoundRect((size - rect2) / 2, (size - rect2) / 2, rect2, rect2, arcSize, arcSize);
            g.drawRoundRect((size - rect3) / 2, (size - rect1) / 2, rect3, rect1, arcSize, arcSize);
            g.drawCenteredCircle(center, center, 18);
            g.drawCenteredCircle(center, center, 26);
        }
        if (options.showSafeZone) {
            g.drawCenteredCircle(center, center, 33);
        }
    }

    private static void drawFullBleedIconGrid(AdaptiveIconOptions options, Graphics2D out) {
        float scaleFactor = GraphicGenerator.getMdpiScaleFactor(options.density);
        int size = AdaptiveIconGenerator.IMAGE_SIZE_FULL_BLEED_DP.width;
        int center = size / 2;
        Color c = new Color(0.0f, 0.0f, 0.0f, 0.2f);
        out.setColor(c);
        out.setRenderingHint(RenderingHints.KEY_ANTIALIASING, RenderingHints.VALUE_ANTIALIAS_ON);
        PrimitiveShapesHelper g = new PrimitiveShapesHelper(out, scaleFactor);
        if (options.showGrid) {
            g.drawRect(0, 0, size, size);
            g.drawRect(18, 18, AdaptiveIconGenerator.IMAGE_SIZE_VIEWPORT_DP.width, AdaptiveIconGenerator.IMAGE_SIZE_VIEWPORT_DP.height);
            g.drawLine(0, 0, size, size);
            g.drawLine(size, 0, 0, size);
            g.drawLine(0, center, size, center);
            g.drawLine(center, 0, center, size);
        }
        if (options.showSafeZone) {
            g.drawCenteredCircle(center, center, AdaptiveIconGenerator.IMAGE_SIZE_SAFE_ZONE_DP.width / 2);
        }
    }

    private static void drawLegacyIconGrid(AdaptiveIconOptions options, Graphics2D out) {
        float scaleFactor = GraphicGenerator.getMdpiScaleFactor(options.density);
        int size = AdaptiveIconGenerator.IMAGE_SIZE_LEGACY_DP.width;
        int center = size / 2;
        Color c = new Color(0.0f, 0.0f, 0.0f, 0.2f);
        out.setColor(c);
        out.setRenderingHint(RenderingHints.KEY_ANTIALIASING, RenderingHints.VALUE_ANTIALIAS_ON);
        PrimitiveShapesHelper g = new PrimitiveShapesHelper(out, scaleFactor);
        g.drawRect(0, 0, size, size);
        g.drawLine(0, 0, size, size);
        g.drawLine(size, 0, 0, size);
        g.drawLine(0, center, size, center);
        g.drawLine(center, 0, center, size);
        int arcSize = 3;
        int rect1 = 32;
        int rect3 = 44;
        g.drawRoundRect((size - rect1) / 2, (size - rect3) / 2, rect1, rect3, arcSize, arcSize);
        g.drawRoundRect((size - rect3) / 2, (size - rect1) / 2, rect3, rect1, arcSize, arcSize);
        g.drawCenteredCircle(center, center, 10);
        g.drawCenteredCircle(center, center, 22);
    }

    @Override
    protected boolean includeDensity(Density density) {
        return super.includeDensity(density) || density == Density.XXXHIGH;
    }

    @Override
    protected String getIconPath(GraphicGenerator.Options options, String name) {
        if (((AdaptiveIconOptions)options).generateWebIcon) {
            return name + "-web.png";
        }
        return super.getIconPath(options, name);
    }

    public static enum PreviewShape {
        NONE("none", "none"),
        CIRCLE("circle", "Circle"),
        SQUIRCLE("squircle", "Squircle"),
        ROUNDED_SQUARE("rounded-square", "Rounded Square"),
        SQUARE("square", "Square"),
        FULL_BLEED("full-bleed-layers", "Full Bleed Layers"),
        LEGACY("legacy", "Legacy Icon"),
        LEGACY_ROUND("legacy-round", "Round Icon"),
        WEB("web", "Google Play Store");

        public final String id;
        public final String displayName;

        private PreviewShape(String id, String displayName) {
            this.id = id;
            this.displayName = displayName;
        }
    }

    public static class AdaptiveIconOptions
    extends GraphicGenerator.Options {
        public String foregroundLayerName;
        public String backgroundLayerName;
        public boolean useForegroundColor = true;
        public int foregroundColor = 0;
        public int backgroundColor = 0;
        public BufferedImage backgroundImage;
        public boolean generateOutputIcons = true;
        public boolean generatePreviewIcons = true;
        public boolean generateLegacyIcon = true;
        public boolean generateRoundIcon = true;
        public boolean generateWebIcon;
        public PreviewShape previewShape = PreviewShape.NONE;
        public Density previewDensity;
        public GraphicGenerator.Shape legacyIconShape = GraphicGenerator.Shape.SQUARE;
        public GraphicGenerator.Shape webIconShape = GraphicGenerator.Shape.SQUARE;
        public boolean showGrid;
        public boolean showSafeZone;

        public AdaptiveIconOptions() {
            this.iconFolderKind = GraphicGenerator.IconFolderKind.MIPMAP;
        }
    }

    private static class Layers {
        public BufferedImage background;
        public BufferedImage foreground;

        public Layers(BufferedImage background, BufferedImage foreground) {
            this.background = background;
            this.foreground = foreground;
        }
    }

    private static class ImageCache {
        private final Object lock = new Object();
        private final GraphicGeneratorContext context;
        private final Map<Key, BufferedImage> map = new HashMap<Key, BufferedImage>();

        public ImageCache(GraphicGeneratorContext context) {
            this.context = context;
        }

        public GraphicGeneratorContext getContext() {
            return this.context;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public BufferedImage getOrCreate(BufferedImage image, Dimension imageRectSize, boolean useFillColor, int fillColor, Callable<BufferedImage> generator) {
            Key key = new Key(image, imageRectSize, useFillColor, fillColor);
            Object object = this.lock;
            synchronized (object) {
                BufferedImage value = this.map.get(key);
                if (value != null) {
                    return value;
                }
                try {
                    value = generator.call();
                }
                catch (Exception e) {
                    throw new RuntimeException(e);
                }
                assert (value != null);
                if (!this.map.containsKey(key)) {
                    this.map.put(key, value);
                }
                return value;
            }
        }

        private static class Key {
            private final BufferedImage image;
            private final Dimension imageRectSize;
            private final boolean useFillColor;
            private final int fillColor;

            public Key(BufferedImage image, Dimension imageRectSize, boolean useFillColor, int fillColor) {
                this.image = image;
                this.imageRectSize = imageRectSize;
                this.useFillColor = useFillColor;
                this.fillColor = fillColor;
            }

            public int hashCode() {
                return Objects.hash(this.image, this.imageRectSize, this.useFillColor, this.fillColor);
            }

            public boolean equals(Object obj) {
                if (!(obj instanceof Key)) {
                    return false;
                }
                Key other = (Key)obj;
                return Objects.equals(this.image, other.image) && Objects.equals(this.imageRectSize, other.imageRectSize) && this.useFillColor == other.useFillColor && this.fillColor == other.fillColor;
            }
        }
    }
}

