/*
 * Decompiled with CFR 0.152.
 */
package com.google.clearsilver.jsilver.resourceloader;

import com.google.clearsilver.jsilver.exceptions.JSilverTemplateNotFoundException;
import com.google.clearsilver.jsilver.resourceloader.BufferedResourceLoader;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.Reader;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ClassResourceLoader
extends BufferedResourceLoader {
    private final Class<?> cls;
    private final String basePath;

    public ClassResourceLoader(Class<?> cls) {
        this.cls = cls;
        this.basePath = "/" + cls.getPackage().getName().replace('.', '/');
    }

    public ClassResourceLoader(Class<?> cls, String basePath) {
        this.cls = cls;
        this.basePath = basePath;
    }

    @Override
    public Reader open(String name) throws IOException {
        InputStream stream = this.cls.getResourceAsStream(this.basePath + '/' + name);
        return stream == null ? null : this.buffer(new InputStreamReader(stream, this.getCharacterSet()));
    }

    @Override
    public Reader openOrFail(String name) throws JSilverTemplateNotFoundException, IOException {
        Reader reader = this.open(name);
        if (reader == null) {
            throw new JSilverTemplateNotFoundException("No '" + name + "' as class resource of " + this.cls.getName());
        }
        return reader;
    }
}

