/*
 * Decompiled with CFR 0.152.
 */
package com.android.builder.symbols;

import com.android.SdkConstants;
import com.android.builder.symbols.IdProvider;
import com.android.builder.symbols.RGeneration;
import com.android.builder.symbols.Symbol;
import com.android.builder.symbols.SymbolIo;
import com.android.builder.symbols.SymbolJavaType;
import com.android.builder.symbols.SymbolTable;
import com.android.ide.common.xml.AndroidManifestParser;
import com.android.ide.common.xml.ManifestData;
import com.android.io.FileWrapper;
import com.android.io.IAbstractFile;
import com.android.resources.ResourceType;
import com.google.common.annotations.VisibleForTesting;
import com.google.common.base.CharMatcher;
import com.google.common.base.Joiner;
import com.google.common.base.Preconditions;
import com.google.common.collect.HashMultimap;
import com.google.common.collect.ImmutableSet;
import com.google.common.collect.Lists;
import com.google.common.collect.SetMultimap;
import java.io.File;
import java.io.IOException;
import java.nio.file.Files;
import java.nio.file.OpenOption;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Set;
import java.util.function.Consumer;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import javax.xml.parsers.ParserConfigurationException;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import org.xml.sax.SAXException;

public final class SymbolUtils {
    private static final CharMatcher NORMALIZED_VALUE_NAME_CHARS = CharMatcher.anyOf((CharSequence)".:").precomputed();

    public static void processLibraryMainSymbolTable(SymbolTable librarySymbols, Set<File> libraries, String mainPackageName, File manifestFile, File sourceOut, File symbolsOut, File proguardOut, File mergedResources, SymbolTable platformSymbols, boolean disableMergeInLib) throws IOException {
        Preconditions.checkNotNull((Object)sourceOut, (Object)"Source output directory should not be null");
        Preconditions.checkNotNull((Object)symbolsOut, (Object)"Symbols output directory should not be null");
        if (mainPackageName == null || proguardOut != null) {
            ManifestData manifestData = SymbolUtils.parseManifest(manifestFile);
            if (mainPackageName == null) {
                mainPackageName = SymbolUtils.getPackageNameFromManifest(manifestData);
            }
            if (proguardOut != null) {
                Files.write(proguardOut.toPath(), SymbolUtils.generateMinifyKeepRules(manifestData, mergedResources), new OpenOption[0]);
            }
        }
        Set<SymbolTable> depSymbolTables = SymbolUtils.loadDependenciesSymbolTables(libraries, mainPackageName);
        SymbolTable mainSymbolTable = disableMergeInLib ? SymbolUtils.mergeAndRenumberSymbols(mainPackageName, librarySymbols, depSymbolTables, platformSymbols) : librarySymbols.rename(mainPackageName);
        SymbolUtils.generateRTxt(mainSymbolTable, symbolsOut);
        SymbolIo.exportToJava(mainSymbolTable, sourceOut, false);
        RGeneration.generateRForLibraries(mainSymbolTable, depSymbolTables, sourceOut, false);
    }

    @VisibleForTesting
    static SymbolTable mergeAndRenumberSymbols(String mainPackageName, SymbolTable librarySymbols, Set<SymbolTable> dependencySymbols, SymbolTable platformSymbols) {
        ArrayList tables = Lists.newArrayListWithCapacity((int)(dependencySymbols.size() + 1));
        tables.add(librarySymbols);
        tables.addAll(dependencySymbols);
        IdProvider idProvider = IdProvider.sequential();
        HashMultimap newSymbolMap = HashMultimap.create();
        HashMultimap arrayToAttrs = HashMultimap.create();
        Consumer<Symbol> symbolConsumer = arg_0 -> SymbolUtils.lambda$mergeAndRenumberSymbols$31((SetMultimap)newSymbolMap, (SetMultimap)arrayToAttrs, arg_0);
        tables.forEach(table -> table.getSymbols().values().forEach(symbolConsumer));
        SymbolTable.Builder tableBuilder = SymbolTable.builder().tablePackage(mainPackageName);
        HashMap<String, Symbol> attrToValue = new HashMap<String, Symbol>();
        for (ResourceType resourceType : newSymbolMap.keySet()) {
            ArrayList symbolNames = Lists.newArrayList((Iterable)newSymbolMap.get((Object)resourceType));
            Collections.sort(symbolNames);
            for (String symbolName : symbolNames) {
                String value = idProvider.next(resourceType);
                Symbol newSymbol = Symbol.createSymbol(resourceType, symbolName, SymbolJavaType.INT, value, Symbol.NO_CHILDREN);
                tableBuilder.add(newSymbol);
                if (resourceType != ResourceType.ATTR) continue;
                attrToValue.put(symbolName, newSymbol);
            }
        }
        for (String arrayName : arrayToAttrs.keySet()) {
            ArrayList attributes = Lists.newArrayList((Iterable)arrayToAttrs.get((Object)arrayName));
            Collections.sort(attributes);
            ArrayList attributeValues = Lists.newArrayListWithCapacity((int)attributes.size());
            for (String attribute : attributes) {
                if (attribute.startsWith("android:")) {
                    String name = attribute.substring(SdkConstants.ANDROID_NS_NAME_PREFIX_LEN);
                    Symbol platformSymbol = (Symbol)platformSymbols.getSymbols().get((Object)ResourceType.ATTR, (Object)name);
                    if (platformSymbol == null) continue;
                    attributeValues.add(platformSymbol.getValue());
                    continue;
                }
                Symbol symbol = (Symbol)attrToValue.get(attribute);
                if (symbol == null) continue;
                attributeValues.add(symbol.getValue());
            }
            tableBuilder.add(Symbol.createSymbol(ResourceType.STYLEABLE, arrayName, SymbolJavaType.INT_LIST, "{ " + Joiner.on((String)", ").join((Iterable)attributeValues) + " }", attributes));
        }
        return tableBuilder.build();
    }

    public static Set<SymbolTable> loadDependenciesSymbolTables(Set<File> libraries, String mainPackageName) throws IOException {
        ImmutableSet.Builder depSymbolTables = ImmutableSet.builder();
        for (File dependency : libraries) {
            depSymbolTables.add((Object)SymbolIo.readTableWithPackage(dependency));
        }
        return depSymbolTables.build();
    }

    public static String getPackageNameFromManifest(File manifestFile) throws IOException {
        ManifestData manifestData;
        try {
            manifestData = AndroidManifestParser.parse((IAbstractFile)new FileWrapper(manifestFile));
        }
        catch (IOException | SAXException e) {
            throw new IOException("Failed to parse android manifest XML file at path: '" + manifestFile.getAbsolutePath(), e);
        }
        return SymbolUtils.getPackageNameFromManifest(manifestData);
    }

    public static String getPackageNameFromManifest(ManifestData manifest) {
        return manifest.getPackage();
    }

    public static List<String> generateMinifyKeepRules(ManifestData manifest, File mergedResources) throws IOException {
        return SymbolUtils.generateKeepRules(manifest, false, mergedResources);
    }

    public static List<String> generateMainDexKeepRules(ManifestData manifest, File mergedResources) throws IOException {
        return SymbolUtils.generateKeepRules(manifest, true, mergedResources);
    }

    @VisibleForTesting
    static List<String> generateKeepRules(ManifestData manifest, boolean isMainDex, File mergedResources) throws IOException {
        ArrayList<String> rules = new ArrayList<String>();
        rules.add("# Generated by the gradle plugin");
        for (ManifestData.KeepClass keepClass : manifest.getKeepClasses()) {
            if (isMainDex) {
                String type = keepClass.getType();
                String process = keepClass.getProcess();
                if (!(type != "activity" && type != "service" && type != "provider" && type != "receiver" || process != null && !process.isEmpty() && !process.startsWith(":"))) continue;
            }
            rules.add(String.format("-keep class %s { <init>(...); }", keepClass.getName()));
        }
        if (mergedResources != null) {
            try {
                DocumentBuilderFactory documentBuilderFactory = DocumentBuilderFactory.newInstance();
                DocumentBuilder documentBuilder = documentBuilderFactory.newDocumentBuilder();
                for (File typeDir : mergedResources.listFiles()) {
                    if (!typeDir.isDirectory() || !typeDir.getName().startsWith("layout")) continue;
                    for (File layoutXml : typeDir.listFiles()) {
                        if (!layoutXml.isFile()) continue;
                        SymbolUtils.generateKeepRulesFromLayoutXmlFile(layoutXml, documentBuilder, rules);
                    }
                }
            }
            catch (ParserConfigurationException e) {
                throw new IOException("Failed to read merged resources", e);
            }
        }
        Collections.sort(rules);
        return rules;
    }

    static void generateKeepRulesFromLayoutXmlFile(File layout, DocumentBuilder documentBuilder, List<String> rules) throws IOException {
        try {
            Document xmlDocument = documentBuilder.parse(layout);
            Element root = xmlDocument.getDocumentElement();
            if (root != null) {
                SymbolUtils.generateKeepRulesFromXmlNode(root, rules);
            }
        }
        catch (IOException | SAXException e) {
            throw new IOException("Failed to parse XML resource file " + layout.getAbsolutePath(), e);
        }
    }

    private static void generateKeepRulesFromXmlNode(Element node, List<String> rules) {
        String tag = node.getTagName();
        if (tag.contains(".")) {
            rules.add(String.format("-keep class %s { <init>(...); }", tag));
        }
        for (Node current = node.getFirstChild(); current != null; current = current.getNextSibling()) {
            if (current.getNodeType() != 1) continue;
            SymbolUtils.generateKeepRulesFromXmlNode((Element)current, rules);
        }
    }

    public static void generateRTxt(SymbolTable table, File directory) {
        File file = new File(directory, "R.txt");
        SymbolIo.write(table, file);
    }

    public static ManifestData parseManifest(File manifestFile) throws IOException {
        try {
            return AndroidManifestParser.parse((IAbstractFile)new FileWrapper(manifestFile));
        }
        catch (IOException | SAXException e) {
            throw new IOException("Failed to parse android manifest XML file at path: '" + manifestFile.getAbsolutePath(), e);
        }
    }

    public static String canonicalizeValueResourceName(String name) {
        return NORMALIZED_VALUE_NAME_CHARS.replaceFrom((CharSequence)name, '_');
    }

    private static /* synthetic */ void lambda$mergeAndRenumberSymbols$31(SetMultimap setMultimap, SetMultimap setMultimap2, Symbol symbol) {
        ResourceType resourceType = symbol.getResourceType();
        String symbolName = symbol.getName();
        if (resourceType != ResourceType.STYLEABLE) {
            setMultimap.put((Object)resourceType, (Object)symbolName);
        } else {
            setMultimap2.putAll((Object)symbol.getName(), symbol.getChildren());
        }
    }

    public static enum SymbolTableGenerationMode {
        FROM_MERGED_RESOURCES,
        ONLY_PACKAGED_RESOURCES;

    }
}

