/*
 * Decompiled with CFR 0.152.
 */
package com.android.hierarchyviewerlib.device;

import com.android.ddmlib.IDevice;
import com.android.hierarchyviewerlib.device.DeviceConnection;
import java.io.IOException;
import java.util.ArrayList;
import java.util.HashMap;

public class WindowUpdater {
    private static HashMap<IDevice, ArrayList<IWindowChangeListener>> sWindowChangeListeners = new HashMap();
    private static HashMap<IDevice, Thread> sListeningThreads = new HashMap();

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void terminate() {
        HashMap<IDevice, Thread> hashMap = sListeningThreads;
        synchronized (hashMap) {
            for (IDevice device : sListeningThreads.keySet()) {
                sListeningThreads.get(device).interrupt();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void startListenForWindowChanges(IWindowChangeListener listener, IDevice device) {
        HashMap<IDevice, ArrayList<IWindowChangeListener>> hashMap = sWindowChangeListeners;
        synchronized (hashMap) {
            if (sWindowChangeListeners.containsKey(device)) {
                sWindowChangeListeners.get(device).add(listener);
                return;
            }
            ArrayList<IWindowChangeListener> listeners = new ArrayList<IWindowChangeListener>();
            listeners.add(listener);
            sWindowChangeListeners.put(device, listeners);
        }
        Thread listeningThread = new Thread(new WindowChangeMonitor(device));
        HashMap<IDevice, Thread> hashMap2 = sListeningThreads;
        synchronized (hashMap2) {
            sListeningThreads.put(device, listeningThread);
        }
        listeningThread.start();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void stopListenForWindowChanges(IWindowChangeListener listener, IDevice device) {
        Thread listeningThread;
        HashMap<IDevice, ArrayList<IWindowChangeListener>> hashMap = sWindowChangeListeners;
        synchronized (hashMap) {
            ArrayList<IWindowChangeListener> listeners = sWindowChangeListeners.get(device);
            if (listeners == null) {
                return;
            }
            listeners.remove(listener);
            if (listeners.size() != 0) {
                return;
            }
            sWindowChangeListeners.remove(device);
        }
        HashMap<IDevice, Thread> hashMap2 = sListeningThreads;
        synchronized (hashMap2) {
            listeningThread = sListeningThreads.get(device);
            sListeningThreads.remove(device);
        }
        listeningThread.interrupt();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static IWindowChangeListener[] getWindowChangeListenersAsArray(IDevice device) {
        IWindowChangeListener[] listeners;
        HashMap<IDevice, ArrayList<IWindowChangeListener>> hashMap = sWindowChangeListeners;
        synchronized (hashMap) {
            ArrayList<IWindowChangeListener> windowChangeListenerList = sWindowChangeListeners.get(device);
            if (windowChangeListenerList == null) {
                return null;
            }
            listeners = windowChangeListenerList.toArray(new IWindowChangeListener[windowChangeListenerList.size()]);
        }
        return listeners;
    }

    public static void notifyWindowsChanged(IDevice device) {
        IWindowChangeListener[] listeners = WindowUpdater.getWindowChangeListenersAsArray(device);
        if (listeners != null) {
            for (int i = 0; i < listeners.length; ++i) {
                listeners[i].windowsChanged(device);
            }
        }
    }

    public static void notifyFocusChanged(IDevice device) {
        IWindowChangeListener[] listeners = WindowUpdater.getWindowChangeListenersAsArray(device);
        if (listeners != null) {
            for (int i = 0; i < listeners.length; ++i) {
                listeners[i].focusChanged(device);
            }
        }
    }

    private static class WindowChangeMonitor
    implements Runnable {
        private IDevice device;

        public WindowChangeMonitor(IDevice device) {
            this.device = device;
        }

        @Override
        public void run() {
            while (!Thread.currentThread().isInterrupted()) {
                DeviceConnection connection = null;
                try {
                    String line;
                    connection = new DeviceConnection(this.device);
                    connection.sendCommand("AUTOLIST");
                    while (!Thread.currentThread().isInterrupted() && (line = connection.getInputStream().readLine()) != null) {
                        if (line.equalsIgnoreCase("LIST UPDATE")) {
                            WindowUpdater.notifyWindowsChanged(this.device);
                            continue;
                        }
                        if (!line.equalsIgnoreCase("FOCUS UPDATE")) continue;
                        WindowUpdater.notifyFocusChanged(this.device);
                    }
                }
                catch (IOException iOException) {}
                continue;
                finally {
                    if (connection == null) continue;
                    connection.close();
                }
            }
        }
    }

    public static interface IWindowChangeListener {
        public void windowsChanged(IDevice var1);

        public void focusChanged(IDevice var1);
    }
}

