/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.psi.impl.compiled;

import com.intellij.navigation.ItemPresentation;
import com.intellij.navigation.ItemPresentationProviders;
import com.intellij.openapi.extensions.Extensions;
import com.intellij.openapi.project.IndexNotReadyException;
import com.intellij.openapi.util.AtomicNotNullLazyValue;
import com.intellij.openapi.util.Comparing;
import com.intellij.openapi.util.NotNullLazyValue;
import com.intellij.openapi.util.NullableLazyValue;
import com.intellij.openapi.util.VolatileNullableLazyValue;
import com.intellij.psi.JavaElementVisitor;
import com.intellij.psi.PsiClass;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiElementVisitor;
import com.intellij.psi.PsiExpression;
import com.intellij.psi.PsiField;
import com.intellij.psi.PsiModifierList;
import com.intellij.psi.PsiType;
import com.intellij.psi.PsiTypeElement;
import com.intellij.psi.PsiVariable;
import com.intellij.psi.impl.ElementPresentationUtil;
import com.intellij.psi.impl.PsiClassImplUtil;
import com.intellij.psi.impl.PsiConstantEvaluationHelperImpl;
import com.intellij.psi.impl.PsiImplUtil;
import com.intellij.psi.impl.PsiVariableEx;
import com.intellij.psi.impl.cache.TypeInfo;
import com.intellij.psi.impl.compiled.ClsClassImpl;
import com.intellij.psi.impl.compiled.ClsCustomNavigationPolicy;
import com.intellij.psi.impl.compiled.ClsElementImpl;
import com.intellij.psi.impl.compiled.ClsMemberImpl;
import com.intellij.psi.impl.compiled.ClsModifierListOwner;
import com.intellij.psi.impl.compiled.ClsParsingUtil;
import com.intellij.psi.impl.compiled.ClsTypeElementImpl;
import com.intellij.psi.impl.java.stubs.JavaStubElementTypes;
import com.intellij.psi.impl.java.stubs.PsiFieldStub;
import com.intellij.psi.impl.source.SourceTreeToPsiMap;
import com.intellij.psi.impl.source.tree.TreeElement;
import com.intellij.psi.search.SearchScope;
import com.intellij.ui.RowIcon;
import com.intellij.util.IncorrectOperationException;
import com.intellij.util.ObjectUtils;
import com.intellij.util.PlatformIcons;
import gnu.trove.THashSet;
import java.util.Set;
import javax.swing.Icon;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class ClsFieldImpl
extends ClsMemberImpl<PsiFieldStub>
implements PsiField,
PsiVariableEx,
ClsModifierListOwner {
    private final NotNullLazyValue<PsiTypeElement> myTypeElement;
    private final NullableLazyValue<PsiExpression> myInitializer;

    public ClsFieldImpl(@NotNull PsiFieldStub stub) {
        if (stub == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "stub", "com/intellij/psi/impl/compiled/ClsFieldImpl", "<init>"));
        }
        super(stub);
        this.myTypeElement = new AtomicNotNullLazyValue<PsiTypeElement>(){

            @Override
            @NotNull
            protected PsiTypeElement compute() {
                PsiFieldStub stub = (PsiFieldStub)ClsFieldImpl.this.getStub();
                String typeText = TypeInfo.createTypeText(stub.getType(false));
                assert (typeText != null) : stub;
                ClsTypeElementImpl clsTypeElementImpl = new ClsTypeElementImpl(ClsFieldImpl.this, typeText, '\u0000');
                if (clsTypeElementImpl == null) {
                    throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/psi/impl/compiled/ClsFieldImpl$1", "compute"));
                }
                return clsTypeElementImpl;
            }
        };
        this.myInitializer = new VolatileNullableLazyValue<PsiExpression>(){

            @Override
            @Nullable
            protected PsiExpression compute() {
                String initializerText = ((PsiFieldStub)ClsFieldImpl.this.getStub()).getInitializerText();
                return initializerText != null && !Comparing.equal(";INITIALIZER_TOO_LONG;", initializerText) ? ClsParsingUtil.createExpressionFromText(initializerText, ClsFieldImpl.this.getManager(), ClsFieldImpl.this) : null;
            }
        };
    }

    @Override
    @NotNull
    public PsiElement[] getChildren() {
        PsiElement[] psiElementArray = this.getChildren(this.getDocComment(), this.getModifierList(), this.getTypeElement(), this.getNameIdentifier());
        if (psiElementArray == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/psi/impl/compiled/ClsFieldImpl", "getChildren"));
        }
        return psiElementArray;
    }

    @Override
    public PsiClass getContainingClass() {
        return (PsiClass)this.getParent();
    }

    @Override
    @NotNull
    public PsiType getType() {
        PsiType psiType = ObjectUtils.assertNotNull(this.getTypeElement()).getType();
        if (psiType == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/psi/impl/compiled/ClsFieldImpl", "getType"));
        }
        return psiType;
    }

    @Override
    public PsiTypeElement getTypeElement() {
        return this.myTypeElement.getValue();
    }

    @Override
    public PsiModifierList getModifierList() {
        return ObjectUtils.assertNotNull(((PsiFieldStub)this.getStub()).findChildStubByType(JavaStubElementTypes.MODIFIER_LIST)).getPsi();
    }

    @Override
    public boolean hasModifierProperty(@NotNull String name) {
        if (name == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "name", "com/intellij/psi/impl/compiled/ClsFieldImpl", "hasModifierProperty"));
        }
        return ObjectUtils.assertNotNull(this.getModifierList()).hasModifierProperty(name);
    }

    @Override
    public PsiExpression getInitializer() {
        return this.myInitializer.getValue();
    }

    @Override
    public boolean hasInitializer() {
        return this.getInitializer() != null;
    }

    @Override
    public Object computeConstantValue() {
        return this.computeConstantValue((Set<PsiVariable>)new THashSet());
    }

    @Override
    public Object computeConstantValue(Set<PsiVariable> visitedVars) {
        if (!this.hasModifierProperty("final")) {
            return null;
        }
        PsiExpression initializer = this.getInitializer();
        if (initializer == null) {
            return null;
        }
        PsiClass containingClass = this.getContainingClass();
        if (containingClass != null) {
            String qName = containingClass.getQualifiedName();
            if ("java.lang.Float".equals(qName)) {
                String name = this.getName();
                if ("POSITIVE_INFINITY".equals(name)) {
                    return Float.valueOf(Float.POSITIVE_INFINITY);
                }
                if ("NEGATIVE_INFINITY".equals(name)) {
                    return Float.valueOf(Float.NEGATIVE_INFINITY);
                }
                if ("NaN".equals(name)) {
                    return Float.valueOf(Float.NaN);
                }
            } else if ("java.lang.Double".equals(qName)) {
                String name = this.getName();
                if ("POSITIVE_INFINITY".equals(name)) {
                    return Double.POSITIVE_INFINITY;
                }
                if ("NEGATIVE_INFINITY".equals(name)) {
                    return Double.NEGATIVE_INFINITY;
                }
                if ("NaN".equals(name)) {
                    return Double.NaN;
                }
            }
        }
        return PsiConstantEvaluationHelperImpl.computeCastTo(initializer, this.getType(), visitedVars);
    }

    @Override
    public boolean isDeprecated() {
        return ((PsiFieldStub)this.getStub()).isDeprecated() || PsiImplUtil.isDeprecatedByAnnotation(this);
    }

    @Override
    public void normalizeDeclaration() throws IncorrectOperationException {
    }

    @Override
    public void appendMirrorText(int indentLevel, @NotNull StringBuilder buffer) {
        if (buffer == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "buffer", "com/intellij/psi/impl/compiled/ClsFieldImpl", "appendMirrorText"));
        }
        ClsFieldImpl.appendText(this.getDocComment(), indentLevel, buffer, "go_to_next_line_and_indent");
        ClsFieldImpl.appendText(this.getModifierList(), indentLevel, buffer, "");
        ClsFieldImpl.appendText(this.getTypeElement(), indentLevel, buffer, " ");
        ClsFieldImpl.appendText(this.getNameIdentifier(), indentLevel, buffer);
        PsiExpression initializer = this.getInitializer();
        if (initializer != null) {
            buffer.append(" = ");
            buffer.append(initializer.getText());
        }
        buffer.append(';');
    }

    @Override
    public void setMirror(@NotNull TreeElement element) throws ClsElementImpl.InvalidMirrorException {
        if (element == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "element", "com/intellij/psi/impl/compiled/ClsFieldImpl", "setMirror"));
        }
        this.setMirrorCheckingType(element, null);
        PsiField mirror = (PsiField)SourceTreeToPsiMap.treeToPsiNotNull(element);
        ClsFieldImpl.setMirrorIfPresent(this.getDocComment(), mirror.getDocComment());
        ClsFieldImpl.setMirror(this.getModifierList(), mirror.getModifierList());
        ClsFieldImpl.setMirror(this.getTypeElement(), mirror.getTypeElement());
        ClsFieldImpl.setMirror(this.getNameIdentifier(), mirror.getNameIdentifier());
    }

    @Override
    public void accept(@NotNull PsiElementVisitor visitor) {
        if (visitor == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "visitor", "com/intellij/psi/impl/compiled/ClsFieldImpl", "accept"));
        }
        if (visitor instanceof JavaElementVisitor) {
            ((JavaElementVisitor)visitor).visitField(this);
        } else {
            visitor.visitElement(this);
        }
    }

    @Override
    @NotNull
    public PsiElement getNavigationElement() {
        PsiElement psiElement;
        for (ClsCustomNavigationPolicy customNavigationPolicy : Extensions.getExtensions(ClsCustomNavigationPolicy.EP_NAME)) {
            PsiElement psiElement2;
            try {
                PsiElement navigationElement = customNavigationPolicy.getNavigationElement(this);
                if (navigationElement == null) continue;
                psiElement2 = navigationElement;
            }
            catch (IndexNotReadyException indexNotReadyException) {
                // empty catch block
            }
            if (psiElement2 == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/psi/impl/compiled/ClsFieldImpl", "getNavigationElement"));
            }
            return psiElement2;
        }
        try {
            PsiClass sourceClassMirror = ((ClsClassImpl)this.getParent()).getSourceMirrorClass();
            PsiField sourceFieldMirror = sourceClassMirror != null ? sourceClassMirror.findFieldByName(this.getName(), false) : null;
            psiElement = sourceFieldMirror != null ? sourceFieldMirror.getNavigationElement() : this;
        }
        catch (IndexNotReadyException e) {
            ClsFieldImpl clsFieldImpl = this;
            if (clsFieldImpl == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/psi/impl/compiled/ClsFieldImpl", "getNavigationElement"));
            }
            return clsFieldImpl;
        }
        if (psiElement == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/psi/impl/compiled/ClsFieldImpl", "getNavigationElement"));
        }
        return psiElement;
    }

    @Override
    public ItemPresentation getPresentation() {
        return ItemPresentationProviders.getItemPresentation(this);
    }

    @Override
    public void setInitializer(PsiExpression initializer) throws IncorrectOperationException {
        throw new IncorrectOperationException();
    }

    @Override
    public Icon getElementIcon(int flags) {
        RowIcon baseIcon = ElementPresentationUtil.createLayeredIcon(PlatformIcons.FIELD_ICON, this, false);
        return ElementPresentationUtil.addVisibilityIcon(this, flags, baseIcon);
    }

    @Override
    public boolean isEquivalentTo(PsiElement another) {
        return PsiClassImplUtil.isFieldEquivalentTo(this, another);
    }

    @Override
    @NotNull
    public SearchScope getUseScope() {
        SearchScope searchScope = PsiImplUtil.getMemberUseScope(this);
        if (searchScope == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/psi/impl/compiled/ClsFieldImpl", "getUseScope"));
        }
        return searchScope;
    }

    @Override
    protected boolean isVisibilitySupported() {
        return true;
    }

    @Override
    public String toString() {
        return "PsiField:" + this.getName();
    }
}

