/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.psi.impl.source.resolve;

import com.intellij.psi.PsiAnonymousClass;
import com.intellij.psi.PsiClass;
import com.intellij.psi.PsiClassType;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiExpression;
import com.intellij.psi.PsiFile;
import com.intellij.psi.PsiIdentifier;
import com.intellij.psi.PsiJavaCodeReferenceElement;
import com.intellij.psi.PsiNewExpression;
import com.intellij.psi.PsiType;
import com.intellij.psi.impl.source.PsiJavaCodeReferenceElementImpl;
import com.intellij.psi.impl.source.resolve.ClassResolverProcessor;
import com.intellij.psi.scope.util.PsiScopesUtil;
import com.intellij.psi.util.PsiUtil;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class ResolveClassUtil {
    @Nullable
    public static PsiClass resolveClass(@NotNull PsiJavaCodeReferenceElement ref, @NotNull PsiFile containingFile) {
        if (ref == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "ref", "com/intellij/psi/impl/source/resolve/ResolveClassUtil", "resolveClass"));
        }
        if (containingFile == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "containingFile", "com/intellij/psi/impl/source/resolve/ResolveClassUtil", "resolveClass"));
        }
        if (ref instanceof PsiJavaCodeReferenceElementImpl && ((PsiJavaCodeReferenceElementImpl)ref).getKind(containingFile) == 6) {
            PsiClass qualifierClass;
            PsiType qualifierType;
            PsiExpression qualifier;
            PsiElement parent = ref.getParent();
            if (parent instanceof PsiAnonymousClass) {
                parent = parent.getParent();
            }
            if (parent instanceof PsiNewExpression && (qualifier = ((PsiNewExpression)parent).getQualifier()) != null && (qualifierType = qualifier.getType()) instanceof PsiClassType && (qualifierClass = PsiUtil.resolveClassInType(qualifierType)) != null) {
                return qualifierClass.findInnerClassByName(ref.getText(), true);
            }
        } else {
            PsiElement classNameElement = ref.getReferenceNameElement();
            if (classNameElement instanceof PsiIdentifier) {
                String className = classNameElement.getText();
                ClassResolverProcessor processor = new ClassResolverProcessor(className, ref, containingFile);
                PsiScopesUtil.resolveAndWalk(processor, ref, null);
                if (processor.getResult().length == 1) {
                    return (PsiClass)processor.getResult()[0].getElement();
                }
            }
        }
        return null;
    }
}

